/*
 * Decompiled with CFR 0.152.
 */
package cwinter.codecraft.core.replay;

import cwinter.codecraft.core.api.DroneControllerBase;
import cwinter.codecraft.core.api.DroneSpec;
import cwinter.codecraft.core.api.DroneSpec$;
import cwinter.codecraft.core.api.Player;
import cwinter.codecraft.core.game.GameConfig;
import cwinter.codecraft.core.game.MineralSpawn;
import cwinter.codecraft.core.game.Spawn;
import cwinter.codecraft.core.objects.drone.DroneCommand;
import cwinter.codecraft.core.objects.drone.HoldPosition$;
import cwinter.codecraft.core.objects.drone.MoveInDirection;
import cwinter.codecraft.core.objects.drone.MoveInDirection$;
import cwinter.codecraft.core.objects.drone.MoveToPosition;
import cwinter.codecraft.core.objects.drone.MoveToPosition$;
import cwinter.codecraft.core.objects.drone.SerializableConstructDrone;
import cwinter.codecraft.core.objects.drone.SerializableConstructDrone$;
import cwinter.codecraft.core.objects.drone.SerializableDepositMinerals;
import cwinter.codecraft.core.objects.drone.SerializableDepositMinerals$;
import cwinter.codecraft.core.objects.drone.SerializableDroneCommand;
import cwinter.codecraft.core.objects.drone.SerializableFireMissiles;
import cwinter.codecraft.core.objects.drone.SerializableFireMissiles$;
import cwinter.codecraft.core.objects.drone.SerializableHarvestMineral;
import cwinter.codecraft.core.objects.drone.SerializableHarvestMineral$;
import cwinter.codecraft.core.objects.drone.SerializableMoveToDrone;
import cwinter.codecraft.core.objects.drone.SerializableMoveToDrone$;
import cwinter.codecraft.core.objects.drone.SerializableMoveToMineralCrystal;
import cwinter.codecraft.core.objects.drone.SerializableMoveToMineralCrystal$;
import cwinter.codecraft.core.replay.Command;
import cwinter.codecraft.core.replay.Command$;
import cwinter.codecraft.core.replay.MineralRecord;
import cwinter.codecraft.core.replay.MineralRecord$;
import cwinter.codecraft.core.replay.RNGSeed;
import cwinter.codecraft.core.replay.RNGSeed$;
import cwinter.codecraft.core.replay.ReplayRecord;
import cwinter.codecraft.core.replay.ReplayRecorder;
import cwinter.codecraft.core.replay.ReplayRecorder$;
import cwinter.codecraft.core.replay.ReplayVersion;
import cwinter.codecraft.core.replay.ReplayVersion$;
import cwinter.codecraft.core.replay.SpawnRecord;
import cwinter.codecraft.core.replay.SpawnRecord$;
import cwinter.codecraft.core.replay.Timestep;
import cwinter.codecraft.core.replay.Timestep$;
import cwinter.codecraft.core.replay.WorldSize;
import cwinter.codecraft.core.replay.WorldSize$;
import cwinter.codecraft.util.maths.Rectangle;
import cwinter.codecraft.util.maths.Rectangle$;
import cwinter.codecraft.util.maths.Vector2;
import cwinter.codecraft.util.maths.Vector2$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple1;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.Tuple5;
import scala.Tuple6;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import sourcecode.Enclosing;
import upickle.Js;
import upickle.Types;
import upickle.default$;

public abstract class ReplayRecorder$class {
    public static void newTimestep(ReplayRecorder $this, long t) {
        $this.timestep_$eq(t);
        $this.timestepWritten_$eq(false);
    }

    public static void recordInitialWorldState(ReplayRecorder $this, GameConfig config) {
        $this.recordVersion();
        ReplayRecorder$class.recordRngSeed($this, config.rngSeed());
        $this.recordWorldSize(config.worldSize());
        config.minerals().foreach((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplayRecorder $outer;

            public final void apply(MineralSpawn mineral) {
                ReplayRecorder$class.cwinter$codecraft$core$replay$ReplayRecorder$$recordMineral(this.$outer, mineral);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        config.drones().withFilter((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Spawn, DroneControllerBase> check$ifrefutable$1) {
                Spawn spawn;
                Tuple2<Spawn, DroneControllerBase> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null && (spawn = (Spawn)tuple2._1()) != null;
                return bl;
            }
        }).foreach((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplayRecorder $outer;

            public final void apply(Tuple2<Spawn, DroneControllerBase> x$1) {
                Spawn spawn;
                Tuple2<Spawn, DroneControllerBase> tuple2 = x$1;
                if (tuple2 != null && (spawn = (Spawn)tuple2._1()) != null) {
                    DroneSpec spec = spawn.droneSpec();
                    Vector2 position2 = spawn.position();
                    Player player = spawn.player();
                    int resources = spawn.resources();
                    Option<String> name = spawn.name();
                    this.$outer.recordSpawn(spec, position2, player, resources, name);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public static void recordVersion(ReplayRecorder $this) {
        ReplayRecorder$class.writeRecord($this, new ReplayVersion("0.6.0"));
    }

    public static void record(ReplayRecorder $this, int droneID, DroneCommand droneCommand) {
        if (!$this.timestepWritten()) {
            ReplayRecorder$class.writeRecord($this, new Timestep($this.timestep()));
            $this.timestepWritten_$eq(true);
        }
        ReplayRecorder$class.writeRecord($this, new Command(droneID, droneCommand.toSerializable()));
    }

    public static void recordSpawn(ReplayRecorder $this, DroneSpec droneSpec, Vector2 position2, Player player, int resources, Option name) {
        ReplayRecorder$class.writeRecord($this, new SpawnRecord(droneSpec, position2, player.id(), resources, (Option<String>)name));
    }

    public static void recordWorldSize(ReplayRecorder $this, Rectangle rectangle) {
        ReplayRecorder$class.writeRecord($this, new WorldSize(rectangle));
    }

    public static void cwinter$codecraft$core$replay$ReplayRecorder$$recordMineral(ReplayRecorder $this, MineralSpawn mineral) {
        ReplayRecorder$class.writeRecord($this, MineralRecord$.MODULE$.apply(mineral));
    }

    private static void recordRngSeed(ReplayRecorder $this, int rngSeed) {
        ReplayRecorder$class.writeRecord($this, new RNGSeed(rngSeed));
    }

    public static Option replayString(ReplayRecorder $this) {
        return None$.MODULE$;
    }

    public static Option replayFilepath(ReplayRecorder $this) {
        return None$.MODULE$;
    }

    private static void writeRecord(ReplayRecorder $this, ReplayRecord record) {
        $this.writeLine(default$.MODULE$.write((Object)record, default$.MODULE$.write$default$2(), new Object($this){
            private Types.Writer<Vector2> derive$macro$849;
            private Types.Writer<SerializableDroneCommand> derive$macro$896;
            private Types.Writer<ReplayRecord> derive$macro$830;
            private Types.Writer<SerializableHarvestMineral> derive$macro$920;
            private Types.Writer<ReplayVersion> derive$macro$833;
            private Types.Writer<MineralRecord> derive$macro$845;
            private Types.Writer<WorldSize> derive$macro$880;
            private Types.Writer<MoveToPosition> derive$macro$908;
            private Types.Writer<Rectangle> derive$macro$883;
            private Types.Writer<SerializableFireMissiles> derive$macro$916;
            private Types.Writer<SerializableDepositMinerals> derive$macro$924;
            private Types.Writer<Timestep> derive$macro$874;
            private Types.Writer<Command> derive$macro$892;
            private Types.Writer<HoldPosition$> derive$macro$905;
            private Types.Writer<SpawnRecord> derive$macro$856;
            private Types.Writer<DroneSpec> derive$macro$859;
            private Types.Writer<RNGSeed> derive$macro$839;
            private Types.Writer<SerializableMoveToDrone> derive$macro$912;
            private Types.Writer<MoveInDirection> derive$macro$928;
            private Types.Writer<SerializableMoveToMineralCrystal> derive$macro$932;
            private Types.Writer<SerializableConstructDrone> derive$macro$899;
            private volatile int bitmap$0;

            private Types.Writer derive$macro$849$lzycompute() {
                ReplayRecorder$.anon.1 var1_1 = this;
                synchronized (var1_1) {
                    if ((this.bitmap$0 & 1) == 0) {
                        this.derive$macro$849 = new Types.Knot$.Writer(default$.MODULE$.Knot(), (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Types.Writer<Vector2> apply() {
                                return default$.MODULE$.CaseW((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final Option<Tuple2<Object, Object>> apply(Vector2 x$0) {
                                        return Vector2$.MODULE$.unapply(x$0);
                                    }
                                }, (String[])((Object[])new String[]{"_x", "_y"}), (Js.Value[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Js.Value[]{null, null}), ClassTag$.MODULE$.apply(Js.Value.class)), (Types.Writer)default$.MODULE$.Tuple2W((Object)default$.MODULE$.FloatRW(), (Object)default$.MODULE$.FloatRW()));
                            }
                        });
                        this.bitmap$0 |= 1;
                    }
                    return this.derive$macro$849;
                }
            }

            private Types.Writer derive$macro$896$lzycompute() {
                ReplayRecorder$.anon.1 var1_1 = this;
                synchronized (var1_1) {
                    if ((this.bitmap$0 & 2) == 0) {
                        this.derive$macro$896 = new Types.Knot$.Writer(default$.MODULE$.Knot(), (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ ReplayRecorder$.anon.1 $outer;

                            public final Types.Writer<SerializableDroneCommand> apply() {
                                return default$.MODULE$.Writer().apply(default$.MODULE$.Internal().merge(default$.MODULE$.Internal().merge(default$.MODULE$.Internal().merge(default$.MODULE$.Internal().merge(default$.MODULE$.Internal().merge(default$.MODULE$.Internal().merge(default$.MODULE$.Internal().merge(default$.MODULE$.Internal().merge(((Types.Writer)Predef$.MODULE$.implicitly(this.$outer.derive$macro$899())).write(), ((Types.Writer)Predef$.MODULE$.implicitly(this.$outer.derive$macro$905())).write(), ClassTag$.MODULE$.apply(SerializableConstructDrone.class), ClassTag$.MODULE$.apply(HoldPosition$.class)), ((Types.Writer)Predef$.MODULE$.implicitly(this.$outer.derive$macro$908())).write(), ClassTag$.MODULE$.Any(), ClassTag$.MODULE$.apply(MoveToPosition.class)), ((Types.Writer)Predef$.MODULE$.implicitly(this.$outer.derive$macro$912())).write(), ClassTag$.MODULE$.Any(), ClassTag$.MODULE$.apply(SerializableMoveToDrone.class)), ((Types.Writer)Predef$.MODULE$.implicitly(this.$outer.derive$macro$916())).write(), ClassTag$.MODULE$.Any(), ClassTag$.MODULE$.apply(SerializableFireMissiles.class)), ((Types.Writer)Predef$.MODULE$.implicitly(this.$outer.derive$macro$920())).write(), ClassTag$.MODULE$.Any(), ClassTag$.MODULE$.apply(SerializableHarvestMineral.class)), ((Types.Writer)Predef$.MODULE$.implicitly(this.$outer.derive$macro$924())).write(), ClassTag$.MODULE$.Any(), ClassTag$.MODULE$.apply(SerializableDepositMinerals.class)), ((Types.Writer)Predef$.MODULE$.implicitly(this.$outer.derive$macro$928())).write(), ClassTag$.MODULE$.Any(), ClassTag$.MODULE$.apply(MoveInDirection.class)), ((Types.Writer)Predef$.MODULE$.implicitly(this.$outer.derive$macro$932())).write(), ClassTag$.MODULE$.Any(), ClassTag$.MODULE$.apply(SerializableMoveToMineralCrystal.class)), new Enclosing("cwinter.codecraft.core.replay.ReplayRecorder#writeRecord $anon#derive$macro$896 $anonfun"));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                        this.bitmap$0 |= 2;
                    }
                    return this.derive$macro$896;
                }
            }

            private Types.Writer derive$macro$830$lzycompute() {
                ReplayRecorder$.anon.1 var1_1 = this;
                synchronized (var1_1) {
                    if ((this.bitmap$0 & 4) == 0) {
                        this.derive$macro$830 = new Types.Knot$.Writer(default$.MODULE$.Knot(), (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ ReplayRecorder$.anon.1 $outer;

                            public final Types.Writer<ReplayRecord> apply() {
                                return default$.MODULE$.Writer().apply(default$.MODULE$.Internal().merge(default$.MODULE$.Internal().merge(default$.MODULE$.Internal().merge(default$.MODULE$.Internal().merge(default$.MODULE$.Internal().merge(default$.MODULE$.Internal().merge(((Types.Writer)Predef$.MODULE$.implicitly(this.$outer.derive$macro$833())).write(), ((Types.Writer)Predef$.MODULE$.implicitly(this.$outer.derive$macro$839())).write(), ClassTag$.MODULE$.apply(ReplayVersion.class), ClassTag$.MODULE$.apply(RNGSeed.class)), ((Types.Writer)Predef$.MODULE$.implicitly(this.$outer.derive$macro$845())).write(), ClassTag$.MODULE$.Any(), ClassTag$.MODULE$.apply(MineralRecord.class)), ((Types.Writer)Predef$.MODULE$.implicitly(this.$outer.derive$macro$856())).write(), ClassTag$.MODULE$.Any(), ClassTag$.MODULE$.apply(SpawnRecord.class)), ((Types.Writer)Predef$.MODULE$.implicitly(this.$outer.derive$macro$874())).write(), ClassTag$.MODULE$.Any(), ClassTag$.MODULE$.apply(Timestep.class)), ((Types.Writer)Predef$.MODULE$.implicitly(this.$outer.derive$macro$880())).write(), ClassTag$.MODULE$.Any(), ClassTag$.MODULE$.apply(WorldSize.class)), ((Types.Writer)Predef$.MODULE$.implicitly(this.$outer.derive$macro$892())).write(), ClassTag$.MODULE$.Any(), ClassTag$.MODULE$.apply(Command.class)), new Enclosing("cwinter.codecraft.core.replay.ReplayRecorder#writeRecord $anon#derive$macro$830 $anonfun"));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                        this.bitmap$0 |= 4;
                    }
                    return this.derive$macro$830;
                }
            }

            private Types.Writer derive$macro$920$lzycompute() {
                ReplayRecorder$.anon.1 var1_1 = this;
                synchronized (var1_1) {
                    if ((this.bitmap$0 & 8) == 0) {
                        this.derive$macro$920 = new Types.Knot$.Writer(default$.MODULE$.Knot(), (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Types.Writer<SerializableHarvestMineral> apply() {
                                return default$.MODULE$.annotate(default$.MODULE$.CaseW((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final Option<Tuple1<Object>> apply(SerializableHarvestMineral x$2) {
                                        return SerializableHarvestMineral$.MODULE$.unapply(x$2).map((Function1)new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final Tuple1<Object> apply(int _1) {
                                                return new Tuple1.mcI.sp(_1);
                                            }
                                        });
                                    }
                                }, (String[])((Object[])new String[]{"mineralID"}), (Js.Value[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Js.Value[]{null}), ClassTag$.MODULE$.apply(Js.Value.class)), (Types.Writer)default$.MODULE$.Tuple1W((Object)default$.MODULE$.IntRW())), "Harvest", ClassTag$.MODULE$.apply(SerializableHarvestMineral.class));
                            }
                        });
                        this.bitmap$0 |= 8;
                    }
                    return this.derive$macro$920;
                }
            }

            private Types.Writer derive$macro$833$lzycompute() {
                ReplayRecorder$.anon.1 var1_1 = this;
                synchronized (var1_1) {
                    if ((this.bitmap$0 & 0x10) == 0) {
                        this.derive$macro$833 = new Types.Knot$.Writer(default$.MODULE$.Knot(), (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Types.Writer<ReplayVersion> apply() {
                                return default$.MODULE$.annotate(default$.MODULE$.CaseW((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final Option<Tuple1<String>> apply(ReplayVersion x$3) {
                                        return ReplayVersion$.MODULE$.unapply(x$3).map((Function1)new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final Tuple1<String> apply(String _1) {
                                                return new Tuple1((Object)_1);
                                            }
                                        });
                                    }
                                }, (String[])((Object[])new String[]{"version"}), (Js.Value[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Js.Value[]{null}), ClassTag$.MODULE$.apply(Js.Value.class)), (Types.Writer)default$.MODULE$.Tuple1W((Object)default$.MODULE$.StringRW())), "Version", ClassTag$.MODULE$.apply(ReplayVersion.class));
                            }
                        });
                        this.bitmap$0 |= 0x10;
                    }
                    return this.derive$macro$833;
                }
            }

            private Types.Writer derive$macro$845$lzycompute() {
                ReplayRecorder$.anon.1 var1_1 = this;
                synchronized (var1_1) {
                    if ((this.bitmap$0 & 0x20) == 0) {
                        this.derive$macro$845 = new Types.Knot$.Writer(default$.MODULE$.Knot(), (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ ReplayRecorder$.anon.1 $outer;

                            public final Types.Writer<MineralRecord> apply() {
                                return default$.MODULE$.annotate(default$.MODULE$.CaseW((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final Option<Tuple2<Object, Vector2>> apply(MineralRecord x$0) {
                                        return MineralRecord$.MODULE$.unapply(x$0);
                                    }
                                }, (String[])((Object[])new String[]{"size", "position"}), (Js.Value[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Js.Value[]{null, null}), ClassTag$.MODULE$.apply(Js.Value.class)), (Types.Writer)default$.MODULE$.Tuple2W((Object)default$.MODULE$.IntRW(), this.$outer.derive$macro$849())), "Mineral", ClassTag$.MODULE$.apply(MineralRecord.class));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                        this.bitmap$0 |= 0x20;
                    }
                    return this.derive$macro$845;
                }
            }

            private Types.Writer derive$macro$880$lzycompute() {
                ReplayRecorder$.anon.1 var1_1 = this;
                synchronized (var1_1) {
                    if ((this.bitmap$0 & 0x40) == 0) {
                        this.derive$macro$880 = new Types.Knot$.Writer(default$.MODULE$.Knot(), (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ ReplayRecorder$.anon.1 $outer;

                            public final Types.Writer<WorldSize> apply() {
                                return default$.MODULE$.annotate(default$.MODULE$.CaseW((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final Option<Tuple1<Rectangle>> apply(WorldSize x$4) {
                                        return WorldSize$.MODULE$.unapply(x$4).map((Function1)new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final Tuple1<Rectangle> apply(Rectangle _1) {
                                                return new Tuple1((Object)_1);
                                            }
                                        });
                                    }
                                }, (String[])((Object[])new String[]{"size"}), (Js.Value[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Js.Value[]{null}), ClassTag$.MODULE$.apply(Js.Value.class)), (Types.Writer)default$.MODULE$.Tuple1W(this.$outer.derive$macro$883())), "WorldSize", ClassTag$.MODULE$.apply(WorldSize.class));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                        this.bitmap$0 |= 0x40;
                    }
                    return this.derive$macro$880;
                }
            }

            private Types.Writer derive$macro$908$lzycompute() {
                ReplayRecorder$.anon.1 var1_1 = this;
                synchronized (var1_1) {
                    if ((this.bitmap$0 & 0x80) == 0) {
                        this.derive$macro$908 = new Types.Knot$.Writer(default$.MODULE$.Knot(), (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ ReplayRecorder$.anon.1 $outer;

                            public final Types.Writer<MoveToPosition> apply() {
                                return default$.MODULE$.annotate(default$.MODULE$.CaseW((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final Option<Tuple1<Vector2>> apply(MoveToPosition x$5) {
                                        return MoveToPosition$.MODULE$.unapply(x$5).map((Function1)new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final Tuple1<Vector2> apply(Vector2 _1) {
                                                return new Tuple1((Object)_1);
                                            }
                                        });
                                    }
                                }, (String[])((Object[])new String[]{"position"}), (Js.Value[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Js.Value[]{null}), ClassTag$.MODULE$.apply(Js.Value.class)), (Types.Writer)default$.MODULE$.Tuple1W(this.$outer.derive$macro$849())), "MoveToPos", ClassTag$.MODULE$.apply(MoveToPosition.class));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                        this.bitmap$0 |= 0x80;
                    }
                    return this.derive$macro$908;
                }
            }

            private Types.Writer derive$macro$883$lzycompute() {
                ReplayRecorder$.anon.1 var1_1 = this;
                synchronized (var1_1) {
                    if ((this.bitmap$0 & 0x100) == 0) {
                        this.derive$macro$883 = new Types.Knot$.Writer(default$.MODULE$.Knot(), (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Types.Writer<Rectangle> apply() {
                                return default$.MODULE$.CaseW((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final Option<Tuple4<Object, Object, Object, Object>> apply(Rectangle x$0) {
                                        return Rectangle$.MODULE$.unapply(x$0);
                                    }
                                }, (String[])((Object[])new String[]{"xMin", "xMax", "yMin", "yMax"}), (Js.Value[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Js.Value[]{null, null, null, null}), ClassTag$.MODULE$.apply(Js.Value.class)), (Types.Writer)default$.MODULE$.Tuple4W((Object)default$.MODULE$.DoubleRW(), (Object)default$.MODULE$.DoubleRW(), (Object)default$.MODULE$.DoubleRW(), (Object)default$.MODULE$.DoubleRW()));
                            }
                        });
                        this.bitmap$0 |= 0x100;
                    }
                    return this.derive$macro$883;
                }
            }

            private Types.Writer derive$macro$916$lzycompute() {
                ReplayRecorder$.anon.1 var1_1 = this;
                synchronized (var1_1) {
                    if ((this.bitmap$0 & 0x200) == 0) {
                        this.derive$macro$916 = new Types.Knot$.Writer(default$.MODULE$.Knot(), (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Types.Writer<SerializableFireMissiles> apply() {
                                return default$.MODULE$.annotate(default$.MODULE$.CaseW((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final Option<Tuple1<Object>> apply(SerializableFireMissiles x$6) {
                                        return SerializableFireMissiles$.MODULE$.unapply(x$6).map((Function1)new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final Tuple1<Object> apply(int _1) {
                                                return new Tuple1.mcI.sp(_1);
                                            }
                                        });
                                    }
                                }, (String[])((Object[])new String[]{"targetID"}), (Js.Value[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Js.Value[]{null}), ClassTag$.MODULE$.apply(Js.Value.class)), (Types.Writer)default$.MODULE$.Tuple1W((Object)default$.MODULE$.IntRW())), "FireMissiles", ClassTag$.MODULE$.apply(SerializableFireMissiles.class));
                            }
                        });
                        this.bitmap$0 |= 0x200;
                    }
                    return this.derive$macro$916;
                }
            }

            private Types.Writer derive$macro$924$lzycompute() {
                ReplayRecorder$.anon.1 var1_1 = this;
                synchronized (var1_1) {
                    if ((this.bitmap$0 & 0x400) == 0) {
                        this.derive$macro$924 = new Types.Knot$.Writer(default$.MODULE$.Knot(), (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Types.Writer<SerializableDepositMinerals> apply() {
                                return default$.MODULE$.annotate(default$.MODULE$.CaseW((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final Option<Tuple1<Object>> apply(SerializableDepositMinerals x$7) {
                                        return SerializableDepositMinerals$.MODULE$.unapply(x$7).map((Function1)new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final Tuple1<Object> apply(int _1) {
                                                return new Tuple1.mcI.sp(_1);
                                            }
                                        });
                                    }
                                }, (String[])((Object[])new String[]{"targetID"}), (Js.Value[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Js.Value[]{null}), ClassTag$.MODULE$.apply(Js.Value.class)), (Types.Writer)default$.MODULE$.Tuple1W((Object)default$.MODULE$.IntRW())), "Deposit", ClassTag$.MODULE$.apply(SerializableDepositMinerals.class));
                            }
                        });
                        this.bitmap$0 |= 0x400;
                    }
                    return this.derive$macro$924;
                }
            }

            private Types.Writer derive$macro$874$lzycompute() {
                ReplayRecorder$.anon.1 var1_1 = this;
                synchronized (var1_1) {
                    if ((this.bitmap$0 & 0x800) == 0) {
                        this.derive$macro$874 = new Types.Knot$.Writer(default$.MODULE$.Knot(), (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Types.Writer<Timestep> apply() {
                                return default$.MODULE$.annotate(default$.MODULE$.CaseW((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final Option<Tuple1<Object>> apply(Timestep x$8) {
                                        return Timestep$.MODULE$.unapply(x$8).map((Function1)new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final Tuple1<Object> apply(long _1) {
                                                return new Tuple1.mcJ.sp(_1);
                                            }
                                        });
                                    }
                                }, (String[])((Object[])new String[]{"time"}), (Js.Value[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Js.Value[]{null}), ClassTag$.MODULE$.apply(Js.Value.class)), (Types.Writer)default$.MODULE$.Tuple1W((Object)default$.MODULE$.LongRW())), "Time", ClassTag$.MODULE$.apply(Timestep.class));
                            }
                        });
                        this.bitmap$0 |= 0x800;
                    }
                    return this.derive$macro$874;
                }
            }

            private Types.Writer derive$macro$892$lzycompute() {
                ReplayRecorder$.anon.1 var1_1 = this;
                synchronized (var1_1) {
                    if ((this.bitmap$0 & 0x1000) == 0) {
                        this.derive$macro$892 = new Types.Knot$.Writer(default$.MODULE$.Knot(), (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ ReplayRecorder$.anon.1 $outer;

                            public final Types.Writer<Command> apply() {
                                return default$.MODULE$.annotate(default$.MODULE$.CaseW((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final Option<Tuple2<Object, SerializableDroneCommand>> apply(Command x$0) {
                                        return Command$.MODULE$.unapply(x$0);
                                    }
                                }, (String[])((Object[])new String[]{"droneID", "command"}), (Js.Value[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Js.Value[]{null, null}), ClassTag$.MODULE$.apply(Js.Value.class)), (Types.Writer)default$.MODULE$.Tuple2W((Object)default$.MODULE$.IntRW(), this.$outer.derive$macro$896())), "Cmd", ClassTag$.MODULE$.apply(Command.class));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                        this.bitmap$0 |= 0x1000;
                    }
                    return this.derive$macro$892;
                }
            }

            private Types.Writer derive$macro$905$lzycompute() {
                ReplayRecorder$.anon.1 var1_1 = this;
                synchronized (var1_1) {
                    if ((this.bitmap$0 & 0x2000) == 0) {
                        this.derive$macro$905 = new Types.Knot$.Writer(default$.MODULE$.Knot(), (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Types.Writer<HoldPosition$> apply() {
                                return default$.MODULE$.annotate(default$.MODULE$.SingletonW((Object)HoldPosition$.MODULE$), "Stop", ClassTag$.MODULE$.apply(HoldPosition$.class));
                            }
                        });
                        this.bitmap$0 |= 0x2000;
                    }
                    return this.derive$macro$905;
                }
            }

            private Types.Writer derive$macro$856$lzycompute() {
                ReplayRecorder$.anon.1 var1_1 = this;
                synchronized (var1_1) {
                    if ((this.bitmap$0 & 0x4000) == 0) {
                        this.derive$macro$856 = new Types.Knot$.Writer(default$.MODULE$.Knot(), (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ ReplayRecorder$.anon.1 $outer;

                            public final Types.Writer<SpawnRecord> apply() {
                                return default$.MODULE$.annotate(default$.MODULE$.CaseW((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final Option<Tuple5<DroneSpec, Vector2, Object, Object, Option<String>>> apply(SpawnRecord x$0) {
                                        return SpawnRecord$.MODULE$.unapply(x$0);
                                    }
                                }, (String[])((Object[])new String[]{"spec", "position", "playerID", "resources", "name"}), (Js.Value[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Js.Value[]{null, null, null, null, null}), ClassTag$.MODULE$.apply(Js.Value.class)), (Types.Writer)default$.MODULE$.Tuple5W(this.$outer.derive$macro$859(), this.$outer.derive$macro$849(), (Object)default$.MODULE$.IntRW(), (Object)default$.MODULE$.IntRW(), (Object)default$.MODULE$.OptionW(default$.MODULE$.StringRW()))), "Spawn", ClassTag$.MODULE$.apply(SpawnRecord.class));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                        this.bitmap$0 |= 0x4000;
                    }
                    return this.derive$macro$856;
                }
            }

            private Types.Writer derive$macro$859$lzycompute() {
                ReplayRecorder$.anon.1 var1_1 = this;
                synchronized (var1_1) {
                    if ((this.bitmap$0 & 0x8000) == 0) {
                        this.derive$macro$859 = new Types.Knot$.Writer(default$.MODULE$.Knot(), (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Types.Writer<DroneSpec> apply() {
                                return default$.MODULE$.CaseW((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final Option<Tuple6<Object, Object, Object, Object, Object, Object>> apply(DroneSpec x$0) {
                                        return DroneSpec$.MODULE$.unapply(x$0);
                                    }
                                }, (String[])((Object[])new String[]{"storageModules", "missileBatteries", "constructors", "engines", "shieldGenerators", "costModifier"}), (Js.Value[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Js.Value[]{default$.MODULE$.writeJs((Object)BoxesRunTime.boxToInteger((int)DroneSpec$.MODULE$.apply$default$1()), (Types.Writer)default$.MODULE$.IntRW()), default$.MODULE$.writeJs((Object)BoxesRunTime.boxToInteger((int)DroneSpec$.MODULE$.apply$default$2()), (Types.Writer)default$.MODULE$.IntRW()), default$.MODULE$.writeJs((Object)BoxesRunTime.boxToInteger((int)DroneSpec$.MODULE$.apply$default$3()), (Types.Writer)default$.MODULE$.IntRW()), default$.MODULE$.writeJs((Object)BoxesRunTime.boxToInteger((int)DroneSpec$.MODULE$.apply$default$4()), (Types.Writer)default$.MODULE$.IntRW()), default$.MODULE$.writeJs((Object)BoxesRunTime.boxToInteger((int)DroneSpec$.MODULE$.apply$default$5()), (Types.Writer)default$.MODULE$.IntRW()), default$.MODULE$.writeJs((Object)BoxesRunTime.boxToInteger((int)DroneSpec$.MODULE$.apply$default$6()), (Types.Writer)default$.MODULE$.IntRW())}), ClassTag$.MODULE$.apply(Js.Value.class)), (Types.Writer)default$.MODULE$.Tuple6W((Object)default$.MODULE$.IntRW(), (Object)default$.MODULE$.IntRW(), (Object)default$.MODULE$.IntRW(), (Object)default$.MODULE$.IntRW(), (Object)default$.MODULE$.IntRW(), (Object)default$.MODULE$.IntRW()));
                            }
                        });
                        this.bitmap$0 |= 0x8000;
                    }
                    return this.derive$macro$859;
                }
            }

            private Types.Writer derive$macro$839$lzycompute() {
                ReplayRecorder$.anon.1 var1_1 = this;
                synchronized (var1_1) {
                    if ((this.bitmap$0 & 0x10000) == 0) {
                        this.derive$macro$839 = new Types.Knot$.Writer(default$.MODULE$.Knot(), (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Types.Writer<RNGSeed> apply() {
                                return default$.MODULE$.annotate(default$.MODULE$.CaseW((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final Option<Tuple1<Object>> apply(RNGSeed x$9) {
                                        return RNGSeed$.MODULE$.unapply(x$9).map((Function1)new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final Tuple1<Object> apply(int _1) {
                                                return new Tuple1.mcI.sp(_1);
                                            }
                                        });
                                    }
                                }, (String[])((Object[])new String[]{"seed"}), (Js.Value[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Js.Value[]{null}), ClassTag$.MODULE$.apply(Js.Value.class)), (Types.Writer)default$.MODULE$.Tuple1W((Object)default$.MODULE$.IntRW())), "Seed", ClassTag$.MODULE$.apply(RNGSeed.class));
                            }
                        });
                        this.bitmap$0 |= 0x10000;
                    }
                    return this.derive$macro$839;
                }
            }

            private Types.Writer derive$macro$912$lzycompute() {
                ReplayRecorder$.anon.1 var1_1 = this;
                synchronized (var1_1) {
                    if ((this.bitmap$0 & 0x20000) == 0) {
                        this.derive$macro$912 = new Types.Knot$.Writer(default$.MODULE$.Knot(), (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Types.Writer<SerializableMoveToDrone> apply() {
                                return default$.MODULE$.annotate(default$.MODULE$.CaseW((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final Option<Tuple1<Object>> apply(SerializableMoveToDrone x$10) {
                                        return SerializableMoveToDrone$.MODULE$.unapply(x$10).map((Function1)new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final Tuple1<Object> apply(int _1) {
                                                return new Tuple1.mcI.sp(_1);
                                            }
                                        });
                                    }
                                }, (String[])((Object[])new String[]{"droneID"}), (Js.Value[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Js.Value[]{null}), ClassTag$.MODULE$.apply(Js.Value.class)), (Types.Writer)default$.MODULE$.Tuple1W((Object)default$.MODULE$.IntRW())), "MoveToDrone", ClassTag$.MODULE$.apply(SerializableMoveToDrone.class));
                            }
                        });
                        this.bitmap$0 |= 0x20000;
                    }
                    return this.derive$macro$912;
                }
            }

            private Types.Writer derive$macro$928$lzycompute() {
                ReplayRecorder$.anon.1 var1_1 = this;
                synchronized (var1_1) {
                    if ((this.bitmap$0 & 0x40000) == 0) {
                        this.derive$macro$928 = new Types.Knot$.Writer(default$.MODULE$.Knot(), (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Types.Writer<MoveInDirection> apply() {
                                return default$.MODULE$.annotate(default$.MODULE$.CaseW((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final Option<Tuple1<Object>> apply(MoveInDirection x$11) {
                                        return MoveInDirection$.MODULE$.unapply(x$11).map((Function1)new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final Tuple1<Object> apply(float _1) {
                                                return new Tuple1((Object)BoxesRunTime.boxToFloat((float)_1));
                                            }
                                        });
                                    }
                                }, (String[])((Object[])new String[]{"direction"}), (Js.Value[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Js.Value[]{null}), ClassTag$.MODULE$.apply(Js.Value.class)), (Types.Writer)default$.MODULE$.Tuple1W((Object)default$.MODULE$.FloatRW())), "MoveInDirec", ClassTag$.MODULE$.apply(MoveInDirection.class));
                            }
                        });
                        this.bitmap$0 |= 0x40000;
                    }
                    return this.derive$macro$928;
                }
            }

            private Types.Writer derive$macro$932$lzycompute() {
                ReplayRecorder$.anon.1 var1_1 = this;
                synchronized (var1_1) {
                    if ((this.bitmap$0 & 0x80000) == 0) {
                        this.derive$macro$932 = new Types.Knot$.Writer(default$.MODULE$.Knot(), (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Types.Writer<SerializableMoveToMineralCrystal> apply() {
                                return default$.MODULE$.annotate(default$.MODULE$.CaseW((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final Option<Tuple1<Object>> apply(SerializableMoveToMineralCrystal x$12) {
                                        return SerializableMoveToMineralCrystal$.MODULE$.unapply(x$12).map((Function1)new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final Tuple1<Object> apply(int _1) {
                                                return new Tuple1.mcI.sp(_1);
                                            }
                                        });
                                    }
                                }, (String[])((Object[])new String[]{"mineralCrystalID"}), (Js.Value[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Js.Value[]{null}), ClassTag$.MODULE$.apply(Js.Value.class)), (Types.Writer)default$.MODULE$.Tuple1W((Object)default$.MODULE$.IntRW())), "MoveToMineral", ClassTag$.MODULE$.apply(SerializableMoveToMineralCrystal.class));
                            }
                        });
                        this.bitmap$0 |= 0x80000;
                    }
                    return this.derive$macro$932;
                }
            }

            private Types.Writer derive$macro$899$lzycompute() {
                ReplayRecorder$.anon.1 var1_1 = this;
                synchronized (var1_1) {
                    if ((this.bitmap$0 & 0x100000) == 0) {
                        this.derive$macro$899 = new Types.Knot$.Writer(default$.MODULE$.Knot(), (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ ReplayRecorder$.anon.1 $outer;

                            public final Types.Writer<SerializableConstructDrone> apply() {
                                return default$.MODULE$.annotate(default$.MODULE$.CaseW((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final Option<Tuple3<DroneSpec, Vector2, Object>> apply(SerializableConstructDrone x$0) {
                                        return SerializableConstructDrone$.MODULE$.unapply(x$0);
                                    }
                                }, (String[])((Object[])new String[]{"spec", "position", "resourceCost"}), (Js.Value[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Js.Value[]{null, null, null}), ClassTag$.MODULE$.apply(Js.Value.class)), (Types.Writer)default$.MODULE$.Tuple3W(this.$outer.derive$macro$859(), this.$outer.derive$macro$849(), (Object)default$.MODULE$.IntRW())), "Construct", ClassTag$.MODULE$.apply(SerializableConstructDrone.class));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                        this.bitmap$0 |= 0x100000;
                    }
                    return this.derive$macro$899;
                }
            }

            public Types.Writer<Vector2> derive$macro$849() {
                return (this.bitmap$0 & 1) == 0 ? this.derive$macro$849$lzycompute() : this.derive$macro$849;
            }

            public Types.Writer<SerializableDroneCommand> derive$macro$896() {
                return (this.bitmap$0 & 2) == 0 ? this.derive$macro$896$lzycompute() : this.derive$macro$896;
            }

            public Types.Writer<ReplayRecord> derive$macro$830() {
                return (this.bitmap$0 & 4) == 0 ? this.derive$macro$830$lzycompute() : this.derive$macro$830;
            }

            public Types.Writer<SerializableHarvestMineral> derive$macro$920() {
                return (this.bitmap$0 & 8) == 0 ? this.derive$macro$920$lzycompute() : this.derive$macro$920;
            }

            public Types.Writer<ReplayVersion> derive$macro$833() {
                return (this.bitmap$0 & 0x10) == 0 ? this.derive$macro$833$lzycompute() : this.derive$macro$833;
            }

            public Types.Writer<MineralRecord> derive$macro$845() {
                return (this.bitmap$0 & 0x20) == 0 ? this.derive$macro$845$lzycompute() : this.derive$macro$845;
            }

            public Types.Writer<WorldSize> derive$macro$880() {
                return (this.bitmap$0 & 0x40) == 0 ? this.derive$macro$880$lzycompute() : this.derive$macro$880;
            }

            public Types.Writer<MoveToPosition> derive$macro$908() {
                return (this.bitmap$0 & 0x80) == 0 ? this.derive$macro$908$lzycompute() : this.derive$macro$908;
            }

            public Types.Writer<Rectangle> derive$macro$883() {
                return (this.bitmap$0 & 0x100) == 0 ? this.derive$macro$883$lzycompute() : this.derive$macro$883;
            }

            public Types.Writer<SerializableFireMissiles> derive$macro$916() {
                return (this.bitmap$0 & 0x200) == 0 ? this.derive$macro$916$lzycompute() : this.derive$macro$916;
            }

            public Types.Writer<SerializableDepositMinerals> derive$macro$924() {
                return (this.bitmap$0 & 0x400) == 0 ? this.derive$macro$924$lzycompute() : this.derive$macro$924;
            }

            public Types.Writer<Timestep> derive$macro$874() {
                return (this.bitmap$0 & 0x800) == 0 ? this.derive$macro$874$lzycompute() : this.derive$macro$874;
            }

            public Types.Writer<Command> derive$macro$892() {
                return (this.bitmap$0 & 0x1000) == 0 ? this.derive$macro$892$lzycompute() : this.derive$macro$892;
            }

            public Types.Writer<HoldPosition$> derive$macro$905() {
                return (this.bitmap$0 & 0x2000) == 0 ? this.derive$macro$905$lzycompute() : this.derive$macro$905;
            }

            public Types.Writer<SpawnRecord> derive$macro$856() {
                return (this.bitmap$0 & 0x4000) == 0 ? this.derive$macro$856$lzycompute() : this.derive$macro$856;
            }

            public Types.Writer<DroneSpec> derive$macro$859() {
                return (this.bitmap$0 & 0x8000) == 0 ? this.derive$macro$859$lzycompute() : this.derive$macro$859;
            }

            public Types.Writer<RNGSeed> derive$macro$839() {
                return (this.bitmap$0 & 0x10000) == 0 ? this.derive$macro$839$lzycompute() : this.derive$macro$839;
            }

            public Types.Writer<SerializableMoveToDrone> derive$macro$912() {
                return (this.bitmap$0 & 0x20000) == 0 ? this.derive$macro$912$lzycompute() : this.derive$macro$912;
            }

            public Types.Writer<MoveInDirection> derive$macro$928() {
                return (this.bitmap$0 & 0x40000) == 0 ? this.derive$macro$928$lzycompute() : this.derive$macro$928;
            }

            public Types.Writer<SerializableMoveToMineralCrystal> derive$macro$932() {
                return (this.bitmap$0 & 0x80000) == 0 ? this.derive$macro$932$lzycompute() : this.derive$macro$932;
            }

            public Types.Writer<SerializableConstructDrone> derive$macro$899() {
                return (this.bitmap$0 & 0x100000) == 0 ? this.derive$macro$899$lzycompute() : this.derive$macro$899;
            }

            public Types.Writer<ReplayRecord> derive$macro$936() {
                return this.derive$macro$830();
            }
        }.derive$macro$936()));
    }

    public static void $init$(ReplayRecorder $this) {
        $this.timestep_$eq(0L);
        $this.timestepWritten_$eq(false);
    }
}

