/*
 * Decompiled with CFR 0.152.
 */
package cwinter.codecraft.core.objects.drone;

import cwinter.codecraft.collisions.ActiveVisionTracking;
import cwinter.codecraft.collisions.NearbyObject;
import cwinter.codecraft.collisions.VisionTracking;
import cwinter.codecraft.core.api.Drone;
import cwinter.codecraft.core.api.DroneControllerBase;
import cwinter.codecraft.core.api.DroneSpec;
import cwinter.codecraft.core.api.MineralCrystal;
import cwinter.codecraft.core.api.Player;
import cwinter.codecraft.core.game.CommandRecorder;
import cwinter.codecraft.core.game.DroneConstructionCancelled;
import cwinter.codecraft.core.game.DroneKilled;
import cwinter.codecraft.core.game.SimulationContext;
import cwinter.codecraft.core.game.SimulatorEvent;
import cwinter.codecraft.core.objects.HomingMissile;
import cwinter.codecraft.core.objects.MineralCrystalImpl;
import cwinter.codecraft.core.objects.WorldObject;
import cwinter.codecraft.core.objects.drone.Collision;
import cwinter.codecraft.core.objects.drone.Command;
import cwinter.codecraft.core.objects.drone.ConstructDrone;
import cwinter.codecraft.core.objects.drone.ConstructorModule;
import cwinter.codecraft.core.objects.drone.DebugLogDatum;
import cwinter.codecraft.core.objects.drone.DepositMinerals;
import cwinter.codecraft.core.objects.drone.DroneCommand;
import cwinter.codecraft.core.objects.drone.DroneContext;
import cwinter.codecraft.core.objects.drone.DroneDebugLog;
import cwinter.codecraft.core.objects.drone.DroneDynamics;
import cwinter.codecraft.core.objects.drone.DroneEvent;
import cwinter.codecraft.core.objects.drone.DroneEventQueue;
import cwinter.codecraft.core.objects.drone.DroneEventQueue$class;
import cwinter.codecraft.core.objects.drone.DroneGraphicsHandler;
import cwinter.codecraft.core.objects.drone.DroneGraphicsHandler$class;
import cwinter.codecraft.core.objects.drone.DroneHull;
import cwinter.codecraft.core.objects.drone.DroneHull$class;
import cwinter.codecraft.core.objects.drone.DroneImpl$;
import cwinter.codecraft.core.objects.drone.DroneMessageDisplay;
import cwinter.codecraft.core.objects.drone.DroneMessageDisplay$class;
import cwinter.codecraft.core.objects.drone.DroneModule;
import cwinter.codecraft.core.objects.drone.DroneModules;
import cwinter.codecraft.core.objects.drone.DroneModules$class;
import cwinter.codecraft.core.objects.drone.DroneMovementDetector;
import cwinter.codecraft.core.objects.drone.DroneMovementDetector$class;
import cwinter.codecraft.core.objects.drone.DroneMovementMsg;
import cwinter.codecraft.core.objects.drone.DroneVisionTracker;
import cwinter.codecraft.core.objects.drone.DroneVisionTracker$class;
import cwinter.codecraft.core.objects.drone.EnemyDrone;
import cwinter.codecraft.core.objects.drone.EnginesModule;
import cwinter.codecraft.core.objects.drone.FireMissiles;
import cwinter.codecraft.core.objects.drone.HarvestMineral;
import cwinter.codecraft.core.objects.drone.MissileBatteryModule;
import cwinter.codecraft.core.objects.drone.MovementCommand;
import cwinter.codecraft.core.objects.drone.Position;
import cwinter.codecraft.core.objects.drone.ShieldGeneratorModule;
import cwinter.codecraft.core.objects.drone.StorageModule;
import cwinter.codecraft.core.objects.drone.SyncableDroneDynamics;
import cwinter.codecraft.core.objects.drone.UnstructuredEvent;
import cwinter.codecraft.graphics.engine.ModelDescriptor;
import cwinter.codecraft.util.maths.Vector2;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.PriorityQueue;
import scala.collection.mutable.Queue;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\t}f!B\u0001\u0003\u0005\u0019a!!\u0003#s_:,\u0017*\u001c9m\u0015\t\u0019A!A\u0003ee>tWM\u0003\u0002\u0006\r\u00059qN\u00196fGR\u001c(BA\u0004\t\u0003\u0011\u0019wN]3\u000b\u0005%Q\u0011!C2pI\u0016\u001c'/\u00194u\u0015\u0005Y\u0011aB2xS:$XM]\n\u000b\u00015\u0019rc\u0007\u0010\"I\u001dR\u0003C\u0001\b\u0012\u001b\u0005y!\"\u0001\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005Iy!AB!osJ+g\r\u0005\u0002\u0015+5\tA!\u0003\u0002\u0017\t\tYqk\u001c:mI>\u0013'.Z2u!\tA\u0012$D\u0001\u0003\u0013\tQ\"A\u0001\nEe>tWMV5tS>tGK]1dW\u0016\u0014\bC\u0001\r\u001d\u0013\ti\"A\u0001\u000bEe>tWm\u0012:ba\"L7m\u001d%b]\u0012dWM\u001d\t\u00031}I!\u0001\t\u0002\u0003'\u0011\u0013xN\\3NKN\u001c\u0018mZ3ESN\u0004H.Y=\u0011\u0005a\u0011\u0013BA\u0012\u0003\u0005U!%o\u001c8f\u001b>4X-\\3oi\u0012+G/Z2u_J\u0004\"\u0001G\u0013\n\u0005\u0019\u0012!!\u0003#s_:,\u0007*\u001e7m!\tA\u0002&\u0003\u0002*\u0005\tyAI]8oK\u00163XM\u001c;Rk\u0016,X\r\u0005\u0002\u0019W%\u0011AF\u0001\u0002\r\tJ|g.Z'pIVdWm\u001d\u0005\t]\u0001\u0011)\u0019!C\u0001a\u0005!1\u000f]3d\u0007\u0001)\u0012!\r\t\u0003eUj\u0011a\r\u0006\u0003i\u0019\t1!\u00199j\u0013\t14GA\u0005Ee>tWm\u00159fG\"A\u0001\b\u0001B\u0001B\u0003%\u0011'A\u0003ta\u0016\u001c\u0007\u0005\u0003\u0005;\u0001\t\u0015\r\u0011\"\u0001<\u0003)\u0019wN\u001c;s_2dWM]\u000b\u0002yA\u0011!'P\u0005\u0003}M\u00121\u0003\u0012:p]\u0016\u001cuN\u001c;s_2dWM\u001d\"bg\u0016D\u0001\u0002\u0011\u0001\u0003\u0002\u0003\u0006I\u0001P\u0001\fG>tGO]8mY\u0016\u0014\b\u0005\u0003\u0005C\u0001\t\u0015\r\u0011\"\u0001D\u0003\u001d\u0019wN\u001c;fqR,\u0012\u0001\u0012\t\u00031\u0015K!A\u0012\u0002\u0003\u0019\u0011\u0013xN\\3D_:$X\r\u001f;\t\u0011!\u0003!\u0011!Q\u0001\n\u0011\u000b\u0001bY8oi\u0016DH\u000f\t\u0005\t\u0015\u0002\u0011\t\u0011)A\u0005\u0017\u0006Q\u0011N\\5uS\u0006d\u0007k\\:\u0011\u00051\u000bV\"A'\u000b\u00059{\u0015!B7bi\"\u001c(B\u0001)\t\u0003\u0011)H/\u001b7\n\u0005Ik%a\u0002,fGR|'O\r\u0005\t)\u0002\u0011\t\u0011)A\u0005+\u0006!A/[7f!\tqa+\u0003\u0002X\u001f\t1Ai\\;cY\u0016D\u0001\"\u0017\u0001\u0003\u0006\u0004%\tBW\u0001\u0012gR\f'\u000f^5oOJ+7o\\;sG\u0016\u001cX#A.\u0011\u00059a\u0016BA/\u0010\u0005\rIe\u000e\u001e\u0005\t?\u0002\u0011\t\u0011)A\u00057\u0006\u00112\u000f^1si&twMU3t_V\u00148-Z:!\u0011\u0015\t\u0007\u0001\"\u0001c\u0003\u0019a\u0014N\\5u}Q91\rZ3gO\"L\u0007C\u0001\r\u0001\u0011\u0015q\u0003\r1\u00012\u0011\u0015Q\u0004\r1\u0001=\u0011\u0015\u0011\u0005\r1\u0001E\u0011\u0015Q\u0005\r1\u0001L\u0011\u0015!\u0006\r1\u0001V\u0011\u001dI\u0006\r%AA\u0002mCqa\u001b\u0001C\u0002\u0013\u0005!,\u0001\u0002jI\"1Q\u000e\u0001Q\u0001\nm\u000b1!\u001b3!\u0011\u001dy\u0007A1A\u0005\u0002i\u000b\u0001\u0002\u001d:j_JLG/\u001f\u0005\u0007c\u0002\u0001\u000b\u0011B.\u0002\u0013A\u0014\u0018n\u001c:jif\u0004\u0003BB:\u0001A\u0003&A/A\u000b`G>t7\u000f\u001e:vGRLwN\u001c)s_\u001e\u0014Xm]:\u0011\u00079)8,\u0003\u0002w\u001f\t1q\n\u001d;j_:Da\u0001\u001f\u0001!B\u0013I\u0018a\u00025b]\u0012dWm\u001d\t\u0007u~\f\u0019!!\u0003\u000e\u0003mT!\u0001`?\u0002\u0013%lW.\u001e;bE2,'B\u0001@\u0010\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0004\u0003\u0003Y(aA'baB\u0019!'!\u0002\n\u0007\u0005\u001d1G\u0001\u0004QY\u0006LXM\u001d\t\u00041\u0005-\u0011bAA\u0007\u0005\tQQI\\3ns\u0012\u0013xN\\3\t\u0013\u0005E\u0001A1A\u0005\u0002\u0005M\u0011\u0001\u00033z]\u0006l\u0017nY:\u0016\u0005\u0005U\u0001c\u0001\r\u0002\u0018%\u0019\u0011\u0011\u0004\u0002\u0003\u001b\u0011\u0013xN\\3Es:\fW.[2t\u0011!\ti\u0002\u0001Q\u0001\n\u0005U\u0011!\u00033z]\u0006l\u0017nY:!\u0011\u001d\t\t\u0003\u0001C\u0001\u0003G\t!\"\u001b8ji&\fG.[:f)\u0011\t)#a\u000b\u0011\u00079\t9#C\u0002\u0002*=\u0011A!\u00168ji\"1A+a\bA\u0002UCq!a\f\u0001\t\u0003\n\t$\u0001\u0004va\u0012\fG/\u001a\u000b\u0003\u0003g\u0001b!!\u000e\u0002F\u0005-c\u0002BA\u001c\u0003\u0003rA!!\u000f\u0002@5\u0011\u00111\b\u0006\u0004\u0003{y\u0013A\u0002\u001fs_>$h(C\u0001\u0011\u0013\r\t\u0019eD\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t9%!\u0013\u0003\u0007M+\u0017OC\u0002\u0002D=\u0001B!!\u0014\u0002T5\u0011\u0011q\n\u0006\u0004\u0003#2\u0011\u0001B4b[\u0016LA!!\u0016\u0002P\tq1+[7vY\u0006$xN]#wK:$\bbBA-\u0001\u0011\u0005\u00111L\u0001\u001dkB$\u0017\r^3Q_NLG/[8o\t\u0016\u0004XM\u001c3f]R\u001cF/\u0019;f)\t\t)\u0003C\u0004\u0002`\u0001!\t!!\u0019\u0002\u0019\r|G\u000e\\5eK\u0012<\u0016\u000e\u001e5\u0015\t\u0005\u0015\u00121\r\u0005\b\u0003K\ni\u00061\u0001d\u0003\u0015yG\u000f[3s\u0011\u001d\tI\u0007\u0001C\u0001\u0003W\nQ\u0001\n2b]\u001e$B!!\n\u0002n!A\u0011qNA4\u0001\u0004\t\t(A\u0004d_6l\u0017M\u001c3\u0011\u0007a\t\u0019(C\u0002\u0002v\t\u0011A\u0002\u0012:p]\u0016\u001cu.\\7b]\u0012DC!a\u001a\u0002zA\u0019a\"a\u001f\n\u0007\u0005utB\u0001\u0004j]2Lg.\u001a\u0005\b\u0003\u0003\u0003A\u0011AAB\u00039)\u00070Z2vi\u0016\u001cu.\\7b]\u0012$B!!\n\u0002\u0006\"A\u0011qNA@\u0001\u0004\t\t\bC\u0004\u0002\n\u0002!\t!a#\u0002\u0015\u0005\u0004\b\u000f\\=Ti\u0006$X\r\u0006\u0003\u0002\u000e\u0006]E\u0003BA\u0013\u0003\u001fCqAQAD\u0001\b\t\t\n\u0005\u0003\u0002N\u0005M\u0015\u0002BAK\u0003\u001f\u0012\u0011cU5nk2\fG/[8o\u0007>tG/\u001a=u\u0011!\tI*a\"A\u0002\u0005m\u0015!B:uCR,\u0007c\u0001\r\u0002\u001e&\u0019\u0011q\u0014\u0002\u0003!\u0011\u0013xN\\3N_Z,W.\u001a8u\u001bN<\u0007bBAR\u0001\u0011\u0005\u0011QU\u0001\rCB\u0004H.\u001f%beZ,7\u000f\u001e\u000b\u0005\u0003O\u000bI\u000b\u0005\u0003\u000fk\u0006-\u0003\u0002CAV\u0003C\u0003\r!!,\u0002\u000f5Lg.\u001a:bYB\u0019A#a,\n\u0007\u0005EFA\u0001\nNS:,'/\u00197Def\u001cH/\u00197J[Bd\u0007bBA[\u0001\u0011%\u0011qW\u0001\u0014O&4X-T8wK6,g\u000e^\"p[6\fg\u000e\u001a\u000b\u0005\u0003s\u000by\fE\u0002\u000f\u0003wK1!!0\u0010\u0005\u001d\u0011un\u001c7fC:D\u0001\"!1\u00024\u0002\u0007\u00111Y\u0001\u0006m\u0006dW/\u001a\t\u00041\u0005\u0015\u0017bAAd\u0005\tyQj\u001c<f[\u0016tGoQ8n[\u0006tG\rC\u0004\u0002L\u0002!I!!4\u0002-M$\u0018M\u001d;Ee>tWmQ8ogR\u0014Xo\u0019;j_:$B!!\n\u0002P\"A\u0011qNAe\u0001\u0004\t\t\u000eE\u0002\u0019\u0003'L1!!6\u0003\u00059\u0019uN\\:ueV\u001cG\u000f\u0012:p]\u0016Dq!!7\u0001\t\u0003\tY.\u0001\u0005j[6|'-\u001b7f+\t\tI\fC\u0004\u0002`\u0002!I!!9\u0002\u0017\u0019L'/Z,fCB|gn\u001d\u000b\u0005\u0003K\t\u0019\u000fC\u0004\u0002f\u0006u\u0007\u0019A2\u0002\rQ\f'oZ3u\u0011\u001d\tI\u000f\u0001C\u0005\u0003W\fq\u0002[1sm\u0016\u001cHOU3t_V\u00148-\u001a\u000b\u0005\u0003K\ti\u000f\u0003\u0005\u0002p\u0006\u001d\b\u0019AAW\u00039i\u0017N\\3sC2\u001c%/_:uC2Dq!a=\u0001\t\u0013\t)0A\beKB|7/\u001b;NS:,'/\u00197t)\u0011\t)#a>\t\u000f\u0005\u0015\u0014\u0011\u001fa\u0001G\"A\u00111 \u0001\u0005\u0002\u0019\ti0A\u0002m_\u001e$B!!\n\u0002\u0000\"A!\u0011AA}\u0001\u0004\u0011\u0019!A\u0003eCR,X\u000eE\u0002\u0019\u0005\u000bI1Aa\u0002\u0003\u00055!UMY;h\u0019><G)\u0019;v[\"A\u00111 \u0001\u0005\u0002\u0019\u0011Y\u0001\u0006\u0003\u0002&\t5\u0001\"\u0003B\b\u0005\u0013!\t\u0019\u0001B\t\u0003\ri7o\u001a\t\u0006\u001d\tM!qC\u0005\u0004\u0005+y!\u0001\u0003\u001fcs:\fW.\u001a \u0011\t\te!q\u0004\b\u0004\u001d\tm\u0011b\u0001B\u000f\u001f\u00051\u0001K]3eK\u001aLAA!\t\u0003$\t11\u000b\u001e:j]\u001eT1A!\b\u0010\u0011\u001d\u00119\u0003\u0001C!\u0005S\t\u0001\u0002]8tSRLwN\\\u000b\u0002\u0017\"1!Q\u0006\u0001\u0005\u0002i\u000bq\"\\5tg&dWmQ8pY\u0012|wO\u001c\u0005\b\u0005c\u0001A\u0011AAn\u00039I7oQ8ogR\u0014Xo\u0019;j]\u001eDqA!\u000e\u0001\t\u0003\tY.\u0001\u0007jg\"\u000b'O^3ti&tw\rC\u0004\u0003:\u0001!\t!a7\u0002\u0011%\u001cXj\u001c<j]\u001eDaA!\u0010\u0001\t\u0003Q\u0016aD:u_J\fw-Z\"ba\u0006\u001c\u0017\u000e^=\t\r\t\u0005\u0003\u0001\"\u0001[\u0003\u0015\u0019\u0018\u000eZ3t\u0011\u001d\u0011)\u0005\u0001C\u0001\u0005\u000f\naA]1eSV\u001cXC\u0001B%!\rq!1J\u0005\u0004\u0005\u001bz!!\u0002$m_\u0006$\bb\u0002B)\u0001\u0011\u0005!1K\u0001\u0007a2\f\u00170\u001a:\u0016\u0005\u0005\r\u0001b\u0002B,\u0001\u0011\u0005!\u0011L\u0001\t[\u0006D8\u000b]3fIV\tQ\u000bC\u0004\u0003^\u0001!\tAa\u0018\u0002)\r|gn\u001d;sk\u000e$\u0018n\u001c8Qe><'/Z:t+\u0005!\bb\u0002B2\u0001\u0011\u0005!QM\u0001\u0019G>t7\u000f\u001e:vGRLwN\u001c)s_\u001e\u0014Xm]:`I\u0015\fH\u0003BA\u0013\u0005OBq!!1\u0003b\u0001\u0007A\u000fC\u0004\u0003l\u0001!\t!a7\u0002\u0013%\u001c8\u000b^;o]\u0016$\u0007B\u0002B8\u0001\u0011\u0005!,\u0001\tbm\u0006LG.\u00192mKN#xN]1hK\"1!1\u000f\u0001\u0005\u0002i\u000bqb\u001d;pe\u0016$'+Z:pkJ\u001cWm\u001d\u0005\b\u0005o\u0002A\u0011\u0001B=\u0003MI7/\u00138ICJ4Xm\u001d;j]\u001e\u0014\u0016M\\4f)\u0011\tILa\u001f\t\u0011\u0005-&Q\u000fa\u0001\u0003[CqAa \u0001\t\u0003\u0011\t)\u0001\u0006xe\u0006\u0004\b/\u001a:G_J$BAa!\u0003\nB\u0019!G!\"\n\u0007\t\u001d5GA\u0003Ee>tW\r\u0003\u0005\u0003R\tu\u0004\u0019AA\u0002\u0011!\u0011i\t\u0001C\u0001\r\t=\u0015a\u00033fCRDWI^3oiN,\"!a\r\t\u000f\tM\u0005\u0001\"\u0011\u0003\u0016\u0006AAo\\*ue&tw\r\u0006\u0002\u0003\u0018\u001dQ!\u0011\u0014\u0002\u0002\u0002#\u0005aAa'\u0002\u0013\u0011\u0013xN\\3J[Bd\u0007c\u0001\r\u0003\u001e\u001aI\u0011AAA\u0001\u0012\u00031!qT\n\u0004\u0005;k\u0001bB1\u0003\u001e\u0012\u0005!1\u0015\u000b\u0003\u00057C!Ba*\u0003\u001eF\u0005I\u0011\u0001BU\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%mU\u0011!1\u0016\u0016\u00047\n56F\u0001BX!\u0011\u0011\tLa/\u000e\u0005\tM&\u0002\u0002B[\u0005o\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\tev\"\u0001\u0006b]:|G/\u0019;j_:LAA!0\u00034\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public final class DroneImpl
implements WorldObject,
DroneVisionTracker,
DroneGraphicsHandler,
DroneMessageDisplay,
DroneMovementDetector,
DroneHull,
DroneEventQueue,
DroneModules {
    private final DroneSpec spec;
    private final DroneControllerBase controller;
    private final DroneContext context;
    private final int startingResources;
    private final int id;
    private final int priority;
    private Option<Object> _constructionProgress;
    private Map<Player, EnemyDrone> handles;
    private final DroneDynamics dynamics;
    private final Option<MissileBatteryModule> weapons;
    private final Option<StorageModule> storage;
    private final Option<ConstructorModule> manipulator;
    private final Option<ShieldGeneratorModule> shieldGenerators;
    private final Option<EnginesModule> engines;
    private final Seq<Option<DroneModule>> droneModules;
    private final Queue cwinter$codecraft$core$objects$drone$DroneEventQueue$$eventQueue;
    private int cwinter$codecraft$core$objects$drone$DroneEventQueue$$t;
    private List<Object> hullState;
    private boolean cwinter$codecraft$core$objects$drone$DroneHull$$_hasDied;
    private Vector2 cwinter$codecraft$core$objects$drone$DroneMovementDetector$$_oldPosition;
    private double cwinter$codecraft$core$objects$drone$DroneMovementDetector$$_oldOrientation;
    private boolean cwinter$codecraft$core$objects$drone$DroneMovementDetector$$_hasMoved;
    private int cwinter$codecraft$core$objects$drone$DroneMessageDisplay$$messageCooldown;
    private Option cwinter$codecraft$core$objects$drone$DroneMessageDisplay$$debugMessage;
    private List cwinter$codecraft$core$objects$drone$DroneMessageDisplay$$debugTexts;
    private final Queue cwinter$codecraft$core$objects$drone$DroneGraphicsHandler$$oldPositions;
    private Option cwinter$codecraft$core$objects$drone$DroneGraphicsHandler$$cachedDescriptor;
    private List cwinter$codecraft$core$objects$drone$DroneGraphicsHandler$$_collisionMarkers;
    private Set cwinter$codecraft$core$objects$drone$DroneVisionTracker$$_mineralsInSight;
    private Set cwinter$codecraft$core$objects$drone$DroneVisionTracker$$_dronesInSight;
    private Set cwinter$codecraft$core$objects$drone$DroneVisionTracker$$_enemiesInSight;
    private Set cwinter$codecraft$core$objects$drone$DroneVisionTracker$$_alliesInSight;
    private Set<VisionTracking> nearbyObjects;
    private final PriorityQueue<NearbyObject> cwinter$codecraft$collisions$ActiveVisionTracking$$collisionQueue;
    private boolean removed;
    private Tuple2<Object, Object> cell;

    public static int $lessinit$greater$default$6() {
        return DroneImpl$.MODULE$.$lessinit$greater$default$6();
    }

    @Override
    public Option<MissileBatteryModule> weapons() {
        return this.weapons;
    }

    @Override
    public Option<StorageModule> storage() {
        return this.storage;
    }

    @Override
    public Option<ConstructorModule> manipulator() {
        return this.manipulator;
    }

    @Override
    public Option<ShieldGeneratorModule> shieldGenerators() {
        return this.shieldGenerators;
    }

    @Override
    public Option<EnginesModule> engines() {
        return this.engines;
    }

    @Override
    public Seq<Option<DroneModule>> droneModules() {
        return this.droneModules;
    }

    @Override
    public void cwinter$codecraft$core$objects$drone$DroneModules$_setter_$weapons_$eq(Option x$1) {
        this.weapons = x$1;
    }

    @Override
    public void cwinter$codecraft$core$objects$drone$DroneModules$_setter_$storage_$eq(Option x$1) {
        this.storage = x$1;
    }

    @Override
    public void cwinter$codecraft$core$objects$drone$DroneModules$_setter_$manipulator_$eq(Option x$1) {
        this.manipulator = x$1;
    }

    @Override
    public void cwinter$codecraft$core$objects$drone$DroneModules$_setter_$shieldGenerators_$eq(Option x$1) {
        this.shieldGenerators = x$1;
    }

    @Override
    public void cwinter$codecraft$core$objects$drone$DroneModules$_setter_$engines_$eq(Option x$1) {
        this.engines = x$1;
    }

    @Override
    public void cwinter$codecraft$core$objects$drone$DroneModules$_setter_$droneModules_$eq(Seq x$1) {
        this.droneModules = x$1;
    }

    @Override
    public Seq<SimulatorEvent> updateModules() {
        return DroneModules$class.updateModules(this);
    }

    @Override
    public Queue cwinter$codecraft$core$objects$drone$DroneEventQueue$$eventQueue() {
        return this.cwinter$codecraft$core$objects$drone$DroneEventQueue$$eventQueue;
    }

    @Override
    public void cwinter$codecraft$core$objects$drone$DroneEventQueue$_setter_$cwinter$codecraft$core$objects$drone$DroneEventQueue$$eventQueue_$eq(Queue x$1) {
        this.cwinter$codecraft$core$objects$drone$DroneEventQueue$$eventQueue = x$1;
    }

    @Override
    public int cwinter$codecraft$core$objects$drone$DroneEventQueue$$t() {
        return this.cwinter$codecraft$core$objects$drone$DroneEventQueue$$t;
    }

    @Override
    public void cwinter$codecraft$core$objects$drone$DroneEventQueue$$t_$eq(int x$1) {
        this.cwinter$codecraft$core$objects$drone$DroneEventQueue$$t = x$1;
    }

    @Override
    public void processEvents() {
        DroneEventQueue$class.processEvents(this);
    }

    @Override
    public void enqueueEvent(DroneEvent event) {
        DroneEventQueue$class.enqueueEvent(this, event);
    }

    @Override
    public List<Object> hullState() {
        return this.hullState;
    }

    @Override
    public void hullState_$eq(List<Object> x$1) {
        this.hullState = x$1;
    }

    @Override
    public boolean cwinter$codecraft$core$objects$drone$DroneHull$$_hasDied() {
        return this.cwinter$codecraft$core$objects$drone$DroneHull$$_hasDied;
    }

    @Override
    public void cwinter$codecraft$core$objects$drone$DroneHull$$_hasDied_$eq(boolean x$1) {
        this.cwinter$codecraft$core$objects$drone$DroneHull$$_hasDied = x$1;
    }

    @Override
    public void missileHit(HomingMissile missile) {
        DroneHull$class.missileHit(this, missile);
    }

    @Override
    public void missileHit(Vector2 position2, int shieldDamage, int hullDamage) {
        DroneHull$class.missileHit(this, position2, shieldDamage, hullDamage);
    }

    @Override
    public boolean isDead() {
        return DroneHull$class.isDead(this);
    }

    @Override
    public int hitpoints() {
        return DroneHull$class.hitpoints(this);
    }

    @Override
    public int hitpointsHull() {
        return DroneHull$class.hitpointsHull(this);
    }

    @Override
    public Vector2 cwinter$codecraft$core$objects$drone$DroneMovementDetector$$_oldPosition() {
        return this.cwinter$codecraft$core$objects$drone$DroneMovementDetector$$_oldPosition;
    }

    @Override
    public void cwinter$codecraft$core$objects$drone$DroneMovementDetector$$_oldPosition_$eq(Vector2 x$1) {
        this.cwinter$codecraft$core$objects$drone$DroneMovementDetector$$_oldPosition = x$1;
    }

    @Override
    public double cwinter$codecraft$core$objects$drone$DroneMovementDetector$$_oldOrientation() {
        return this.cwinter$codecraft$core$objects$drone$DroneMovementDetector$$_oldOrientation;
    }

    @Override
    public void cwinter$codecraft$core$objects$drone$DroneMovementDetector$$_oldOrientation_$eq(double x$1) {
        this.cwinter$codecraft$core$objects$drone$DroneMovementDetector$$_oldOrientation = x$1;
    }

    @Override
    public boolean cwinter$codecraft$core$objects$drone$DroneMovementDetector$$_hasMoved() {
        return this.cwinter$codecraft$core$objects$drone$DroneMovementDetector$$_hasMoved;
    }

    @Override
    public void cwinter$codecraft$core$objects$drone$DroneMovementDetector$$_hasMoved_$eq(boolean x$1) {
        this.cwinter$codecraft$core$objects$drone$DroneMovementDetector$$_hasMoved = x$1;
    }

    @Override
    public void recomputeHasMoved() {
        DroneMovementDetector$class.recomputeHasMoved(this);
    }

    @Override
    public boolean hasMoved() {
        return DroneMovementDetector$class.hasMoved(this);
    }

    @Override
    public int cwinter$codecraft$core$objects$drone$DroneMessageDisplay$$messageCooldown() {
        return this.cwinter$codecraft$core$objects$drone$DroneMessageDisplay$$messageCooldown;
    }

    @Override
    public void cwinter$codecraft$core$objects$drone$DroneMessageDisplay$$messageCooldown_$eq(int x$1) {
        this.cwinter$codecraft$core$objects$drone$DroneMessageDisplay$$messageCooldown = x$1;
    }

    @Override
    public Option cwinter$codecraft$core$objects$drone$DroneMessageDisplay$$debugMessage() {
        return this.cwinter$codecraft$core$objects$drone$DroneMessageDisplay$$debugMessage;
    }

    @Override
    public void cwinter$codecraft$core$objects$drone$DroneMessageDisplay$$debugMessage_$eq(Option x$1) {
        this.cwinter$codecraft$core$objects$drone$DroneMessageDisplay$$debugMessage = x$1;
    }

    @Override
    public List cwinter$codecraft$core$objects$drone$DroneMessageDisplay$$debugTexts() {
        return this.cwinter$codecraft$core$objects$drone$DroneMessageDisplay$$debugTexts;
    }

    @Override
    public void cwinter$codecraft$core$objects$drone$DroneMessageDisplay$$debugTexts_$eq(List x$1) {
        this.cwinter$codecraft$core$objects$drone$DroneMessageDisplay$$debugTexts = x$1;
    }

    @Override
    public void error(String message) {
        DroneMessageDisplay$class.error(this, message);
    }

    @Override
    public void warn(String message) {
        DroneMessageDisplay$class.warn(this, message);
    }

    @Override
    public void inform(String message) {
        DroneMessageDisplay$class.inform(this, message);
    }

    @Override
    public void showText(String message) {
        DroneMessageDisplay$class.showText(this, message);
    }

    @Override
    public void showText(String message, float xPos, float yPos) {
        DroneMessageDisplay$class.showText(this, message, xPos, yPos);
    }

    @Override
    public void resetMessageDisplay() {
        DroneMessageDisplay$class.resetMessageDisplay(this);
    }

    @Override
    public void displayMessages() {
        DroneMessageDisplay$class.displayMessages(this);
    }

    @Override
    public Queue cwinter$codecraft$core$objects$drone$DroneGraphicsHandler$$oldPositions() {
        return this.cwinter$codecraft$core$objects$drone$DroneGraphicsHandler$$oldPositions;
    }

    @Override
    public void cwinter$codecraft$core$objects$drone$DroneGraphicsHandler$_setter_$cwinter$codecraft$core$objects$drone$DroneGraphicsHandler$$oldPositions_$eq(Queue x$1) {
        this.cwinter$codecraft$core$objects$drone$DroneGraphicsHandler$$oldPositions = x$1;
    }

    @Override
    public Option cwinter$codecraft$core$objects$drone$DroneGraphicsHandler$$cachedDescriptor() {
        return this.cwinter$codecraft$core$objects$drone$DroneGraphicsHandler$$cachedDescriptor;
    }

    @Override
    public void cwinter$codecraft$core$objects$drone$DroneGraphicsHandler$$cachedDescriptor_$eq(Option x$1) {
        this.cwinter$codecraft$core$objects$drone$DroneGraphicsHandler$$cachedDescriptor = x$1;
    }

    @Override
    public List cwinter$codecraft$core$objects$drone$DroneGraphicsHandler$$_collisionMarkers() {
        return this.cwinter$codecraft$core$objects$drone$DroneGraphicsHandler$$_collisionMarkers;
    }

    @Override
    public void cwinter$codecraft$core$objects$drone$DroneGraphicsHandler$$_collisionMarkers_$eq(List x$1) {
        this.cwinter$codecraft$core$objects$drone$DroneGraphicsHandler$$_collisionMarkers = x$1;
    }

    @Override
    public Seq<ModelDescriptor<?>> descriptor() {
        return DroneGraphicsHandler$class.descriptor(this);
    }

    @Override
    public void invalidateModelCache() {
        DroneGraphicsHandler$class.invalidateModelCache(this);
    }

    @Override
    public void recordPosition() {
        DroneGraphicsHandler$class.recordPosition(this);
    }

    @Override
    public void addCollisionMarker(Vector2 collisionPosition) {
        DroneGraphicsHandler$class.addCollisionMarker(this, collisionPosition);
    }

    @Override
    public void updateCollisionMarkers() {
        DroneGraphicsHandler$class.updateCollisionMarkers(this);
    }

    @Override
    public Set cwinter$codecraft$core$objects$drone$DroneVisionTracker$$_mineralsInSight() {
        return this.cwinter$codecraft$core$objects$drone$DroneVisionTracker$$_mineralsInSight;
    }

    @Override
    public void cwinter$codecraft$core$objects$drone$DroneVisionTracker$$_mineralsInSight_$eq(Set x$1) {
        this.cwinter$codecraft$core$objects$drone$DroneVisionTracker$$_mineralsInSight = x$1;
    }

    @Override
    public Set cwinter$codecraft$core$objects$drone$DroneVisionTracker$$_dronesInSight() {
        return this.cwinter$codecraft$core$objects$drone$DroneVisionTracker$$_dronesInSight;
    }

    @Override
    public void cwinter$codecraft$core$objects$drone$DroneVisionTracker$$_dronesInSight_$eq(Set x$1) {
        this.cwinter$codecraft$core$objects$drone$DroneVisionTracker$$_dronesInSight = x$1;
    }

    @Override
    public Set cwinter$codecraft$core$objects$drone$DroneVisionTracker$$_enemiesInSight() {
        return this.cwinter$codecraft$core$objects$drone$DroneVisionTracker$$_enemiesInSight;
    }

    @Override
    public void cwinter$codecraft$core$objects$drone$DroneVisionTracker$$_enemiesInSight_$eq(Set x$1) {
        this.cwinter$codecraft$core$objects$drone$DroneVisionTracker$$_enemiesInSight = x$1;
    }

    @Override
    public Set cwinter$codecraft$core$objects$drone$DroneVisionTracker$$_alliesInSight() {
        return this.cwinter$codecraft$core$objects$drone$DroneVisionTracker$$_alliesInSight;
    }

    @Override
    public void cwinter$codecraft$core$objects$drone$DroneVisionTracker$$_alliesInSight_$eq(Set x$1) {
        this.cwinter$codecraft$core$objects$drone$DroneVisionTracker$$_alliesInSight = x$1;
    }

    @Override
    public void objectEnteredVision(VisionTracking obj) {
        DroneVisionTracker$class.objectEnteredVision(this, obj);
    }

    @Override
    public void objectLeftVision(VisionTracking obj) {
        DroneVisionTracker$class.objectLeftVision(this, obj);
    }

    @Override
    public void objectRemoved(VisionTracking obj) {
        DroneVisionTracker$class.objectRemoved(this, obj);
    }

    @Override
    public Set<Drone> dronesInSight() {
        return DroneVisionTracker$class.dronesInSight(this);
    }

    @Override
    public Set<Drone> enemiesInSight() {
        return DroneVisionTracker$class.enemiesInSight(this);
    }

    @Override
    public Set<Drone> alliesInSight() {
        return DroneVisionTracker$class.alliesInSight(this);
    }

    @Override
    public Set<MineralCrystal> mineralsInSight() {
        return DroneVisionTracker$class.mineralsInSight(this);
    }

    public Set<VisionTracking> nearbyObjects() {
        return this.nearbyObjects;
    }

    public void nearbyObjects_$eq(Set<VisionTracking> x$1) {
        this.nearbyObjects = x$1;
    }

    public PriorityQueue<NearbyObject> cwinter$codecraft$collisions$ActiveVisionTracking$$collisionQueue() {
        return this.cwinter$codecraft$collisions$ActiveVisionTracking$$collisionQueue;
    }

    public void cwinter$codecraft$collisions$ActiveVisionTracking$_setter_$cwinter$codecraft$collisions$ActiveVisionTracking$$collisionQueue_$eq(PriorityQueue x$1) {
        this.cwinter$codecraft$collisions$ActiveVisionTracking$$collisionQueue = x$1;
    }

    public void objectIsNearby(VisionTracking obj) {
        ActiveVisionTracking.class.objectIsNearby((ActiveVisionTracking)this, (VisionTracking)obj);
    }

    public void recomputeVisible(int time, double radius) {
        ActiveVisionTracking.class.recomputeVisible((ActiveVisionTracking)this, (int)time, (double)radius);
    }

    public boolean removed() {
        return this.removed;
    }

    public void removed_$eq(boolean x$1) {
        this.removed = x$1;
    }

    public Tuple2<Object, Object> cell() {
        return this.cell;
    }

    public void cell_$eq(Tuple2<Object, Object> x$1) {
        this.cell = x$1;
    }

    public int x() {
        return VisionTracking.class.x((VisionTracking)this);
    }

    public int y() {
        return VisionTracking.class.y((VisionTracking)this);
    }

    public void x_$eq(int value) {
        VisionTracking.class.x_$eq((VisionTracking)this, (int)value);
    }

    public void y_$eq(int value) {
        VisionTracking.class.y_$eq((VisionTracking)this, (int)value);
    }

    public DroneSpec spec() {
        return this.spec;
    }

    public DroneControllerBase controller() {
        return this.controller;
    }

    public DroneContext context() {
        return this.context;
    }

    public int startingResources() {
        return this.startingResources;
    }

    @Override
    public int id() {
        return this.id;
    }

    public int priority() {
        return this.priority;
    }

    public DroneDynamics dynamics() {
        return this.dynamics;
    }

    public void initialise(double time) {
        this.dynamics().setTime(time);
        this.controller().initialise(this);
        this.invalidateModelCache();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Seq<SimulatorEvent> update() {
        void var1_1;
        this.log(new Position(this.position(), this.dynamics().orientation()));
        this.handles.withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Player, EnemyDrone> check$ifrefutable$1) {
                Tuple2<Player, EnemyDrone> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Tuple2<Player, EnemyDrone> x$1) {
                Tuple2<Player, EnemyDrone> tuple2 = x$1;
                if (tuple2 != null) {
                    EnemyDrone wrapper = (EnemyDrone)tuple2._2();
                    wrapper.recordPosition();
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
        });
        Seq<SimulatorEvent> events = this.updateModules();
        this.dynamics().recomputeVelocity();
        this.updateCollisionMarkers();
        this.recordPosition();
        this.displayMessages();
        return var1_1;
    }

    public void updatePositionDependentState() {
        this.recomputeHasMoved();
        this.dynamics().checkArrivalConditions().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DroneImpl $outer;

            public final void apply(DroneEvent event) {
                this.$outer.enqueueEvent(event);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void collidedWith(DroneImpl other) {
        this.log(new Collision(this.position(), other.id()));
        this.addCollisionMarker(other.position());
    }

    public void $bang(DroneCommand command) {
        this.executeCommand(command);
    }

    public void executeCommand(DroneCommand command) {
        DroneCommand droneCommand;
        block10: {
            boolean redundant;
            block6: {
                block9: {
                    block8: {
                        block7: {
                            block5: {
                                if (this.isDead()) {
                                    this.warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Command ", " given to dead drone."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{command})));
                                    return;
                                }
                                redundant = false;
                                droneCommand = command;
                                if (!(droneCommand instanceof MovementCommand)) break block5;
                                MovementCommand movementCommand = (MovementCommand)droneCommand;
                                redundant = this.giveMovementCommand(movementCommand);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                break block6;
                            }
                            if (!(droneCommand instanceof ConstructDrone)) break block7;
                            ConstructDrone constructDrone = (ConstructDrone)droneCommand;
                            this.startDroneConstruction(constructDrone);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block6;
                        }
                        if (!(droneCommand instanceof DepositMinerals)) break block8;
                        DepositMinerals depositMinerals2 = (DepositMinerals)droneCommand;
                        DroneImpl target = depositMinerals2.target();
                        this.depositMinerals(target);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block6;
                    }
                    if (!(droneCommand instanceof FireMissiles)) break block9;
                    FireMissiles fireMissiles = (FireMissiles)droneCommand;
                    DroneImpl target = fireMissiles.target();
                    this.fireWeapons(target);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block6;
                }
                if (!(droneCommand instanceof HarvestMineral)) break block10;
                HarvestMineral harvestMineral = (HarvestMineral)droneCommand;
                MineralCrystalImpl mineral = harvestMineral.mineral();
                this.harvestResource(mineral);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            if (!redundant) {
                this.context().replayRecorder().record(this.id(), command);
                this.context().commandRecorder().foreach((Function1)new Serializable(this, command){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ DroneImpl $outer;
                    private final DroneCommand command$1;

                    public final void apply(CommandRecorder x$2) {
                        x$2.record(this.$outer.id(), this.command$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.command$1 = command$1;
                    }
                });
            }
            this.log(new Command(command, redundant));
            return;
        }
        throw new MatchError((Object)droneCommand);
    }

    public void applyState(DroneMovementMsg state, SimulationContext context) {
        DroneDynamics droneDynamics = this.dynamics();
        if (droneDynamics instanceof SyncableDroneDynamics) {
            DroneDynamics droneDynamics2 = droneDynamics;
            ((SyncableDroneDynamics)((Object)droneDynamics2)).synchronize(state, context);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        throw new AssertionError((Object)"Trying to apply state to locally computed drone.");
    }

    public Option<SimulatorEvent> applyHarvest(MineralCrystalImpl mineral) {
        Predef$.MODULE$.assert(this.context().isMultiplayer() && !this.context().isLocallyComputed(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Trying to apply harvest to locally computed drone.";
            }
        });
        Predef$.MODULE$.assert(this.storage().nonEmpty(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Trying to apply harvest to drone without storage module.";
            }
        });
        return this.storage().flatMap((Function1)new Serializable(this, mineral){
            public static final long serialVersionUID = 0L;
            private final MineralCrystalImpl mineral$1;

            public final Option<SimulatorEvent> apply(StorageModule x$3) {
                return x$3.performHarvest(this.mineral$1);
            }
            {
                this.mineral$1 = mineral$1;
            }
        });
    }

    private boolean giveMovementCommand(MovementCommand value) {
        return this.dynamics().setMovementCommand(value);
    }

    private void startDroneConstruction(ConstructDrone command) {
        Option<ConstructorModule> option;
        block4: {
            block3: {
                block2: {
                    option = this.manipulator();
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    ConstructorModule m = (ConstructorModule)some.x();
                    m.startDroneConstruction(command);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                this.warn("Drone construction requires a constructor module.");
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError(option);
    }

    public boolean immobile() {
        return this.droneModules().exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Option<DroneModule> x$4) {
                return x$4.exists((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(DroneModule x$5) {
                        return x$5.cancelMovement();
                    }
                });
            }
        });
    }

    private void fireWeapons(DroneImpl target) {
        Option<MissileBatteryModule> option;
        block5: {
            block3: {
                block4: {
                    block2: {
                        DroneImpl droneImpl = target;
                        DroneImpl droneImpl2 = this;
                        if (droneImpl != null ? !droneImpl.equals(droneImpl2) : droneImpl2 != null) break block2;
                        this.warn("Drone tried to shoot itself!");
                        break block3;
                    }
                    option = this.weapons();
                    if (!(option instanceof Some)) break block4;
                    Some some = (Some)option;
                    MissileBatteryModule w = (MissileBatteryModule)some.x();
                    w.fire(target);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block5;
                this.warn("Firing missiles requires a missile battery module.");
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError(option);
    }

    private void harvestResource(MineralCrystalImpl mineralCrystal) {
        Option<StorageModule> option;
        block4: {
            block3: {
                block2: {
                    option = this.storage();
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    StorageModule s = (StorageModule)some.x();
                    s.harvestMineral(mineralCrystal);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                this.warn("Harvesting resources requires a storage module.");
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError(option);
    }

    private void depositMinerals(DroneImpl other) {
        DroneImpl droneImpl = other;
        DroneImpl droneImpl2 = this;
        if (!(droneImpl != null ? !droneImpl.equals(droneImpl2) : droneImpl2 != null)) {
            this.warn("Drone is trying to deposit minerals into itself!");
        } else if (other.storage().isEmpty()) {
            this.warn("Trying to deposit minerals into a drone without a storage module.");
        } else if (this.storedResources() == 0) {
            this.warn("Drone has no minerals to deposit.");
        } else if (other.position().$minus(this.position()).lengthSquared() > (this.radius() + other.radius() + (float)20) * (this.radius() + other.radius() + (float)20)) {
            this.warn("Too far away to deposit minerals.");
        } else {
            this.storage().foreach((Function1)new Serializable(this, other){
                public static final long serialVersionUID = 0L;
                private final DroneImpl other$1;

                public final void apply(StorageModule s) {
                    s.depositResources(this.other$1.storage());
                }
                {
                    this.other$1 = other$1;
                }
            });
        }
    }

    public void log(DebugLogDatum datum) {
        this.context().debugLog().foreach((Function1)new Serializable(this, datum){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DroneImpl $outer;
            private final DebugLogDatum datum$1;

            public final void apply(DroneDebugLog log2) {
                log2.record(this.$outer.context().simulator().timestep(), this.$outer.id(), this.datum$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.datum$1 = datum$1;
            }
        });
    }

    public void log(Function0<String> msg) {
        this.log(new UnstructuredEvent((String)msg.apply()));
    }

    @Override
    public Vector2 position() {
        return this.dynamics().pos();
    }

    public int missileCooldown() {
        return BoxesRunTime.unboxToInt((Object)this.weapons().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(MissileBatteryModule x$6) {
                return x$6.cooldown();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return 1;
            }
        }));
    }

    public boolean isConstructing() {
        return this.manipulator().exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(ConstructorModule x$7) {
                return x$7.isConstructing();
            }
        });
    }

    public boolean isHarvesting() {
        return this.storage().exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(StorageModule x$8) {
                return x$8.isHarvesting();
            }
        });
    }

    public boolean isMoving() {
        return this.dynamics().isMoving();
    }

    public int storageCapacity() {
        return this.spec().storageModules();
    }

    public int sides() {
        return this.spec().sides();
    }

    public float radius() {
        return this.spec().radius();
    }

    public Player player() {
        return this.context().player();
    }

    public double maxSpeed() {
        return this.spec().maxSpeed();
    }

    public Option<Object> constructionProgress() {
        return this._constructionProgress;
    }

    public void constructionProgress_$eq(Option<Object> value) {
        this._constructionProgress = value;
        this.invalidateModelCache();
    }

    public boolean isStunned() {
        return this.dynamics().isStunned();
    }

    public int availableStorage() {
        return BoxesRunTime.unboxToInt((Object)this.storage().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(StorageModule s) {
                return s.predictedAvailableStorage();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return 0;
            }
        }));
    }

    public int storedResources() {
        return BoxesRunTime.unboxToInt((Object)this.storage().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(StorageModule s) {
                return s.predictedStoredResources();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return 0;
            }
        }));
    }

    public boolean isInHarvestingRange(MineralCrystalImpl mineral) {
        return mineral.position().$minus(this.position()).lengthSquared() <= (float)4900;
    }

    public Drone wrapperFor(Player player) {
        Drone drone;
        Player player2 = player;
        Player player3 = this.player();
        if (!(player2 != null ? !player2.equals(player3) : player3 != null)) {
            drone = this.controller();
        } else {
            if (!this.handles.contains((Object)player)) {
                this.handles = this.handles.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)player), (Object)new EnemyDrone(this, player)));
            }
            drone = (Drone)this.handles.apply((Object)player);
        }
        return drone;
    }

    public Seq<SimulatorEvent> deathEvents() {
        Seq seq;
        if (this.isDead()) {
            ObjectRef events = ObjectRef.create((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimulatorEvent[]{new DroneKilled(this)})));
            this.manipulator().foreach((Function1)new Serializable(this, events){
                public static final long serialVersionUID = 0L;
                public final ObjectRef events$1;

                public final void apply(ConstructorModule m) {
                    m.droneInConstruction().foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$deathEvents$1 $outer;

                        public final void apply(DroneImpl d) {
                            this.$outer.events$1.elem = ((List)this.$outer.events$1.elem).$colon$colon((Object)new DroneConstructionCancelled(d));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                {
                    this.events$1 = events$1;
                }
            });
            seq = (List)events.elem;
        } else {
            seq = (Seq)Seq$.MODULE$.empty();
        }
        return seq;
    }

    public String toString() {
        return ((Object)BoxesRunTime.boxToInteger((int)this.id())).toString();
    }

    public DroneImpl(DroneSpec spec, DroneControllerBase controller, DroneContext context, Vector2 initialPos, double time, int startingResources) {
        this.spec = spec;
        this.controller = controller;
        this.context = context;
        this.startingResources = startingResources;
        VisionTracking.class.$init$((VisionTracking)this);
        ActiveVisionTracking.class.$init$((ActiveVisionTracking)this);
        DroneVisionTracker$class.$init$(this);
        DroneGraphicsHandler$class.$init$(this);
        DroneMessageDisplay$class.$init$(this);
        DroneMovementDetector$class.$init$(this);
        DroneHull$class.$init$(this);
        DroneEventQueue$class.$init$(this);
        DroneModules$class.$init$(this);
        this.id = context.idGenerator().getAndIncrement();
        this.priority = context.rng().int();
        this._constructionProgress = None$.MODULE$;
        this.handles = Predef$.MODULE$.Map().empty();
        this.dynamics = spec.constructDynamics(this, initialPos, time);
    }
}

