/*
 * Decompiled with CFR 0.152.
 */
package cwinter.codecraft.core.objects;

import cwinter.codecraft.core.api.Player;
import cwinter.codecraft.core.game.HomingMissileFaded;
import cwinter.codecraft.core.game.MissileExplodes;
import cwinter.codecraft.core.game.SimulatorEvent;
import cwinter.codecraft.core.graphics.BasicHomingMissileModel;
import cwinter.codecraft.core.graphics.HomingMissileModel;
import cwinter.codecraft.core.objects.MissileDynamics;
import cwinter.codecraft.core.objects.WorldObject;
import cwinter.codecraft.core.objects.drone.DroneImpl;
import cwinter.codecraft.graphics.engine.ModelDescriptor;
import cwinter.codecraft.graphics.engine.ModelDescriptor$;
import cwinter.codecraft.graphics.engine.NullPositionDescriptor$;
import cwinter.codecraft.graphics.engine.PositionDescriptor;
import cwinter.codecraft.graphics.engine.WorldObjectDescriptor;
import cwinter.codecraft.util.maths.Vector2;
import cwinter.codecraft.util.maths.Vector2$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015h!B\u0001\u0003\u0001\u0011Q!!\u0004%p[&tw-T5tg&dWM\u0003\u0002\u0004\t\u00059qN\u00196fGR\u001c(BA\u0003\u0007\u0003\u0011\u0019wN]3\u000b\u0005\u001dA\u0011!C2pI\u0016\u001c'/\u00194u\u0015\u0005I\u0011aB2xS:$XM]\n\u0004\u0001-\t\u0002C\u0001\u0007\u0010\u001b\u0005i!\"\u0001\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Ai!AB!osJ+g\r\u0005\u0002\u0013'5\t!!\u0003\u0002\u0015\u0005\tYqk\u001c:mI>\u0013'.Z2u\u0011!1\u0002A!b\u0001\n\u0003A\u0012A\u00029mCf,'o\u0001\u0001\u0016\u0003e\u0001\"AG\u000f\u000e\u0003mQ!\u0001\b\u0003\u0002\u0007\u0005\u0004\u0018.\u0003\u0002\u001f7\t1\u0001\u000b\\1zKJD\u0001\u0002\t\u0001\u0003\u0002\u0003\u0006I!G\u0001\ba2\f\u00170\u001a:!\u0011!\u0011\u0003A!A!\u0002\u0013\u0019\u0013AC5oSRL\u0017\r\u001c)pgB\u0011A%K\u0007\u0002K)\u0011aeJ\u0001\u0006[\u0006$\bn\u001d\u0006\u0003Q\u0019\tA!\u001e;jY&\u0011!&\n\u0002\b-\u0016\u001cGo\u001c:3\u0011!a\u0003A!b\u0001\n\u0003i\u0013AA5e+\u0005q\u0003C\u0001\u00070\u0013\t\u0001TBA\u0002J]RD\u0001B\r\u0001\u0003\u0002\u0003\u0006IAL\u0001\u0004S\u0012\u0004\u0003\u0002\u0003\u001b\u0001\u0005\u0003\u0005\u000b\u0011B\u001b\u0002\tQLW.\u001a\t\u0003\u0019YJ!aN\u0007\u0003\r\u0011{WO\u00197f\u0011!I\u0004A!A!\u0002\u0013Q\u0014A\u0002;be\u001e,G\u000f\u0005\u0002<}5\tAH\u0003\u0002>\u0005\u0005)AM]8oK&\u0011q\b\u0010\u0002\n\tJ|g.Z%na2DQ!\u0011\u0001\u0005\u0002\t\u000ba\u0001P5oSRtDCB\"E\u000b\u001a;\u0005\n\u0005\u0002\u0013\u0001!)a\u0003\u0011a\u00013!)!\u0005\u0011a\u0001G!)A\u0006\u0011a\u0001]!)A\u0007\u0011a\u0001k!)\u0011\b\u0011a\u0001u!9!\n\u0001b\u0001\n\u0003Y\u0015\u0001\u00033z]\u0006l\u0017nY:\u0016\u00031\u0003\"AE'\n\u00059\u0013!aD'jgNLG.\u001a#z]\u0006l\u0017nY:\t\rA\u0003\u0001\u0015!\u0003M\u0003%!\u0017P\\1nS\u000e\u001c\b\u0005C\u0004S\u0001\t\u0007I\u0011A*\u0002#A\u0014XM^5pkN\u0004vn]5uS>t7/F\u0001U!\r)&lI\u0007\u0002-*\u0011q\u000bW\u0001\b[V$\u0018M\u00197f\u0015\tIV\"\u0001\u0006d_2dWm\u0019;j_:L!a\u0017,\u0003\u000bE+X-^3\t\ru\u0003\u0001\u0015!\u0003U\u0003I\u0001(/\u001a<j_V\u001c\bk\\:ji&|gn\u001d\u0011\t\u000f}\u0003!\u0019!C\u0001[\u0005I\u0001o\\:ji&|gn\u001d\u0005\u0007C\u0002\u0001\u000b\u0011\u0002\u0018\u0002\u0015A|7/\u001b;j_:\u001c\b\u0005C\u0004d\u0001\u0001\u0007I\u0011A\u0017\u0002\u00111Lg-\u001a;j[\u0016Dq!\u001a\u0001A\u0002\u0013\u0005a-\u0001\u0007mS\u001a,G/[7f?\u0012*\u0017\u000f\u0006\u0002hUB\u0011A\u0002[\u0005\u0003S6\u0011A!\u00168ji\"91\u000eZA\u0001\u0002\u0004q\u0013a\u0001=%c!1Q\u000e\u0001Q!\n9\n\u0011\u0002\\5gKRLW.\u001a\u0011\t\u000f=\u0004\u0001\u0019!C\u0001a\u00061a-\u00193j]\u001e,\u0012!\u001d\t\u0003\u0019IL!a]\u0007\u0003\u000f\t{w\u000e\\3b]\"9Q\u000f\u0001a\u0001\n\u00031\u0018A\u00034bI&twm\u0018\u0013fcR\u0011qm\u001e\u0005\bWR\f\t\u00111\u0001r\u0011\u0019I\b\u0001)Q\u0005c\u00069a-\u00193j]\u001e\u0004\u0003\"B>\u0001\t\u0003a\u0018AB;qI\u0006$X\rF\u0001~!\u0015q\u0018QBA\n\u001d\ry\u0018\u0011\u0002\b\u0005\u0003\u0003\t9!\u0004\u0002\u0002\u0004)\u0019\u0011QA\f\u0002\rq\u0012xn\u001c;?\u0013\u0005q\u0011bAA\u0006\u001b\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\b\u0003#\u00111aU3r\u0015\r\tY!\u0004\t\u0005\u0003+\tY\"\u0004\u0002\u0002\u0018)\u0019\u0011\u0011\u0004\u0003\u0002\t\u001d\fW.Z\u0005\u0005\u0003;\t9B\u0001\bTS6,H.\u0019;pe\u00163XM\u001c;\t\u000f\u0005\u0005\u0002\u0001\"\u0003\u0002$\u0005!a-\u00193f)\t\t)\u0003\u0005\u0004\u0002(\u0005%\u00121C\u0007\u00021&\u0019\u0011q\u0002-\t\u000f\u00055\u0002\u0001\"\u0003\u0002$\u0005qQ\u000f\u001d3bi\u0016\u0004vn]5uS>t\u0007bBA\u0019\u0001\u0011%\u00111G\u0001\u000fe\u0016\u001cwN\u001d3Q_NLG/[8o)\u00059\u0007bBA\u001c\u0001\u0011%\u0011\u0011H\u0001\u0010G\",7m\u001b$peJ+Wn\u001c<bYV\u0011\u0011Q\u0005\u0005\u0007\u0003{\u0001A\u0011\u00019\u0002\u0015%\u001c\u0018I\\5nCR,G\rC\u0004\u0002B\u0001!\t%a\u0011\u0002\u0011A|7/\u001b;j_:,\u0012a\t\u0005\t\u0003\u000f\u0002A\u0011\t\u0003\u0002J\u0005QA-Z:de&\u0004Ho\u001c:\u0016\u0005\u0005-\u0003#\u0002@\u0002\u000e\u00055\u0003\u0007BA(\u0003G\u0002b!!\u0015\u0002\\\u0005}SBAA*\u0015\u0011\t)&a\u0016\u0002\r\u0015tw-\u001b8f\u0015\r\tIFB\u0001\tOJ\f\u0007\u000f[5dg&!\u0011QLA*\u0005=iu\u000eZ3m\t\u0016\u001c8M]5qi>\u0014\b\u0003BA1\u0003Gb\u0001\u0001\u0002\u0007\u0002f\u0005\u0015\u0013\u0011!A\u0001\u0006\u0003\t9GA\u0002`IE\nB!!\u001b\u0002pA\u0019A\"a\u001b\n\u0007\u00055TBA\u0004O_RD\u0017N\\4\u0011\u00071\t\t(C\u0002\u0002t5\u00111!\u00118z\u0011\u001d\t9\b\u0001C\u0005\u0003s\nq\"\\8eK2$Um]2sSB$xN]\u000b\u0003\u0003w\u0012\"\"! \u0002\u0004\u0006%\u0015\u0011ZAh\r\u0019\ty\b\u0001\u0001\u0002|\taAH]3gS:,W.\u001a8u})\u0019\u0011\u0011\f\u0003\u0011\u000b\u0005E\u0013QQ4\n\t\u0005\u001d\u00151\u000b\u0002\u0016/>\u0014H\u000eZ(cU\u0016\u001cG\u000fR3tGJL\u0007\u000f^8sa\u0011\tY)!'\u0011\u000f\u00055\u00151SALO6\u0011\u0011q\u0012\u0006\u0005\u0003#\u000b9&A\u0003n_\u0012,G.\u0003\u0003\u0002\u0016\u0006=%AE*j[BdW-T8eK2\u0014U/\u001b7eKJ\u0004B!!\u0019\u0002\u001a\u0012Y\u00111\u0014\u0001\u0002\u0002\u0003\u0005)\u0011AAO\u0005\tyV'\u0005\u0003\u0002 \u0006E&CBAQ\u0003G\u000bYK\u0002\u0004\u0002\u0000\u0001\u0001\u0011q\u0014\t\u0005\u0003K\u000b9+\u0004\u0002\u0002\u0002&!\u0011\u0011VAA\u0005IAu.\\5oO6K7o]5mK6{G-\u001a7\u0011\t\u0005\u0015\u0016QV\u0005\u0005\u0003_\u000b\tIA\fCCNL7\rS8nS:<W*[:tS2,Wj\u001c3fYJQ\u00111WAB\u0003k\u000bI-a4\u0007\r\u0005}\u0004\u0001AAYa\u0011\t9,a/\u0011\u000f\u00055\u00151SA]OB!\u0011\u0011MA^\t-\ti\fAA\u0001\u0002\u0003\u0015\t!a0\u0003\u0005}\u001b\u0014\u0003BAa\u0003\u000b\u0014b!a1\u0002$\u0006-fABA@\u0001\u0001\t\tM\u0005\u0005\u0002H\u0006\r\u0015\u0011ZAh\r\u0019\ty\b\u0001\u0001\u0002FB\u0019A\"a3\n\u0007\u00055WBA\u0004Qe>$Wo\u0019;\u0011\u00071\t\t.C\u0002\u0002T6\u0011AbU3sS\u0006d\u0017N_1cY\u0016Dq!a6\u0001\t\u0013\tI.\u0001\u000bgC:\u001c\u00170T8eK2$Um]2sSB$xN]\u000b\u0003\u0003GCq!!8\u0001\t\u0013\ty.\u0001\u000bcCNL7-T8eK2$Um]2sSB$xN]\u000b\u0003\u0003WCq!a9\u0001\t\u0003\"\u0001/\u0001\u0004jg\u0012+\u0017\r\u001a")
public class HomingMissile
implements WorldObject {
    private final Player player;
    private final int id;
    private final DroneImpl target;
    private final MissileDynamics dynamics;
    private final Queue<Vector2> previousPositions;
    private final int positions;
    private int lifetime;
    private boolean fading;

    public Player player() {
        return this.player;
    }

    @Override
    public int id() {
        return this.id;
    }

    public MissileDynamics dynamics() {
        return this.dynamics;
    }

    public Queue<Vector2> previousPositions() {
        return this.previousPositions;
    }

    public int positions() {
        return this.positions;
    }

    public int lifetime() {
        return this.lifetime;
    }

    public void lifetime_$eq(int x$1) {
        this.lifetime = x$1;
    }

    public boolean fading() {
        return this.fading;
    }

    public void fading_$eq(boolean x$1) {
        this.fading = x$1;
    }

    @Override
    public Seq<SimulatorEvent> update() {
        return this.fading() ? this.fade() : this.updatePosition();
    }

    private Seq<SimulatorEvent> fade() {
        this.previousPositions().dequeue();
        return this.previousPositions().isEmpty() ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new HomingMissileFaded[]{new HomingMissileFaded(this)})) : (Seq)Seq$.MODULE$.empty();
    }

    private Seq<SimulatorEvent> updatePosition() {
        this.dynamics().recomputeVelocity();
        this.lifetime_$eq(this.lifetime() - 1);
        if (this.isAnimated()) {
            this.recordPosition();
        }
        return this.checkForRemoval();
    }

    private void recordPosition() {
        this.previousPositions().enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Vector2[]{this.position()}));
        Object object = this.previousPositions().length() > this.positions() ? this.previousPositions().dequeue() : BoxedUnit.UNIT;
        while (this.previousPositions().length() > this.lifetime() + 1) {
            this.previousPositions().dequeue();
        }
    }

    private Seq<SimulatorEvent> checkForRemoval() {
        Seq seq;
        if (this.dynamics().removed()) {
            this.fading_$eq(true);
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MissileExplodes[]{new MissileExplodes(this)}));
        } else if (this.lifetime() == 0) {
            this.dynamics().remove();
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new HomingMissileFaded[]{new HomingMissileFaded(this)}));
        } else {
            seq = (Seq)Seq$.MODULE$.empty();
        }
        return seq;
    }

    public boolean isAnimated() {
        return this.target.context().settings().allowMissileAnimation();
    }

    @Override
    public Vector2 position() {
        return this.dynamics().pos();
    }

    @Override
    public Seq<ModelDescriptor<?>> descriptor() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ModelDescriptor[]{ModelDescriptor$.MODULE$.apply((PositionDescriptor)NullPositionDescriptor$.MODULE$, this.modelDescriptor())}));
    }

    private WorldObjectDescriptor<BoxedUnit> modelDescriptor() {
        return this.isAnimated() ? this.fancyModelDescriptor() : this.basicModelDescriptor();
    }

    private HomingMissileModel fancyModelDescriptor() {
        return new HomingMissileModel((Seq<Tuple2<Object, Object>>)((Seq)this.previousPositions().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply(Vector2 x0$1) {
                Vector2 vector2 = x0$1;
                Option option = Vector2$.MODULE$.unapply(vector2);
                if (option.isEmpty()) {
                    throw new MatchError((Object)vector2);
                }
                float x = BoxesRunTime.unboxToFloat((Object)((Tuple2)option.get())._1());
                float y = BoxesRunTime.unboxToFloat((Object)((Tuple2)option.get())._2());
                Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToFloat((float)x), (Object)BoxesRunTime.boxToFloat((float)y));
                return tuple2;
            }
        }, Queue$.MODULE$.canBuildFrom())), package$.MODULE$.min(50 - this.lifetime(), this.positions()), this.player().color());
    }

    private BasicHomingMissileModel basicModelDescriptor() {
        return new BasicHomingMissileModel(this.position().x(), this.position().y(), this.player().color());
    }

    @Override
    public boolean isDead() {
        return this.lifetime() <= 0;
    }

    public HomingMissile(Player player, Vector2 initialPos, int id, double time, DroneImpl target) {
        this.player = player;
        this.id = id;
        this.target = target;
        this.dynamics = new MissileDynamics(17.0, target.dynamics(), player.id(), this, initialPos, time);
        this.previousPositions = (Queue)Queue$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Vector2[]{initialPos}));
        this.positions = 7;
        this.lifetime = 50;
        this.fading = false;
    }
}

