/*
 * Decompiled with CFR 0.152.
 */
package cwinter.codecraft.core.graphics;

import cwinter.codecraft.graphics.engine.GraphicsContext;
import cwinter.codecraft.graphics.engine.RenderStack;
import cwinter.codecraft.graphics.model.EmptyModel;
import cwinter.codecraft.graphics.model.Model;
import cwinter.codecraft.graphics.model.StaticCompositeModel;
import cwinter.codecraft.graphics.primitives.RichQuadStrip;
import cwinter.codecraft.graphics.primitives.RichQuadStrip$;
import cwinter.codecraft.util.maths.ColorRGB;
import cwinter.codecraft.util.maths.ColorRGBA;
import cwinter.codecraft.util.maths.ColorRGBA$;
import cwinter.codecraft.util.maths.Geometry$;
import cwinter.codecraft.util.maths.VertexXY;
import cwinter.codecraft.util.maths.VertexXY$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005=b!B\u0001\u0003\u0001\tQ!a\b#s_:,G\u000b\u001b:vgR,'\u000f\u0016:bS2\u001cXj\u001c3fY\u001a\u000b7\r^8ss*\u00111\u0001B\u0001\tOJ\f\u0007\u000f[5dg*\u0011QAB\u0001\u0005G>\u0014XM\u0003\u0002\b\u0011\u0005I1m\u001c3fGJ\fg\r\u001e\u0006\u0002\u0013\u000591m^5oi\u0016\u00148C\u0001\u0001\f!\taq\"D\u0001\u000e\u0015\u0005q\u0011!B:dC2\f\u0017B\u0001\t\u000e\u0005\u0019\te.\u001f*fM\"A!\u0003\u0001BC\u0002\u0013\u0005A#\u0001\u0006tS\u0012,G*\u001a8hi\"\u001c\u0001!F\u0001\u0016!\taa#\u0003\u0002\u0018\u001b\t)a\t\\8bi\"A\u0011\u0004\u0001B\u0001B\u0003%Q#A\u0006tS\u0012,G*\u001a8hi\"\u0004\u0003\u0002C\u000e\u0001\u0005\u000b\u0007I\u0011\u0001\u000b\u0002\u0015I\fG-[;t\u0011VdG\u000e\u0003\u0005\u001e\u0001\t\u0005\t\u0015!\u0003\u0016\u0003-\u0011\u0018\rZ5vg\"+H\u000e\u001c\u0011\t\u0011}\u0001!Q1A\u0005\u0002\u0001\nQa]5eKN,\u0012!\t\t\u0003\u0019\tJ!aI\u0007\u0003\u0007%sG\u000f\u0003\u0005&\u0001\t\u0005\t\u0015!\u0003\"\u0003\u0019\u0019\u0018\u000eZ3tA!Aq\u0005\u0001BC\u0002\u0013\u0005\u0001&A\u0006qY\u0006LXM]\"pY>\u0014X#A\u0015\u0011\u0005)zS\"A\u0016\u000b\u00051j\u0013!B7bi\"\u001c(B\u0001\u0018\u0007\u0003\u0011)H/\u001b7\n\u0005AZ#\u0001C\"pY>\u0014(k\u0012\"\t\u0011I\u0002!\u0011!Q\u0001\n%\nA\u0002\u001d7bs\u0016\u00148i\u001c7pe\u0002B\u0001\u0002\u000e\u0001\u0003\u0002\u0003\u0006Y!N\u0001\u0003eN\u0004\"A\u000e\u001e\u000e\u0003]R!\u0001O\u001d\u0002\r\u0015tw-\u001b8f\u0015\t\u0019a!\u0003\u0002<o\tY!+\u001a8eKJ\u001cF/Y2l\u0011\u0015i\u0004\u0001\"\u0001?\u0003\u0019a\u0014N\\5u}Q)qh\u0011#F\rR\u0011\u0001I\u0011\t\u0003\u0003\u0002i\u0011A\u0001\u0005\u0006iq\u0002\u001d!\u000e\u0005\u0006%q\u0002\r!\u0006\u0005\u00067q\u0002\r!\u0006\u0005\u0006?q\u0002\r!\t\u0005\u0006Oq\u0002\r!\u000b\u0005\u0006\u0011\u0002!\t!S\u0001\u000bEVLG\u000eZ'pI\u0016dGc\u0001&TIB\u00191J\u0014)\u000e\u00031S!!T\u001d\u0002\u000b5|G-\u001a7\n\u0005=c%!B'pI\u0016d\u0007C\u0001\u0007R\u0013\t\u0011VB\u0001\u0003V]&$\b\"\u0002+H\u0001\u0004)\u0016!\u00039pg&$\u0018n\u001c8t!\r1f,\u0019\b\u0003/rs!\u0001W.\u000e\u0003eS!AW\n\u0002\rq\u0012xn\u001c;?\u0013\u0005q\u0011BA/\u000e\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u00181\u0003\u0007M+\u0017O\u0003\u0002^\u001bA)ABY\u000b\u0016+%\u00111-\u0004\u0002\u0007)V\u0004H.Z\u001a\t\u000b\u0015<\u0005\u0019\u00014\u0002\u000f\r|g\u000e^3yiB\u0011agZ\u0005\u0003Q^\u0012qb\u0012:ba\"L7m]\"p]R,\u0007\u0010\u001e\u0005\u0006U\u0002!\ta[\u0001\u0013G>l\u0007/\u001e;f)\"\u0014Xo\u001d;feB{7\u000fF\u0002m_F\u0004\"AK7\n\u00059\\#\u0001\u0003,feR,\u0007\u0010W-\t\u000bAL\u0007\u0019A\u0011\u0002\tMLG-\u001a\u0005\be&\u0004\n\u00111\u0001\u0016\u0003\u0015\tgn\u001a7f\u0011\u0015!\b\u0001\"\u0001v\u0003MyW\u000f^3s\u001b>$W\u000f\\3Q_NLG/[8o)\rag\u000f\u001f\u0005\u0006oN\u0004\r!I\u0001\u0002]\"9\u0011p\u001dI\u0001\u0002\u0004)\u0012!E8sS\u0016tG/\u0019;j_:|eMZ:fi\")1\u0010\u0001C\u0001y\u0006\tr.\u001e;fe6{G-\u001e7f\u001d>\u0014X.\u00197\u0015\u00071lh\u0010C\u0003xu\u0002\u0007\u0011\u0005C\u0004zuB\u0005\t\u0019A\u000b\t\u000f\u0005\u0005\u0001\u0001\"\u0001\u0002\u0004\u0005Ar.\u001e;fe6{G-\u001e7f!\u0016\u0014\b/\u001a8eS\u000e,H.\u0019:\u0015\u000b1\f)!a\u0002\t\u000b]|\b\u0019A\u0011\t\u000fe|\b\u0013!a\u0001+!I\u00111\u0002\u0001\u0012\u0002\u0013\u0005\u0011QB\u0001\u001dG>l\u0007/\u001e;f)\"\u0014Xo\u001d;feB{7\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\tyAK\u0002\u0016\u0003#Y#!a\u0005\u0011\t\u0005U\u0011qD\u0007\u0003\u0003/QA!!\u0007\u0002\u001c\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003;i\u0011AC1o]>$\u0018\r^5p]&!\u0011\u0011EA\f\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\n\u0003K\u0001\u0011\u0013!C\u0001\u0003\u001b\t!e\\;uKJlu\u000eZ;mKB+'\u000f]3oI&\u001cW\u000f\\1sI\u0011,g-Y;mi\u0012\u0012\u0004\"CA\u0015\u0001E\u0005I\u0011AA\u0007\u0003uyW\u000f^3s\u001b>$W\u000f\\3Q_NLG/[8oI\u0011,g-Y;mi\u0012\u0012\u0004\"CA\u0017\u0001E\u0005I\u0011AA\u0007\u0003myW\u000f^3s\u001b>$W\u000f\\3O_Jl\u0017\r\u001c\u0013eK\u001a\fW\u000f\u001c;%e\u0001")
public class DroneThrusterTrailsModelFactory {
    private final float sideLength;
    private final float radiusHull;
    private final int sides;
    private final ColorRGB playerColor;
    private final RenderStack rs;

    public float sideLength() {
        return this.sideLength;
    }

    public float radiusHull() {
        return this.radiusHull;
    }

    public int sides() {
        return this.sides;
    }

    public ColorRGB playerColor() {
        return this.playerColor;
    }

    public Model<BoxedUnit> buildModel(Seq<Tuple3<Object, Object, Object>> positions, GraphicsContext context) {
        int n = positions.length();
        if (n <= 1) {
            return new EmptyModel();
        }
        Seq trailPositions = (Seq)((TraversableLike)((SeqLike)positions.zipWithIndex(Seq$.MODULE$.canBuildFrom())).reverse()).withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Tuple3<Object, Object, Object>, Object> check$ifrefutable$1) {
                Tuple3 tuple3;
                Tuple2<Tuple3<Object, Object, Object>, Object> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null && (tuple3 = (Tuple3)tuple2._1()) != null;
                return bl;
            }
        }).map((Function1)new Serializable(this, n){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DroneThrusterTrailsModelFactory $outer;
            private final int n$1;

            public final Tuple2<VertexXY, VertexXY> apply(Tuple2<Tuple3<Object, Object, Object>, Object> x$1) {
                Tuple2<Tuple3<Object, Object, Object>, Object> tuple2 = x$1;
                if (tuple2 != null) {
                    Tuple3 tuple3 = (Tuple3)tuple2._1();
                    int t = tuple2._2$mcI$sp();
                    if (tuple3 != null) {
                        float x = BoxesRunTime.unboxToFloat((Object)tuple3._1());
                        float y = BoxesRunTime.unboxToFloat((Object)tuple3._2());
                        float a = BoxesRunTime.unboxToFloat((Object)tuple3._3());
                        VertexXY drift = VertexXY$.MODULE$.apply((double)a).unary_$minus().$times((float)(this.n$1 - t - 1)).$times(2.0f);
                        VertexXY offset = new VertexXY(x, y).$plus(drift);
                        Tuple2 tuple22 = new Tuple2((Object)this.$outer.computeThrusterPos(1, a).$plus(offset), (Object)this.$outer.computeThrusterPos(-1, a).$plus(offset));
                        return tuple22;
                    }
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.n$1 = n$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Tuple2 tuple2 = trailPositions.unzip((Function1)Predef$.MODULE$.$conforms());
        if (tuple2 != null) {
            Tuple2 tuple22;
            Seq trail1 = (Seq)tuple2._1();
            Seq trail2 = (Seq)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)trail1, (Object)trail2);
            Seq trail12 = (Seq)tuple23._1();
            Seq trail22 = (Seq)tuple23._2();
            IndexedSeq colors = (IndexedSeq)trailPositions.indices().map((Function1)new Serializable(this, n){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DroneThrusterTrailsModelFactory $outer;
                private final int n$1;

                public final ColorRGBA apply(int index) {
                    return ColorRGBA$.MODULE$.apply(this.$outer.playerColor(), (float)(this.n$1 - index) / (float)this.n$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.n$1 = n$1;
                }
            }, IndexedSeq$.MODULE$.canBuildFrom());
            return new StaticCompositeModel((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Model[]{new RichQuadStrip(this.rs.TranslucentAdditive(), trail12, (Seq)colors, (Seq)colors, this.sideLength() * 0.4f, RichQuadStrip$.MODULE$.apply$default$6(), ClassTag$.MODULE$.apply(ColorRGBA.class)).noCaching().getModel(context), new RichQuadStrip(this.rs.TranslucentAdditive(), trail22, (Seq)colors, (Seq)colors, this.sideLength() * 0.4f, RichQuadStrip$.MODULE$.apply$default$6(), ClassTag$.MODULE$.apply(ColorRGBA.class)).noCaching().getModel(context)}))).identityModelview();
        }
        throw new MatchError((Object)tuple2);
    }

    public VertexXY computeThrusterPos(int side, float angle) {
        VertexXY perp = this.outerModulePerpendicular(0, angle);
        return this.outerModulePosition(0, angle).$plus(VertexXY.Scalar$.MODULE$.$times$extension(VertexXY$.MODULE$.Scalar((float)side * this.sideLength() * 0.3f), perp));
    }

    public float computeThrusterPos$default$2() {
        return 0.0f;
    }

    public VertexXY outerModulePosition(int n, float orientationOffset) {
        float r = Geometry$.MODULE$.inradius(this.radiusHull(), this.sides());
        return VertexXY.Scalar$.MODULE$.$times$extension(VertexXY$.MODULE$.Scalar(r), this.outerModuleNormal(n, orientationOffset));
    }

    public float outerModulePosition$default$2() {
        return 0.0f;
    }

    public VertexXY outerModuleNormal(int n, float orientationOffset) {
        double angle = Math.PI + (double)(2 * n) * Math.PI / (double)this.sides() + (double)orientationOffset;
        return VertexXY$.MODULE$.apply(angle);
    }

    public float outerModuleNormal$default$2() {
        return 0.0f;
    }

    public VertexXY outerModulePerpendicular(int n, float orientationOffset) {
        return this.outerModuleNormal(n, orientationOffset).perpendicular();
    }

    public float outerModulePerpendicular$default$2() {
        return 0.0f;
    }

    public DroneThrusterTrailsModelFactory(float sideLength, float radiusHull, int sides, ColorRGB playerColor, RenderStack rs) {
        this.sideLength = sideLength;
        this.radiusHull = radiusHull;
        this.sides = sides;
        this.playerColor = playerColor;
        this.rs = rs;
    }
}

