/*
 * Decompiled with CFR 0.152.
 */
package cwinter.codecraft.core.api;

import cwinter.codecraft.core.api.RunContext;
import cwinter.codecraft.util.maths.ColorRGBA;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.scalajs.js.Date$;

@ScalaSignature(bytes="\u0006\u0001\t4A!\u0001\u0002\u0001\u0017\tAa\tU*NKR,'O\u0003\u0002\u0004\t\u0005\u0019\u0011\r]5\u000b\u0005\u00151\u0011\u0001B2pe\u0016T!a\u0002\u0005\u0002\u0013\r|G-Z2sC\u001a$(\"A\u0005\u0002\u000f\r<\u0018N\u001c;fe\u000e\u00011C\u0001\u0001\r!\ti\u0001#D\u0001\u000f\u0015\u0005y\u0011!B:dC2\f\u0017BA\t\u000f\u0005\u0019\te.\u001f*fM\"A1\u0003\u0001B\u0001B\u0003%A#A\u0004d_:$X\r\u001f;\u0011\u0005U1R\"\u0001\u0002\n\u0005]\u0011!A\u0003*v]\u000e{g\u000e^3yi\")\u0011\u0004\u0001C\u00015\u00051A(\u001b8jiz\"\"a\u0007\u000f\u0011\u0005U\u0001\u0001\"B\n\u0019\u0001\u0004!\u0002b\u0002\u0010\u0001\u0005\u0004%\taH\u0001\ngR\f'\u000f\u001e+j[\u0016,\u0012\u0001\t\t\u0003\u001b\u0005J!A\t\b\u0003\r\u0011{WO\u00197f\u0011\u0019!\u0003\u0001)A\u0005A\u0005Q1\u000f^1siRKW.\u001a\u0011\t\u000f\u0019\u0002\u0001\u0019!C\u0001?\u0005\u0011B.Y:umA2%/Y7f'R\f'\u000f^3e\u0011\u001dA\u0003\u00011A\u0005\u0002%\na\u0003\\1tiZ\u0002dI]1nKN#\u0018M\u001d;fI~#S-\u001d\u000b\u0003U5\u0002\"!D\u0016\n\u00051r!\u0001B+oSRDqAL\u0014\u0002\u0002\u0003\u0007\u0001%A\u0002yIEBa\u0001\r\u0001!B\u0013\u0001\u0013a\u00057bgR4\u0004G\u0012:b[\u0016\u001cF/\u0019:uK\u0012\u0004\u0003b\u0002\u001a\u0001\u0001\u0004%\taH\u0001\u0011Y\u0006\u001cHO\u0012:b[\u0016\u001cF/\u0019:uK\u0012Dq\u0001\u000e\u0001A\u0002\u0013\u0005Q'\u0001\u000bmCN$hI]1nKN#\u0018M\u001d;fI~#S-\u001d\u000b\u0003UYBqAL\u001a\u0002\u0002\u0003\u0007\u0001\u0005\u0003\u00049\u0001\u0001\u0006K\u0001I\u0001\u0012Y\u0006\u001cHO\u0012:b[\u0016\u001cF/\u0019:uK\u0012\u0004\u0003b\u0002\u001e\u0001\u0001\u0004%\taO\u0001\u0004MB\u001cX#\u0001\u001f\u0011\u00055i\u0014B\u0001 \u000f\u0005\rIe\u000e\u001e\u0005\b\u0001\u0002\u0001\r\u0011\"\u0001B\u0003\u001d1\u0007o]0%KF$\"A\u000b\"\t\u000f9z\u0014\u0011!a\u0001y!1A\t\u0001Q!\nq\nAA\u001a9tA!)a\t\u0001C\u0001\u000f\u00069AM]1x\rB\u001bF#\u0001\u0016\t\u000b%\u0003A\u0011A$\u0002\u0011A\u0014\u0018N\u001c;G!NCQa\u0013\u0001\u0005\u00021\u000b\u0011B\u001a9t'R\u0014\u0018N\\4\u0016\u00035\u0003\"AT)\u000f\u00055y\u0015B\u0001)\u000f\u0003\u0019\u0001&/\u001a3fM&\u0011!k\u0015\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005As\u0001\"B+\u0001\t\u00031\u0016aD:i_VdGmU6ja\u001a\u0013\u0018-\\3\u0015\u0005]S\u0006CA\u0007Y\u0013\tIfBA\u0004C_>dW-\u00198\t\u000bm#\u0006\u0019\u0001\u001f\u0002\u0013Q\f'oZ3u\rB\u001b\u0006\"B/\u0001\t\u0003q\u0016\u0001D:uCJ$X\r\u001a$sC6,GC\u0001\u0016`\u0011\u0015YF\f1\u0001=\u0011\u0015\t\u0007\u0001\"\u0001H\u0003E)\b\u000fZ1uKNkwn\u001c;iK\u00124\u0005k\u0015")
public class FPSMeter {
    private final RunContext context;
    private final double startTime;
    private double last60FrameStarted;
    private double lastFrameStarted;
    private int fps;

    public double startTime() {
        return this.startTime;
    }

    public double last60FrameStarted() {
        return this.last60FrameStarted;
    }

    public void last60FrameStarted_$eq(double x$1) {
        this.last60FrameStarted = x$1;
    }

    public double lastFrameStarted() {
        return this.lastFrameStarted;
    }

    public void lastFrameStarted_$eq(double x$1) {
        this.lastFrameStarted = x$1;
    }

    public int fps() {
        return this.fps;
    }

    public void fps_$eq(int x$1) {
        this.fps = x$1;
    }

    public void drawFPS() {
        this.context.simulator().debug().drawText(this.fpsString(), -1.0, 1.0, new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f), true, false, false);
    }

    public void printFPS() {
        Predef$.MODULE$.println((Object)this.fpsString());
    }

    public String fpsString() {
        double elapsedSeconds = (Date$.MODULE$.now() - this.startTime()) / (double)1000;
        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"T=", ","})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.context.simulator().timestep())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" Average FPS: ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)((int)((double)this.context.simulator().timestep() / elapsedSeconds)))}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"FPS: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.context.simulator().measuredFramerate())}))).toString();
    }

    public boolean shouldSkipFrame(int targetFPS) {
        double interval = 1000.0 / (double)targetFPS;
        double now = Date$.MODULE$.now();
        double delta = now - this.lastFrameStarted();
        return delta < interval;
    }

    public void startedFrame(int targetFPS) {
        double interval = 1000.0 / (double)targetFPS;
        double now = Date$.MODULE$.now();
        double delta = now - this.lastFrameStarted();
        this.lastFrameStarted_$eq(Date$.MODULE$.now() - delta % interval);
    }

    public void updateSmoothedFPS() {
        if (this.context.simulator().timestep() % 60 == 0) {
            this.fps_$eq((int)package$.MODULE$.round((double)60000 / (Date$.MODULE$.now() - this.last60FrameStarted())));
            this.last60FrameStarted_$eq(Date$.MODULE$.now());
        }
    }

    public FPSMeter(RunContext context) {
        this.context = context;
        this.startTime = Date$.MODULE$.now();
        this.last60FrameStarted = Date$.MODULE$.now();
        this.lastFrameStarted = Date$.MODULE$.now();
        this.fps = 0;
    }
}

