/*
 * Decompiled with CFR 0.152.
 */
package cwinter.codecraft.core.api;

import cwinter.codecraft.core.api.Drone;
import cwinter.codecraft.core.api.DroneControllerBase;
import cwinter.codecraft.core.api.DroneSpec;
import cwinter.codecraft.core.api.DroneSpec$;
import cwinter.codecraft.core.api.MineralCrystal;
import cwinter.codecraft.core.objects.drone.ConstructDrone;
import cwinter.codecraft.core.objects.drone.DepositMinerals;
import cwinter.codecraft.core.objects.drone.DroneImpl;
import cwinter.codecraft.core.objects.drone.FireMissiles;
import cwinter.codecraft.core.objects.drone.HarvestMineral;
import cwinter.codecraft.core.objects.drone.HoldPosition$;
import cwinter.codecraft.core.objects.drone.MoveInDirection;
import cwinter.codecraft.core.objects.drone.MoveToDrone;
import cwinter.codecraft.core.objects.drone.MoveToMineralCrystal;
import cwinter.codecraft.core.objects.drone.MoveToPosition;
import cwinter.codecraft.util.maths.GlobalRNG$;
import cwinter.codecraft.util.maths.RNG;
import cwinter.codecraft.util.maths.Rectangle;
import cwinter.codecraft.util.maths.Vector2;
import cwinter.codecraft.util.maths.Vector2$;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.Set;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public abstract class DroneControllerBase$class {
    public static void onSpawn(DroneControllerBase $this) {
    }

    public static void onDeath(DroneControllerBase $this) {
    }

    public static void onTick(DroneControllerBase $this) {
    }

    public static void onMineralEntersVision(DroneControllerBase $this, MineralCrystal mineralCrystal) {
    }

    public static void onDroneEntersVision(DroneControllerBase $this, Drone drone) {
    }

    public static void onArrivesAtPosition(DroneControllerBase $this) {
    }

    public static void onArrivesAtMineral(DroneControllerBase $this, MineralCrystal mineralCrystal) {
    }

    public static void onArrivesAtDrone(DroneControllerBase $this, Drone drone) {
    }

    public static void onConstructionCancelled(DroneControllerBase $this) {
    }

    public static Option metaController(DroneControllerBase $this) {
        return None$.MODULE$;
    }

    public static void moveInDirection(DroneControllerBase $this, Vector2 directionVector) {
        Vector2 vector2 = directionVector;
        Vector2 vector22 = Vector2$.MODULE$.Null();
        if (!(vector2 != null ? !vector2.equals(vector22) : vector22 != null)) {
            $this.halt();
        } else {
            $this.drone().$bang(new MoveInDirection(directionVector.orientation()));
        }
    }

    public static void moveInDirection(DroneControllerBase $this, double direction) {
        $this.drone().$bang(new MoveInDirection((float)direction));
    }

    public static void moveInDirection(DroneControllerBase $this, float direction) {
        $this.drone().$bang(new MoveInDirection(direction));
    }

    public static void moveTo(DroneControllerBase $this, Drone otherDrone) {
        if (otherDrone.isEnemy() && !otherDrone.isVisible()) {
            $this.drone().error("Cannot moveTo enemy drone that is not inside the sight radius of any of your drones.");
        } else if (otherDrone.isDead()) {
            $this.drone().warn("Trying to moveTo a dead drone!");
        } else {
            $this.drone().$bang(new MoveToDrone(otherDrone.drone()));
        }
    }

    public static void moveTo(DroneControllerBase $this, MineralCrystal mineralCrystal) {
        $this.drone().$bang(new MoveToMineralCrystal(mineralCrystal.mineralCrystal()));
    }

    public static void moveTo(DroneControllerBase $this, double x, double y) {
        $this.moveTo(Vector2$.MODULE$.apply(x, y));
    }

    public static void moveTo(DroneControllerBase $this, Vector2 position2) {
        Vector2 clippedPosition = DroneControllerBase$class.clipToRectangle($this, position2, $this.worldSize());
        $this.drone().$bang(new MoveToPosition(clippedPosition));
    }

    private static Vector2 clipToRectangle(DroneControllerBase $this, Vector2 vector, Rectangle rectangle) {
        double xClipped = DroneControllerBase$class.clip($this, vector.x(), $this.worldSize().xMin(), $this.worldSize().xMax());
        double yClipped = DroneControllerBase$class.clip($this, vector.y(), $this.worldSize().yMin(), $this.worldSize().yMax());
        return Vector2$.MODULE$.apply(xClipped, yClipped);
    }

    private static double clip(DroneControllerBase $this, double value, double min, double max) {
        return value <= min ? min : (value >= max ? max : value);
    }

    public static void halt(DroneControllerBase $this) {
        $this.drone().$bang(HoldPosition$.MODULE$);
    }

    public static void harvest(DroneControllerBase $this, MineralCrystal mineralCrystal) {
        $this.drone().$bang(new HarvestMineral(mineralCrystal.mineralCrystal()));
    }

    public static void giveResourcesTo(DroneControllerBase $this, Drone otherDrone) {
        if (otherDrone.isDead()) {
            $this.drone().warn("Trying to give minerals to a drone that does not exist anymore!");
        } else {
            $this.drone().$bang(new DepositMinerals(otherDrone.drone()));
        }
    }

    public static void buildDrone(DroneControllerBase $this, DroneControllerBase controller, DroneSpec spec) {
        Vector2 pos = $this.drone().position().$minus(Vector2.ScalarI$.MODULE$.$times$extension(Vector2$.MODULE$.ScalarI(110), GlobalRNG$.MODULE$.vector2(GlobalRNG$.MODULE$.vector2$default$1())));
        Vector2 cappedPos = Vector2$.MODULE$.apply(DroneControllerBase$class.cap$1($this, pos.x(), $this.worldSize().xMin(), $this.worldSize().xMax()), DroneControllerBase$class.cap$1($this, pos.y(), $this.worldSize().yMin(), $this.worldSize().yMax()));
        RNG rng = $this.cwinter$codecraft$core$api$DroneControllerBase$$_drone().context().rng();
        int cost = $this.cwinter$codecraft$core$api$DroneControllerBase$$_drone().context().specialRules().modifiedCost(rng, spec);
        $this.drone().$bang(new ConstructDrone(spec, controller, cappedPos, cost));
    }

    public static void buildDrone(DroneControllerBase $this, DroneControllerBase controller, int storageModules, int missileBatteries, int constructors, int engines, int shieldGenerators) {
        DroneSpec spec = new DroneSpec(storageModules, missileBatteries, constructors, engines, shieldGenerators, DroneSpec$.MODULE$.$lessinit$greater$default$6());
        $this.buildDrone(controller, spec);
    }

    public static void fireMissilesAt(DroneControllerBase $this, Drone target) {
        if (target.isDead()) {
            $this.drone().warn("Trying to fireMissilesAt a drone that does not exist anymore!");
        } else {
            $this.drone().$bang(new FireMissiles(target.drone()));
        }
    }

    public static boolean isVisible(DroneControllerBase $this) {
        return true;
    }

    public static boolean isEnemy(DroneControllerBase $this) {
        return false;
    }

    public static Vector2 lastKnownPosition(DroneControllerBase $this) {
        return $this.position();
    }

    public static double lastKnownOrientation(DroneControllerBase $this) {
        return $this.orientation();
    }

    public static final DroneImpl drone(DroneControllerBase $this) {
        return $this.cwinter$codecraft$core$api$DroneControllerBase$$_drone();
    }

    public static boolean isInMissileRange(DroneControllerBase $this, Drone otherDrone) {
        return otherDrone.position().$minus($this.drone().position()).lengthSquared() <= (float)90000;
    }

    public static boolean isInHarvestingRange(DroneControllerBase $this, MineralCrystal mineralCrystal) {
        return $this.drone().isInHarvestingRange(mineralCrystal.mineralCrystal());
    }

    public static final Set dronesInSightScala(DroneControllerBase $this) {
        return $this.drone().dronesInSight();
    }

    public static final Set alliesInSightScala(DroneControllerBase $this) {
        return $this.drone().alliesInSight();
    }

    public static final Set enemiesInSightScala(DroneControllerBase $this) {
        return $this.drone().enemiesInSight();
    }

    public static final Set mineralsInSightScala(DroneControllerBase $this) {
        return $this.drone().mineralsInSight();
    }

    public static Rectangle worldSize(DroneControllerBase $this) {
        return $this.drone().context().worldSize();
    }

    public static int tickPeriod(DroneControllerBase $this) {
        return $this.drone().context().tickPeriod();
    }

    public static void showText(DroneControllerBase $this, String text, Vector2 position2) {
        if ($this.drone().context().settings().allowMessages()) {
            $this.drone().showText(text, position2.x(), position2.y());
        }
    }

    public static void willProcessEvents(DroneControllerBase $this) {
    }

    public static void initialise(DroneControllerBase $this, DroneImpl drone) {
        Predef$.MODULE$.require($this.cwinter$codecraft$core$api$DroneControllerBase$$_drone() == null, (Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "DroneController must only be initialised once.";
            }
        });
        $this.cwinter$codecraft$core$api$DroneControllerBase$$_drone_$eq(drone);
    }

    public static void giveMineralsTo(DroneControllerBase $this, Drone otherDrone) {
        $this.giveResourcesTo(otherDrone);
    }

    public static void buildDrone(DroneControllerBase $this, DroneSpec spec, DroneControllerBase controller) {
        $this.buildDrone(controller, spec);
    }

    public static int buildDrone$default$2(DroneControllerBase $this) {
        return 0;
    }

    public static int buildDrone$default$3(DroneControllerBase $this) {
        return 0;
    }

    public static int buildDrone$default$4(DroneControllerBase $this) {
        return 0;
    }

    public static int buildDrone$default$5(DroneControllerBase $this) {
        return 0;
    }

    public static int buildDrone$default$6(DroneControllerBase $this) {
        return 0;
    }

    public static int availableRefineries(DroneControllerBase $this) {
        return 0;
    }

    public static Object $js$exported$meth$onSpawn(DroneControllerBase $this) {
        $this.onSpawn();
        return BoxedUnit.UNIT;
    }

    public static Object $js$exported$meth$onDeath(DroneControllerBase $this) {
        $this.onDeath();
        return BoxedUnit.UNIT;
    }

    public static Object $js$exported$meth$onTick(DroneControllerBase $this) {
        $this.onTick();
        return BoxedUnit.UNIT;
    }

    public static Object $js$exported$meth$onMineralEntersVision(DroneControllerBase $this, MineralCrystal mineralCrystal) {
        $this.onMineralEntersVision(mineralCrystal);
        return BoxedUnit.UNIT;
    }

    public static Object $js$exported$meth$onDroneEntersVision(DroneControllerBase $this, Drone drone) {
        $this.onDroneEntersVision(drone);
        return BoxedUnit.UNIT;
    }

    public static Object $js$exported$meth$onArrivesAtPosition(DroneControllerBase $this) {
        $this.onArrivesAtPosition();
        return BoxedUnit.UNIT;
    }

    public static Object $js$exported$meth$onArrivesAtMineral(DroneControllerBase $this, MineralCrystal mineralCrystal) {
        $this.onArrivesAtMineral(mineralCrystal);
        return BoxedUnit.UNIT;
    }

    public static Object $js$exported$meth$onArrivesAtDrone(DroneControllerBase $this, Drone drone) {
        $this.onArrivesAtDrone(drone);
        return BoxedUnit.UNIT;
    }

    public static Object $js$exported$meth$onConstructionCancelled(DroneControllerBase $this) {
        $this.onConstructionCancelled();
        return BoxedUnit.UNIT;
    }

    public static Object $js$exported$prop$metaController(DroneControllerBase $this) {
        return $this.metaController();
    }

    public static Object $js$exported$meth$moveInDirection(DroneControllerBase $this, Vector2 directionVector) {
        $this.moveInDirection(directionVector);
        return BoxedUnit.UNIT;
    }

    public static Object $js$exported$meth$moveInDirection(DroneControllerBase $this, double direction) {
        $this.moveInDirection(direction);
        return BoxedUnit.UNIT;
    }

    public static Object $js$exported$meth$moveInDirection(DroneControllerBase $this, float direction) {
        $this.moveInDirection(direction);
        return BoxedUnit.UNIT;
    }

    public static Object $js$exported$meth$moveTo(DroneControllerBase $this, Drone otherDrone) {
        $this.moveTo(otherDrone);
        return BoxedUnit.UNIT;
    }

    public static Object $js$exported$meth$moveTo(DroneControllerBase $this, MineralCrystal mineralCrystal) {
        $this.moveTo(mineralCrystal);
        return BoxedUnit.UNIT;
    }

    public static Object $js$exported$meth$moveTo(DroneControllerBase $this, double x, double y) {
        $this.moveTo(x, y);
        return BoxedUnit.UNIT;
    }

    public static Object $js$exported$meth$moveTo(DroneControllerBase $this, Vector2 position2) {
        $this.moveTo(position2);
        return BoxedUnit.UNIT;
    }

    public static Object $js$exported$meth$halt(DroneControllerBase $this) {
        $this.halt();
        return BoxedUnit.UNIT;
    }

    public static Object $js$exported$meth$harvest(DroneControllerBase $this, MineralCrystal mineralCrystal) {
        $this.harvest(mineralCrystal);
        return BoxedUnit.UNIT;
    }

    public static Object $js$exported$meth$giveResourcesTo(DroneControllerBase $this, Drone otherDrone) {
        $this.giveResourcesTo(otherDrone);
        return BoxedUnit.UNIT;
    }

    public static Object $js$exported$meth$buildDrone(DroneControllerBase $this, DroneControllerBase controller, DroneSpec spec) {
        $this.buildDrone(controller, spec);
        return BoxedUnit.UNIT;
    }

    public static Object $js$exported$meth$buildDrone(DroneControllerBase $this, DroneControllerBase controller, int storageModules, int missileBatteries, int constructors, int engines, int shieldGenerators) {
        $this.buildDrone(controller, storageModules, missileBatteries, constructors, engines, shieldGenerators);
        return BoxedUnit.UNIT;
    }

    public static int $js$exported$meth$buildDrone$default$2(DroneControllerBase $this) {
        return $this.buildDrone$default$2();
    }

    public static int $js$exported$meth$buildDrone$default$3(DroneControllerBase $this) {
        return $this.buildDrone$default$3();
    }

    public static int $js$exported$meth$buildDrone$default$4(DroneControllerBase $this) {
        return $this.buildDrone$default$4();
    }

    public static int $js$exported$meth$buildDrone$default$5(DroneControllerBase $this) {
        return $this.buildDrone$default$5();
    }

    public static int $js$exported$meth$buildDrone$default$6(DroneControllerBase $this) {
        return $this.buildDrone$default$6();
    }

    public static Object $js$exported$meth$fireMissilesAt(DroneControllerBase $this, Drone target) {
        $this.fireMissilesAt(target);
        return BoxedUnit.UNIT;
    }

    public static Object $js$exported$prop$isVisible(DroneControllerBase $this) {
        return BoxesRunTime.boxToBoolean((boolean)$this.isVisible());
    }

    public static Object $js$exported$prop$isEnemy(DroneControllerBase $this) {
        return BoxesRunTime.boxToBoolean((boolean)$this.isEnemy());
    }

    public static Object $js$exported$prop$lastKnownPosition(DroneControllerBase $this) {
        return $this.lastKnownPosition();
    }

    public static Object $js$exported$prop$lastKnownOrientation(DroneControllerBase $this) {
        return BoxesRunTime.boxToDouble((double)$this.lastKnownOrientation());
    }

    public static Object $js$exported$meth$isInMissileRange(DroneControllerBase $this, Drone otherDrone) {
        return BoxesRunTime.boxToBoolean((boolean)$this.isInMissileRange(otherDrone));
    }

    public static Object $js$exported$meth$isInHarvestingRange(DroneControllerBase $this, MineralCrystal mineralCrystal) {
        return BoxesRunTime.boxToBoolean((boolean)$this.isInHarvestingRange(mineralCrystal));
    }

    public static Object $js$exported$prop$worldSize(DroneControllerBase $this) {
        return $this.worldSize();
    }

    public static Object $js$exported$prop$tickPeriod(DroneControllerBase $this) {
        return BoxesRunTime.boxToInteger((int)$this.tickPeriod());
    }

    public static Object $js$exported$meth$showText(DroneControllerBase $this, String text, Vector2 position2) {
        $this.showText(text, position2);
        return BoxedUnit.UNIT;
    }

    public static Object $js$exported$meth$giveMineralsTo(DroneControllerBase $this, Drone otherDrone) {
        $this.giveMineralsTo(otherDrone);
        return BoxedUnit.UNIT;
    }

    public static Object $js$exported$meth$buildDrone(DroneControllerBase $this, DroneSpec spec, DroneControllerBase controller) {
        $this.buildDrone(spec, controller);
        return BoxedUnit.UNIT;
    }

    public static Object $js$exported$prop$availableRefineries(DroneControllerBase $this) {
        return BoxesRunTime.boxToInteger((int)$this.availableRefineries());
    }

    private static final double cap$1(DroneControllerBase $this, double value, double min, double max) {
        return package$.MODULE$.min(package$.MODULE$.max(value, min), max);
    }

    public static void $init$(DroneControllerBase $this) {
        $this.cwinter$codecraft$core$api$DroneControllerBase$$_drone_$eq(null);
    }
}

