/*
 * Decompiled with CFR 0.152.
 */
package cwinter.codecraft.core.ai.shared;

import cwinter.codecraft.core.ai.shared.SearchToken;
import cwinter.codecraft.core.ai.shared.SharedContext;
import cwinter.codecraft.core.api.Drone;
import cwinter.codecraft.core.api.DroneController;
import cwinter.codecraft.core.api.MineralCrystal;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005McAB\u0001\u0003\u0003\u0003AABA\nBk\u001elWM\u001c;fI\u000e{g\u000e\u001e:pY2,'O\u0003\u0002\u0004\t\u000511\u000f[1sK\u0012T!!\u0002\u0004\u0002\u0005\u0005L'BA\u0004\t\u0003\u0011\u0019wN]3\u000b\u0005%Q\u0011!C2pI\u0016\u001c'/\u00194u\u0015\u0005Y\u0011aB2xS:$XM]\u000b\u0004\u001b!R2C\u0001\u0001\u000f!\ty!#D\u0001\u0011\u0015\t\tb!A\u0002ba&L!a\u0005\t\u0003\u001f\u0011\u0013xN\\3D_:$(o\u001c7mKJD\u0001\"\u0006\u0001\u0003\u0006\u0004%\taF\u0001\bG>tG/\u001a=u\u0007\u0001)\u0012\u0001\u0007\t\u00033ia\u0001\u0001B\u0003\u001c\u0001\t\u0007AD\u0001\u0005U\u0007>tG/\u001a=u#\ti2\u0005\u0005\u0002\u001fC5\tqDC\u0001!\u0003\u0015\u00198-\u00197b\u0013\t\u0011sDA\u0004O_RD\u0017N\\4\u0011\u0007\u0011*s%D\u0001\u0003\u0013\t1#AA\u0007TQ\u0006\u0014X\rZ\"p]R,\u0007\u0010\u001e\t\u00033!\"Q!\u000b\u0001C\u0002)\u0012\u0001\u0002V\"p[6\fg\u000eZ\t\u0003;-\u0002\"A\b\u0017\n\u00055z\"aA!os\"Aq\u0006\u0001B\u0001B\u0003%\u0001$\u0001\u0005d_:$X\r\u001f;!\u0011\u0015\t\u0004\u0001\"\u00013\u0003\u0019a\u0014N\\5u}Q\u00111\u0007\u000e\t\u0005I\u00019\u0003\u0004C\u0003\u0016a\u0001\u0007\u0001\u0004C\u00047\u0001\u0001\u0007I\u0011A\u001c\u0002\u0017M,\u0017M]2i)>\\WM\\\u000b\u0002qA\u0019a$O\u001e\n\u0005iz\"AB(qi&|g\u000e\u0005\u0002%y%\u0011QH\u0001\u0002\f'\u0016\f'o\u00195U_.,g\u000eC\u0004@\u0001\u0001\u0007I\u0011\u0001!\u0002\u001fM,\u0017M]2i)>\\WM\\0%KF$\"!\u0011#\u0011\u0005y\u0011\u0015BA\" \u0005\u0011)f.\u001b;\t\u000f\u0015s\u0014\u0011!a\u0001q\u0005\u0019\u0001\u0010J\u0019\t\r\u001d\u0003\u0001\u0015)\u00039\u00031\u0019X-\u0019:dQR{7.\u001a8!\u0011\u0015I\u0005\u0001\"\u0002K\u0003\u001d)g.Z7jKN,\u0012a\u0013\t\u0004\u0019>\u0013fB\u0001\u0010N\u0013\tqu$\u0001\u0004Qe\u0016$WMZ\u0005\u0003!F\u00131aU3u\u0015\tqu\u0004\u0005\u0002\u0010'&\u0011A\u000b\u0005\u0002\u0006\tJ|g.\u001a\u0015\u0003\u0011Z\u0003\"AH,\n\u0005a{\"AB5oY&tW\rC\u0003[\u0001\u0011\u0005!*\u0001\u0007be6,G-\u00128f[&,7\u000fC\u0003]\u0001\u0011\u0005Q,A\u0007paRLW.\u00197UCJ<W\r^\u000b\u0002=B\u0019a$\u000f*\t\u000b\u0001\u0004A\u0011A1\u0002\u0019\rdwn]3ti\u0016sW-\\=\u0016\u0003ICQa\u0019\u0001\u0005\u0002\u0011\fAc\u00197pg\u0016\u001cH/\u00128f[f\fe\u000e\u001a#jgR\u0014T#A3\u0011\ty1'\u000b[\u0005\u0003O~\u0011a\u0001V;qY\u0016\u0014\u0004C\u0001\u0010j\u0013\tQwDA\u0003GY>\fG\u000fC\u0003m\u0001\u0011\u0005Q.A\u0007iC:$G.Z,fCB|gn\u001d\u000b\u0002\u0003\")q\u000e\u0001C\u0001a\u0006\t2-\u00197dk2\fG/Z*ue\u0016tw\r\u001e5\u0015\u0005E$\bC\u0001\u0010s\u0013\t\u0019xDA\u0002J]RDQ!\u001e8A\u0002Y\fa\u0001\u001a:p]\u0016\u001c\bcA<\u0000%:\u0011\u00010 \b\u0003srl\u0011A\u001f\u0006\u0003wZ\ta\u0001\u0010:p_Rt\u0014\"\u0001\u0011\n\u0005y|\u0012a\u00029bG.\fw-Z\u0005\u0005\u0003\u0003\t\u0019A\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0015\tqx\u0004C\u0004\u0002\b\u0001!\t!!\u0003\u0002\r\r\fgnV5o+\t\tY\u0001E\u0002\u001f\u0003\u001bI1!a\u0004 \u0005\u001d\u0011un\u001c7fC:Dq!a\u0005\u0001\t\u0003\tI!A\u0007f]\u0016l\u0017p\u0015;s_:<WM\u001d\u0005\u0007_\u0002!\t!a\u0006\u0016\u0005\u0005e\u0001\u0003\u0002\u0010gcFDa!!\b\u0001\t\u0003i\u0017!B:d_V$\bbBA\u0011\u0001\u0011\u0005\u00111E\u0001\u0013e\u0016\fX/Z:u'\u0016\f'o\u00195U_.,g\u000eF\u00019\u0011\u0019\t9\u0003\u0001C![\u00069qN\u001c#fCRD\u0007BBA\u0016\u0001\u0011\u0005S.A\fp]\u000e{gn\u001d;sk\u000e$\u0018n\u001c8DC:\u001cW\r\u001c7fI\"9\u0011q\u0006\u0001\u0005B\u0005E\u0012!F8o\u001b&tWM]1m\u000b:$XM]:WSNLwN\u001c\u000b\u0004\u0003\u0006M\u0002\u0002CA\u001b\u0003[\u0001\r!a\u000e\u0002\u001d5Lg.\u001a:bY\u000e\u0013\u0018p\u001d;bYB\u0019q\"!\u000f\n\u0007\u0005m\u0002C\u0001\bNS:,'/\u00197Def\u001cH/\u00197\t\u000f\u0005}\u0002\u0001\"\u0011\u0002B\u0005\u0019rN\u001c#s_:,WI\u001c;feN4\u0016n]5p]R\u0019\u0011)a\u0011\t\u000f\u0005\u0015\u0013Q\ba\u0001%\u0006)AM]8oK\"9\u0011\u0011\n\u0001\u0005B\u0005-\u0013AD7fi\u0006\u001cuN\u001c;s_2dWM]\u000b\u0003\u0003\u001b\u0002BAHA(1%\u0019\u0011\u0011K\u0010\u0003\tM{W.\u001a")
public abstract class AugmentedController<TCommand, TContext extends SharedContext<TCommand>>
extends DroneController {
    private final TContext context;
    private Option<SearchToken> searchToken;

    public TContext context() {
        return this.context;
    }

    public Option<SearchToken> searchToken() {
        return this.searchToken;
    }

    public void searchToken_$eq(Option<SearchToken> x$1) {
        this.searchToken = x$1;
    }

    public final Set<Drone> enemies() {
        return this.enemiesInSight();
    }

    public Set<Drone> armedEnemies() {
        return (Set)this.enemiesInSight().filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Drone x$1) {
                return x$1.spec().missileBatteries() > 0;
            }
        });
    }

    public Option<Drone> optimalTarget() {
        Set inRange = (Set)this.enemies().filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AugmentedController $outer;

            public final boolean apply(Drone otherDrone) {
                return this.$outer.isInMissileRange(otherDrone);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        return inRange.isEmpty() ? None$.MODULE$ : new Some(inRange.maxBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final float apply(Drone x) {
                return (float)x.spec().missileBatteries() / (float)x.hitpoints();
            }
        }, (Ordering)Ordering.Float$.MODULE$));
    }

    public Drone closestEnemy() {
        return (Drone)this.enemiesInSight().minBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AugmentedController $outer;

            public final float apply(Drone x) {
                return x.position().$minus(this.$outer.position()).lengthSquared();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Ordering)Ordering.Float$.MODULE$);
    }

    public Tuple2<Drone, Object> closestEnemyAndDist2() {
        return (Tuple2)((TraversableOnce)this.enemies().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AugmentedController $outer;

            public final Tuple2<Drone, Object> apply(Drone x) {
                return new Tuple2((Object)x, (Object)BoxesRunTime.boxToFloat((float)x.position().$minus(this.$outer.position()).lengthSquared()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Set$.MODULE$.canBuildFrom())).minBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final float apply(Tuple2<Drone, Object> x$2) {
                return BoxesRunTime.unboxToFloat((Object)x$2._2());
            }
        }, (Ordering)Ordering.Float$.MODULE$);
    }

    public void handleWeapons() {
        if (this.missileCooldown() <= 0) {
            this.optimalTarget().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ AugmentedController $outer;

                public final void apply(Drone target) {
                    this.$outer.fireMissilesAt(target);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }
    }

    public int calculateStrength(Iterable<Drone> drones) {
        Tuple2 tuple2 = (Tuple2)drones.foldLeft((Object)new Tuple2.mcII.sp(0, 0), (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply(Tuple2<Object, Object> x0$1, Drone x1$1) {
                Tuple2 tuple2 = new Tuple2(x0$1, (Object)x1$1);
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._1();
                    Drone d = (Drone)tuple2._2();
                    if (tuple22 != null) {
                        int h = tuple22._1$mcI$sp();
                        int a = tuple22._2$mcI$sp();
                        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(h + d.hitpoints(), a + d.spec().missileBatteries());
                        return sp2;
                    }
                }
                throw new MatchError((Object)tuple2);
            }
        });
        if (tuple2 != null) {
            Tuple2.mcII.sp sp2;
            int health = tuple2._1$mcI$sp();
            int attack = tuple2._2$mcI$sp();
            Tuple2.mcII.sp sp3 = sp2 = new Tuple2.mcII.sp(health, attack);
            int health2 = sp3._1$mcI$sp();
            int attack2 = sp3._2$mcI$sp();
            return health2 * attack2;
        }
        throw new MatchError((Object)tuple2);
    }

    public boolean canWin() {
        Tuple2<Object, Object> tuple2 = this.calculateStrength();
        if (tuple2 != null) {
            int alliedStrength;
            int alliedStrength2;
            int enemyStrength = tuple2._1$mcI$sp();
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(enemyStrength, alliedStrength2 = tuple2._2$mcI$sp());
            Tuple2.mcII.sp sp3 = sp2;
            int enemyStrength2 = sp3._1$mcI$sp();
            return enemyStrength2 <= (alliedStrength = sp3._2$mcI$sp());
        }
        throw new MatchError(tuple2);
    }

    public boolean enemyStronger() {
        Tuple2<Object, Object> tuple2 = this.calculateStrength();
        if (tuple2 != null) {
            Tuple2.mcII.sp sp2;
            int enemyStrength = tuple2._1$mcI$sp();
            int alliedStrength = tuple2._2$mcI$sp();
            Tuple2.mcII.sp sp3 = sp2 = new Tuple2.mcII.sp(enemyStrength, alliedStrength);
            int enemyStrength2 = sp3._1$mcI$sp();
            int alliedStrength2 = sp3._2$mcI$sp();
            return alliedStrength2 <= enemyStrength2;
        }
        throw new MatchError(tuple2);
    }

    public Tuple2<Object, Object> calculateStrength() {
        int enemyStrength = this.calculateStrength((Iterable<Drone>)((Iterable)this.dronesInSight().filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Drone x$6) {
                return x$6.isEnemy();
            }
        })));
        int alliedStrength = this.calculateStrength((Iterable<Drone>)((SetLike)this.dronesInSight().filterNot((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Drone x$7) {
                return x$7.isEnemy();
            }
        })).$plus((Object)this));
        return new Tuple2.mcII.sp(enemyStrength, alliedStrength);
    }

    public void scout() {
        this.searchToken().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AugmentedController $outer;

            public final void apply(SearchToken t) {
                if (this.$outer.position().$minus(t.pos()).lengthSquared() < 1.0f) {
                    this.$outer.searchToken_$eq((Option<SearchToken>)None$.MODULE$);
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        if (this.searchToken().isEmpty()) {
            this.searchToken_$eq(this.requestSearchToken());
        }
        this.searchToken().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AugmentedController $outer;

            public final void apply(SearchToken t) {
                this.$outer.moveTo(t.pos());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public Option<SearchToken> requestSearchToken() {
        return this.context().searchCoordinator().getSearchToken(this.position());
    }

    @Override
    public void onDeath() {
        this.searchToken().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AugmentedController $outer;

            public final void apply(SearchToken st) {
                this.$outer.context().searchCoordinator().returnSearchToken(st);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.context().droneCount().decrement(this.getClass());
    }

    @Override
    public void onConstructionCancelled() {
        this.context().droneCount().decrement(this.getClass());
    }

    @Override
    public void onMineralEntersVision(MineralCrystal mineralCrystal) {
        this.context().harvestCoordinator().registerMineral(mineralCrystal);
    }

    @Override
    public void onDroneEntersVision(Drone drone) {
        if (drone.isEnemy() && drone.spec().constructors() > 0) {
            this.context().battleCoordinator().foundCapitalShip(drone);
        }
    }

    public Some<TContext> metaController() {
        return new Some(this.context());
    }

    public AugmentedController(TContext context) {
        this.context = context;
        this.searchToken = None$.MODULE$;
        context.droneCount().increment(this.getClass());
    }
}

