/*
 * Decompiled with CFR 0.152.
 */
package cwinter.codecraft.core.ai.destroyer;

import cwinter.codecraft.core.ai.destroyer.Attack;
import cwinter.codecraft.core.ai.destroyer.DestroyerCommand;
import cwinter.codecraft.core.ai.destroyer.DestroyerContext;
import cwinter.codecraft.core.ai.destroyer.DestroyerController;
import cwinter.codecraft.core.ai.destroyer.MoveClose;
import cwinter.codecraft.core.ai.destroyer.MoveTo;
import cwinter.codecraft.core.ai.shared.Mission;
import cwinter.codecraft.core.ai.shared.MissionExecutor;
import cwinter.codecraft.core.ai.shared.MissionExecutor$class;
import cwinter.codecraft.core.api.Drone;
import cwinter.codecraft.core.api.DroneControllerBase$class;
import cwinter.codecraft.core.api.MineralCrystal;
import cwinter.codecraft.util.maths.Vector2;
import cwinter.codecraft.util.maths.Vector2$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u00055b!B\u0001\u0003\u0001!a!!\u0003#fgR\u0014x._3s\u0015\t\u0019A!A\u0005eKN$(o\\=fe*\u0011QAB\u0001\u0003C&T!a\u0002\u0005\u0002\t\r|'/\u001a\u0006\u0003\u0013)\t\u0011bY8eK\u000e\u0014\u0018M\u001a;\u000b\u0003-\tqaY<j]R,'oE\u0002\u0001\u001bE\u0001\"AD\b\u000e\u0003\tI!\u0001\u0005\u0002\u0003'\u0011+7\u000f\u001e:ps\u0016\u00148i\u001c8ue>dG.\u001a:\u0011\u0007I)r#D\u0001\u0014\u0015\t!B!\u0001\u0004tQ\u0006\u0014X\rZ\u0005\u0003-M\u0011q\"T5tg&|g.\u0012=fGV$xN\u001d\t\u0003\u001daI!!\u0007\u0002\u0003!\u0011+7\u000f\u001e:ps\u0016\u00148i\\7nC:$\u0007\"C\u000e\u0001\u0005\u0003\u0005\u000b\u0011B\u000f!\u0003\r\u0019G\u000f_\u0002\u0001!\tqa$\u0003\u0002 \u0005\t\u0001B)Z:ue>LXM]\"p]R,\u0007\u0010^\u0005\u0003C\t\nqaY8oi\u0016DH/\u0003\u0002$'\t\u0019\u0012)^4nK:$X\rZ\"p]R\u0014x\u000e\u001c7fe\")Q\u0005\u0001C\u0001M\u00051A(\u001b8jiz\"\"a\n\u0015\u0011\u00059\u0001\u0001\"B\u000e%\u0001\u0004i\u0002b\u0002\u0016\u0001\u0001\u0004%\taK\u0001\fQ\u0006\u001c(+\u001a;ve:,G-F\u0001-!\ti\u0003'D\u0001/\u0015\u0005y\u0013!B:dC2\f\u0017BA\u0019/\u0005\u001d\u0011un\u001c7fC:Dqa\r\u0001A\u0002\u0013\u0005A'A\biCN\u0014V\r^;s]\u0016$w\fJ3r)\t)\u0004\b\u0005\u0002.m%\u0011qG\f\u0002\u0005+:LG\u000fC\u0004:e\u0005\u0005\t\u0019\u0001\u0017\u0002\u0007a$\u0013\u0007\u0003\u0004<\u0001\u0001\u0006K\u0001L\u0001\rQ\u0006\u001c(+\u001a;ve:,G\r\t\u0005\b{\u0001\u0001\r\u0011\"\u0001?\u0003-qW\r\u001f;Def\u001cH/\u00197\u0016\u0003}\u00022!\f!C\u0013\t\teF\u0001\u0004PaRLwN\u001c\t\u0003\u0007\u001ak\u0011\u0001\u0012\u0006\u0003\u000b\u001a\t1!\u00199j\u0013\t9EI\u0001\bNS:,'/\u00197Def\u001cH/\u00197\t\u000f%\u0003\u0001\u0019!C\u0001\u0015\u0006ya.\u001a=u\u0007JL8\u000f^1m?\u0012*\u0017\u000f\u0006\u00026\u0017\"9\u0011\bSA\u0001\u0002\u0004y\u0004BB'\u0001A\u0003&q(\u0001\u0007oKb$8I]=ti\u0006d\u0007\u0005C\u0004P\u0001\u0001\u0007I\u0011\u0001)\u0002\u0017\u0019d\u0017n\u001a5u)&lWM]\u000b\u0002#B\u0011QFU\u0005\u0003':\u00121!\u00138u\u0011\u001d)\u0006\u00011A\u0005\u0002Y\u000bqB\u001a7jO\"$H+[7fe~#S-\u001d\u000b\u0003k]Cq!\u000f+\u0002\u0002\u0003\u0007\u0011\u000b\u0003\u0004Z\u0001\u0001\u0006K!U\u0001\rM2Lw\r\u001b;US6,'\u000f\t\u0005\u00067\u0002!\t\u0005X\u0001\b_:\u001c\u0006/Y<o)\u0005)\u0004\"\u00020\u0001\t\u0003b\u0016AB8o)&\u001c7\u000eC\u0003a\u0001\u0011\u0005\u0011-\u0001\bfq\u0016\u001cW\u000f^3D_6l\u0017M\u001c3\u0015\u0005U\u0012\u0007\"B2`\u0001\u00049\u0012aB2p[6\fg\u000e\u001a\u0005\u0006K\u0002!\tAZ\u0001\nG\u0006tg)\u001b8jg\"$\"\u0001L4\t\u000b!$\u0007\u0019A5\u0002\u000b\u0015tW-\\=\u0011\u0005\rS\u0017BA6E\u0005\u0015!%o\u001c8f\u0011\u0015i\u0007\u0001\"\u0001o\u0003E\t\u0007\u000f\u001d:pC\u000eD7)\u0019:fMVdG.\u001f\u000b\u0003k=DQ\u0001\u001d7A\u0002E\fa\u0001^1sO\u0016$\bC\u0001:x\u001b\u0005\u0019(B\u0001;v\u0003\u0015i\u0017\r\u001e5t\u0015\t1\b\"\u0001\u0003vi&d\u0017B\u0001=t\u0005\u001d1Vm\u0019;peJBQA\u001f\u0001\u0005\u0002q\u000ba\u0002]1ue>dW*\u001b8fe\u0006d7\u000fC\u0003}\u0001\u0011\u0005C,\u0001\u0007bE>\u0014H/T5tg&|g\u000eC\u0003\u007f\u0001\u0011\u0005C,A\u0004p]\u0012+\u0017\r\u001e5\t\u000f\u0005\u0005\u0001\u0001\"\u0001\u0002\u0004\u0005QQn\u001c<f\u0003J|WO\u001c3\u0015\u000bE\f)!a\u0002\t\u000bA|\b\u0019A9\t\u000f\u0005%q\u00101\u0001\u0002\f\u00059A\u000f\u001b:fCR\u001c\b#BA\u0007\u0003;Ig\u0002BA\b\u00033qA!!\u0005\u0002\u00185\u0011\u00111\u0003\u0006\u0004\u0003+a\u0012A\u0002\u001fs_>$h(C\u00010\u0013\r\tYBL\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ty\"!\t\u0003\u0011%#XM]1cY\u0016T1!a\u0007/\u0011\u001d\t)\u0003\u0001C\u0001\u0003O\tA#\\8wK^KG\u000f[8vi\u000e{G\u000e\\5tS>tGcA\u001b\u0002*!9\u00111FA\u0012\u0001\u0004\t\u0018a\u0004;be\u001e,G\u000fR5sK\u000e$\u0018n\u001c8")
public class Destroyer
extends DestroyerController
implements MissionExecutor<DestroyerCommand> {
    private boolean hasReturned;
    private Option<MineralCrystal> nextCrystal;
    private int flightTimer;
    private Option cwinter$codecraft$core$ai$shared$MissionExecutor$$_mission;

    @Override
    public Option cwinter$codecraft$core$ai$shared$MissionExecutor$$_mission() {
        return this.cwinter$codecraft$core$ai$shared$MissionExecutor$$_mission;
    }

    @Override
    public void cwinter$codecraft$core$ai$shared$MissionExecutor$$_mission_$eq(Option x$1) {
        this.cwinter$codecraft$core$ai$shared$MissionExecutor$$_mission = x$1;
    }

    @Override
    public Option<Mission<DestroyerCommand>> mission() {
        return MissionExecutor$class.mission(this);
    }

    @Override
    public void startMission(Mission<DestroyerCommand> mission) {
        MissionExecutor$class.startMission(this, mission);
    }

    @Override
    public int missionPriority() {
        return MissionExecutor$class.missionPriority(this);
    }

    public boolean hasReturned() {
        return this.hasReturned;
    }

    public void hasReturned_$eq(boolean x$1) {
        this.hasReturned = x$1;
    }

    public Option<MineralCrystal> nextCrystal() {
        return this.nextCrystal;
    }

    public void nextCrystal_$eq(Option<MineralCrystal> x$1) {
        this.nextCrystal = x$1;
    }

    public int flightTimer() {
        return this.flightTimer;
    }

    public void flightTimer_$eq(int x$1) {
        this.flightTimer = x$1;
    }

    @Override
    public void onSpawn() {
        DroneControllerBase$class.onSpawn(this);
        ((DestroyerContext)this.context()).battleCoordinator().online(this);
    }

    @Override
    public void onTick() {
        Option<Mission<DestroyerCommand>> option;
        block4: {
            block3: {
                block2: {
                    option = this.mission();
                    if (!None$.MODULE$.equals(option)) break block2;
                    this.patrolMinerals();
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!(option instanceof Some)) break block4;
                Some some = (Some)option;
                Mission mission = (Mission)some.x();
                this.executeCommand((DestroyerCommand)mission.missionInstructions());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            this.handleWeapons();
            return;
        }
        throw new MatchError(option);
    }

    public void executeCommand(DestroyerCommand command) {
        DestroyerCommand destroyerCommand;
        block16: {
            block14: {
                BoxedUnit boxedUnit;
                block15: {
                    block13: {
                        BoxedUnit boxedUnit2;
                        destroyerCommand = command;
                        if (!(destroyerCommand instanceof Attack)) break block13;
                        Attack attack = (Attack)destroyerCommand;
                        Drone enemy = attack.enemy();
                        Function0<BoxedUnit> notFound = attack.notFound();
                        Function1<Object, BoxedUnit> metResistance = attack.metResistance();
                        if (enemy.lastKnownPosition().$minus(this.position()).lengthSquared() < (float)10000 && !enemy.isVisible()) {
                            notFound.apply$mcV$sp();
                        } else if (this.canFinish(enemy)) {
                            this.moveTo(enemy.lastKnownPosition());
                        } else {
                            this.approachCarefully(enemy.lastKnownPosition());
                        }
                        if (this.armedEnemies().nonEmpty()) {
                            metResistance.apply$mcVI$sp(this.calculateStrength((Iterable<Drone>)this.armedEnemies()));
                            boxedUnit2 = BoxedUnit.UNIT;
                        } else {
                            boxedUnit2 = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit3 = boxedUnit2;
                        break block14;
                    }
                    if (!(destroyerCommand instanceof MoveTo)) break block15;
                    MoveTo moveTo = (MoveTo)destroyerCommand;
                    Vector2 position2 = moveTo.position();
                    this.approachCarefully(position2);
                    BoxedUnit boxedUnit4 = BoxedUnit.UNIT;
                    break block14;
                }
                if (!(destroyerCommand instanceof MoveClose)) break block16;
                MoveClose moveClose = (MoveClose)destroyerCommand;
                Vector2 targetPos = moveClose.position();
                double targetDist = moveClose.dist();
                float dist2 = targetPos.$minus(this.position()).lengthSquared();
                if ((double)dist2 > (targetDist + (double)25) * (targetDist + (double)25)) {
                    this.moveInDirection(targetPos.$minus(this.position()));
                    boxedUnit = BoxedUnit.UNIT;
                } else if ((double)dist2 < (targetDist - (double)25) * (targetDist - (double)25)) {
                    this.moveInDirection(this.position().$minus(targetPos));
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    this.halt();
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit5 = boxedUnit;
            }
            return;
        }
        throw new MatchError((Object)destroyerCommand);
    }

    public boolean canFinish(Drone enemy) {
        int minDist = 450;
        if (enemy.isVisible() && !(this.position().$minus(enemy.lastKnownPosition()).lengthSquared() >= (float)(minDist * minDist))) {
            int enemyFirepower = BoxesRunTime.unboxToInt((Object)this.armedEnemies().foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final int apply(int x$1, Drone x$2) {
                    return x$1 + x$2.spec().missileBatteries();
                }
            }));
            boolean tmp = this.spec().missileBatteries() * this.hitpoints() > enemy.hitpoints() * enemyFirepower;
            return enemyFirepower == 0 || tmp;
        }
        return false;
    }

    public void approachCarefully(Vector2 target) {
        Set<Drone> threats = this.armedEnemies();
        if (threats.isEmpty()) {
            this.moveWithoutCollision(target.$minus(this.position()));
        } else {
            Vector2 movementVector = this.moveAround(target, (Iterable<Drone>)threats);
            this.moveWithoutCollision(movementVector);
        }
    }

    public void patrolMinerals() {
        if (this.isMoving()) {
            return;
        }
        Set<MineralCrystal> minerals = ((DestroyerContext)this.context()).harvestCoordinator().minerals();
        if (minerals.isEmpty()) {
            return;
        }
        int totalSize = BoxesRunTime.unboxToInt((Object)minerals.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(int x$3, MineralCrystal x$4) {
                return x$3 + x$4.size();
            }
        }));
        int rand = this.context().rng().int(totalSize);
        IntRef cumulative = IntRef.create((int)0);
        Option randMineral = minerals.find((Function1)new Serializable(this, rand, cumulative){
            public static final long serialVersionUID = 0L;
            private final int rand$1;
            private final IntRef cumulative$1;

            public final boolean apply(MineralCrystal m) {
                this.cumulative$1.elem += m.size();
                return this.rand$1 < this.cumulative$1.elem;
            }
            {
                this.rand$1 = rand$1;
                this.cumulative$1 = cumulative$1;
            }
        });
        randMineral.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Destroyer $outer;

            public final void apply(MineralCrystal mineralCrystal) {
                this.$outer.moveTo(mineralCrystal);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Override
    public void abortMission() {
        MissionExecutor$class.abortMission(this);
        if (!this.isDead()) {
            this.halt();
        }
    }

    @Override
    public void onDeath() {
        super.onDeath();
        ((DestroyerContext)this.context()).battleCoordinator().offline(this);
        this.abortMission();
    }

    public Vector2 moveAround(Vector2 target, Iterable<Drone> threats) {
        Vector2 vector2;
        ObjectRef threatVector = ObjectRef.create((Object)Vector2$.MODULE$.Null());
        DoubleRef threatWeight = DoubleRef.create((double)0.0);
        threats.foreach((Function1)new Serializable(this, threatVector, threatWeight){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Destroyer $outer;
            private final ObjectRef threatVector$1;
            private final DoubleRef threatWeight$1;

            public final void apply(Drone threat) {
                Vector2 delta = this.$outer.position().$minus(threat.lastKnownPosition());
                int dangerZone = 350;
                int safeZone = 450;
                double distanceModifier = delta.lengthSquared() < (float)(dangerZone * dangerZone) ? 1.0 : (delta.lengthSquared() > (float)(safeZone * safeZone) ? 0.0 : ((double)safeZone - delta.length()) / (double)(safeZone - dangerZone));
                int strength = threat.spec().missileBatteries() + threat.spec().shieldGenerators();
                double weight = (double)strength * distanceModifier;
                this.threatWeight$1.elem += weight;
                this.threatVector$1.elem = ((Vector2)this.threatVector$1.elem).$plus(Vector2.ScalarD$.MODULE$.$times$extension(Vector2$.MODULE$.ScalarD(weight), delta.normalized()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.threatVector$1 = threatVector$1;
                this.threatWeight$1 = threatWeight$1;
            }
        });
        Vector2 targetContribution = Vector2.ScalarI$.MODULE$.$times$extension(Vector2$.MODULE$.ScalarI(2), target.$minus(this.position()).normalized());
        Vector2 vector22 = (Vector2)threatVector.elem;
        Vector2 vector23 = Vector2$.MODULE$.Null();
        if (!(vector22 != null ? !vector22.equals(vector23) : vector23 != null)) {
            vector2 = targetContribution;
        } else {
            int alliedStrength = BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.dronesInSight().filter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Drone x$5) {
                    return !x$5.isEnemy();
                }
            })).foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final int apply(int x0$1, Drone x1$1) {
                    Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)x0$1), (Object)x1$1);
                    if (tuple2 != null) {
                        int acc = tuple2._1$mcI$sp();
                        Drone d = (Drone)tuple2._2();
                        int n = acc + d.spec().missileBatteries() + d.spec().shieldGenerators();
                        return n;
                    }
                    throw new MatchError((Object)tuple2);
                }
            }));
            double adjustedEnemyWeight = package$.MODULE$.max(0.0, threatWeight.elem - (double)((float)alliedStrength * 0.8f));
            vector2 = targetContribution.$plus(((Vector2)threatVector.elem).normalized().$times(adjustedEnemyWeight));
        }
        return vector2;
    }

    public void moveWithoutCollision(Vector2 targetDirection) {
        double abstand = 30.0;
        Set obstacles = (Set)this.dronesInSight().filter((Function1)new Serializable(this, abstand){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Destroyer $outer;
            private final double abstand$1;

            public final boolean apply(Drone d) {
                float dist2 = d.position().$minus(this.$outer.position()).lengthSquared();
                double minDist = (double)(d.spec().radius() + this.$outer.spec().radius()) + this.abstand$1;
                return d.spec().missileBatteries() > 0 && (double)dist2 <= minDist * minDist;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.abstand$1 = abstand$1;
            }
        });
        if (obstacles.isEmpty()) {
            this.moveInDirection(targetDirection);
        } else {
            Drone obstacle = (Drone)obstacles.head();
            Vector2 avoidanceVector = this.position().$minus(obstacle.position());
            double weight = (avoidanceVector.length() - (double)obstacle.spec().radius() - (double)this.spec().radius()) / abstand;
            this.moveInDirection(Vector2.ScalarD$.MODULE$.$times$extension(Vector2$.MODULE$.ScalarD(weight), targetDirection.normalized()).$plus(Vector2.ScalarD$.MODULE$.$times$extension(Vector2$.MODULE$.ScalarD(1.0 - weight), avoidanceVector.normalized())));
        }
    }

    public Destroyer(DestroyerContext ctx) {
        super(ctx);
        MissionExecutor$class.$init$(this);
        this.hasReturned = false;
        this.nextCrystal = None$.MODULE$;
        this.flightTimer = 0;
    }
}

