/*
 * Decompiled with CFR 0.152.
 */
package org.cloudgraph.rdb.service;

import commonj.sdo.Property;
import commonj.sdo.Type;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudgraph.common.concurrent.ConfigProps;
import org.cloudgraph.rdb.filter.RDBFilterAssembler;
import org.cloudgraph.rdb.filter.RDBGroupingAssembler;
import org.cloudgraph.rdb.filter.RDBOrderingAssembler;
import org.cloudgraph.rdb.graph.GraphAssembler;
import org.cloudgraph.rdb.graph.ParallelGraphAssembler;
import org.cloudgraph.rdb.service.RDBDataConverter;
import org.cloudgraph.rdb.service.RDBServiceException;
import org.cloudgraph.store.lang.DefaultAssembler;
import org.cloudgraph.store.lang.LangStoreGraphAssembler;
import org.cloudgraph.store.lang.StatementUtil;
import org.cloudgraph.store.mapping.FetchType;
import org.cloudgraph.store.mapping.StoreMappingProp;
import org.cloudgraph.store.service.AliasMap;
import org.plasma.query.Query;
import org.plasma.query.collector.SelectionCollector;
import org.plasma.query.model.From;
import org.plasma.query.model.GroupBy;
import org.plasma.query.model.OrderBy;
import org.plasma.query.model.Select;
import org.plasma.query.model.Variable;
import org.plasma.query.model.Where;
import org.plasma.query.visitor.DefaultQueryVisitor;
import org.plasma.query.visitor.QueryVisitor;
import org.plasma.runtime.DataAccessProviderName;
import org.plasma.runtime.PlasmaRuntime;
import org.plasma.runtime.RDBMSVendorName;
import org.plasma.sdo.PlasmaDataGraph;
import org.plasma.sdo.PlasmaDataObject;
import org.plasma.sdo.PlasmaProperty;
import org.plasma.sdo.PlasmaType;
import org.plasma.sdo.access.DataAccessException;
import org.plasma.sdo.access.MaxResultsExceededException;
import org.plasma.sdo.access.QueryDispatcher;
import org.plasma.sdo.access.provider.common.DataObjectHashKeyAssembler;
import org.plasma.sdo.access.provider.common.PropertyPair;
import org.plasma.sdo.helper.PlasmaTypeHelper;

public class GraphQuery
implements QueryDispatcher {
    private static Log log = LogFactory.getLog(GraphQuery.class);
    private static final String ROWNUM_ALIAS = "RNMX";
    private static final String PAGE_ALIAS = "TX";
    private Connection con;
    private StatementUtil statementUtil;

    private GraphQuery() {
    }

    public GraphQuery(Connection con) {
        this.con = con;
        this.statementUtil = new StatementUtil();
    }

    public PlasmaDataGraph[] find(org.plasma.query.model.Query query, Timestamp snapshotDate) {
        return this.find(query, -1, snapshotDate);
    }

    public PlasmaDataGraph[] find(org.plasma.query.model.Query query, int requestMax, Timestamp snapshotDate) {
        From from = query.getFromClause();
        PlasmaType type = (PlasmaType)PlasmaTypeHelper.INSTANCE.getType(from.getEntity().getNamespaceURI(), from.getEntity().getName());
        SelectionCollector collector = new SelectionCollector(query.getSelectClause(), null, query.findOrderByClause(), (Type)type);
        collector.setOnlySingularProperties(false);
        collector.setOnlyDeclaredProperties(false);
        List<List<PropertyPair>> queryResults = this.findResults(query, collector, type, this.con);
        DefaultAssembler assembler = null;
        FetchType fetchType = StoreMappingProp.getQueryFetchType((Query)query);
        switch (fetchType) {
            case PARALLEL: {
                int minPool = StoreMappingProp.getQueryPoolMin((Query)query);
                int maxPool = StoreMappingProp.getQueryPoolMax((Query)query);
                if (minPool > maxPool) {
                    minPool = maxPool;
                }
                int threadMaxDepth = StoreMappingProp.getQueryThreadMaxDepth((Query)query);
                ConfigProps config = new ConfigProps(minPool, maxPool, threadMaxDepth);
                assembler = new ParallelGraphAssembler(type, collector, snapshotDate, config, this.con);
                break;
            }
            default: {
                assembler = new GraphAssembler(type, collector, snapshotDate, this.con);
            }
        }
        PlasmaDataGraph[] results = null;
        try {
            results = !query.getSelectClause().hasDistinctProperties() ? this.assembleResults(queryResults, requestMax, (LangStoreGraphAssembler)assembler) : this.trimResults(queryResults, requestMax, (LangStoreGraphAssembler)assembler, query.getSelectClause(), (Type)type);
        }
        catch (SQLException e) {
            throw new RDBServiceException(e);
        }
        return results;
    }

    public int count(org.plasma.query.model.Query query) {
        From from = query.getFromClause();
        PlasmaType type = (PlasmaType)PlasmaTypeHelper.INSTANCE.getType(from.getEntity().getNamespaceURI(), from.getEntity().getName());
        int size = this.countResults(this.con, query, type);
        return size;
    }

    private PlasmaDataGraph[] assembleResults(List<List<PropertyPair>> collection, int requestMax, LangStoreGraphAssembler assembler) throws SQLException {
        long before = System.currentTimeMillis();
        ArrayList<PlasmaDataGraph> list = new ArrayList<PlasmaDataGraph>(20);
        Iterator<List<PropertyPair>> iter = collection.iterator();
        int i = 1;
        while (iter.hasNext()) {
            List<PropertyPair> pairs = iter.next();
            if (requestMax <= 0) {
                if (i > 15000) {
                    throw new MaxResultsExceededException(i, 15000);
                }
            } else if (i > requestMax) {
                if (!log.isDebugEnabled()) break;
                log.debug((Object)("truncating results at " + String.valueOf(requestMax)));
                break;
            }
            assembler.assemble(pairs);
            list.add(assembler.getDataGraph());
            assembler.clear();
            ++i;
        }
        PlasmaDataGraph[] results = new PlasmaDataGraph[list.size()];
        list.toArray(results);
        if (log.isDebugEnabled()) {
            long after = System.currentTimeMillis();
            log.debug((Object)("assembled " + String.valueOf(results.length) + " results (" + String.valueOf(after - before) + ")"));
        }
        return results;
    }

    private PlasmaDataGraph[] trimResults(List<List<PropertyPair>> collection, int requestMax, LangStoreGraphAssembler assembler, Select select, Type type) throws SQLException {
        DataObjectHashKeyAssembler hashKeyAssembler = new DataObjectHashKeyAssembler(select, type);
        HashMap<String, PlasmaDataObject> distinctMap = new HashMap<String, PlasmaDataObject>(20);
        ArrayList<PlasmaDataObject> distinctList = new ArrayList<PlasmaDataObject>(20);
        Iterator<List<PropertyPair>> iter = collection.iterator();
        int i = 1;
        while (iter.hasNext()) {
            if (requestMax <= 0 && i > 15000) {
                throw new MaxResultsExceededException(i, 15000);
            }
            List<PropertyPair> pairs = iter.next();
            assembler.assemble(pairs);
            PlasmaDataGraph dataGraph = assembler.getDataGraph();
            assembler.clear();
            String key = hashKeyAssembler.getHashKey((PlasmaDataObject)dataGraph.getRootObject());
            if (distinctMap.get(key) == null) {
                if (requestMax <= 0) {
                    if (i > 15000) {
                        throw new MaxResultsExceededException(distinctList.size(), 15000);
                    }
                } else if (i > requestMax) {
                    if (!log.isDebugEnabled()) break;
                    log.debug((Object)("truncating results at " + String.valueOf(requestMax)));
                    break;
                }
                distinctMap.put(key, (PlasmaDataObject)dataGraph.getRootObject());
                distinctList.add((PlasmaDataObject)dataGraph.getRootObject());
            }
            ++i;
        }
        PlasmaDataGraph[] trimmedResults = new PlasmaDataGraph[distinctList.size()];
        i = 0;
        while (i < trimmedResults.length) {
            trimmedResults[i] = (PlasmaDataGraph)((PlasmaDataObject)distinctList.get(i)).getDataGraph();
            ++i;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("assembled " + String.valueOf(trimmedResults.length) + " results out of " + String.valueOf(i)));
        }
        return trimmedResults;
    }

    private int countResults(Connection con, org.plasma.query.model.Query query, PlasmaType type) {
        int result = 0;
        Object[] params = new Object[]{};
        StringBuilder sqlQuery = new StringBuilder();
        AliasMap aliasMap = new AliasMap(type);
        RDBFilterAssembler filterAssembler = null;
        Where where = query.findWhereClause();
        if (where != null) {
            filterAssembler = new RDBFilterAssembler(where, (Type)type, aliasMap);
            params = filterAssembler.getParams();
            if (log.isDebugEnabled()) {
                log.debug((Object)("filter: " + filterAssembler.getFilter()));
            }
        }
        sqlQuery.append("SELECT COUNT(*)");
        sqlQuery.append(" FROM ");
        Iterator it = aliasMap.getTypes();
        int count = 0;
        while (it.hasNext()) {
            PlasmaType aliasType = (PlasmaType)it.next();
            String alias = aliasMap.getAlias(aliasType);
            if (count > 0) {
                sqlQuery.append(", ");
            }
            sqlQuery.append(this.statementUtil.getQualifiedPhysicalName(aliasType));
            sqlQuery.append(" ");
            sqlQuery.append(alias);
            ++count;
        }
        if (filterAssembler != null) {
            sqlQuery.append(" ");
            sqlQuery.append(filterAssembler.getFilter());
        }
        if (query.getStartRange() != null && query.getEndRange() != null) {
            log.warn((Object)("query range (start: " + query.getStartRange() + ", end: " + query.getEndRange() + ") ignored for count operation"));
        }
        Statement statement = null;
        ResultSet rs = null;
        try {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("queryString: " + sqlQuery.toString()));
                    log.debug((Object)"executing...");
                }
                statement = con.prepareStatement(sqlQuery.toString(), 1003, 1007);
                if (filterAssembler != null && (params = filterAssembler.getParams()) != null) {
                    int i = 0;
                    while (i < params.length) {
                        statement.setObject(i + 1, params[i]);
                        ++i;
                    }
                }
                if (log.isDebugEnabled()) {
                    if (params == null || params.length == 0) {
                        log.debug((Object)("executing: " + sqlQuery.toString()));
                    } else {
                        StringBuilder paramBuf = new StringBuilder();
                        paramBuf.append(" [");
                        int p = 0;
                        while (p < params.length) {
                            if (p > 0) {
                                paramBuf.append(", ");
                            }
                            paramBuf.append(String.valueOf(params[p]));
                            ++p;
                        }
                        paramBuf.append("]");
                        log.debug((Object)("executing: " + sqlQuery.toString() + " " + paramBuf.toString()));
                    }
                }
                statement.execute();
                rs = statement.getResultSet();
                rs.next();
                result = rs.getInt(1);
            }
            catch (Throwable t) {
                StringBuffer buf = this.generateErrorDetail(t, sqlQuery.toString(), filterAssembler);
                log.error((Object)buf.toString());
                throw new DataAccessException(t);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }

    private List<List<PropertyPair>> findResults(org.plasma.query.model.Query query, SelectionCollector collector, PlasmaType type, Connection con) {
        AbstractStringBuilder buf;
        Object[] params = new Object[]{};
        RDBDataConverter converter = RDBDataConverter.INSTANCE;
        AliasMap aliasMap = new AliasMap(type);
        RDBFilterAssembler filterAssembler = null;
        Where where = query.findWhereClause();
        if (where != null) {
            filterAssembler = new RDBFilterAssembler(where, (Type)type, aliasMap);
            params = filterAssembler.getParams();
        }
        RDBOrderingAssembler orderingDeclAssembler = null;
        OrderBy orderby = query.findOrderByClause();
        if (orderby != null) {
            orderingDeclAssembler = new RDBOrderingAssembler(orderby, type, aliasMap);
        }
        RDBGroupingAssembler groupingDeclAssembler = null;
        GroupBy groupby = query.findGroupByClause();
        if (groupby != null) {
            groupingDeclAssembler = new RDBGroupingAssembler(groupby, type, aliasMap);
        }
        String rootAlias = aliasMap.getAlias(type);
        AbstractStringBuilder sqlQuery = new StringBuilder();
        ((StringBuilder)sqlQuery).append("SELECT DISTINCT ");
        boolean hasLob = false;
        int i = 0;
        Set props = collector.getProperties((Type)type);
        for (Property prop : props) {
            if (prop.isMany() && !prop.getType().isDataType()) continue;
            if (i > 0) {
                ((StringBuilder)sqlQuery).append(", ");
            }
            ((StringBuilder)sqlQuery).append(rootAlias);
            ((StringBuilder)sqlQuery).append(".");
            ((StringBuilder)sqlQuery).append(((PlasmaProperty)prop).getPhysicalName());
            ++i;
        }
        ((StringBuilder)sqlQuery).append(" FROM ");
        Iterator it = aliasMap.getTypes();
        int count = 0;
        while (it.hasNext()) {
            PlasmaType aliasType = (PlasmaType)it.next();
            String alias = aliasMap.getAlias(aliasType);
            if (count > 0) {
                ((StringBuilder)sqlQuery).append(", ");
            }
            ((StringBuilder)sqlQuery).append(this.statementUtil.getQualifiedPhysicalName(aliasType));
            ((StringBuilder)sqlQuery).append(" ");
            ((StringBuilder)sqlQuery).append(alias);
            ++count;
        }
        if (filterAssembler != null) {
            ((StringBuilder)sqlQuery).append(" ");
            ((StringBuilder)sqlQuery).append(filterAssembler.getFilter());
        }
        if (orderingDeclAssembler != null) {
            ((StringBuilder)sqlQuery).append(" ");
            ((StringBuilder)sqlQuery).append(orderingDeclAssembler.getOrderingDeclaration());
        }
        if (groupingDeclAssembler != null) {
            ((StringBuilder)sqlQuery).append(" ");
            ((StringBuilder)sqlQuery).append(groupingDeclAssembler.getGroupingDeclaration());
        }
        RDBMSVendorName vendor = PlasmaRuntime.getInstance().getRDBMSProviderVendor(DataAccessProviderName.JDBC);
        switch (vendor) {
            case ORACLE: {
                if (query.getStartRange() == null || query.getEndRange() == null) break;
                long offset = query.getStartRange() - 1;
                if (offset < 0L) {
                    offset = 0L;
                }
                long rowcount = (long)query.getEndRange().intValue() - offset;
                buf = new StringBuilder();
                if (offset == 0L) {
                    ((StringBuilder)buf).append("SELECT * FROM (");
                    ((StringBuilder)buf).append((CharSequence)sqlQuery);
                    ((StringBuilder)buf).append(") WHERE ROWNUM <= ");
                    ((StringBuilder)buf).append(rowcount);
                } else {
                    ((StringBuilder)buf).append("SELECT * FROM (SELECT ");
                    ((StringBuilder)buf).append(PAGE_ALIAS);
                    ((StringBuilder)buf).append(".*, ROWNUM AS ");
                    ((StringBuilder)buf).append(ROWNUM_ALIAS);
                    ((StringBuilder)buf).append(" FROM (");
                    ((StringBuilder)buf).append((CharSequence)sqlQuery);
                    ((StringBuilder)buf).append(") ");
                    ((StringBuilder)buf).append(PAGE_ALIAS);
                    ((StringBuilder)buf).append(") ");
                    ((StringBuilder)buf).append("WHERE ");
                    ((StringBuilder)buf).append(ROWNUM_ALIAS);
                    ((StringBuilder)buf).append(" >= ");
                    ((StringBuilder)buf).append(query.getStartRange());
                    ((StringBuilder)buf).append(" AND ROWNUM <= ");
                    ((StringBuilder)buf).append(rowcount);
                }
                sqlQuery = buf;
                break;
            }
            case MYSQL: {
                if (query.getStartRange() == null || query.getEndRange() == null) break;
                long offset = query.getStartRange() - 1;
                if (offset < 0L) {
                    offset = 0L;
                }
                long rowcount = (long)query.getEndRange().intValue() - offset;
                ((StringBuilder)sqlQuery).append(" LIMIT ");
                ((StringBuilder)sqlQuery).append(String.valueOf(offset));
                ((StringBuilder)sqlQuery).append(",");
                ((StringBuilder)sqlQuery).append(String.valueOf(rowcount));
            }
        }
        ArrayList<List<PropertyPair>> rows = new ArrayList<List<PropertyPair>>();
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            try {
                statement = con.prepareStatement(((StringBuilder)sqlQuery).toString(), 1003, 1007);
                int paramCount = 0;
                if (filterAssembler != null && (params = filterAssembler.getParams()) != null) {
                    paramCount = params.length;
                    i = 0;
                    while (i < params.length) {
                        statement.setObject(i + 1, params[i]);
                        ++i;
                    }
                }
                long before = System.currentTimeMillis();
                statement.execute();
                long after = System.currentTimeMillis();
                if (log.isDebugEnabled()) {
                    if (params == null || params.length == 0) {
                        log.debug((Object)("executed: " + ((StringBuilder)sqlQuery).toString() + " (" + String.valueOf(after - before) + ")"));
                    } else {
                        StringBuilder paramBuf = new StringBuilder();
                        paramBuf.append(" [");
                        int p = 0;
                        while (p < params.length) {
                            if (p > 0) {
                                paramBuf.append(", ");
                            }
                            paramBuf.append(String.valueOf(params[p]));
                            ++p;
                        }
                        paramBuf.append("]");
                        log.debug((Object)("executed: " + ((StringBuilder)sqlQuery).toString() + " " + paramBuf.toString() + " (" + String.valueOf(after - before) + ")"));
                    }
                }
                before = System.currentTimeMillis();
                int numresults = 0;
                rs = statement.getResultSet();
                int numcols = rs.getMetaData().getColumnCount();
                ResultSetMetaData rsMeta = rs.getMetaData();
                ArrayList<PropertyPair> row = null;
                PropertyPair pair = null;
                while (rs.next()) {
                    row = new ArrayList<PropertyPair>();
                    rows.add(row);
                    i = 1;
                    while (i <= numcols) {
                        String columnName = rsMeta.getColumnLabel(i);
                        if (columnName == null) {
                            columnName = rsMeta.getColumnName(i);
                        }
                        if (!ROWNUM_ALIAS.equals(columnName)) {
                            PlasmaProperty prop;
                            int columnType = rsMeta.getColumnType(i);
                            PlasmaProperty valueProp = prop = (PlasmaProperty)type.getProperty(columnName);
                            while (!valueProp.getType().isDataType()) {
                                valueProp = this.statementUtil.getOppositePriKeyProperty((Property)valueProp);
                            }
                            Object value = converter.fromJDBCDataType(rs, i, columnType, valueProp);
                            if (value != null) {
                                pair = new PropertyPair(prop, value);
                                pair.setColumn(i);
                                if (!valueProp.equals(prop)) {
                                    pair.setValueProp(valueProp);
                                }
                                row.add(pair);
                            }
                        }
                        ++i;
                    }
                    ++numresults;
                }
                after = System.currentTimeMillis();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("read " + numresults + " results (" + String.valueOf(after - before) + ")"));
                }
            }
            catch (Throwable t) {
                buf = this.generateErrorDetail(t, ((StringBuilder)sqlQuery).toString(), filterAssembler);
                log.error((Object)((StringBuffer)buf).toString());
                throw new DataAccessException(t);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return rows;
    }

    private StringBuffer generateErrorDetail(Throwable t, String queryString, RDBFilterAssembler filterAssembler) {
        StringBuffer buf = new StringBuffer(2048);
        buf.append("QUERY FAILED: ");
        buf.append(t.getMessage());
        buf.append(" \n");
        if (queryString != null) {
            buf.append("queryString: ");
            buf.append(queryString);
            buf.append(" \n");
        }
        if (filterAssembler != null) {
            Object[] params;
            if (filterAssembler.hasImportDeclarations()) {
                buf.append("import decl: ");
                buf.append(filterAssembler.getImportDeclarations());
                buf.append(" \n");
            }
            if ((params = filterAssembler.getParams()) != null) {
                buf.append("parameters: [");
                int i = 0;
                while (i < params.length) {
                    if (i > 0) {
                        buf.append(", ");
                    }
                    buf.append(String.valueOf(params[i]));
                    ++i;
                }
                buf.append("]");
                buf.append(" \n");
            }
            if (filterAssembler.hasParameterDeclarations()) {
                buf.append("param decl: ");
                buf.append(filterAssembler.getParameterDeclarations());
                buf.append(" \n");
            }
            if (filterAssembler.hasVariableDeclarations()) {
                buf.append("variable decl: ");
                buf.append(filterAssembler.getVariableDeclarations());
                buf.append(" \n");
            }
        }
        return buf;
    }

    public List<Variable> getVariables(Where where) {
        final ArrayList<Variable> list = new ArrayList<Variable>(1);
        DefaultQueryVisitor visitor = new DefaultQueryVisitor(){

            public void start(Variable var) {
                list.add(var);
            }
        };
        where.accept((QueryVisitor)visitor);
        return list;
    }

    public void close() {
    }
}

