/*
 * Decompiled with CFR 0.152.
 */
package org.cloudgraph.rdb.graph;

import commonj.sdo.DataGraph;
import commonj.sdo.Property;
import commonj.sdo.Type;
import java.sql.Connection;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudgraph.common.concurrent.ConfigProps;
import org.cloudgraph.common.concurrent.GraphMetricVisitor;
import org.cloudgraph.common.concurrent.SubgraphTask;
import org.cloudgraph.common.concurrent.Traversal;
import org.cloudgraph.rdb.filter.RDBStatementExecutor;
import org.cloudgraph.rdb.filter.RDBStatementFactory;
import org.cloudgraph.rdb.graph.ParallelSubgraphTask;
import org.cloudgraph.store.lang.DefaultAssembler;
import org.cloudgraph.store.lang.LangStoreGraphAssembler;
import org.cloudgraph.store.lang.StatementExecutor;
import org.cloudgraph.store.lang.StatementFactory;
import org.plasma.query.collector.SelectionCollector;
import org.plasma.sdo.PlasmaDataGraphVisitor;
import org.plasma.sdo.PlasmaDataObject;
import org.plasma.sdo.PlasmaProperty;
import org.plasma.sdo.PlasmaType;
import org.plasma.sdo.access.provider.common.PropertyPair;
import org.plasma.sdo.core.CoreNode;

public class ParallelGraphAssembler
extends DefaultAssembler
implements LangStoreGraphAssembler {
    private static Log log = LogFactory.getLog(ParallelGraphAssembler.class);
    private ThreadPoolExecutor executorService;
    private ConfigProps config;

    public ParallelGraphAssembler(PlasmaType rootType, SelectionCollector collector, Timestamp snapshotDate, ConfigProps config, Connection con) {
        super(rootType, collector, (StatementFactory)new RDBStatementFactory(), (StatementExecutor)new RDBStatementExecutor(con), new ConcurrentHashMap(), snapshotDate);
        this.executorService = new ThreadPoolExecutor(config.getMinThreadPoolSize(), config.getMaxThreadPoolSize(), 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadPoolExecutor.CallerRunsPolicy());
        this.config = config;
    }

    public ThreadPoolExecutor getExecutorService() {
        return this.executorService;
    }

    public ConfigProps getConfig() {
        return this.config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void link(PlasmaDataObject target, PlasmaDataObject source, PlasmaProperty sourceProperty) {
        PlasmaDataObject plasmaDataObject = source;
        synchronized (plasmaDataObject) {
            PlasmaDataObject plasmaDataObject2 = target;
            synchronized (plasmaDataObject2) {
                super.link(target, source, sourceProperty);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PlasmaDataObject createDataObject(List<PropertyPair> row, PlasmaDataObject source, PlasmaProperty sourceProperty) {
        ParallelGraphAssembler parallelGraphAssembler = this;
        synchronized (parallelGraphAssembler) {
            return super.createDataObject(row, source, sourceProperty);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void assemble(List<PropertyPair> results) {
        void var10_18;
        ParallelSubgraphTask task;
        Object trav;
        void var10_14;
        long before = System.currentTimeMillis();
        DataGraph dataGraph = this.initRoot(results);
        CoreNode rootNode = (CoreNode)dataGraph.getRootObject();
        ArrayList<Traversal> traversals = new ArrayList<Traversal>();
        for (PropertyPair pair : results) {
            if (pair.getProp().isMany() || pair.getProp().getType().isDataType()) continue;
            List childKeyProps = this.getChildKeyPairs(pair);
            Traversal traversal = new Traversal((PlasmaType)pair.getProp().getType(), this.root, pair.getProp(), childKeyProps, 1);
            traversals.add(traversal);
        }
        Set props = this.collector.getProperties((Type)this.rootType);
        for (Property p : props) {
            PlasmaProperty plasmaProperty = (PlasmaProperty)p;
            if (!plasmaProperty.isMany() || plasmaProperty.getType().isDataType()) continue;
            List childKeyProps = this.getChildKeyPairs(this.root, plasmaProperty);
            Traversal trav3 = new Traversal((PlasmaType)plasmaProperty.getType(), this.root, plasmaProperty, childKeyProps, 1);
            traversals.add(trav3);
        }
        this.logPoolStatistics();
        int available = this.numThreadsAvailable();
        if (available > traversals.size()) {
            available = traversals.size();
        }
        ArrayList<ParallelSubgraphTask> concurrentTasks = new ArrayList<ParallelSubgraphTask>();
        boolean bl = false;
        while (var10_14 < available) {
            trav = (Traversal)traversals.get((int)var10_14);
            task = new ParallelSubgraphTask(trav.getSubrootType(), trav.getSource(), this.collector, this.getStatementFactory(), this.getStatementExecutor(), trav.getSourceProperty(), trav.getChildKeyPairs(), trav.getLevel(), (int)var10_14, this);
            concurrentTasks.add(task);
            ++var10_14;
        }
        for (SubgraphTask subgraphTask : concurrentTasks) {
            subgraphTask.start();
        }
        for (SubgraphTask subgraphTask : concurrentTasks) {
            subgraphTask.join();
        }
        int n = available;
        while (var10_18 < traversals.size()) {
            trav = (Traversal)traversals.get((int)var10_18);
            task = new ParallelSubgraphTask(trav.getSubrootType(), trav.getSource(), this.collector, this.getStatementFactory(), this.getStatementExecutor(), trav.getSourceProperty(), trav.getChildKeyPairs(), trav.getLevel(), traversals.size(), this);
            task.assemble();
            ++var10_18;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("completed root " + this.root));
        }
        long l = System.currentTimeMillis();
        rootNode.getValueObject().put("GraphAssemblyTime", (Object)(l - before));
        GraphMetricVisitor visitor = new GraphMetricVisitor();
        this.root.accept((PlasmaDataGraphVisitor)visitor);
        rootNode.getValueObject().put("GraphNodeCount", (Object)visitor.getCount());
        rootNode.getValueObject().put("GraphDepth", (Object)visitor.getDepth());
        rootNode.getValueObject().put("GraphThreadCount", (Object)visitor.getThreadCount());
    }

    protected void assemble(PlasmaType targetType, PlasmaDataObject source, PlasmaProperty sourceProperty, List<PropertyPair> childKeyPairs, int level) {
    }

    public void logPoolStatistics() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("active: " + this.executorService.getActiveCount() + ", size: " + this.executorService.getPoolSize()));
        }
    }

    public boolean threadsAvailable() {
        return this.executorService.getActiveCount() < this.executorService.getMaximumPoolSize();
    }

    public int numThreadsAvailable() {
        int result = this.executorService.getMaximumPoolSize() - this.executorService.getActiveCount();
        if (result < 0) {
            result = 0;
        }
        return result;
    }
}

