/*
 * Decompiled with CFR 0.152.
 */
package org.cloudgraph.rdb.graph;

import com.google.common.util.concurrent.Uninterruptibles;
import commonj.sdo.Property;
import commonj.sdo.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.RejectedExecutionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudgraph.common.concurrent.SubgraphTask;
import org.cloudgraph.common.concurrent.Traversal;
import org.cloudgraph.rdb.graph.ParallelGraphAssembler;
import org.cloudgraph.store.lang.AssemblerSupport;
import org.cloudgraph.store.lang.DefaultAssembler;
import org.cloudgraph.store.lang.StatementExecutor;
import org.cloudgraph.store.lang.StatementFactory;
import org.plasma.query.collector.SelectionCollector;
import org.plasma.sdo.PlasmaDataObject;
import org.plasma.sdo.PlasmaProperty;
import org.plasma.sdo.PlasmaType;
import org.plasma.sdo.access.provider.common.PropertyPair;

public class ParallelSubgraphTask
extends AssemblerSupport
implements SubgraphTask {
    private static Log log = LogFactory.getLog(ParallelSubgraphTask.class);
    protected PlasmaType subrootType;
    protected PlasmaDataObject source;
    protected PlasmaProperty sourceProperty;
    protected List<PropertyPair> subrootChildKeyPairs;
    protected int level;
    protected int sequence;
    private final CountDownLatch shutdownLatch = new CountDownLatch(1);
    private ParallelGraphAssembler sharedAssembler;

    public ParallelSubgraphTask(PlasmaType subrootType, PlasmaDataObject source, SelectionCollector selection, StatementFactory statementFactory, StatementExecutor statementExecutor, PlasmaProperty sourceProperty, List<PropertyPair> childKeyPairs, int level, int sequence, ParallelGraphAssembler assembler) {
        super(selection, statementFactory, statementExecutor);
        this.subrootType = subrootType;
        this.source = source;
        this.sourceProperty = sourceProperty;
        this.subrootChildKeyPairs = childKeyPairs;
        this.level = level;
        this.sequence = sequence;
        this.sharedAssembler = assembler;
        if (log.isDebugEnabled()) {
            log.debug((Object)(String.valueOf(String.valueOf(level)) + ":process: " + source.getType().getName() + "." + sourceProperty.getName() + "->" + subrootType.getName() + ": " + childKeyPairs));
        }
    }

    public void start() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("start-" + this.level + "." + this.sequence));
        }
        try {
            this.sharedAssembler.getExecutorService().execute(new Runnable(){

                @Override
                public void run() {
                    ParallelSubgraphTask.this.assemble();
                    ParallelSubgraphTask.this.shutdown();
                }
            });
        }
        catch (RejectedExecutionException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected void shutdown() {
        this.shutdownLatch.countDown();
    }

    public void join() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("join-" + this.level + "." + this.sequence));
        }
        Uninterruptibles.awaitUninterruptibly((CountDownLatch)this.shutdownLatch);
    }

    public void assemble() {
        this.assemble(this.subrootType, this.source, this.sourceProperty, this.subrootChildKeyPairs, this.level);
    }

    /*
     * WARNING - void declaration
     */
    private void assemble(PlasmaType targetType, PlasmaDataObject source, PlasmaProperty sourceProperty, List<PropertyPair> childKeyPairs, int level) {
        Set props = this.collector.getProperties((Type)targetType, level);
        if (props == null) {
            props = DefaultAssembler.EMPTY_PROPERTY_SET;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(String.valueOf(String.valueOf(level)) + ":assemble: " + source.getType().getName() + "." + sourceProperty.getName() + "->" + targetType.getName() + ": " + props));
        }
        List result = this.getPredicateResult(targetType, sourceProperty, props, childKeyPairs);
        if (log.isDebugEnabled()) {
            log.debug((Object)(String.valueOf(String.valueOf(level)) + ":results: " + result.size()));
        }
        Map resultMap = this.sharedAssembler.collectResults(targetType, source, sourceProperty, result);
        for (PlasmaDataObject target : resultMap.keySet()) {
            void var15_16;
            void var15_21;
            Object trav;
            List row = (List)resultMap.get(target);
            ArrayList<Object> traversals = new ArrayList<Object>();
            for (PropertyPair pair : row) {
                if (pair.getProp().isMany() || pair.getProp().getType().isDataType() || !pair.isQueryProperty()) continue;
                List list = this.getNextKeyPairs(target, pair, level);
                if (log.isDebugEnabled()) {
                    log.debug((Object)(String.valueOf(String.valueOf(level)) + ":traverse: (" + pair.getProp().isMany() + ") " + pair.getProp().toString() + ":" + String.valueOf(pair.getValue())));
                }
                trav = new Traversal((PlasmaType)pair.getProp().getType(), target, pair.getProp(), list, level + 1);
                traversals.add(trav);
            }
            for (Property p : props) {
                PlasmaProperty plasmaProperty = (PlasmaProperty)p;
                if (!plasmaProperty.isMany() || plasmaProperty.getType().isDataType()) continue;
                List childKeyProps = this.getChildKeyProps(target, targetType, plasmaProperty);
                if (log.isDebugEnabled()) {
                    log.debug((Object)(String.valueOf(String.valueOf(level)) + ":traverse: (" + plasmaProperty.isMany() + ") " + plasmaProperty.toString() + " - " + childKeyProps.toArray().toString()));
                }
                Traversal trav2 = new Traversal((PlasmaType)plasmaProperty.getType(), target, plasmaProperty, childKeyProps, level + 1);
                traversals.add(trav2);
            }
            this.sharedAssembler.logPoolStatistics();
            int available = 0;
            if (level <= this.sharedAssembler.getConfig().getMaxThreadDepth() && (available = this.sharedAssembler.numThreadsAvailable()) > traversals.size()) {
                available = traversals.size();
            }
            ArrayList<ParallelSubgraphTask> concurrentTasks = null;
            boolean bl = false;
            while (var15_21 < available) {
                if (concurrentTasks == null) {
                    concurrentTasks = new ArrayList<ParallelSubgraphTask>();
                }
                trav = (Traversal)traversals.get((int)var15_21);
                ParallelSubgraphTask task = new ParallelSubgraphTask(trav.getSubrootType(), trav.getSource(), this.collector, this.getStatementFactory(), this.getStatementExecutor(), trav.getSourceProperty(), trav.getChildKeyPairs(), trav.getLevel(), (int)var15_21, this.sharedAssembler);
                concurrentTasks.add(task);
                ++var15_21;
            }
            if (concurrentTasks != null) {
                for (SubgraphTask subgraphTask : concurrentTasks) {
                    subgraphTask.start();
                }
                for (SubgraphTask subgraphTask : concurrentTasks) {
                    subgraphTask.join();
                }
            }
            int n = available;
            while (var15_16 < traversals.size()) {
                trav = (Traversal)traversals.get((int)var15_16);
                this.assemble(trav.getSubrootType(), trav.getSource(), trav.getSourceProperty(), trav.getChildKeyPairs(), trav.getLevel());
                ++var15_16;
            }
        }
    }
}

