/*
 * Decompiled with CFR 0.152.
 */
package org.cloudgraph.rdb.filter;

import commonj.sdo.Property;
import commonj.sdo.Type;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudgraph.rdb.filter.RDBFilterAssembler;
import org.cloudgraph.rdb.service.RDBDataConverter;
import org.cloudgraph.store.lang.FilterAssembler;
import org.cloudgraph.store.lang.GraphFilterException;
import org.cloudgraph.store.lang.StatementFactory;
import org.cloudgraph.store.lang.StatementUtil;
import org.cloudgraph.store.service.AliasMap;
import org.plasma.config.DataAccessProviderName;
import org.plasma.config.PlasmaConfig;
import org.plasma.config.RDBMSVendorName;
import org.plasma.query.model.Where;
import org.plasma.sdo.DataFlavor;
import org.plasma.sdo.PlasmaProperty;
import org.plasma.sdo.PlasmaType;
import org.plasma.sdo.access.provider.common.PropertyPair;
import org.plasma.sdo.profile.ConcurrencyType;
import org.plasma.sdo.profile.ConcurrentDataFlavor;
import org.plasma.sdo.profile.KeyType;

public class RDBStatementFactory
implements StatementFactory {
    private static Log log = LogFactory.getFactory().getInstance(RDBStatementFactory.class);
    protected RDBDataConverter converter = RDBDataConverter.INSTANCE;
    private StatementUtil statementUtil = new StatementUtil();

    public StringBuilder createSelectConcurrent(PlasmaType type, List<PropertyPair> keyValues, int waitSeconds, List<Object> params) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ");
        ArrayList<Object> props = new ArrayList<Object>();
        for (PropertyPair pair : keyValues) {
            props.add(pair.getProp());
        }
        Property lockingUserProperty = type.findProperty(ConcurrencyType.pessimistic, ConcurrentDataFlavor.user);
        if (lockingUserProperty != null) {
            props.add(lockingUserProperty);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("could not find locking user property for type, " + type.getURI() + "#" + type.getName()));
        }
        Property lockingTimestampProperty = type.findProperty(ConcurrencyType.pessimistic, ConcurrentDataFlavor.time);
        if (lockingTimestampProperty != null) {
            props.add(lockingTimestampProperty);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("could not find locking timestamp property for type, " + type.getURI() + "#" + type.getName()));
        }
        Property concurrencyUserProperty = type.findProperty(ConcurrencyType.optimistic, ConcurrentDataFlavor.user);
        if (concurrencyUserProperty != null) {
            props.add(concurrencyUserProperty);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("could not find optimistic concurrency (username) property for type, " + type.getURI() + "#" + type.getName()));
        }
        Property concurrencyTimestampProperty = type.findProperty(ConcurrencyType.optimistic, ConcurrentDataFlavor.time);
        if (concurrencyTimestampProperty != null) {
            props.add(concurrencyTimestampProperty);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("could not find optimistic concurrency timestamp property for type, " + type.getURI() + "#" + type.getName()));
        }
        int i = 0;
        for (Property property : props) {
            PlasmaProperty prop = (PlasmaProperty)property;
            if (prop.isMany() && !prop.getType().isDataType()) continue;
            if (i > 0) {
                sql.append(", ");
            }
            sql.append("t0.");
            sql.append(prop.getPhysicalName());
            ++i;
        }
        sql.append(" FROM ");
        sql.append(this.statementUtil.getQualifiedPhysicalName(type));
        sql.append(" t0 ");
        sql.append(" WHERE ");
        try {
            for (int k = 0; k < keyValues.size(); ++k) {
                if (k > 0) {
                    sql.append(" AND ");
                }
                PropertyPair propertyPair = keyValues.get(k);
                sql.append("t0.");
                sql.append(propertyPair.getProp().getPhysicalName());
                sql.append(" = ");
                this.appendValue(propertyPair, true, sql);
            }
        }
        catch (SQLException e) {
            throw new GraphFilterException((Throwable)e);
        }
        RDBMSVendorName vendor = PlasmaConfig.getInstance().getRDBMSProviderVendor(DataAccessProviderName.JDBC);
        switch (vendor) {
            case ORACLE: {
                sql.append(" FOR UPDATE WAIT ");
                sql.append(String.valueOf(waitSeconds));
                break;
            }
            case MYSQL: {
                sql.append(" FOR UPDATE");
                break;
            }
            default: {
                sql.append(" FOR UPDATE WAIT");
                sql.append(String.valueOf(waitSeconds));
            }
        }
        return sql;
    }

    public StringBuilder createSelect(PlasmaType type, Set<Property> props, List<PropertyPair> keyValues, List<Object> params) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ");
        int count = 0;
        List pkProps = type.findProperties(KeyType.primary);
        for (Property pkProp : pkProps) {
            if (props.contains(pkProp)) continue;
            if (count > 0) {
                sql.append(", ");
            }
            sql.append("t0.");
            sql.append(((PlasmaProperty)pkProp).getPhysicalName());
            ++count;
        }
        for (Property p : props) {
            PlasmaProperty prop = (PlasmaProperty)p;
            if (prop.isMany() && !prop.getType().isDataType()) continue;
            if (count > 0) {
                sql.append(", ");
            }
            sql.append("t0.");
            sql.append(prop.getPhysicalName());
            ++count;
        }
        sql.append(" FROM ");
        sql.append(this.statementUtil.getQualifiedPhysicalName(type));
        sql.append(" t0 ");
        sql.append(" WHERE ");
        try {
            for (count = 0; count < keyValues.size(); ++count) {
                if (count > 0) {
                    sql.append(" AND ");
                }
                PropertyPair propValue = keyValues.get(count);
                sql.append("t0.");
                sql.append(propValue.getProp().getPhysicalName());
                sql.append(" = ?");
                params.add(this.getParamValue(propValue));
            }
        }
        catch (SQLException e) {
            throw new GraphFilterException((Throwable)e);
        }
        return sql;
    }

    public StringBuilder createSelect(PlasmaType type, Set<Property> props, List<PropertyPair> keyValues, FilterAssembler filterAssembler, List<Object> params) {
        PropertyPair propValue;
        StringBuilder sql = new StringBuilder();
        AliasMap aliasMap = ((RDBFilterAssembler)filterAssembler).getAliasMap();
        sql.append("SELECT ");
        int count = 0;
        List pkProps = type.findProperties(KeyType.primary);
        for (Property pkProp : pkProps) {
            if (props.contains(pkProp)) continue;
            if (count > 0) {
                sql.append(", ");
            }
            sql.append("t0.");
            sql.append(((PlasmaProperty)pkProp).getPhysicalName());
            ++count;
        }
        for (Property p : props) {
            PlasmaProperty prop = (PlasmaProperty)p;
            if (prop.isMany() && !prop.getType().isDataType()) continue;
            if (count > 0) {
                sql.append(", ");
            }
            sql.append("t0.");
            sql.append(prop.getPhysicalName());
            ++count;
        }
        sql.append(" FROM ");
        Iterator it = aliasMap.getTypes();
        count = 0;
        while (it.hasNext()) {
            Object[] aliasType = (Object[])it.next();
            String alias = aliasMap.getAlias((PlasmaType)aliasType);
            if (count > 0) {
                sql.append(", ");
            }
            sql.append(this.statementUtil.getQualifiedPhysicalName((PlasmaType)aliasType));
            sql.append(" ");
            sql.append(alias);
            ++count;
        }
        sql.append(" ");
        sql.append(filterAssembler.getFilter());
        for (Object filterParam : filterAssembler.getParams()) {
            params.add(filterParam);
        }
        try {
            for (count = 0; count < keyValues.size(); ++count) {
                sql.append(" AND ");
                propValue = keyValues.get(count);
                sql.append("t0.");
                sql.append(propValue.getProp().getPhysicalName());
                sql.append(" = ?");
                params.add(this.getParamValue(propValue));
            }
        }
        catch (SQLException e) {
            throw new GraphFilterException((Throwable)e);
        }
        sql.append(" ORDER BY ");
        for (count = 0; count < keyValues.size(); ++count) {
            if (count > 0) {
                sql.append(", ");
            }
            propValue = keyValues.get(count);
            sql.append("t0.");
            sql.append(propValue.getProp().getPhysicalName());
        }
        return sql;
    }

    public StringBuilder createInsert(PlasmaType type, Map<String, PropertyPair> values) {
        PlasmaProperty prop;
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT INTO ");
        sql.append(this.statementUtil.getQualifiedPhysicalName(type));
        sql.append("(");
        int i = 0;
        for (PropertyPair pair : values.values()) {
            prop = pair.getProp();
            if (prop.isMany() && !prop.getType().isDataType()) continue;
            if (i > 0) {
                sql.append(", ");
            }
            sql.append(pair.getProp().getPhysicalName());
            pair.setColumn(i + 1);
            ++i;
        }
        sql.append(") VALUES (");
        i = 0;
        for (PropertyPair pair : values.values()) {
            prop = pair.getProp();
            if (prop.isMany() && !prop.getType().isDataType()) continue;
            if (i > 0) {
                sql.append(", ");
            }
            sql.append("?");
            ++i;
        }
        sql.append(")");
        return sql;
    }

    public StringBuilder createUpdate(PlasmaType type, Map<String, PropertyPair> values) {
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE ");
        sql.append(this.statementUtil.getQualifiedPhysicalName(type));
        sql.append(" t0 SET ");
        int col = 0;
        for (PropertyPair pair : values.values()) {
            PlasmaProperty prop = pair.getProp();
            if (prop.isMany() && !prop.getType().isDataType() || prop.isKey(KeyType.primary) && pair.getOldValue() == null) continue;
            if (col > 0) {
                sql.append(", ");
            }
            sql.append("t0.");
            sql.append(prop.getPhysicalName());
            sql.append(" = ?");
            pair.setColumn(col + 1);
            ++col;
        }
        int key = 0;
        sql.append(" WHERE ");
        for (PropertyPair pair : values.values()) {
            PlasmaProperty prop = pair.getProp();
            if (prop.isMany() && !prop.getType().isDataType() || !prop.isKey(KeyType.primary)) continue;
            if (key > 0) {
                sql.append(" AND ");
            }
            sql.append("t0.");
            sql.append(pair.getProp().getPhysicalName());
            sql.append(" = ?");
            if (pair.getOldValue() == null) {
                pair.setColumn(col + 1);
            } else {
                pair.setOldValueColumn(col + 1);
            }
            ++col;
            ++key;
        }
        return sql;
    }

    public StringBuilder createDelete(PlasmaType type, Map<String, PropertyPair> values) {
        StringBuilder sql = new StringBuilder();
        sql.append("DELETE FROM ");
        sql.append(this.statementUtil.getQualifiedPhysicalName(type));
        sql.append(" WHERE ");
        int i = 0;
        for (PropertyPair pair : values.values()) {
            PlasmaProperty prop = pair.getProp();
            if (prop.isMany() && !prop.getType().isDataType() || !prop.isKey(KeyType.primary)) continue;
            if (i > 0) {
                sql.append(" AND ");
            }
            sql.append(pair.getProp().getPhysicalName());
            sql.append(" = ? ");
            pair.setColumn(i + 1);
            ++i;
        }
        return sql;
    }

    public PlasmaProperty getOppositePriKeyProperty(Property targetProperty) {
        return this.statementUtil.getOppositePriKeyProperty(targetProperty);
    }

    public boolean hasUpdatableProperties(Map<String, PropertyPair> values) {
        return this.statementUtil.hasUpdatableProperties(values);
    }

    public FilterAssembler createFilterAssembler(Where where, Type targetType) {
        AliasMap aliasMap = new AliasMap((PlasmaType)targetType);
        return new RDBFilterAssembler(where, targetType, aliasMap);
    }

    private Object getParamValue(PropertyPair pair) throws SQLException {
        PlasmaProperty valueProp = pair.getProp();
        if (pair.getValueProp() != null) {
            valueProp = pair.getValueProp();
        }
        Object jdbcValue = RDBDataConverter.INSTANCE.toJDBCDataValue(valueProp, pair.getValue());
        DataFlavor dataFlavor = RDBDataConverter.INSTANCE.toJDBCDataFlavor(valueProp);
        switch (dataFlavor) {
            case string: 
            case temporal: 
            case other: {
                break;
            }
        }
        return jdbcValue;
    }

    private void appendValue(PropertyPair pair, boolean useOldValue, StringBuilder sql) throws SQLException {
        PlasmaProperty valueProp = pair.getProp();
        if (pair.getValueProp() != null) {
            valueProp = pair.getValueProp();
        }
        Object jdbcValue = null;
        jdbcValue = !useOldValue || pair.getOldValue() == null ? RDBDataConverter.INSTANCE.toJDBCDataValue(valueProp, pair.getValue()) : RDBDataConverter.INSTANCE.toJDBCDataValue(valueProp, pair.getOldValue());
        DataFlavor dataFlavor = RDBDataConverter.INSTANCE.toJDBCDataFlavor(valueProp);
        switch (dataFlavor) {
            case string: 
            case temporal: 
            case other: {
                sql.append("'");
                sql.append(jdbcValue);
                sql.append("'");
                break;
            }
            default: {
                sql.append(jdbcValue);
            }
        }
    }
}

