/*
 * Decompiled with CFR 0.152.
 */
package org.cloudgraph.rdb.connect;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudgraph.rdb.connect.ConnectionProvider;
import org.plasma.config.DataAccessProviderName;
import org.plasma.config.PlasmaConfig;
import org.plasma.config.Property;
import org.plasma.sdo.access.DataAccessException;

public class ProviderManager {
    private static final Log log = LogFactory.getLog(ProviderManager.class);
    private static ProviderManager instance;
    private ConnectionProvider provider;

    private ProviderManager() {
        Properties props = new Properties();
        for (Property property : PlasmaConfig.getInstance().getDataAccessProvider(DataAccessProviderName.JDBC).getProperties()) {
            props.put(property.getName(), property.getValue());
        }
        String providerName = props.getProperty("org.plasma.sdo.access.provider.jdbc.ConnectionProviderName");
        try {
            this.provider = (ConnectionProvider)Class.forName(providerName).newInstance();
        }
        catch (Exception e2) {
            log.error((Object)("Error when attempting to obtain JDBC Provider: " + providerName), (Throwable)e2);
            throw new DataAccessException((Throwable)e2);
        }
    }

    public static ProviderManager instance() {
        if (instance == null) {
            ProviderManager.initInstance();
        }
        return instance;
    }

    private static synchronized void initInstance() {
        if (instance == null) {
            instance = new ProviderManager();
        }
    }

    protected void finalize() {
        log.debug((Object)("Finalizing " + this.getClass().getName()));
        try {
            super.finalize();
        }
        catch (Throwable ex) {
            log.error((Object)"finalize failed: ", ex);
        }
    }

    public Connection getConnection() throws SQLException {
        return this.provider.getConnection();
    }
}

