/*
 * Decompiled with CFR 0.152.
 */
package org.cloudgraph.rdb.filter;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudgraph.rdb.filter.Functions;
import org.cloudgraph.store.service.AliasMap;
import org.plasma.query.model.OrderBy;
import org.plasma.query.model.Path;
import org.plasma.query.model.PathNode;
import org.plasma.query.model.Property;
import org.plasma.query.model.QueryConstants;
import org.plasma.query.model.SortDirectionValues;
import org.plasma.query.visitor.DefaultQueryVisitor;
import org.plasma.query.visitor.QueryVisitor;
import org.plasma.query.visitor.Traversal;
import org.plasma.sdo.PlasmaProperty;
import org.plasma.sdo.PlasmaType;

public class RDBOrderingAssembler
extends DefaultQueryVisitor
implements QueryConstants {
    private static Log log = LogFactory.getLog(RDBOrderingAssembler.class);
    private PlasmaType contextType;
    private commonj.sdo.Property contextProp;
    private StringBuilder orderingDeclaration = new StringBuilder();
    private AliasMap aliasMap;

    private RDBOrderingAssembler() {
    }

    public RDBOrderingAssembler(OrderBy orderby, PlasmaType contextType, AliasMap aliasMap) {
        this.contextType = contextType;
        this.aliasMap = aliasMap;
        if (orderby.getTextContent() == null) {
            orderby.accept((QueryVisitor)this);
        } else {
            this.orderingDeclaration.append(orderby.getTextContent().getValue());
        }
    }

    public String getOrderingDeclaration() {
        return this.orderingDeclaration.toString();
    }

    public void start(Property property) {
        List functions;
        if (this.orderingDeclaration.length() == 0) {
            this.orderingDeclaration.append("ORDER BY ");
        }
        if (this.orderingDeclaration.length() > "ORDER BY ".length()) {
            this.orderingDeclaration.append(", ");
        }
        PlasmaType targetType = this.contextType;
        if (property.getPath() != null) {
            Path path = property.getPath();
            for (int i = 0; i < path.getPathNodes().size(); ++i) {
                PlasmaProperty prop = (PlasmaProperty)targetType.getProperty(((PathNode)path.getPathNodes().get(i)).getPathElement().getValue());
                targetType = (PlasmaType)prop.getType();
            }
        }
        PlasmaProperty endpoint = (PlasmaProperty)targetType.getProperty(property.getName());
        this.contextProp = endpoint;
        String targetAlias = this.aliasMap.getAlias(targetType);
        if (targetAlias == null) {
            targetAlias = this.aliasMap.addAlias(targetType);
        }
        if ((functions = property.getFunctions()) == null || functions.size() == 0) {
            this.orderingDeclaration.append(targetAlias + "." + endpoint.getPhysicalName());
        } else {
            this.orderingDeclaration.append(Functions.wrap(endpoint, functions, targetAlias));
        }
        if (property.getDirection() == null || property.getDirection().ordinal() == SortDirectionValues.ASC.ordinal()) {
            this.orderingDeclaration.append(" ASC");
        } else {
            this.orderingDeclaration.append(" DESC");
        }
        this.getContext().setTraversal(Traversal.ABORT);
    }
}

