/*
 * Decompiled with CFR 0.152.
 */
package org.cloudgraph.rdb.service;

import commonj.sdo.DataGraph;
import commonj.sdo.Type;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudgraph.rdb.connect.ProviderManager;
import org.cloudgraph.rdb.service.GraphDispatcher;
import org.cloudgraph.rdb.service.GraphQuery;
import org.plasma.common.bind.BindingValidationEventHandler;
import org.plasma.common.bind.DefaultValidationEventHandler;
import org.plasma.config.DataAccessProviderName;
import org.plasma.config.PlasmaConfig;
import org.plasma.config.RDBMSVendorName;
import org.plasma.query.bind.PlasmaQueryDataBinding;
import org.plasma.query.model.From;
import org.plasma.query.model.Query;
import org.plasma.query.model.QueryValidator;
import org.plasma.sdo.PlasmaDataGraph;
import org.plasma.sdo.access.DataAccessException;
import org.plasma.sdo.access.PlasmaDataAccessService;
import org.plasma.sdo.core.SnapshotMap;
import org.plasma.sdo.helper.PlasmaTypeHelper;
import org.xml.sax.SAXException;

public class RDBGraphService
implements PlasmaDataAccessService {
    private static Log log = LogFactory.getLog(RDBGraphService.class);

    public void initialize() {
    }

    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int count(Query query) {
        if (query == null) {
            throw new IllegalArgumentException("expected non-null 'query' argument");
        }
        this.validate(query);
        if (log.isDebugEnabled()) {
            this.log(query);
        }
        Connection con = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"getting connection");
            }
            if ((con = ProviderManager.instance().getConnection()).getAutoCommit()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"turning off connection autocommit for count query");
                }
                con.setAutoCommit(false);
            }
            RDBMSVendorName vendor = PlasmaConfig.getInstance().getRDBMSProviderVendor(DataAccessProviderName.JDBC);
            switch (vendor) {
                case ORACLE: {
                    con.setTransactionIsolation(2);
                    break;
                }
                case MYSQL: {
                    con.setTransactionIsolation(0);
                    break;
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("using transaction isolation level " + con.getTransactionIsolation() + " for count query"));
            }
        }
        catch (SQLException e2) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"closing connection");
                }
                con.close();
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            throw new DataAccessException((Throwable)e2);
        }
        GraphQuery dispatcher = new GraphQuery(con);
        try {
            int n = dispatcher.count(query);
            return n;
        }
        finally {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"closing connection");
                }
                con.close();
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] count(Query[] queries) {
        if (queries == null) {
            throw new IllegalArgumentException("expected non-null 'queries' argument");
        }
        Connection con = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"getting connection");
            }
            if ((con = ProviderManager.instance().getConnection()).getAutoCommit()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"turning off connection autocommit for multi count query");
                }
                con.setAutoCommit(false);
            }
            RDBMSVendorName vendor = PlasmaConfig.getInstance().getRDBMSProviderVendor(DataAccessProviderName.JDBC);
            switch (vendor) {
                case ORACLE: {
                    con.setTransactionIsolation(2);
                    break;
                }
                case MYSQL: {
                    con.setTransactionIsolation(0);
                    break;
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("using transaction isolation level " + con.getTransactionIsolation() + " for multi count query"));
            }
        }
        catch (SQLException e2) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"closing connection");
                }
                con.close();
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            throw new DataAccessException((Throwable)e2);
        }
        GraphQuery dispatcher = new GraphQuery(con);
        int[] counts = new int[queries.length];
        try {
            for (int i = 0; i < queries.length; ++i) {
                counts[i] = dispatcher.count(queries[i]);
            }
            int[] nArray = counts;
            return nArray;
        }
        finally {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"closing connection");
                }
                con.close();
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public DataGraph[] find(Query query) {
        return this.find(query, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataGraph[] find(Query query, int maxResults) {
        if (query == null) {
            throw new IllegalArgumentException("expected non-null 'query' argument");
        }
        this.validate(query);
        if (log.isDebugEnabled()) {
            this.log(query);
        }
        Connection con = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"getting connection");
            }
            if ((con = ProviderManager.instance().getConnection()).getAutoCommit()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"turning off connection autocommit for graph query");
                }
                con.setAutoCommit(false);
            }
            RDBMSVendorName vendor = PlasmaConfig.getInstance().getRDBMSProviderVendor(DataAccessProviderName.JDBC);
            switch (vendor) {
                case ORACLE: {
                    con.setTransactionIsolation(2);
                    break;
                }
                case MYSQL: {
                    con.setTransactionIsolation(0);
                    break;
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("using transaction isolation level " + con.getTransactionIsolation() + " for graph query"));
            }
        }
        catch (SQLException e2) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"closing connection");
                }
                con.close();
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            throw new DataAccessException((Throwable)e2);
        }
        GraphQuery dispatcher = new GraphQuery(con);
        try {
            PlasmaDataGraph[] results = null;
            results = maxResults > 0 ? dispatcher.find(query, maxResults, new Timestamp(new Date().getTime())) : dispatcher.find(query, new Timestamp(new Date().getTime()));
            PlasmaDataGraph[] plasmaDataGraphArray = results;
            return plasmaDataGraphArray;
        }
        finally {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"closing connection");
                }
                con.close();
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DataGraph[]> find(Query[] queries) {
        if (queries == null) {
            throw new IllegalArgumentException("expected non-null 'queries' argument");
        }
        Connection con = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"getting connection");
            }
            if ((con = ProviderManager.instance().getConnection()).getAutoCommit()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"turning off connection autocommit for multi graph query");
                }
                con.setAutoCommit(false);
            }
            RDBMSVendorName vendor = PlasmaConfig.getInstance().getRDBMSProviderVendor(DataAccessProviderName.JDBC);
            switch (vendor) {
                case ORACLE: {
                    con.setTransactionIsolation(2);
                    break;
                }
                case MYSQL: {
                    con.setTransactionIsolation(0);
                    break;
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("using transaction isolation level " + con.getTransactionIsolation() + " for multi graph query"));
            }
        }
        catch (SQLException e2) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"closing connection");
                }
                con.close();
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            throw new DataAccessException((Throwable)e2);
        }
        GraphQuery dispatcher = new GraphQuery(con);
        ArrayList<DataGraph[]> list = new ArrayList<DataGraph[]>();
        Timestamp snapshotDate = new Timestamp(new Date().getTime());
        try {
            for (int i = 0; i < queries.length; ++i) {
                this.validate(queries[i]);
                if (log.isDebugEnabled()) {
                    this.log(queries[i]);
                }
                PlasmaDataGraph[] results = dispatcher.find(queries[i], snapshotDate);
                list.add((DataGraph[])results);
            }
            ArrayList<DataGraph[]> arrayList = list;
            return arrayList;
        }
        finally {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"closing connection");
                }
                con.close();
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public SnapshotMap commit(DataGraph dataGraph, String username) {
        if (dataGraph == null) {
            throw new IllegalArgumentException("expected non-null 'dataGraph' argument");
        }
        if (username == null) {
            throw new IllegalArgumentException("expected non-null 'username' argument");
        }
        if (username.trim().length() == 0) {
            throw new IllegalArgumentException("unexpected zero length 'username' argument");
        }
        SnapshotMap snapshotMap = new SnapshotMap(new Timestamp(new Date().getTime()));
        if (log.isDebugEnabled()) {
            log.debug((Object)"getting connection");
        }
        Connection con = null;
        try {
            con = ProviderManager.instance().getConnection();
            if (con.getAutoCommit()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"turning off connection autocommit for graph commit");
                }
                con.setAutoCommit(false);
            }
            con.setTransactionIsolation(2);
            if (log.isDebugEnabled()) {
                log.debug((Object)("using transaction isolation level " + con.getTransactionIsolation() + " forgraph commit"));
            }
        }
        catch (SQLException e2) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"closing connection");
                }
                con.close();
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            throw new DataAccessException((Throwable)e2);
        }
        GraphDispatcher dispatcher = new GraphDispatcher(snapshotMap, username, con);
        try {
            dispatcher.commit(dataGraph);
            con.commit();
            SnapshotMap e = snapshotMap;
            return e;
        }
        catch (DataAccessException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)e.getMessage(), (Throwable)e);
            }
            try {
                con.rollback();
            }
            catch (SQLException e1) {
                log.error((Object)e.getMessage(), (Throwable)e1);
            }
            throw e;
        }
        catch (Throwable t) {
            if (log.isDebugEnabled()) {
                log.debug((Object)t.getMessage(), t);
            }
            try {
                con.rollback();
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            throw new DataAccessException(t);
        }
        finally {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"closing connection");
                }
                con.close();
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage());
            }
            dispatcher.close();
        }
    }

    public SnapshotMap commit(DataGraph[] dataGraphs, String username) {
        if (dataGraphs == null) {
            throw new IllegalArgumentException("expected non-null 'dataGraphs' argument");
        }
        if (username == null) {
            throw new IllegalArgumentException("expected non-null 'username' argument");
        }
        if (username.trim().length() == 0) {
            throw new IllegalArgumentException("unexpected zero length 'username' argument");
        }
        SnapshotMap snapshotMap = new SnapshotMap(new Timestamp(new Date().getTime()));
        Connection con = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"getting connection");
            }
            if ((con = ProviderManager.instance().getConnection()).getAutoCommit()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"turning off connection autocommit for multi graph commit");
                }
                con.setAutoCommit(false);
            }
            con.setTransactionIsolation(2);
            if (log.isDebugEnabled()) {
                log.debug((Object)("using transaction isolation level " + con.getTransactionIsolation() + " for multi graph commit"));
            }
        }
        catch (SQLException e2) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"closing connection");
                }
                con.close();
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            throw new DataAccessException((Throwable)e2);
        }
        GraphDispatcher dispatcher = new GraphDispatcher(snapshotMap, username, con);
        try {
            dispatcher.commit(dataGraphs);
            con.commit();
            SnapshotMap e = snapshotMap;
            return e;
        }
        catch (DataAccessException e) {
            try {
                con.rollback();
            }
            catch (SQLException e1) {
                log.error((Object)e1.getMessage(), (Throwable)e1);
            }
            throw e;
        }
        catch (Throwable t) {
            try {
                con.rollback();
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            throw new DataAccessException(t);
        }
        finally {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"closing connection");
                }
                con.close();
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage());
            }
            dispatcher.close();
        }
    }

    private void validate(Query query) {
        From from = query.getFromClause();
        Type type = PlasmaTypeHelper.INSTANCE.getType(from.getEntity().getNamespaceURI(), from.getEntity().getName());
        log.debug((Object)"validating query");
        new QueryValidator(query, type);
    }

    private void log(Query query) {
        String xml = "";
        try {
            PlasmaQueryDataBinding binding = new PlasmaQueryDataBinding((BindingValidationEventHandler)new DefaultValidationEventHandler());
            xml = binding.marshal((Object)query);
        }
        catch (JAXBException e) {
        }
        catch (SAXException e) {
            // empty catch block
        }
    }
}

