/*
 * Decompiled with CFR 0.152.
 */
package org.cloudgraph.rdb.service;

import commonj.sdo.Property;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudgraph.rdb.filter.FilterAssembler;
import org.cloudgraph.rdb.service.AliasMap;
import org.cloudgraph.rdb.service.RDBDataConverter;
import org.plasma.config.DataAccessProviderName;
import org.plasma.config.PlasmaConfig;
import org.plasma.config.RDBMSVendorName;
import org.plasma.sdo.DataFlavor;
import org.plasma.sdo.PlasmaProperty;
import org.plasma.sdo.PlasmaType;
import org.plasma.sdo.access.DataAccessException;
import org.plasma.sdo.access.provider.common.PropertyPair;
import org.plasma.sdo.profile.ConcurrencyType;
import org.plasma.sdo.profile.ConcurrentDataFlavor;
import org.plasma.sdo.profile.KeyType;

public abstract class JDBCSupport {
    private static Log log = LogFactory.getFactory().getInstance(JDBCSupport.class);
    protected RDBDataConverter converter = RDBDataConverter.INSTANCE;

    protected JDBCSupport() {
    }

    protected StringBuilder createSelectForUpdate(PlasmaType type, List<PropertyPair> keyValues, int waitSeconds) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ");
        ArrayList<Object> props = new ArrayList<Object>();
        for (PropertyPair pair : keyValues) {
            props.add(pair.getProp());
        }
        Property lockingUserProperty = type.findProperty(ConcurrencyType.pessimistic, ConcurrentDataFlavor.user);
        if (lockingUserProperty != null) {
            props.add(lockingUserProperty);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("could not find locking user property for type, " + type.getURI() + "#" + type.getName()));
        }
        Property lockingTimestampProperty = type.findProperty(ConcurrencyType.pessimistic, ConcurrentDataFlavor.time);
        if (lockingTimestampProperty != null) {
            props.add(lockingTimestampProperty);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("could not find locking timestamp property for type, " + type.getURI() + "#" + type.getName()));
        }
        Property concurrencyUserProperty = type.findProperty(ConcurrencyType.optimistic, ConcurrentDataFlavor.user);
        if (concurrencyUserProperty != null) {
            props.add(concurrencyUserProperty);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("could not find optimistic concurrency (username) property for type, " + type.getURI() + "#" + type.getName()));
        }
        Property concurrencyTimestampProperty = type.findProperty(ConcurrencyType.optimistic, ConcurrentDataFlavor.time);
        if (concurrencyTimestampProperty != null) {
            props.add(concurrencyTimestampProperty);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("could not find optimistic concurrency timestamp property for type, " + type.getURI() + "#" + type.getName()));
        }
        int i = 0;
        for (Property property : props) {
            PlasmaProperty prop = (PlasmaProperty)property;
            if (prop.isMany() && !prop.getType().isDataType()) continue;
            if (i > 0) {
                sql.append(", ");
            }
            sql.append("t0.");
            sql.append(prop.getPhysicalName());
            ++i;
        }
        sql.append(" FROM ");
        sql.append(this.getQualifiedPhysicalName(type));
        sql.append(" t0 ");
        sql.append(" WHERE ");
        for (int k = 0; k < keyValues.size(); ++k) {
            if (k > 0) {
                sql.append(" AND ");
            }
            PropertyPair propertyPair = keyValues.get(k);
            sql.append("t0.");
            sql.append(propertyPair.getProp().getPhysicalName());
            sql.append(" = ");
            this.appendValue(propertyPair, true, sql);
        }
        RDBMSVendorName vendor = PlasmaConfig.getInstance().getRDBMSProviderVendor(DataAccessProviderName.JDBC);
        switch (vendor) {
            case ORACLE: {
                sql.append(" FOR UPDATE WAIT ");
                sql.append(String.valueOf(waitSeconds));
                break;
            }
            case MYSQL: {
                sql.append(" FOR UPDATE");
                break;
            }
            default: {
                sql.append(" FOR UPDATE WAIT");
                sql.append(String.valueOf(waitSeconds));
            }
        }
        return sql;
    }

    protected String getQualifiedPhysicalName(PlasmaType type) {
        String packageName = type.getPackagePhysicalName();
        if (packageName != null) {
            return packageName + "." + type.getPhysicalName();
        }
        return type.getPhysicalName();
    }

    protected StringBuilder createSelect(PlasmaType type, Set<Property> props, List<PropertyPair> keyValues, List<Object> params) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ");
        int count = 0;
        List pkProps = type.findProperties(KeyType.primary);
        for (Property pkProp : pkProps) {
            if (props.contains(pkProp)) continue;
            if (count > 0) {
                sql.append(", ");
            }
            sql.append("t0.");
            sql.append(((PlasmaProperty)pkProp).getPhysicalName());
            ++count;
        }
        for (Property p : props) {
            PlasmaProperty prop = (PlasmaProperty)p;
            if (prop.isMany() && !prop.getType().isDataType()) continue;
            if (count > 0) {
                sql.append(", ");
            }
            sql.append("t0.");
            sql.append(prop.getPhysicalName());
            ++count;
        }
        sql.append(" FROM ");
        sql.append(this.getQualifiedPhysicalName(type));
        sql.append(" t0 ");
        sql.append(" WHERE ");
        for (count = 0; count < keyValues.size(); ++count) {
            if (count > 0) {
                sql.append(" AND ");
            }
            PropertyPair propValue = keyValues.get(count);
            sql.append("t0.");
            sql.append(propValue.getProp().getPhysicalName());
            sql.append(" = ?");
            params.add(this.getParamValue(propValue));
        }
        return sql;
    }

    protected StringBuilder createSelect(PlasmaType type, Set<Property> props, List<PropertyPair> keyValues, FilterAssembler filterAssembler, List<Object> params, AliasMap aliasMap) throws SQLException {
        PropertyPair propValue;
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ");
        int count = 0;
        List pkProps = type.findProperties(KeyType.primary);
        for (Property pkProp : pkProps) {
            if (props.contains(pkProp)) continue;
            if (count > 0) {
                sql.append(", ");
            }
            sql.append("t0.");
            sql.append(((PlasmaProperty)pkProp).getPhysicalName());
            ++count;
        }
        for (Property p : props) {
            PlasmaProperty prop = (PlasmaProperty)p;
            if (prop.isMany() && !prop.getType().isDataType()) continue;
            if (count > 0) {
                sql.append(", ");
            }
            sql.append("t0.");
            sql.append(prop.getPhysicalName());
            ++count;
        }
        sql.append(" FROM ");
        Iterator<PlasmaType> it = aliasMap.getTypes();
        count = 0;
        while (it.hasNext()) {
            PlasmaType aliasType = it.next();
            String alias = aliasMap.getAlias(aliasType);
            if (count > 0) {
                sql.append(", ");
            }
            sql.append(this.getQualifiedPhysicalName(aliasType));
            sql.append(" ");
            sql.append(alias);
            ++count;
        }
        sql.append(" ");
        sql.append(filterAssembler.getFilter());
        for (count = 0; count < keyValues.size(); ++count) {
            sql.append(" AND ");
            propValue = keyValues.get(count);
            sql.append("t0.");
            sql.append(propValue.getProp().getPhysicalName());
            sql.append(" = ?");
            params.add(this.getParamValue(propValue));
        }
        sql.append(" ORDER BY ");
        for (count = 0; count < keyValues.size(); ++count) {
            if (count > 0) {
                sql.append(", ");
            }
            propValue = keyValues.get(count);
            sql.append("t0.");
            sql.append(propValue.getProp().getPhysicalName());
        }
        return sql;
    }

    private void appendValue(PropertyPair pair, StringBuilder sql) throws SQLException {
        this.appendValue(pair, false, sql);
    }

    private void appendValue(PropertyPair pair, boolean useOldValue, StringBuilder sql) throws SQLException {
        PlasmaProperty valueProp = pair.getProp();
        if (pair.getValueProp() != null) {
            valueProp = pair.getValueProp();
        }
        Object jdbcValue = null;
        jdbcValue = !useOldValue || pair.getOldValue() == null ? RDBDataConverter.INSTANCE.toJDBCDataValue(valueProp, pair.getValue()) : RDBDataConverter.INSTANCE.toJDBCDataValue(valueProp, pair.getOldValue());
        DataFlavor dataFlavor = RDBDataConverter.INSTANCE.toJDBCDataFlavor(valueProp);
        switch (dataFlavor) {
            case string: 
            case temporal: 
            case other: {
                sql.append("'");
                sql.append(jdbcValue);
                sql.append("'");
                break;
            }
            default: {
                sql.append(jdbcValue);
            }
        }
    }

    private Object getParamValue(PropertyPair pair) throws SQLException {
        PlasmaProperty valueProp = pair.getProp();
        if (pair.getValueProp() != null) {
            valueProp = pair.getValueProp();
        }
        Object jdbcValue = RDBDataConverter.INSTANCE.toJDBCDataValue(valueProp, pair.getValue());
        DataFlavor dataFlavor = RDBDataConverter.INSTANCE.toJDBCDataFlavor(valueProp);
        switch (dataFlavor) {
            case string: 
            case temporal: 
            case other: {
                break;
            }
        }
        return jdbcValue;
    }

    protected StringBuilder createInsert(PlasmaType type, Map<String, PropertyPair> values) {
        PlasmaProperty prop;
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT INTO ");
        sql.append(this.getQualifiedPhysicalName(type));
        sql.append("(");
        int i = 0;
        for (PropertyPair pair : values.values()) {
            prop = pair.getProp();
            if (prop.isMany() && !prop.getType().isDataType()) continue;
            if (i > 0) {
                sql.append(", ");
            }
            sql.append(pair.getProp().getPhysicalName());
            pair.setColumn(i + 1);
            ++i;
        }
        sql.append(") VALUES (");
        i = 0;
        for (PropertyPair pair : values.values()) {
            prop = pair.getProp();
            if (prop.isMany() && !prop.getType().isDataType()) continue;
            if (i > 0) {
                sql.append(", ");
            }
            sql.append("?");
            ++i;
        }
        sql.append(")");
        return sql;
    }

    protected boolean hasUpdatableProperties(Map<String, PropertyPair> values) {
        for (PropertyPair pair : values.values()) {
            PlasmaProperty prop = pair.getProp();
            if (prop.isMany() && !prop.getType().isDataType() || prop.isKey(KeyType.primary) && pair.getOldValue() == null) continue;
            return true;
        }
        return false;
    }

    protected StringBuilder createUpdate(PlasmaType type, Map<String, PropertyPair> values) {
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE ");
        sql.append(this.getQualifiedPhysicalName(type));
        sql.append(" t0 SET ");
        int col = 0;
        for (PropertyPair pair : values.values()) {
            PlasmaProperty prop = pair.getProp();
            if (prop.isMany() && !prop.getType().isDataType() || prop.isKey(KeyType.primary) && pair.getOldValue() == null) continue;
            if (col > 0) {
                sql.append(", ");
            }
            sql.append("t0.");
            sql.append(prop.getPhysicalName());
            sql.append(" = ?");
            pair.setColumn(col + 1);
            ++col;
        }
        int key = 0;
        sql.append(" WHERE ");
        for (PropertyPair pair : values.values()) {
            PlasmaProperty prop = pair.getProp();
            if (prop.isMany() && !prop.getType().isDataType() || !prop.isKey(KeyType.primary)) continue;
            if (key > 0) {
                sql.append(" AND ");
            }
            sql.append("t0.");
            sql.append(pair.getProp().getPhysicalName());
            sql.append(" = ?");
            if (pair.getOldValue() == null) {
                pair.setColumn(col + 1);
            } else {
                pair.setOldValueColumn(col + 1);
            }
            ++col;
            ++key;
        }
        return sql;
    }

    protected StringBuilder createDelete(PlasmaType type, Map<String, PropertyPair> values) {
        StringBuilder sql = new StringBuilder();
        sql.append("DELETE FROM ");
        sql.append(this.getQualifiedPhysicalName(type));
        sql.append(" WHERE ");
        int i = 0;
        for (PropertyPair pair : values.values()) {
            PlasmaProperty prop = pair.getProp();
            if (prop.isMany() && !prop.getType().isDataType() || !prop.isKey(KeyType.primary)) continue;
            if (i > 0) {
                sql.append(" AND ");
            }
            sql.append(pair.getProp().getPhysicalName());
            sql.append(" = ? ");
            pair.setColumn(i + 1);
            ++i;
        }
        return sql;
    }

    protected List<List<PropertyPair>> fetch(PlasmaType type, StringBuilder sql, Connection con) {
        return this.fetch(type, sql, new HashSet<Property>(), new Object[0], con);
    }

    protected List<List<PropertyPair>> fetch(PlasmaType type, StringBuilder sql, Set<Property> props, Connection con) {
        return this.fetch(type, sql, props, new Object[0], con);
    }

    protected List<List<PropertyPair>> fetch(PlasmaType type, StringBuilder sql, Set<Property> props, Object[] params, Connection con) {
        ArrayList<List<PropertyPair>> result = new ArrayList<List<PropertyPair>>();
        Statement statement = null;
        ResultSet rs = null;
        try {
            if (log.isDebugEnabled()) {
                if (params == null || params.length == 0) {
                    log.debug((Object)("fetch: " + sql.toString()));
                } else {
                    StringBuilder paramBuf = new StringBuilder();
                    paramBuf.append(" [");
                    for (int p = 0; p < params.length; ++p) {
                        if (p > 0) {
                            paramBuf.append(", ");
                        }
                        paramBuf.append(String.valueOf(params[p]));
                    }
                    paramBuf.append("]");
                    log.debug((Object)("fetch: " + sql.toString() + " " + paramBuf.toString()));
                }
            }
            statement = con.prepareStatement(sql.toString(), 1003, 1007);
            for (int i = 0; i < params.length; ++i) {
                statement.setString(i + 1, String.valueOf(params[i]));
            }
            statement.execute();
            rs = statement.getResultSet();
            ResultSetMetaData rsMeta = rs.getMetaData();
            int numcols = rsMeta.getColumnCount();
            int count = 0;
            while (rs.next()) {
                ArrayList<PropertyPair> row = new ArrayList<PropertyPair>(numcols);
                result.add(row);
                for (int i = 1; i <= numcols; ++i) {
                    PlasmaProperty prop;
                    String columnName = rsMeta.getColumnName(i);
                    int columnType = rsMeta.getColumnType(i);
                    PlasmaProperty valueProp = prop = (PlasmaProperty)type.getProperty(columnName);
                    while (!valueProp.getType().isDataType()) {
                        valueProp = this.getOppositePriKeyProperty((Property)valueProp);
                    }
                    Object value = this.converter.fromJDBCDataType(rs, i, columnType, valueProp);
                    if (value == null) continue;
                    PropertyPair pair = new PropertyPair(prop, value);
                    if (!valueProp.equals(prop)) {
                        pair.setValueProp(valueProp);
                    }
                    if (!props.contains(prop)) {
                        pair.setQueryProperty(false);
                    }
                    row.add(pair);
                }
                ++count;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("returned " + count + " results"));
            }
        }
        catch (Throwable t) {
            throw new DataAccessException(t);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }

    protected Map<String, PropertyPair> fetchRowMap(PlasmaType type, StringBuilder sql, Connection con) {
        HashMap<String, PropertyPair> result = new HashMap<String, PropertyPair>();
        Statement statement = null;
        ResultSet rs = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("fetch: " + sql.toString()));
            }
            statement = con.prepareStatement(sql.toString(), 1003, 1007);
            statement.execute();
            rs = statement.getResultSet();
            ResultSetMetaData rsMeta = rs.getMetaData();
            int numcols = rsMeta.getColumnCount();
            int count = 0;
            while (rs.next()) {
                for (int i = 1; i <= numcols; ++i) {
                    PlasmaProperty prop;
                    String columnName = rsMeta.getColumnName(i);
                    int columnType = rsMeta.getColumnType(i);
                    PlasmaProperty valueProp = prop = (PlasmaProperty)type.getProperty(columnName);
                    while (!valueProp.getType().isDataType()) {
                        valueProp = this.getOppositePriKeyProperty((Property)valueProp);
                    }
                    Object value = this.converter.fromJDBCDataType(rs, i, columnType, valueProp);
                    if (value == null) continue;
                    PropertyPair pair = new PropertyPair(prop, value);
                    if (!valueProp.equals(prop)) {
                        pair.setValueProp(valueProp);
                    }
                    result.put(prop.getName(), pair);
                }
                ++count;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("returned " + count + " results"));
            }
        }
        catch (Throwable t) {
            throw new DataAccessException(t);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }

    protected List<PropertyPair> fetchRow(PlasmaType type, StringBuilder sql, Connection con) {
        ArrayList<PropertyPair> result = new ArrayList<PropertyPair>();
        Statement statement = null;
        ResultSet rs = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("fetch: " + sql.toString()));
            }
            statement = con.prepareStatement(sql.toString(), 1003, 1007);
            statement.execute();
            rs = statement.getResultSet();
            ResultSetMetaData rsMeta = rs.getMetaData();
            int numcols = rsMeta.getColumnCount();
            int count = 0;
            while (rs.next()) {
                for (int i = 1; i <= numcols; ++i) {
                    PlasmaProperty prop;
                    String columnName = rsMeta.getColumnName(i);
                    int columnType = rsMeta.getColumnType(i);
                    PlasmaProperty valueProp = prop = (PlasmaProperty)type.getProperty(columnName);
                    while (!valueProp.getType().isDataType()) {
                        valueProp = this.getOppositePriKeyProperty((Property)valueProp);
                    }
                    Object value = this.converter.fromJDBCDataType(rs, i, columnType, valueProp);
                    if (value == null) continue;
                    PropertyPair pair = new PropertyPair(prop, value);
                    if (!valueProp.equals(prop)) {
                        pair.setValueProp(valueProp);
                    }
                    result.add(pair);
                }
                ++count;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("returned " + count + " results"));
            }
        }
        catch (Throwable t) {
            throw new DataAccessException(t);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }

    protected void execute(PlasmaType type, StringBuilder sql, Map<String, PropertyPair> values, Connection con) {
        Statement statement = null;
        ArrayList<ByteArrayInputStream> streams = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("execute: " + sql.toString()));
                StringBuilder paramBuf = this.createParamDebug(values);
                log.debug((Object)("params: " + paramBuf.toString()));
            }
            statement = con.prepareStatement(sql.toString());
            for (PropertyPair propertyPair : values.values()) {
                PlasmaProperty valueProp = propertyPair.getProp();
                if (propertyPair.getValueProp() != null) {
                    valueProp = propertyPair.getValueProp();
                }
                int jdbcType = this.converter.toJDBCDataType(valueProp, propertyPair.getValue());
                Object jdbcValue = this.converter.toJDBCDataValue(valueProp, propertyPair.getValue());
                if (jdbcType != 2004 && jdbcType != -3) {
                    statement.setObject(propertyPair.getColumn(), jdbcValue, jdbcType);
                } else {
                    byte[] bytes = (byte[])jdbcValue;
                    long len = bytes.length;
                    ByteArrayInputStream is = new ByteArrayInputStream(bytes);
                    statement.setBinaryStream(propertyPair.getColumn(), is, len);
                    if (streams == null) {
                        streams = new ArrayList<ByteArrayInputStream>();
                    }
                    streams.add(is);
                }
                if (propertyPair.getOldValue() == null) continue;
                Object jdbcOldValue = this.converter.toJDBCDataValue(valueProp, propertyPair.getOldValue());
                if (jdbcType != 2004 && jdbcType != -3) {
                    statement.setObject(propertyPair.getOldValueColumn(), jdbcOldValue, jdbcType);
                    continue;
                }
                byte[] bytes = (byte[])jdbcOldValue;
                long len = bytes.length;
                ByteArrayInputStream is = new ByteArrayInputStream(bytes);
                statement.setBinaryStream(propertyPair.getOldValueColumn(), is, len);
                if (streams == null) {
                    streams = new ArrayList();
                }
                streams.add(is);
            }
            statement.executeUpdate();
        }
        catch (Throwable t) {
            throw new DataAccessException(t);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            if (streams != null) {
                try {
                    for (InputStream inputStream : streams) {
                        inputStream.close();
                    }
                }
                catch (IOException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    protected void executeInsert(PlasmaType type, StringBuilder sql, Map<String, PropertyPair> values, Connection con) {
        Statement statement = null;
        ArrayList<ByteArrayInputStream> streams = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("execute: " + sql.toString()));
                StringBuilder paramBuf = this.createParamDebug(values);
                log.debug((Object)("params: " + paramBuf.toString()));
            }
            statement = con.prepareStatement(sql.toString());
            for (PropertyPair propertyPair : values.values()) {
                PlasmaProperty valueProp = propertyPair.getProp();
                if (propertyPair.getValueProp() != null) {
                    valueProp = propertyPair.getValueProp();
                }
                int jdbcType = this.converter.toJDBCDataType(valueProp, propertyPair.getValue());
                Object jdbcValue = this.converter.toJDBCDataValue(valueProp, propertyPair.getValue());
                if (jdbcType != 2004 && jdbcType != -3) {
                    statement.setObject(propertyPair.getColumn(), jdbcValue, jdbcType);
                    continue;
                }
                byte[] bytes = (byte[])jdbcValue;
                long len = bytes.length;
                ByteArrayInputStream is = new ByteArrayInputStream(bytes);
                statement.setBinaryStream(propertyPair.getColumn(), is, len);
                if (streams == null) {
                    streams = new ArrayList<ByteArrayInputStream>();
                }
                streams.add(is);
            }
            statement.execute();
        }
        catch (Throwable t) {
            throw new DataAccessException(t);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            if (streams != null) {
                try {
                    for (InputStream inputStream : streams) {
                        inputStream.close();
                    }
                }
                catch (IOException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    protected List<PropertyPair> executeInsertWithGeneratedKeys(PlasmaType type, StringBuilder sql, Map<String, PropertyPair> values, Connection con) {
        ArrayList<PropertyPair> resultKeys = new ArrayList<PropertyPair>();
        Statement statement = null;
        ArrayList<ByteArrayInputStream> streams = null;
        ResultSet generatedKeys = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("execute: " + sql.toString()));
                StringBuilder paramBuf = this.createParamDebug(values);
                log.debug((Object)("params: " + paramBuf.toString()));
            }
            statement = con.prepareStatement(sql.toString(), 1);
            for (PropertyPair propertyPair : values.values()) {
                PlasmaProperty valueProp = propertyPair.getProp();
                if (propertyPair.getValueProp() != null) {
                    valueProp = propertyPair.getValueProp();
                }
                int jdbcType = this.converter.toJDBCDataType(valueProp, propertyPair.getValue());
                Object jdbcValue = this.converter.toJDBCDataValue(valueProp, propertyPair.getValue());
                if (jdbcType != 2004 && jdbcType != -3) {
                    statement.setObject(propertyPair.getColumn(), jdbcValue, jdbcType);
                    continue;
                }
                byte[] bytes = (byte[])jdbcValue;
                long len = bytes.length;
                ByteArrayInputStream is = new ByteArrayInputStream(bytes);
                statement.setBinaryStream(propertyPair.getColumn(), is, len);
                if (streams == null) {
                    streams = new ArrayList<ByteArrayInputStream>();
                }
                streams.add(is);
            }
            statement.execute();
            generatedKeys = statement.getGeneratedKeys();
            ResultSetMetaData rsMeta = generatedKeys.getMetaData();
            int n = rsMeta.getColumnCount();
            if (log.isDebugEnabled()) {
                log.debug((Object)("returned " + n + " keys"));
            }
            if (generatedKeys.next()) {
                List pkPropList = type.findProperties(KeyType.primary);
                if (pkPropList == null || pkPropList.size() == 0) {
                    throw new DataAccessException("no pri-key properties found for type '" + type.getName() + "'");
                }
                if (pkPropList.size() > 1) {
                    throw new DataAccessException("multiple pri-key properties found for type '" + type.getName() + "' - cannot map to generated keys");
                }
                PlasmaProperty prop = (PlasmaProperty)pkPropList.get(0);
                for (int i = 1; i <= n; ++i) {
                    String columnName = rsMeta.getColumnName(i);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("returned key column '" + columnName + "'"));
                    }
                    int columnType = rsMeta.getColumnType(i);
                    Object value = this.converter.fromJDBCDataType(generatedKeys, i, columnType, prop);
                    PropertyPair pair = new PropertyPair(prop, value);
                    resultKeys.add(pair);
                }
            }
        }
        catch (Throwable t) {
            throw new DataAccessException(t);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            if (streams != null) {
                try {
                    for (InputStream inputStream : streams) {
                        inputStream.close();
                    }
                }
                catch (IOException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return resultKeys;
    }

    protected PlasmaProperty getOppositePriKeyProperty(Property targetProperty) {
        PlasmaProperty opposite = (PlasmaProperty)targetProperty.getOpposite();
        PlasmaType oppositeType = null;
        oppositeType = opposite != null ? (PlasmaType)opposite.getContainingType() : (PlasmaType)targetProperty.getType();
        List pkeyProps = oppositeType.findProperties(KeyType.primary);
        if (pkeyProps.size() == 0) {
            throw new DataAccessException("no opposite pri-key properties found - cannot map from reference property, " + targetProperty.toString());
        }
        PlasmaProperty supplier = ((PlasmaProperty)targetProperty).getKeySupplier();
        if (supplier != null) {
            return supplier;
        }
        if (pkeyProps.size() == 1) {
            return (PlasmaProperty)pkeyProps.get(0);
        }
        throw new DataAccessException("multiple opposite pri-key properties found - cannot map from reference property, " + targetProperty.toString() + " - please add a derivation supplier");
    }

    private StringBuilder createParamDebug(Map<String, PropertyPair> values) throws SQLException {
        StringBuilder paramBuf = new StringBuilder();
        paramBuf.append("[");
        paramBuf.append("[");
        int i = 1;
        for (PropertyPair pair : values.values()) {
            PlasmaProperty valueProp = pair.getProp();
            if (pair.getValueProp() != null) {
                valueProp = pair.getValueProp();
            }
            int jdbcType = this.converter.toJDBCDataType(valueProp, pair.getValue());
            Object jdbcValue = this.converter.toJDBCDataValue(valueProp, pair.getValue());
            Object jdbcOldValue = null;
            if (pair.getOldValue() != null) {
                jdbcOldValue = this.converter.toJDBCDataValue(valueProp, pair.getOldValue());
            }
            if (i > 1) {
                paramBuf.append(", ");
            }
            paramBuf.append("(");
            paramBuf.append(jdbcValue.getClass().getSimpleName());
            paramBuf.append("/");
            paramBuf.append(this.converter.getJdbcTypeName(jdbcType));
            paramBuf.append(")");
            paramBuf.append(String.valueOf(jdbcValue));
            if (jdbcOldValue != null) {
                paramBuf.append("(");
                paramBuf.append(String.valueOf(jdbcOldValue));
                paramBuf.append(")");
            }
            ++i;
        }
        paramBuf.append("]");
        return paramBuf;
    }
}

