/*
 * Decompiled with CFR 0.152.
 */
package org.cloudgraph.rdb.filter;

import commonj.sdo.Property;
import commonj.sdo.Type;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudgraph.rdb.filter.Functions;
import org.cloudgraph.rdb.filter.SubqueryFilterAssembler;
import org.cloudgraph.rdb.service.AliasMap;
import org.plasma.common.bind.BindingValidationEventHandler;
import org.plasma.common.bind.DefaultValidationEventHandler;
import org.plasma.query.QueryException;
import org.plasma.query.bind.PlasmaQueryDataBinding;
import org.plasma.query.model.AbstractPathElement;
import org.plasma.query.model.Expression;
import org.plasma.query.model.From;
import org.plasma.query.model.Literal;
import org.plasma.query.model.Parameter;
import org.plasma.query.model.Path;
import org.plasma.query.model.PathElement;
import org.plasma.query.model.PathNode;
import org.plasma.query.model.Query;
import org.plasma.query.model.QueryConstants;
import org.plasma.query.model.SubqueryOperator;
import org.plasma.query.model.Term;
import org.plasma.query.model.Where;
import org.plasma.query.model.WildcardOperator;
import org.plasma.query.model.WildcardPathElement;
import org.plasma.query.visitor.QueryVisitor;
import org.plasma.query.visitor.Traversal;
import org.plasma.sdo.PlasmaProperty;
import org.plasma.sdo.PlasmaType;
import org.plasma.sdo.access.DataAccessException;
import org.plasma.sdo.access.model.EntityConstants;
import org.plasma.sdo.access.provider.common.SQLQueryFilterAssembler;
import org.plasma.sdo.helper.PlasmaTypeHelper;
import org.plasma.sdo.profile.KeyType;
import org.xml.sax.SAXException;

public class FilterAssembler
extends SQLQueryFilterAssembler
implements QueryConstants,
EntityConstants {
    private static Log log = LogFactory.getLog(FilterAssembler.class);
    private Map variableMap;
    private StringBuffer variableDecls;
    private String importDecls;
    private String parameterDecls;
    private int variableDeclCount = 0;
    private int subqueryCount = 0;
    private AliasMap aliasMap;

    public FilterAssembler(Where where, Type contextType, AliasMap aliasMap) {
        super(contextType);
        this.aliasMap = aliasMap;
        if (where.getTextContent() == null && where.getFilterId() == null) {
            if (where.getImportDeclaration() != null) {
                throw new DataAccessException("import declaration allowed only for 'free-text' Where clause");
            }
            if (where.getParameters().size() > 0) {
                throw new DataAccessException("parameters allowed only for 'free-text' Where clause");
            }
            if (where.getParameterDeclaration() != null) {
                throw new DataAccessException("parameter declarations allowed only for 'free-text' Where clause");
            }
            if (where.getVariableDeclaration() != null) {
                throw new DataAccessException("import declarations allowed only for 'free-text' Where clause");
            }
            if (log.isDebugEnabled()) {
                this.log(where);
            }
            this.filter.append(" WHERE ");
            where.accept((QueryVisitor)this);
        } else {
            for (int i = 0; i < where.getParameters().size(); ++i) {
                this.params.add(((Parameter)where.getParameters().get(i)).getValue());
            }
            if (where.getImportDeclaration() != null) {
                this.importDecls = where.getImportDeclaration().getValue();
            }
            if (where.getParameterDeclaration() != null) {
                this.parameterDecls = where.getParameterDeclaration().getValue();
            }
            if (where.getVariableDeclaration() != null) {
                if (this.variableDecls == null) {
                    this.variableDecls = new StringBuffer();
                }
                this.variableDecls.append(where.getVariableDeclaration().getValue());
            }
            if (where.getTextContent() != null) {
                this.filter.append(where.getTextContent().getValue());
            } else {
                throw new QueryException("expected free-text content or filter id");
            }
        }
    }

    public String getVariableDeclarations() {
        return this.variableDecls.toString();
    }

    public boolean hasVariableDeclarations() {
        return this.variableDecls != null && this.variableDecls.length() > 0;
    }

    public String getImportDeclarations() {
        return this.importDecls;
    }

    public boolean hasImportDeclarations() {
        return this.importDecls != null && this.importDecls.length() > 0;
    }

    public String getParameterDeclarations() {
        return this.parameterDecls;
    }

    public boolean hasParameterDeclarations() {
        return this.parameterDecls != null && this.parameterDecls.length() > 0;
    }

    public void start(Expression expression) {
        for (int i = 0; i < expression.getTerms().size(); ++i) {
            SubqueryOperator subqueryOper = ((Term)expression.getTerms().get(i)).getSubqueryOperator();
            if (subqueryOper == null) continue;
            org.plasma.query.model.Property property = ((Term)expression.getTerms().get(i - 1)).getProperty();
            Query query = ((Term)expression.getTerms().get(i + 1)).getQuery();
            this.assembleSubquery(property, subqueryOper, query);
            ++this.subqueryCount;
            this.getContext().setTraversal(Traversal.ABORT);
        }
    }

    protected void assembleSubquery(org.plasma.query.model.Property property, SubqueryOperator oper, Query query) {
        From from = query.getFromClause();
        Type type = PlasmaTypeHelper.INSTANCE.getType(from.getEntity().getNamespaceURI(), from.getEntity().getName());
        String alias = "a" + String.valueOf(this.subqueryCount);
        SubqueryFilterAssembler assembler = new SubqueryFilterAssembler(alias, query, this.params, type);
        if (property.getPath() != null) {
            throw new QueryException("properties with paths (" + property.getName() + ") not allowed as subquery target");
        }
        Property endpointProperty = this.contextType.getProperty(property.getName());
        if (endpointProperty.isMany()) {
            throw new QueryException("multi-valued properties (" + this.contextType.getName() + "." + endpointProperty.getName() + ") not allowed as subquery target");
        }
        this.contextProperty = endpointProperty;
        switch (oper.getValue()) {
            case IN: {
                this.filter.append("(");
                this.filter.append(assembler.getFilter());
                this.filter.append(").contains(");
                this.filter.append("" + endpointProperty.getName());
                this.filter.append(")");
                break;
            }
            case NOT_IN: {
                this.filter.append("!(");
                this.filter.append(assembler.getFilter());
                this.filter.append(").contains(");
                this.filter.append("" + endpointProperty.getName());
                this.filter.append(")");
                break;
            }
            case EXISTS: {
                this.filter.append("!(");
                this.filter.append(assembler.getFilter());
                this.filter.append(").isEmpty()");
                break;
            }
            case NOT_EXISTS: {
                this.filter.append("(");
                this.filter.append(assembler.getFilter());
                this.filter.append(").isEmpty()");
            }
        }
    }

    protected void processWildcardExpression(org.plasma.query.model.Property property, WildcardOperator oper, Literal literal) {
        String content = literal.getValue().trim();
        content = content.replace("*", "%");
        this.start(property);
        this.filter.append("'");
        this.filter.append(content);
        this.filter.append("'");
    }

    public void start(org.plasma.query.model.Property property) {
        PlasmaType targetType;
        String targetAlias;
        Path path = property.getPath();
        if (this.filter.length() > 0) {
            this.filter.append(" ");
        }
        if ((targetAlias = this.aliasMap.getAlias(targetType = (PlasmaType)this.contextType)) == null) {
            targetAlias = this.aliasMap.addAlias(targetType);
        }
        if (path != null) {
            String pathKey = "";
            for (int i = 0; i < path.getPathNodes().size(); ++i) {
                PlasmaType prevTargetType = targetType;
                String prevTargetAlias = targetAlias;
                AbstractPathElement pathElem = ((PathNode)path.getPathNodes().get(i)).getPathElement();
                if (pathElem instanceof WildcardPathElement) {
                    throw new DataAccessException("wildcard path elements applicable for 'Select' clause paths only, not 'Where' clause paths");
                }
                String elem = ((PathElement)pathElem).getValue();
                PlasmaProperty prop = (PlasmaProperty)targetType.getProperty(elem);
                targetAlias = this.aliasMap.getAlias(targetType = (PlasmaType)prop.getType());
                if (targetAlias == null) {
                    targetAlias = this.aliasMap.addAlias(targetType);
                }
                pathKey = pathKey + "/" + elem;
                if (!prop.isMany()) {
                    this.filter.append(prevTargetAlias + "." + prop.getPhysicalName());
                    this.filter.append(" = ");
                    PlasmaProperty priKeyProp = (PlasmaProperty)targetType.findProperty(KeyType.primary);
                    this.filter.append(targetAlias + "." + priKeyProp.getPhysicalName());
                } else {
                    PlasmaProperty opposite = (PlasmaProperty)prop.getOpposite();
                    if (opposite.isMany()) {
                        throw new DataAccessException("expected singular opposite for property, " + prop.getContainingType().getURI() + "#" + prop.getContainingType().getName() + "." + prop.getName());
                    }
                    this.filter.append(targetAlias + "." + opposite.getPhysicalName());
                    this.filter.append(" = ");
                    PlasmaProperty priKeyProp = (PlasmaProperty)prevTargetType.findProperty(KeyType.primary);
                    this.filter.append(prevTargetAlias + "." + priKeyProp.getPhysicalName());
                }
                this.filter.append(" AND ");
            }
        }
        PlasmaProperty endpointProp = (PlasmaProperty)targetType.getProperty(property.getName());
        this.contextProperty = endpointProp;
        List functions = property.getFunctions();
        if (functions == null || functions.size() == 0) {
            this.filter.append(targetAlias + "." + endpointProp.getPhysicalName());
        } else {
            this.filter.append(Functions.wrap(endpointProp, functions, targetAlias));
        }
        super.start(property);
    }

    protected void log(Where root) {
        String xml = "";
        try {
            PlasmaQueryDataBinding binding = new PlasmaQueryDataBinding((BindingValidationEventHandler)new DefaultValidationEventHandler());
            xml = binding.marshal((Object)root);
        }
        catch (JAXBException e) {
            log.debug((Object)e);
        }
        catch (SAXException e) {
            log.debug((Object)e);
        }
        log.debug((Object)("where: " + xml));
    }
}

