/*
 * Decompiled with CFR 0.152.
 */
package org.cloudgraph.rdb.service;

import commonj.sdo.DataObject;
import commonj.sdo.Type;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudgraph.rdb.connect.RDBConnectionManager;
import org.plasma.config.DataAccessProviderName;
import org.plasma.config.PlasmaConfig;
import org.plasma.config.SequenceConfiguration;
import org.plasma.sdo.Alias;
import org.plasma.sdo.PlasmaType;
import org.plasma.sdo.access.DataAccessException;
import org.plasma.sdo.access.SequenceGenerator;

public class StoredProcSequenceGenerator
implements SequenceGenerator {
    private static Log log = LogFactory.getLog(StoredProcSequenceGenerator.class);
    private Connection conn;

    public Long get(DataObject dataObject) {
        return this.getSeqNum(this.getSeqName(dataObject.getType()));
    }

    private Long getSeqNum(String seqName) {
        Statement cstmt1 = null;
        try {
            if (this.conn == null) {
                this.initialize();
            }
            cstmt1 = this.conn.prepareCall("{ call GET_SQNC_NMBR (?, ?) }");
            cstmt1.registerOutParameter(2, 2);
            cstmt1.setString(1, seqName);
            cstmt1.execute();
            long id = cstmt1.getLong(2);
            Long l = new Long(id);
            return l;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        finally {
            if (cstmt1 != null) {
                try {
                    cstmt1.close();
                }
                catch (Throwable t2) {}
            }
        }
    }

    private String getSeqName(Type type) {
        SequenceConfiguration config = PlasmaConfig.getInstance().getDataAccessProvider(DataAccessProviderName.JDBC).getSequenceConfiguration();
        Alias alias = ((PlasmaType)type).getAlias();
        if (alias == null) {
            throw new RuntimeException("type has no alias, " + type.getURI() + "#" + type.getName());
        }
        StringBuilder buf = new StringBuilder();
        if (config.getPrefix() != null && config.getPrefix().trim().length() > 0) {
            buf.append(config.getPrefix());
        }
        buf.append(alias.getPhysicalName());
        if (config.getSuffix() != null && config.getSuffix().trim().length() > 0) {
            buf.append(config.getSuffix());
        }
        return buf.toString();
    }

    public void initialize() {
        try {
            this.conn = RDBConnectionManager.instance().getConnection();
        }
        catch (SQLException e2) {
            throw new DataAccessException((Throwable)e2);
        }
    }

    public void close() {
        try {
            if (this.conn != null) {
                this.conn.close();
                this.conn = null;
            }
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage());
        }
    }
}

