/*
 * Decompiled with CFR 0.152.
 */
package org.cloudgraph.rdb.service;

import commonj.sdo.Property;
import commonj.sdo.Type;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.bind.JAXBException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudgraph.rdb.connect.RDBConnectionManager;
import org.cloudgraph.rdb.filter.FilterAssembler;
import org.cloudgraph.rdb.filter.GroupingDeclarationAssembler;
import org.cloudgraph.rdb.filter.OrderingDeclarationAssembler;
import org.cloudgraph.rdb.service.AliasMap;
import org.cloudgraph.rdb.service.GraphAssembler;
import org.cloudgraph.rdb.service.JDBCSupport;
import org.cloudgraph.rdb.service.RDBDataConverter;
import org.cloudgraph.rdb.service.RDBServiceException;
import org.plasma.common.bind.BindingValidationEventHandler;
import org.plasma.common.bind.DefaultValidationEventHandler;
import org.plasma.config.DataAccessProviderName;
import org.plasma.config.PlasmaConfig;
import org.plasma.config.RDBMSVendorName;
import org.plasma.query.bind.PlasmaQueryDataBinding;
import org.plasma.query.collector.SelectionCollector;
import org.plasma.query.model.From;
import org.plasma.query.model.GroupBy;
import org.plasma.query.model.OrderBy;
import org.plasma.query.model.Query;
import org.plasma.query.model.Select;
import org.plasma.query.model.Variable;
import org.plasma.query.model.Where;
import org.plasma.query.visitor.DefaultQueryVisitor;
import org.plasma.query.visitor.QueryVisitor;
import org.plasma.sdo.PlasmaDataGraph;
import org.plasma.sdo.PlasmaDataObject;
import org.plasma.sdo.PlasmaProperty;
import org.plasma.sdo.PlasmaType;
import org.plasma.sdo.access.DataAccessException;
import org.plasma.sdo.access.MaxResultsExceededException;
import org.plasma.sdo.access.QueryDispatcher;
import org.plasma.sdo.access.provider.common.DataObjectHashKeyAssembler;
import org.plasma.sdo.access.provider.common.PropertyPair;
import org.plasma.sdo.helper.PlasmaTypeHelper;
import org.xml.sax.SAXException;

public class GraphQuery
extends JDBCSupport
implements QueryDispatcher {
    private static Log log = LogFactory.getLog(GraphQuery.class);
    private static final String ROWNUM = "R_NM";

    public PlasmaDataGraph[] find(Query query, Timestamp snapshotDate) {
        return this.find(query, -1, snapshotDate);
    }

    public PlasmaDataGraph[] find(Query query, int requestMax, Timestamp snapshotDate) {
        Connection con = null;
        try {
            con = RDBConnectionManager.instance().getConnection();
        }
        catch (SQLException e2) {
            throw new DataAccessException((Throwable)e2);
        }
        From from = query.getFromClause();
        PlasmaType type = (PlasmaType)PlasmaTypeHelper.INSTANCE.getType(from.getEntity().getNamespaceURI(), from.getEntity().getName());
        SelectionCollector collector = new SelectionCollector(query.getSelectClause(), null, query.findOrderByClause(), (Type)type);
        collector.setOnlySingularProperties(false);
        collector.setOnlyDeclaredProperties(false);
        List<List<PropertyPair>> queryResults = this.findResults(query, collector, type, con);
        GraphAssembler assembler = new GraphAssembler(type, collector, snapshotDate, con);
        if (log.isDebugEnabled()) {
            log.debug((Object)"assembling results");
        }
        PlasmaDataGraph[] results = null;
        try {
            results = !query.getSelectClause().hasDistinctProperties() ? this.assembleResults(queryResults, requestMax, assembler) : this.trimResults(queryResults, requestMax, assembler, query.getSelectClause(), (Type)type);
        }
        catch (SQLException e) {
            throw new RDBServiceException(e);
        }
        finally {
            try {
                con.close();
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return results;
    }

    public int count(Query query) {
        Connection con = null;
        try {
            con = RDBConnectionManager.instance().getConnection();
        }
        catch (SQLException e2) {
            throw new DataAccessException((Throwable)e2);
        }
        From from = query.getFromClause();
        PlasmaType type = (PlasmaType)PlasmaTypeHelper.INSTANCE.getType(from.getEntity().getNamespaceURI(), from.getEntity().getName());
        int size = this.countResults(con, query, type);
        try {
            con.close();
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return size;
    }

    private PlasmaDataGraph[] assembleResults(List<List<PropertyPair>> collection, int requestMax, GraphAssembler assembler) throws SQLException {
        ArrayList<PlasmaDataGraph> list = new ArrayList<PlasmaDataGraph>(20);
        Iterator<List<PropertyPair>> iter = collection.iterator();
        int i = 1;
        while (iter.hasNext()) {
            List<PropertyPair> pairs = iter.next();
            if (requestMax <= 0) {
                if (i > 15000) {
                    throw new MaxResultsExceededException(i, 15000);
                }
            } else if (i > requestMax) {
                if (!log.isDebugEnabled()) break;
                log.debug((Object)("truncating results at " + String.valueOf(requestMax)));
                break;
            }
            assembler.assemble(pairs);
            list.add(assembler.getDataGraph());
            assembler.clear();
            ++i;
        }
        PlasmaDataGraph[] results = new PlasmaDataGraph[list.size()];
        list.toArray(results);
        if (log.isDebugEnabled()) {
            log.debug((Object)("assembled " + String.valueOf(results.length) + " results"));
        }
        return results;
    }

    private PlasmaDataGraph[] trimResults(List<List<PropertyPair>> collection, int requestMax, GraphAssembler assembler, Select select, Type type) throws SQLException {
        DataObjectHashKeyAssembler hashKeyAssembler = new DataObjectHashKeyAssembler(select, type);
        HashMap<String, PlasmaDataObject> distinctMap = new HashMap<String, PlasmaDataObject>(20);
        ArrayList<PlasmaDataObject> distinctList = new ArrayList<PlasmaDataObject>(20);
        Iterator<List<PropertyPair>> iter = collection.iterator();
        int i = 1;
        while (iter.hasNext()) {
            if (requestMax <= 0 && i > 15000) {
                throw new MaxResultsExceededException(i, 15000);
            }
            List<PropertyPair> pairs = iter.next();
            assembler.assemble(pairs);
            PlasmaDataGraph dataGraph = assembler.getDataGraph();
            assembler.clear();
            String key = hashKeyAssembler.getHashKey((PlasmaDataObject)dataGraph.getRootObject());
            if (distinctMap.get(key) == null) {
                if (requestMax <= 0) {
                    if (i > 15000) {
                        throw new MaxResultsExceededException(distinctList.size(), 15000);
                    }
                } else if (i > requestMax) {
                    if (!log.isDebugEnabled()) break;
                    log.debug((Object)("truncating results at " + String.valueOf(requestMax)));
                    break;
                }
                distinctMap.put(key, (PlasmaDataObject)dataGraph.getRootObject());
                distinctList.add((PlasmaDataObject)dataGraph.getRootObject());
            }
            ++i;
        }
        PlasmaDataGraph[] trimmedResults = new PlasmaDataGraph[distinctList.size()];
        for (i = 0; i < trimmedResults.length; ++i) {
            trimmedResults[i] = (PlasmaDataGraph)((PlasmaDataObject)distinctList.get(i)).getDataGraph();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("assembled " + String.valueOf(trimmedResults.length) + " results out of " + String.valueOf(i)));
        }
        return trimmedResults;
    }

    private int countResults(Connection con, Query query, PlasmaType type) {
        int result = 0;
        Object[] params = new Object[]{};
        StringBuilder sqlQuery = new StringBuilder();
        AliasMap aliasMap = new AliasMap(type);
        FilterAssembler filterAssembler = null;
        Where where = query.findWhereClause();
        if (where != null) {
            filterAssembler = new FilterAssembler(where, (Type)type, aliasMap);
            params = filterAssembler.getParams();
            if (log.isDebugEnabled()) {
                log.debug((Object)("filter: " + filterAssembler.getFilter()));
            }
        }
        sqlQuery.append("SELECT COUNT(*)");
        sqlQuery.append(" FROM ");
        Iterator<PlasmaType> it = aliasMap.getTypes();
        int count = 0;
        while (it.hasNext()) {
            PlasmaType aliasType = it.next();
            String alias = aliasMap.getAlias(aliasType);
            if (count > 0) {
                sqlQuery.append(", ");
            }
            sqlQuery.append(this.getQualifiedPhysicalName(aliasType));
            sqlQuery.append(" ");
            sqlQuery.append(alias);
            ++count;
        }
        if (filterAssembler != null) {
            sqlQuery.append(" ");
            sqlQuery.append(filterAssembler.getFilter());
        }
        if (query.getStartRange() != null && query.getEndRange() != null) {
            log.warn((Object)("query range (start: " + query.getStartRange() + ", end: " + query.getEndRange() + ") ignored for count operation"));
        }
        Statement statement = null;
        ResultSet rs = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("queryString: " + sqlQuery.toString()));
                log.debug((Object)"executing...");
            }
            statement = con.prepareStatement(sqlQuery.toString(), 1003, 1007);
            if (filterAssembler != null && (params = filterAssembler.getParams()) != null) {
                for (int i = 0; i < params.length; ++i) {
                    statement.setObject(i + 1, params[i]);
                }
            }
            if (log.isDebugEnabled()) {
                if (params == null || params.length == 0) {
                    log.debug((Object)("executing: " + sqlQuery.toString()));
                } else {
                    StringBuilder paramBuf = new StringBuilder();
                    paramBuf.append(" [");
                    for (int p = 0; p < params.length; ++p) {
                        if (p > 0) {
                            paramBuf.append(", ");
                        }
                        paramBuf.append(String.valueOf(params[p]));
                    }
                    paramBuf.append("]");
                    log.debug((Object)("executing: " + sqlQuery.toString() + " " + paramBuf.toString()));
                }
            }
            statement.execute();
            rs = statement.getResultSet();
            rs.next();
            result = rs.getInt(1);
        }
        catch (Throwable t) {
            StringBuffer buf = this.generateErrorDetail(t, sqlQuery.toString(), filterAssembler);
            log.error((Object)buf.toString());
            throw new DataAccessException(t);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }

    private List<List<PropertyPair>> findResults(Query query, SelectionCollector collector, PlasmaType type, Connection con) {
        Object[] params = new Object[]{};
        RDBDataConverter converter = RDBDataConverter.INSTANCE;
        if (log.isDebugEnabled()) {
            this.log(query);
        }
        AliasMap aliasMap = new AliasMap(type);
        FilterAssembler filterAssembler = null;
        Where where = query.findWhereClause();
        if (where != null) {
            filterAssembler = new FilterAssembler(where, (Type)type, aliasMap);
            params = filterAssembler.getParams();
        }
        OrderingDeclarationAssembler orderingDeclAssembler = null;
        OrderBy orderby = query.findOrderByClause();
        if (orderby != null) {
            orderingDeclAssembler = new OrderingDeclarationAssembler(orderby, type, aliasMap);
        }
        GroupingDeclarationAssembler groupingDeclAssembler = null;
        GroupBy groupby = query.findGroupByClause();
        if (groupby != null) {
            groupingDeclAssembler = new GroupingDeclarationAssembler(groupby, type, aliasMap);
        }
        String rootAlias = aliasMap.getAlias(type);
        StringBuilder sqlQuery = new StringBuilder();
        sqlQuery.append("SELECT DISTINCT ");
        RDBMSVendorName vendor = PlasmaConfig.getInstance().getRDBMSProviderVendor(DataAccessProviderName.JDBC);
        switch (vendor) {
            case ORACLE: {
                if (query.getStartRange() == null || query.getEndRange() == null) break;
                sqlQuery.append("ROWNUM as ");
                sqlQuery.append(ROWNUM);
                sqlQuery.append(", ");
                break;
            }
        }
        boolean hasLob = false;
        int i = 0;
        Set props = collector.getProperties((Type)type);
        for (Property prop : props) {
            if (prop.isMany() && !prop.getType().isDataType()) continue;
            if (i > 0) {
                sqlQuery.append(", ");
            }
            sqlQuery.append(rootAlias);
            sqlQuery.append(".");
            sqlQuery.append(((PlasmaProperty)prop).getPhysicalName());
            ++i;
        }
        sqlQuery.append(" FROM ");
        Iterator<PlasmaType> it = aliasMap.getTypes();
        int count = 0;
        while (it.hasNext()) {
            PlasmaType aliasType = it.next();
            String alias = aliasMap.getAlias(aliasType);
            if (count > 0) {
                sqlQuery.append(", ");
            }
            sqlQuery.append(this.getQualifiedPhysicalName(aliasType));
            sqlQuery.append(" ");
            sqlQuery.append(alias);
            ++count;
        }
        if (filterAssembler != null) {
            sqlQuery.append(" ");
            sqlQuery.append(filterAssembler.getFilter());
        }
        if (orderingDeclAssembler != null) {
            sqlQuery.append(" ");
            sqlQuery.append(orderingDeclAssembler.getOrderingDeclaration());
        }
        if (groupingDeclAssembler != null) {
            sqlQuery.append(" ");
            sqlQuery.append(groupingDeclAssembler.getGroupingDeclaration());
        }
        switch (vendor) {
            case ORACLE: {
                if (query.getStartRange() == null || query.getEndRange() == null) break;
                StringBuilder buf = new StringBuilder();
                buf.append("SELECT * FROM (");
                buf.append((CharSequence)sqlQuery);
                buf.append(") WHERE ");
                buf.append(ROWNUM);
                buf.append(" >= ");
                buf.append(String.valueOf(query.getStartRange()));
                buf.append(" AND ");
                buf.append(ROWNUM);
                buf.append(" <= ");
                buf.append(String.valueOf(query.getEndRange()));
                sqlQuery = buf;
                break;
            }
            case MYSQL: {
                if (query.getStartRange() == null || query.getEndRange() == null) break;
                long offset = query.getStartRange() - 1;
                if (offset < 0L) {
                    offset = 0L;
                }
                long rowcount = (long)query.getEndRange().intValue() - offset;
                sqlQuery.append(" LIMIT ");
                sqlQuery.append(String.valueOf(offset));
                sqlQuery.append(",");
                sqlQuery.append(String.valueOf(rowcount));
                break;
            }
        }
        ArrayList<List<PropertyPair>> rows = new ArrayList<List<PropertyPair>>();
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            statement = con.prepareStatement(sqlQuery.toString(), 1003, 1007);
            if (filterAssembler != null && (params = filterAssembler.getParams()) != null) {
                for (i = 0; i < params.length; ++i) {
                    statement.setObject(i + 1, params[i]);
                }
            }
            if (log.isDebugEnabled()) {
                if (params == null || params.length == 0) {
                    log.debug((Object)("executing: " + sqlQuery.toString()));
                } else {
                    StringBuilder paramBuf = new StringBuilder();
                    paramBuf.append(" [");
                    for (int p = 0; p < params.length; ++p) {
                        if (p > 0) {
                            paramBuf.append(", ");
                        }
                        paramBuf.append(String.valueOf(params[p]));
                    }
                    paramBuf.append("]");
                    log.debug((Object)("executing: " + sqlQuery.toString() + " " + paramBuf.toString()));
                }
            }
            statement.execute();
            rs = statement.getResultSet();
            int numcols = rs.getMetaData().getColumnCount();
            ResultSetMetaData rsMeta = rs.getMetaData();
            ArrayList<PropertyPair> row = null;
            PropertyPair pair = null;
            while (rs.next()) {
                row = new ArrayList<PropertyPair>();
                rows.add(row);
                for (i = 1; i <= numcols; ++i) {
                    PlasmaProperty prop;
                    String columnName = rsMeta.getColumnLabel(i);
                    if (columnName == null) {
                        columnName = rsMeta.getColumnName(i);
                    }
                    if (ROWNUM.equals(columnName)) continue;
                    int columnType = rsMeta.getColumnType(i);
                    PlasmaProperty valueProp = prop = (PlasmaProperty)type.getProperty(columnName);
                    while (!valueProp.getType().isDataType()) {
                        valueProp = this.getOppositePriKeyProperty((Property)valueProp);
                    }
                    Object value = converter.fromJDBCDataType(rs, i, columnType, valueProp);
                    if (value == null) continue;
                    pair = new PropertyPair(prop, value);
                    pair.setColumn(i);
                    if (!valueProp.equals(prop)) {
                        pair.setValueProp(valueProp);
                    }
                    row.add(pair);
                }
            }
        }
        catch (Throwable t) {
            StringBuffer buf = this.generateErrorDetail(t, sqlQuery.toString(), filterAssembler);
            log.error((Object)buf.toString());
            throw new DataAccessException(t);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return rows;
    }

    private StringBuffer generateErrorDetail(Throwable t, String queryString, FilterAssembler filterAssembler) {
        StringBuffer buf = new StringBuffer(2048);
        buf.append("QUERY FAILED: ");
        buf.append(t.getMessage());
        buf.append(" \n");
        if (queryString != null) {
            buf.append("queryString: ");
            buf.append(queryString);
            buf.append(" \n");
        }
        if (filterAssembler != null) {
            Object[] params;
            if (filterAssembler.hasImportDeclarations()) {
                buf.append("import decl: ");
                buf.append(filterAssembler.getImportDeclarations());
                buf.append(" \n");
            }
            if ((params = filterAssembler.getParams()) != null) {
                buf.append("parameters: [");
                for (int i = 0; i < params.length; ++i) {
                    if (i > 0) {
                        buf.append(", ");
                    }
                    buf.append(String.valueOf(params[i]));
                }
                buf.append("]");
                buf.append(" \n");
            }
            if (filterAssembler.hasParameterDeclarations()) {
                buf.append("param decl: ");
                buf.append(filterAssembler.getParameterDeclarations());
                buf.append(" \n");
            }
            if (filterAssembler.hasVariableDeclarations()) {
                buf.append("variable decl: ");
                buf.append(filterAssembler.getVariableDeclarations());
                buf.append(" \n");
            }
        }
        return buf;
    }

    public List<Variable> getVariables(Where where) {
        final ArrayList<Variable> list = new ArrayList<Variable>(1);
        DefaultQueryVisitor visitor = new DefaultQueryVisitor(){

            public void start(Variable var) {
                list.add(var);
            }
        };
        where.accept((QueryVisitor)visitor);
        return list;
    }

    public void close() {
    }

    protected void log(Query root) {
        String xml = "";
        try {
            PlasmaQueryDataBinding binding = new PlasmaQueryDataBinding((BindingValidationEventHandler)new DefaultValidationEventHandler());
            xml = binding.marshal((Object)root);
        }
        catch (JAXBException e) {
            log.debug((Object)e);
        }
        catch (SAXException e) {
            log.debug((Object)e);
        }
        log.debug((Object)("where: " + xml));
    }
}

