/*
 * Decompiled with CFR 0.152.
 */
package org.cloudgraph.rdb.connect;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.cloudgraph.rdb.service.RDBServiceException;
import org.plasma.config.DataAccessProviderName;
import org.plasma.config.PlasmaConfig;
import org.plasma.config.Property;

public class RDBConnectionManager {
    private static final Log log = LogFactory.getLog(RDBConnectionManager.class);
    public static final String DBCP_DEFAULTAUTOCOMMIT = "defaultAutoCommit";
    public static final String DBCP_DEFAULTREADONLY = "defaultReadOnly";
    public static final String DBCP_DEFAULTTRANSACTIONISOLATION = "defaultTransactionIsolation";
    public static final String DBCP_DEFAULTCATALOG = "defaultCatalog";
    public static final String DBCP_INITIALSIZE = "initialSize";
    public static final String DBCP_MAXACTIVE = "maxActive";
    public static final String DBCP_MAXIDLE = "maxIdle";
    public static final String DBCP_MINIDLE = "minIdle";
    public static final String DBCP_MAXWAIT = "maxWait";
    public static final String DBCP_VALIDATIONQUERY = "validationQuery";
    public static final String DBCP_TESTONBORROW = "testOnBorrow";
    public static final String DBCP_TESTONRETURN = "testOnReturn";
    public static final String DBCP_TESTWHILEIDLE = "testWhileIdle";
    public static final String DBCP_TIMEBETWEENEVICTIONRUNSMILLIS = "timeBetweenEvictionRunsMillis";
    public static final String DBCP_NUMTESTSPEREVICTIONRUN = "numTestsPerEvictionRun";
    public static final String DBCP_MINEVICTABLEIDLETIMEMILLIS = "minEvictableIdleTimeMillis";
    public static final String DBCP_CONNECTIONINITSQLS = "connectionInitSqls";
    public static final String DBCP_REMOVEABANDONED = "removeAbandoned";
    public static final String DBCP_REMOVEABANDONEDTIMEOUT = "removeAbandonedTimeout";
    public static final String DBCP_LOGABANDONED = "logAbandoned";
    private static RDBConnectionManager instance;
    private static DataSource DS;
    private static GenericObjectPool _pool;

    private RDBConnectionManager() {
        HashMap<String, String> props = new HashMap<String, String>();
        for (Property property : PlasmaConfig.getInstance().getDataAccessProvider(DataAccessProviderName.JDBC).getProperties()) {
            props.put(property.getName(), property.getValue());
        }
        String driverName = (String)props.get("org.plasma.sdo.access.provider.jdbc.ConnectionDriverName");
        String url = (String)props.get("org.plasma.sdo.access.provider.jdbc.ConnectionURL");
        String user = (String)props.get("org.plasma.sdo.access.provider.jdbc.ConnectionUserName");
        String password = (String)props.get("org.plasma.sdo.access.provider.jdbc.ConnectionPassword");
        int poolMinSize = Integer.valueOf((String)props.get("org.plasma.sdo.access.provider.jdbc.ConnectionPoolMinSize"));
        int poolMaxSize = Integer.valueOf((String)props.get("org.plasma.sdo.access.provider.jdbc.ConnectionPoolMaxSize"));
        try {
            Class.forName(driverName).newInstance();
        }
        catch (Exception e) {
            log.error((Object)("Error when attempting to obtain DB Driver: " + driverName), (Throwable)e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"trying to connect to database...");
        }
        try {
            DS = RDBConnectionManager.setup(url, user, password, poolMinSize, poolMaxSize, props);
            log.debug((Object)"Connection attempt to database succeeded.");
        }
        catch (Exception e) {
            log.error((Object)"Error when attempting to connect to DB ", (Throwable)e);
        }
    }

    public static RDBConnectionManager instance() {
        if (instance == null) {
            RDBConnectionManager.initInstance();
        }
        return instance;
    }

    private static synchronized void initInstance() {
        if (instance == null) {
            instance = new RDBConnectionManager();
        }
    }

    protected void finalize() {
        log.debug((Object)"Finalizing ConnectionManager");
        try {
            super.finalize();
        }
        catch (Throwable ex) {
            log.error((Object)"ConnectionManager finalize failed to disconnect: ", ex);
        }
    }

    public Connection getConnection() throws SQLException {
        try {
            RDBConnectionManager.printDriverStats();
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
        }
        return DS.getConnection();
    }

    private static DataSource setup(String connectURI, String username, String password, int minIdle, int maxActive, Map<String, String> props) throws Exception {
        GenericObjectPool.Config config = RDBConnectionManager.createGenericObjectPoolConfig(props);
        GenericObjectPool connectionPool = new GenericObjectPool(null, config);
        connectionPool.setMinIdle(minIdle);
        connectionPool.setMaxActive(maxActive);
        _pool = connectionPool;
        DriverManagerConnectionFactory connectionFactory = new DriverManagerConnectionFactory(connectURI, username, password);
        PoolableConnectionFactory poolableConnectionFactory = new PoolableConnectionFactory((ConnectionFactory)connectionFactory, (ObjectPool)connectionPool, null, null, false, true);
        String value = RDBConnectionManager.getValue(DBCP_VALIDATIONQUERY, props);
        if (value != null) {
            try {
                poolableConnectionFactory.setValidationQuery(value);
            }
            catch (Exception e) {
                throw new RDBServiceException(e);
            }
        }
        PoolingDataSource dataSource = new PoolingDataSource((ObjectPool)connectionPool);
        return dataSource;
    }

    public static void printDriverStats() throws Exception {
        GenericObjectPool connectionPool = _pool;
        log.debug((Object)("NumActive: " + connectionPool.getNumActive() + " NumIdle: " + connectionPool.getNumIdle()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumLockedProcesses() {
        int num_locked_connections = 0;
        Connection con = null;
        PreparedStatement p_stmt = null;
        ResultSet rs = null;
        try {
            con = DS.getConnection();
            p_stmt = con.prepareStatement("SHOW PROCESSLIST");
            rs = p_stmt.executeQuery();
            while (rs.next()) {
                if (rs.getString("State") == null || !rs.getString("State").equals("Locked")) continue;
                ++num_locked_connections;
            }
        }
        catch (Exception e) {
            log.debug((Object)("Failed to get get Locked Connections - Exception: " + e.toString()));
        }
        finally {
            try {
                rs.close();
                p_stmt.close();
                con.close();
            }
            catch (SQLException ex) {
                log.error((Object)ex.toString());
            }
        }
        return num_locked_connections;
    }

    private static GenericObjectPool.Config createGenericObjectPoolConfig(Map<String, String> props) {
        GenericObjectPool.Config config = new GenericObjectPool.Config();
        String value = RDBConnectionManager.getValue(DBCP_TESTONBORROW, props);
        if (value != null) {
            try {
                config.testOnBorrow = Boolean.parseBoolean(value);
            }
            catch (Exception e) {
                throw new RDBServiceException(e);
            }
        }
        if ((value = RDBConnectionManager.getValue(DBCP_TESTONRETURN, props)) != null) {
            try {
                config.testOnReturn = Boolean.parseBoolean(value);
            }
            catch (Exception e) {
                throw new RDBServiceException(e);
            }
        }
        if ((value = RDBConnectionManager.getValue(DBCP_TESTWHILEIDLE, props)) != null) {
            try {
                config.testWhileIdle = Boolean.parseBoolean(value);
            }
            catch (Exception e) {
                throw new RDBServiceException(e);
            }
        }
        if ((value = RDBConnectionManager.getValue(DBCP_TIMEBETWEENEVICTIONRUNSMILLIS, props)) != null) {
            try {
                config.timeBetweenEvictionRunsMillis = Long.parseLong(value);
            }
            catch (NumberFormatException e) {
                throw new RDBServiceException(e);
            }
        }
        if ((value = RDBConnectionManager.getValue(DBCP_NUMTESTSPEREVICTIONRUN, props)) != null) {
            try {
                config.numTestsPerEvictionRun = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                throw new RDBServiceException(e);
            }
        }
        if ((value = RDBConnectionManager.getValue(DBCP_MINEVICTABLEIDLETIMEMILLIS, props)) != null) {
            try {
                config.minEvictableIdleTimeMillis = Long.parseLong(value);
            }
            catch (NumberFormatException e) {
                throw new RDBServiceException(e);
            }
        }
        if ((value = RDBConnectionManager.getValue(DBCP_MAXIDLE, props)) != null) {
            try {
                config.maxIdle = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                throw new RDBServiceException(e);
            }
        }
        if ((value = RDBConnectionManager.getValue(DBCP_MINIDLE, props)) != null) {
            try {
                config.minIdle = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                throw new RDBServiceException(e);
            }
        }
        if ((value = RDBConnectionManager.getValue(DBCP_MAXACTIVE, props)) != null) {
            try {
                config.maxActive = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                throw new RDBServiceException(e);
            }
        }
        if ((value = RDBConnectionManager.getValue(DBCP_MAXWAIT, props)) != null) {
            try {
                config.maxWait = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                throw new RDBServiceException(e);
            }
        }
        return config;
    }

    private static String getValue(String name, Map<String, String> props) {
        String value = props.get(name);
        if (value == null) {
            value = props.get("org.apache.commons.dbcp." + name);
        }
        return value;
    }

    static {
        DS = null;
        _pool = null;
    }
}

