/*
 * Decompiled with CFR 0.152.
 */
package org.cloudgraph.rdb.service;

import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.Type;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudgraph.rdb.filter.FilterAssembler;
import org.cloudgraph.rdb.service.AliasMap;
import org.cloudgraph.rdb.service.JDBCSupport;
import org.cloudgraph.rdb.service.RDBDataConverter;
import org.plasma.query.collector.SelectionCollector;
import org.plasma.query.model.Where;
import org.plasma.sdo.PlasmaDataGraph;
import org.plasma.sdo.PlasmaDataObject;
import org.plasma.sdo.PlasmaNode;
import org.plasma.sdo.PlasmaProperty;
import org.plasma.sdo.PlasmaType;
import org.plasma.sdo.access.DataAccessException;
import org.plasma.sdo.access.DataGraphAssembler;
import org.plasma.sdo.access.provider.common.PropertyPair;
import org.plasma.sdo.core.CoreNode;
import org.plasma.sdo.helper.PlasmaDataFactory;
import org.plasma.sdo.profile.KeyType;

public class GraphAssembler
extends JDBCSupport
implements DataGraphAssembler {
    private static Log log = LogFactory.getLog(GraphAssembler.class);
    private static Set<Property> EMPTY_PROPERTY_SET = new HashSet<Property>();
    private PlasmaType rootType;
    private PlasmaDataObject root;
    private SelectionCollector collector;
    private Timestamp snapshotDate;
    private Connection con;
    private Map<Integer, PlasmaDataObject> dataObjectMap = new HashMap<Integer, PlasmaDataObject>();
    private Comparator<PropertyPair> nameComparator;
    private HashSet<PlasmaProperty> rightTraversalProperties = new HashSet();

    private GraphAssembler() {
    }

    public GraphAssembler(PlasmaType rootType, SelectionCollector collector, Timestamp snapshotDate, Connection con) {
        this.rootType = rootType;
        this.collector = collector;
        this.snapshotDate = snapshotDate;
        this.con = con;
        this.converter = RDBDataConverter.INSTANCE;
        this.nameComparator = new Comparator<PropertyPair>(){

            @Override
            public int compare(PropertyPair o1, PropertyPair o2) {
                return o1.getProp().getName().compareTo(o2.getProp().getName());
            }
        };
    }

    public void assemble(List<PropertyPair> results) throws SQLException {
        PlasmaDataGraph dataGraph = PlasmaDataFactory.INSTANCE.createDataGraph();
        this.root = (PlasmaDataObject)dataGraph.createRootObject((Type)this.rootType);
        if (log.isDebugEnabled()) {
            log.debug((Object)("assembling root: " + this.root.getType().getName()));
        }
        CoreNode rootNode = (CoreNode)this.root;
        if (this.snapshotDate != null) {
            rootNode.setValue("snapshotTimestamp", (Object)this.snapshotDate);
        }
        for (PropertyPair pair : results) {
            if (!pair.getProp().getType().isDataType()) continue;
            rootNode.setValue(pair.getProp().getName(), pair.getValue());
        }
        int key = this.createHashKey((PlasmaType)this.root.getType(), results);
        if (log.isDebugEnabled()) {
            log.debug((Object)("mapping root " + key + "->" + this.root));
        }
        this.dataObjectMap.put(key, this.root);
        for (PropertyPair pair : results) {
            if (pair.getProp().isMany() || pair.getProp().getType().isDataType()) continue;
            ArrayList<PropertyPair> childKeyProps = new ArrayList<PropertyPair>();
            List childPkProps = ((PlasmaType)pair.getProp().getType()).findProperties(KeyType.primary);
            if (childPkProps.size() == 1) {
                childKeyProps.add(new PropertyPair((PlasmaProperty)childPkProps.get(0), pair.getValue()));
            } else {
                this.throwPriKeyError(childPkProps, pair.getProp().getType(), (Property)pair.getProp());
            }
            this.assemble((PlasmaType)pair.getProp().getType(), this.root, pair.getProp(), childKeyProps, 1);
        }
        Set props = this.collector.getProperties((Type)this.rootType);
        for (Property p : props) {
            PlasmaProperty prop = (PlasmaProperty)p;
            if (!prop.isMany() || prop.getType().isDataType()) continue;
            PlasmaProperty opposite = (PlasmaProperty)prop.getOpposite();
            if (opposite == null) {
                throw new DataAccessException("no opposite property found - cannot map from many property, " + prop.toString());
            }
            ArrayList<PropertyPair> childKeyProps = new ArrayList<PropertyPair>();
            List rootPkProps = ((PlasmaType)this.root.getType()).findProperties(KeyType.primary);
            if (rootPkProps.size() == 1) {
                childKeyProps.add(new PropertyPair(opposite, this.root.get((Property)rootPkProps.get(0))));
            } else {
                this.throwPriKeyError(rootPkProps, this.root.getType(), (Property)prop);
            }
            this.assemble((PlasmaType)prop.getType(), this.root, prop, childKeyProps, 1);
        }
    }

    private void assemble(PlasmaType targetType, PlasmaDataObject source, PlasmaProperty sourceProperty, List<PropertyPair> childKeyPairs, int level) throws SQLException {
        Set<Property> props = this.collector.getProperties((Type)targetType, level);
        if (props == null) {
            props = EMPTY_PROPERTY_SET;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(String.valueOf(level) + ":assemble: " + source.getType().getName() + "." + sourceProperty.getName() + "->" + targetType.getName() + ": " + props));
        }
        List<List<PropertyPair>> result = null;
        Where where = this.collector.getPredicate((Property)sourceProperty);
        if (where == null) {
            StringBuilder query = this.createSelect(targetType, props, childKeyPairs);
            result = this.fetch(targetType, query, props, this.con);
        } else {
            AliasMap aliasMap = new AliasMap(targetType);
            FilterAssembler filterAssembler = new FilterAssembler(where, (Type)targetType, aliasMap);
            StringBuilder query = this.createSelect(targetType, props, childKeyPairs, filterAssembler, aliasMap);
            result = this.fetch(targetType, query, props, filterAssembler.getParams(), this.con);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(String.valueOf(level) + ":results: " + result.size()));
        }
        HashMap<PlasmaDataObject, List<PropertyPair>> resultMap = new HashMap<PlasmaDataObject, List<PropertyPair>>();
        for (List<PropertyPair> row : result) {
            PlasmaDataObject target = this.findDataObject(targetType, row);
            if (target == null) {
                target = this.createDataObject(row, source, sourceProperty);
                resultMap.put(target, row);
                continue;
            }
            this.link(target, source, sourceProperty);
        }
        for (PlasmaDataObject target : resultMap.keySet()) {
            List row = (List)resultMap.get(target);
            for (PropertyPair pair : row) {
                if (pair.getProp().isMany() || pair.getProp().getType().isDataType() || !pair.isQueryProperty()) continue;
                PlasmaProperty opposite = (PlasmaProperty)pair.getProp().getOpposite();
                if (opposite != null && this.rightTraversalProperties.contains(opposite)) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)(String.valueOf(level) + ":skipping traversal for, " + pair.getProp().isMany() + ") " + pair.getProp().toString() + " - opposite is a registered right traversal"));
                    continue;
                }
                ArrayList<PropertyPair> nextKeyPairs = new ArrayList<PropertyPair>();
                List nextKeyProps = ((PlasmaType)pair.getProp().getType()).findProperties(KeyType.primary);
                if (nextKeyProps.size() == 1) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(String.valueOf(level) + ":found single PK for type, " + pair.getProp().getType()));
                    }
                    PlasmaProperty next = (PlasmaProperty)nextKeyProps.get(0);
                    nextKeyPairs.add(new PropertyPair(next, pair.getValue()));
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(String.valueOf(level) + ":added single PK, " + next.toString()));
                    }
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(String.valueOf(level) + ":found multiple PK's - throwing PK error"));
                    }
                    this.throwPriKeyError(nextKeyProps, pair.getProp().getType(), (Property)pair.getProp());
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)(String.valueOf(level) + ":traverse: (" + pair.getProp().isMany() + ") " + pair.getProp().toString() + ":" + String.valueOf(pair.getValue())));
                }
                this.assemble((PlasmaType)pair.getProp().getType(), target, pair.getProp(), nextKeyPairs, level + 1);
            }
            for (Property p : props) {
                PlasmaProperty prop = (PlasmaProperty)p;
                if (!prop.isMany() || prop.getType().isDataType()) continue;
                PlasmaProperty opposite = (PlasmaProperty)prop.getOpposite();
                if (opposite == null) {
                    throw new DataAccessException("no opposite property found - cannot map from many property, " + prop.getType() + "." + prop.getName());
                }
                if (this.rightTraversalProperties.contains(opposite)) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)(String.valueOf(level) + ":skipping traversal for (" + prop.isMany() + ") " + prop.toString() + " - opposite is a registered right traversal"));
                    continue;
                }
                ArrayList<PropertyPair> childKeyProps = new ArrayList<PropertyPair>();
                List nextKeyProps = targetType.findProperties(KeyType.primary);
                if (nextKeyProps.size() == 1) {
                    childKeyProps.add(new PropertyPair(opposite, target.get((Property)nextKeyProps.get(0))));
                } else {
                    this.throwPriKeyError(nextKeyProps, (Type)targetType, (Property)prop);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)(String.valueOf(level) + ":traverse: (" + prop.isMany() + ") " + prop.toString() + " - " + childKeyProps.toArray().toString()));
                }
                this.assemble((PlasmaType)prop.getType(), target, prop, childKeyProps, level + 1);
            }
        }
    }

    private PlasmaDataObject createDataObject(List<PropertyPair> row, PlasmaDataObject source, PlasmaProperty sourceProperty) {
        PlasmaDataObject target = (PlasmaDataObject)source.createDataObject((Property)sourceProperty);
        CoreNode node = (CoreNode)target;
        if (log.isDebugEnabled()) {
            log.debug((Object)("create: " + source.getType().getName() + "." + sourceProperty.getName() + "->" + target.getType().getName()));
        }
        if (this.snapshotDate != null) {
            node.setValue("snapshotTimestamp", (Object)this.snapshotDate);
        }
        for (PropertyPair pair : row) {
            if (!pair.getProp().getType().isDataType()) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("set: (" + pair.getValue() + ") " + pair.getProp().getContainingType().getName() + "." + pair.getProp().getName()));
            }
            node.setValue(pair.getProp().getName(), pair.getValue());
        }
        int key = this.createHashKey((PlasmaType)target.getType(), row);
        if (log.isDebugEnabled()) {
            log.debug((Object)("mapping " + key + "->" + target));
        }
        this.dataObjectMap.put(key, target);
        this.rightTraversalProperties.add(sourceProperty);
        return target;
    }

    private PlasmaDataObject findDataObject(PlasmaType type, List<PropertyPair> row) {
        int key = this.createHashKey(type, row);
        PlasmaDataObject result = this.dataObjectMap.get(key);
        if (log.isDebugEnabled()) {
            if (result != null) {
                log.debug((Object)("found existing mapping " + key + "->" + result));
            } else {
                log.debug((Object)("found no existing mapping for hash key: " + key));
            }
        }
        return result;
    }

    private int createHashKey(PlasmaType type, List<PropertyPair> row) {
        List pkProps;
        PropertyPair[] pairs = new PropertyPair[row.size()];
        row.toArray(pairs);
        Arrays.sort(pairs, this.nameComparator);
        int pkHash = type.getQualifiedName().hashCode();
        int fallBackHash = type.getQualifiedName().hashCode();
        int pks = 0;
        for (int i = 0; i < pairs.length; ++i) {
            Object value = pairs[i].getValue();
            if (value == null) {
                log.warn((Object)("null voue for property, " + pairs[i].getProp().toString()));
                continue;
            }
            if (pairs[i].getProp().isKey(KeyType.primary)) {
                pkHash ^= value.hashCode();
                fallBackHash ^= value.hashCode();
                ++pks;
                continue;
            }
            fallBackHash ^= value.hashCode();
        }
        if (pks > 0 && (pkProps = type.findProperties(KeyType.primary)).size() == pks) {
            return pkHash;
        }
        return fallBackHash;
    }

    private void link(PlasmaDataObject target, PlasmaDataObject source, PlasmaProperty sourceProperty) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("linking source (" + source.getUUIDAsString() + ") " + source.getType().getURI() + "#" + source.getType().getName() + "." + sourceProperty.getName() + "->(" + target.getUUIDAsString() + ") " + target.getType().getURI() + "#" + target.getType().getName()));
        }
        if (sourceProperty.isMany()) {
            PlasmaDataObject existingOpposite;
            PlasmaProperty opposite = (PlasmaProperty)sourceProperty.getOpposite();
            if (opposite != null && !opposite.isMany() && target.isSet((Property)opposite) && (existingOpposite = (PlasmaDataObject)target.get((Property)opposite)) != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("encountered existing opposite (" + existingOpposite.getType().getName() + ") value found while creating link (" + source.getUUIDAsString() + ") " + source.getType().getURI() + "#" + source.getType().getName() + "." + sourceProperty.getName() + "->(" + target.getUUIDAsString() + ") " + target.getType().getURI() + "#" + target.getType().getName() + " - no link created"));
                }
                return;
            }
            ArrayList<PlasmaDataObject> list = source.getList((Property)sourceProperty);
            if (list == null) {
                list = new ArrayList<PlasmaDataObject>();
            }
            if (log.isDebugEnabled()) {
                for (DataObject dataObject : list) {
                    log.debug((Object)("existing: (" + ((PlasmaNode)dataObject).getUUIDAsString() + ") " + dataObject.getType().getURI() + "#" + dataObject.getType().getName()));
                }
            }
            if (!list.contains(target)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("adding target  (" + source.getUUIDAsString() + ") " + source.getType().getURI() + "#" + source.getType().getName() + "." + sourceProperty.getName() + "->(" + target.getUUIDAsString() + ") " + target.getType().getURI() + "#" + target.getType().getName()));
                }
                if (target.getContainer() == null) {
                    target.setContainer((DataObject)source);
                    target.setContainmentProperty((Property)sourceProperty);
                }
                list.add(target);
                source.setList((Property)sourceProperty, list);
            }
        } else {
            PlasmaDataObject existing = (PlasmaDataObject)source.get((Property)sourceProperty);
            if (existing == null) {
                source.set((Property)sourceProperty, (Object)target);
                if (target.getContainer() == null) {
                    target.setContainer((DataObject)source);
                    target.setContainmentProperty((Property)sourceProperty);
                }
            } else if (!existing.getUUIDAsString().equals(target.getUUIDAsString()) && log.isDebugEnabled()) {
                log.debug((Object)("encountered existing (" + existing.getType().getName() + ") value found while creating link (" + source.getUUIDAsString() + ") " + source.getType().getURI() + "#" + source.getType().getName() + "." + sourceProperty.getName() + "->(" + target.getUUIDAsString() + ") " + target.getType().getURI() + "#" + target.getType().getName()));
            }
        }
    }

    private void throwPriKeyError(List<Property> rootPkProps, Type type, Property prop) {
        if (prop.isMany()) {
            if (rootPkProps.size() == 0) {
                throw new DataAccessException("no pri-keys found for " + type.getURI() + "#" + type.getName() + " - cannot map from many property, " + prop.getType() + "." + prop.getName());
            }
            throw new DataAccessException("multiple pri-keys found for " + type.getURI() + "#" + type.getName() + " - cannot map from many property, " + prop.getType() + "." + prop.getName());
        }
        if (rootPkProps.size() == 0) {
            throw new DataAccessException("no pri-keys found for " + type.getURI() + "#" + type.getName() + " - cannot map from singular property, " + prop.getType() + "." + prop.getName());
        }
        throw new DataAccessException("multiple pri-keys found for " + type.getURI() + "#" + type.getName() + " - cannot map from singular property, " + prop.getType() + "." + prop.getName());
    }

    public PlasmaDataGraph getDataGraph() {
        return (PlasmaDataGraph)this.root.getDataGraph();
    }

    public void clear() {
        this.root = null;
        this.dataObjectMap.clear();
        this.rightTraversalProperties.clear();
    }
}

