/*
 * Decompiled with CFR 0.152.
 */
package org.cloudgraph.rdb.service;

import commonj.sdo.Property;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudgraph.rdb.filter.FilterAssembler;
import org.cloudgraph.rdb.service.AliasMap;
import org.cloudgraph.rdb.service.RDBDataConverter;
import org.plasma.sdo.DataFlavor;
import org.plasma.sdo.PlasmaDataObject;
import org.plasma.sdo.PlasmaProperty;
import org.plasma.sdo.PlasmaType;
import org.plasma.sdo.access.DataAccessException;
import org.plasma.sdo.access.provider.common.PropertyPair;
import org.plasma.sdo.core.CoreDataObject;
import org.plasma.sdo.profile.ConcurrencyType;
import org.plasma.sdo.profile.ConcurrentDataFlavor;
import org.plasma.sdo.profile.KeyType;

public abstract class JDBCSupport {
    private static Log log = LogFactory.getFactory().getInstance(JDBCSupport.class);
    protected RDBDataConverter converter = RDBDataConverter.INSTANCE;

    protected JDBCSupport() {
    }

    protected StringBuilder createSelectForUpdate(PlasmaType type, List<PropertyPair> keyValues, int waitSeconds) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ");
        ArrayList<Object> props = new ArrayList<Object>();
        for (PropertyPair pair : keyValues) {
            props.add(pair.getProp());
        }
        Property lockingUserProperty = type.findProperty(ConcurrencyType.pessimistic, ConcurrentDataFlavor.user);
        if (lockingUserProperty != null) {
            props.add(lockingUserProperty);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("could not find locking user property for type, " + type.getURI() + "#" + type.getName()));
        }
        Property lockingTimestampProperty = type.findProperty(ConcurrencyType.pessimistic, ConcurrentDataFlavor.time);
        if (lockingTimestampProperty != null) {
            props.add(lockingTimestampProperty);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("could not find locking timestamp property for type, " + type.getURI() + "#" + type.getName()));
        }
        Property concurrencyUserProperty = type.findProperty(ConcurrencyType.optimistic, ConcurrentDataFlavor.user);
        if (concurrencyUserProperty != null) {
            props.add(concurrencyUserProperty);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("could not find optimistic concurrency (username) property for type, " + type.getURI() + "#" + type.getName()));
        }
        Property concurrencyTimestampProperty = type.findProperty(ConcurrencyType.optimistic, ConcurrentDataFlavor.time);
        if (concurrencyTimestampProperty != null) {
            props.add(concurrencyTimestampProperty);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("could not find optimistic concurrency timestamp property for type, " + type.getURI() + "#" + type.getName()));
        }
        int i = 0;
        for (Property property : props) {
            PlasmaProperty prop = (PlasmaProperty)property;
            if (prop.isMany() && !prop.getType().isDataType()) continue;
            if (i > 0) {
                sql.append(", ");
            }
            sql.append("t0.");
            sql.append(prop.getPhysicalName());
            ++i;
        }
        sql.append(" FROM ");
        sql.append(this.getQualifiedPhysicalName(type));
        sql.append(" t0 ");
        sql.append(" WHERE ");
        for (int k = 0; k < keyValues.size(); ++k) {
            if (k > 0) {
                sql.append(", ");
            }
            PropertyPair propertyPair = keyValues.get(k);
            sql.append("t0.");
            sql.append(propertyPair.getProp().getPhysicalName());
            sql.append(" = ");
            this.appendValue(propertyPair, sql);
        }
        sql.append(" FOR UPDATE");
        return sql;
    }

    protected String getQualifiedPhysicalName(PlasmaType type) {
        String packageName = type.getPackagePhysicalName();
        if (packageName != null) {
            return packageName + "." + type.getPhysicalName();
        }
        return type.getPhysicalName();
    }

    protected StringBuilder createSelect(PlasmaType type, List<String> names, List<PropertyPair> keyValues) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ");
        int count = 0;
        List pkProps = type.findProperties(KeyType.primary);
        for (Property pkProp : pkProps) {
            if (names.contains(pkProp.getName())) continue;
            if (count > 0) {
                sql.append(", ");
            }
            sql.append("t0.");
            sql.append(((PlasmaProperty)pkProp).getPhysicalName());
            ++count;
        }
        for (String name : names) {
            PlasmaProperty prop = (PlasmaProperty)type.getProperty(name);
            if (prop.isMany() && !prop.getType().isDataType()) continue;
            if (count > 0) {
                sql.append(", ");
            }
            sql.append("t0.");
            sql.append(prop.getPhysicalName());
            ++count;
        }
        sql.append(" FROM ");
        sql.append(this.getQualifiedPhysicalName(type));
        sql.append(" t0 ");
        sql.append(" WHERE ");
        for (count = 0; count < keyValues.size(); ++count) {
            if (count > 0) {
                sql.append(" AND ");
            }
            PropertyPair propValue = keyValues.get(count);
            sql.append("t0.");
            sql.append(propValue.getProp().getPhysicalName());
            sql.append(" = ");
            this.appendValue(propValue, sql);
        }
        return sql;
    }

    protected StringBuilder createSelect(PlasmaType type, List<String> names, List<PropertyPair> keyValues, FilterAssembler filterAssembler, AliasMap aliasMap) throws SQLException {
        PropertyPair propValue;
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ");
        int count = 0;
        List pkProps = type.findProperties(KeyType.primary);
        for (Property pkProp : pkProps) {
            if (names.contains(pkProp.getName())) continue;
            if (count > 0) {
                sql.append(", ");
            }
            sql.append("t0.");
            sql.append(((PlasmaProperty)pkProp).getPhysicalName());
            ++count;
        }
        for (String name : names) {
            PlasmaProperty prop = (PlasmaProperty)type.getProperty(name);
            if (prop.isMany() && !prop.getType().isDataType()) continue;
            if (count > 0) {
                sql.append(", ");
            }
            sql.append("t0.");
            sql.append(prop.getPhysicalName());
            ++count;
        }
        sql.append(" FROM ");
        Iterator<PlasmaType> it = aliasMap.getTypes();
        count = 0;
        while (it.hasNext()) {
            PlasmaType aliasType = it.next();
            String alias = aliasMap.getAlias(aliasType);
            if (count > 0) {
                sql.append(", ");
            }
            sql.append(this.getQualifiedPhysicalName(aliasType));
            sql.append(" ");
            sql.append(alias);
            ++count;
        }
        sql.append(" ");
        sql.append(filterAssembler.getFilter());
        for (count = 0; count < keyValues.size(); ++count) {
            sql.append(" AND ");
            propValue = keyValues.get(count);
            sql.append("t0.");
            sql.append(propValue.getProp().getPhysicalName());
            sql.append(" = ");
            this.appendValue(propValue, sql);
        }
        sql.append(" ORDER BY ");
        for (count = 0; count < keyValues.size(); ++count) {
            if (count > 0) {
                sql.append(", ");
            }
            propValue = keyValues.get(count);
            sql.append("t0.");
            sql.append(propValue.getProp().getPhysicalName());
        }
        return sql;
    }

    private void appendValue(PropertyPair propValue, StringBuilder sql) throws SQLException {
        PlasmaProperty dataProperty = propValue.getProp();
        if (!propValue.getProp().getType().isDataType()) {
            PlasmaType oppositeType = (PlasmaType)propValue.getProp().getType();
            List pkPropList = oppositeType.findProperties(KeyType.primary);
            if (pkPropList == null || pkPropList.size() == 0) {
                throw new DataAccessException("no pri-key properties found for type '" + oppositeType.getName() + "'");
            }
            if (pkPropList.size() > 1) {
                throw new DataAccessException("multiple pri-key properties found for type '" + oppositeType.getName() + "' - cannot map to generated keys");
            }
            dataProperty = (PlasmaProperty)pkPropList.get(0);
        }
        Object jdbcValue = RDBDataConverter.INSTANCE.toJDBCDataValue(dataProperty, propValue.getValue());
        DataFlavor dataFlavor = dataProperty.getDataFlavor();
        switch (dataFlavor) {
            case string: 
            case temporal: 
            case other: {
                sql.append("'");
                sql.append(jdbcValue);
                sql.append("'");
                break;
            }
            default: {
                sql.append(jdbcValue);
            }
        }
    }

    protected StringBuilder createInsert(PlasmaType type, Map<String, PropertyPair> values) {
        PlasmaProperty prop;
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT INTO ");
        sql.append(this.getQualifiedPhysicalName(type));
        sql.append("(");
        int i = 0;
        for (PropertyPair pair : values.values()) {
            prop = pair.getProp();
            if (prop.isMany() && !prop.getType().isDataType()) continue;
            if (i > 0) {
                sql.append(", ");
            }
            sql.append(pair.getProp().getPhysicalName());
            pair.setColumn(i + 1);
            ++i;
        }
        sql.append(") VALUES (");
        i = 0;
        for (PropertyPair pair : values.values()) {
            prop = pair.getProp();
            if (prop.isMany() && !prop.getType().isDataType()) continue;
            if (i > 0) {
                sql.append(", ");
            }
            sql.append("?");
            ++i;
        }
        sql.append(")");
        return sql;
    }

    protected boolean hasUpdatableProperties(Map<String, PropertyPair> values) {
        for (PropertyPair pair : values.values()) {
            PlasmaProperty prop = pair.getProp();
            if (prop.isMany() && !prop.getType().isDataType() || prop.isKey(KeyType.primary)) continue;
            return true;
        }
        return false;
    }

    protected StringBuilder createUpdate(PlasmaType type, Map<String, PropertyPair> values) {
        PlasmaProperty prop;
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE ");
        sql.append(this.getQualifiedPhysicalName(type));
        sql.append(" t0 SET ");
        int i = 0;
        for (PropertyPair pair : values.values()) {
            prop = pair.getProp();
            if (prop.isMany() && !prop.getType().isDataType() || prop.isKey(KeyType.primary)) continue;
            if (i > 0) {
                sql.append(", ");
            }
            sql.append("t0.");
            sql.append(prop.getPhysicalName());
            sql.append(" = ?");
            pair.setColumn(i + 1);
            ++i;
        }
        sql.append(" WHERE ");
        for (PropertyPair pair : values.values()) {
            prop = pair.getProp();
            if (prop.isMany() && !prop.getType().isDataType() || !prop.isKey(KeyType.primary)) continue;
            sql.append("t0.");
            sql.append(pair.getProp().getPhysicalName());
            sql.append(" = ?");
            pair.setColumn(i + 1);
            ++i;
        }
        return sql;
    }

    protected StringBuilder createDelete(PlasmaType type, Map<String, PropertyPair> values) {
        StringBuilder sql = new StringBuilder();
        sql.append("DELETE FROM ");
        sql.append(this.getQualifiedPhysicalName(type));
        sql.append(" WHERE ");
        int i = 0;
        for (PropertyPair pair : values.values()) {
            PlasmaProperty prop = pair.getProp();
            if (prop.isMany() && !prop.getType().isDataType() || !prop.isKey(KeyType.primary)) continue;
            sql.append(pair.getProp().getPhysicalName());
            sql.append(" = ?");
            pair.setColumn(i + 1);
            ++i;
        }
        return sql;
    }

    protected List<List<PropertyPair>> fetch(PlasmaType type, StringBuilder sql, Connection con) {
        return this.fetch(type, sql, new Object[0], con);
    }

    protected List<List<PropertyPair>> fetch(PlasmaType type, StringBuilder sql, Object[] params, Connection con) {
        ArrayList<List<PropertyPair>> result = new ArrayList<List<PropertyPair>>();
        Statement statement = null;
        ResultSet rs = null;
        try {
            if (log.isDebugEnabled()) {
                if (params == null || params.length == 0) {
                    log.debug((Object)("fetch: " + sql.toString()));
                } else {
                    StringBuilder paramBuf = new StringBuilder();
                    paramBuf.append(" [");
                    for (int p = 0; p < params.length; ++p) {
                        if (p > 0) {
                            paramBuf.append(", ");
                        }
                        paramBuf.append(String.valueOf(params[p]));
                    }
                    paramBuf.append("]");
                    log.debug((Object)("fetch: " + sql.toString() + " " + paramBuf.toString()));
                }
            }
            statement = con.prepareStatement(sql.toString(), 1003, 1007);
            for (int i = 0; i < params.length; ++i) {
                statement.setString(i + 1, String.valueOf(params[i]));
            }
            statement.execute();
            rs = statement.getResultSet();
            ResultSetMetaData rsMeta = rs.getMetaData();
            int numcols = rsMeta.getColumnCount();
            while (rs.next()) {
                ArrayList<PropertyPair> row = new ArrayList<PropertyPair>(numcols);
                result.add(row);
                for (int i = 1; i <= numcols; ++i) {
                    PlasmaProperty prop;
                    String columnName = rsMeta.getColumnName(i);
                    int columnType = rsMeta.getColumnType(i);
                    Object value = this.converter.fromJDBCDataType(rs, i, columnType, prop = (PlasmaProperty)type.getProperty(columnName));
                    if (value == null) continue;
                    PropertyPair pair = new PropertyPair(prop, value);
                    row.add(pair);
                }
            }
        }
        catch (Throwable t) {
            throw new DataAccessException(t);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }

    protected List<PlasmaDataObject> fetch(PlasmaDataObject source, PlasmaProperty sourceProperty, StringBuilder sqlQuery, Connection con) {
        ArrayList<PlasmaDataObject> result = new ArrayList<PlasmaDataObject>();
        Statement statement = null;
        ResultSet rs = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("fetch: " + sqlQuery.toString()));
            }
            statement = con.prepareStatement(sqlQuery.toString(), 1003, 1007);
            statement.execute();
            rs = statement.getResultSet();
            ResultSetMetaData rsMeta = rs.getMetaData();
            int numcols = rsMeta.getColumnCount();
            while (rs.next()) {
                PlasmaDataObject target = (PlasmaDataObject)source.createDataObject((Property)sourceProperty);
                result.add(target);
                for (int i = 1; i <= numcols; ++i) {
                    String columnName = rsMeta.getColumnName(i);
                    int columnType = rsMeta.getColumnType(i);
                    PlasmaProperty prop = (PlasmaProperty)target.getType().getProperty(columnName);
                    Object value = this.converter.fromJDBCDataType(rs, i, columnType, prop);
                    if (!prop.isReadOnly()) {
                        target.set((Property)prop, value);
                        continue;
                    }
                    CoreDataObject coreObject = (CoreDataObject)target;
                    coreObject.setValue(prop.getName(), value);
                }
            }
        }
        catch (Throwable t) {
            throw new DataAccessException(t);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }

    protected Map<String, PropertyPair> fetchRowMap(PlasmaType type, StringBuilder sql, Connection con) {
        HashMap<String, PropertyPair> result = new HashMap<String, PropertyPair>();
        Statement statement = null;
        ResultSet rs = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("fetch: " + sql.toString()));
            }
            statement = con.prepareStatement(sql.toString(), 1003, 1007);
            statement.execute();
            rs = statement.getResultSet();
            ResultSetMetaData rsMeta = rs.getMetaData();
            int numcols = rsMeta.getColumnCount();
            while (rs.next()) {
                for (int i = 1; i <= numcols; ++i) {
                    PlasmaProperty prop;
                    String columnName = rsMeta.getColumnName(i);
                    int columnType = rsMeta.getColumnType(i);
                    Object value = this.converter.fromJDBCDataType(rs, i, columnType, prop = (PlasmaProperty)type.getProperty(columnName));
                    if (value == null) continue;
                    PropertyPair pair = new PropertyPair(prop, value);
                    result.put(prop.getName(), pair);
                }
            }
        }
        catch (Throwable t) {
            throw new DataAccessException(t);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }

    protected List<PropertyPair> fetchRow(PlasmaType type, StringBuilder sql, Connection con) {
        ArrayList<PropertyPair> result = new ArrayList<PropertyPair>();
        Statement statement = null;
        ResultSet rs = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("fetch: " + sql.toString()));
            }
            statement = con.prepareStatement(sql.toString(), 1003, 1007);
            statement.execute();
            rs = statement.getResultSet();
            ResultSetMetaData rsMeta = rs.getMetaData();
            int numcols = rsMeta.getColumnCount();
            while (rs.next()) {
                for (int i = 1; i <= numcols; ++i) {
                    PlasmaProperty prop;
                    String columnName = rsMeta.getColumnName(i);
                    int columnType = rsMeta.getColumnType(i);
                    Object value = this.converter.fromJDBCDataType(rs, i, columnType, prop = (PlasmaProperty)type.getProperty(columnName));
                    if (value == null) continue;
                    PropertyPair pair = new PropertyPair(prop, value);
                    result.add(pair);
                }
            }
        }
        catch (Throwable t) {
            throw new DataAccessException(t);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }

    protected void execute(PlasmaType type, StringBuilder sql, Map<String, PropertyPair> values, Connection con) {
        Statement statement = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("execute: " + sql.toString()));
                StringBuilder paramBuf = this.createParamDebug(values);
                log.debug((Object)("params: " + paramBuf.toString()));
            }
            statement = con.prepareStatement(sql.toString());
            for (PropertyPair pair : values.values()) {
                int jdbcType = this.converter.toJDBCDataType(pair.getProp(), pair.getValue());
                Object jdbcValue = this.converter.toJDBCDataValue(pair.getProp(), pair.getValue());
                statement.setObject(pair.getColumn(), jdbcValue, jdbcType);
            }
            statement.executeUpdate();
        }
        catch (Throwable t) {
            throw new DataAccessException(t);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    protected void executeInsert(PlasmaType type, StringBuilder sql, Map<String, PropertyPair> values, Connection con) {
        Statement statement = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("execute: " + sql.toString()));
                StringBuilder paramBuf = this.createParamDebug(values);
                log.debug((Object)("params: " + paramBuf.toString()));
            }
            statement = con.prepareStatement(sql.toString());
            for (PropertyPair pair : values.values()) {
                int jdbcType = this.converter.toJDBCDataType(pair.getProp(), pair.getValue());
                Object jdbcValue = this.converter.toJDBCDataValue(pair.getProp(), pair.getValue());
                statement.setObject(pair.getColumn(), jdbcValue, jdbcType);
            }
            statement.execute();
        }
        catch (Throwable t) {
            throw new DataAccessException(t);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    protected List<PropertyPair> executeInsertWithGeneratedKeys(PlasmaType type, StringBuilder sql, Map<String, PropertyPair> values, Connection con) {
        ArrayList<PropertyPair> resultKeys = new ArrayList<PropertyPair>();
        Statement statement = null;
        ResultSet generatedKeys = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("execute: " + sql.toString()));
                StringBuilder paramBuf = this.createParamDebug(values);
                log.debug((Object)("params: " + paramBuf.toString()));
            }
            statement = con.prepareStatement(sql.toString(), 1);
            for (PropertyPair pair : values.values()) {
                int jdbcType = this.converter.toJDBCDataType(pair.getProp(), pair.getValue());
                Object jdbcValue = this.converter.toJDBCDataValue(pair.getProp(), pair.getValue());
                statement.setObject(pair.getColumn(), jdbcValue, jdbcType);
            }
            statement.execute();
            generatedKeys = statement.getGeneratedKeys();
            ResultSetMetaData rsMeta = generatedKeys.getMetaData();
            int numcols = rsMeta.getColumnCount();
            if (log.isDebugEnabled()) {
                log.debug((Object)("returned " + numcols + " keys"));
            }
            if (generatedKeys.next()) {
                List pkPropList = type.findProperties(KeyType.primary);
                if (pkPropList == null || pkPropList.size() == 0) {
                    throw new DataAccessException("no pri-key properties found for type '" + type.getName() + "'");
                }
                if (pkPropList.size() > 1) {
                    throw new DataAccessException("multiple pri-key properties found for type '" + type.getName() + "' - cannot map to generated keys");
                }
                PlasmaProperty prop = (PlasmaProperty)pkPropList.get(0);
                for (int i = 1; i <= numcols; ++i) {
                    String columnName = rsMeta.getColumnName(i);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("returned key column '" + columnName + "'"));
                    }
                    int columnType = rsMeta.getColumnType(i);
                    Object value = this.converter.fromJDBCDataType(generatedKeys, i, columnType, prop);
                    PropertyPair pair = new PropertyPair(prop, value);
                    resultKeys.add(pair);
                }
            }
        }
        catch (Throwable t) {
            throw new DataAccessException(t);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return resultKeys;
    }

    private StringBuilder createParamDebug(Map<String, PropertyPair> values) throws SQLException {
        StringBuilder paramBuf = new StringBuilder();
        paramBuf.append("[");
        paramBuf.append("[");
        int i = 1;
        for (PropertyPair pair : values.values()) {
            int jdbcType = this.converter.toJDBCDataType(pair.getProp(), pair.getValue());
            Object jdbcValue = this.converter.toJDBCDataValue(pair.getProp(), pair.getValue());
            if (i > 1) {
                paramBuf.append(", ");
            }
            paramBuf.append("(");
            paramBuf.append(jdbcValue.getClass().getSimpleName());
            paramBuf.append("/");
            paramBuf.append(this.converter.getJdbcTypeName(jdbcType));
            paramBuf.append(")");
            paramBuf.append(String.valueOf(jdbcValue));
            ++i;
        }
        paramBuf.append("]");
        return paramBuf;
    }
}

