/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.zone;

import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.cloudfoundry.identity.uaa.zone.BrandingInformation;
import org.cloudfoundry.identity.uaa.zone.BrandingInformationSource;
import org.cloudfoundry.identity.uaa.zone.IdentityZone;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;

public class MergedZoneBrandingInformation
implements BrandingInformationSource {
    private static final BrandingInformationSource singleton = new MergedZoneBrandingInformation();

    private MergedZoneBrandingInformation() {
    }

    public static BrandingInformationSource resolveBranding() {
        return singleton;
    }

    public BrandingInformation.Banner getBanner() {
        return MergedZoneBrandingInformation.resolve(BrandingInformationSource::getBanner);
    }

    public String getCompanyName() {
        return MergedZoneBrandingInformation.resolve(BrandingInformationSource::getCompanyName);
    }

    public String getProductLogo() {
        return MergedZoneBrandingInformation.tryGet(IdentityZoneHolder.get(), BrandingInformationSource::getProductLogo).orElse(null);
    }

    public String getSquareLogo() {
        return MergedZoneBrandingInformation.resolve(BrandingInformationSource::getSquareLogo);
    }

    public String getFooterLegalText() {
        return MergedZoneBrandingInformation.resolve(BrandingInformationSource::getFooterLegalText);
    }

    public Map<String, String> getFooterLinks() {
        return MergedZoneBrandingInformation.resolve(BrandingInformationSource::getFooterLinks);
    }

    private static <T> T resolve(Function<BrandingInformationSource, T> brandingProperty) {
        return MergedZoneBrandingInformation.tryGet(IdentityZoneHolder.get(), brandingProperty).orElse(MergedZoneBrandingInformation.tryGet(IdentityZoneHolder.getUaaZone(), brandingProperty).orElse(null));
    }

    private static <T> Optional<T> tryGet(IdentityZone zone, Function<BrandingInformationSource, T> brandingProperty) {
        return Optional.ofNullable(zone.getConfig()).flatMap(c -> Optional.ofNullable(c.getBranding())).flatMap(b -> Optional.ofNullable(brandingProperty.apply((BrandingInformationSource)b)));
    }
}

