/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.zone;

import org.cloudfoundry.identity.uaa.approval.ApprovalStore;
import org.cloudfoundry.identity.uaa.client.ClientDetailsValidator;
import org.cloudfoundry.identity.uaa.zone.ClientServicesExtension;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.springframework.security.oauth2.provider.ClientDetails;

public class IdentityZoneEndpointClientRegistrationService {
    private final ClientServicesExtension clientDetailsService;
    private final ClientDetailsValidator clientDetailsValidator;
    private final ApprovalStore approvalStore;

    public IdentityZoneEndpointClientRegistrationService(ClientServicesExtension clientDetailsService, ClientDetailsValidator clientDetailsValidator, ApprovalStore approvalStore) {
        this.clientDetailsService = clientDetailsService;
        this.clientDetailsValidator = clientDetailsValidator;
        this.approvalStore = approvalStore;
    }

    public ClientDetails createClient(ClientDetails clientDetails) {
        ClientDetails validated = this.clientDetailsValidator.validate(clientDetails, ClientDetailsValidator.Mode.CREATE);
        this.clientDetailsService.addClientDetails(validated, IdentityZoneHolder.get().getId());
        return validated;
    }

    public ClientDetails deleteClient(String clientId) {
        String zoneId = IdentityZoneHolder.get().getId();
        ClientDetails clientDetails = this.clientDetailsService.loadClientByClientId(clientId, zoneId);
        this.clientDetailsValidator.validate(clientDetails, ClientDetailsValidator.Mode.DELETE);
        this.clientDetailsService.removeClientDetails(clientId, zoneId);
        this.approvalStore.revokeApprovalsForClient(clientId, zoneId);
        return clientDetails;
    }
}

