/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.web;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.springframework.util.StringUtils;

public class BackwardsCompatibleScopeParsingFilter
implements Filter {
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        chain.doFilter((ServletRequest)new ScopeRewriteRequestWrapper((HttpServletRequest)request), response);
    }

    public void destroy() {
    }

    public class ScopeRewriteRequestWrapper
    extends HttpServletRequestWrapper {
        public ScopeRewriteRequestWrapper(HttpServletRequest request) {
            super(request);
        }

        public String getParameter(String name) {
            if ("scope".equals(name)) {
                return this.translateScope(super.getParameter(name));
            }
            return super.getParameter(name);
        }

        public Map<String, String[]> getParameterMap() {
            HashMap<String, String[]> map = super.getParameterMap();
            if (map.containsKey("scope")) {
                HashMap<String, String[]> result = new HashMap<String, String[]>(map);
                result.put("scope", this.getParameterValues("scope"));
                map = result;
            }
            return map;
        }

        public String[] getParameterValues(String name) {
            String[] values = super.getParameterValues(name);
            if ("scope".equals(name)) {
                for (int i = 0; values != null && i < values.length; ++i) {
                    values[i] = this.translateScope(values[i]);
                }
            }
            return values;
        }

        private String translateScope(String scope) {
            return StringUtils.hasText((String)scope) ? scope.replace(',', ' ') : scope;
        }
    }
}

