/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import org.cloudfoundry.identity.uaa.authentication.GenericPasswordPolicy;
import org.passay.CharacterData;
import org.passay.CharacterRule;
import org.passay.EnglishCharacterData;
import org.passay.LengthRule;
import org.passay.MessageResolver;
import org.passay.PasswordValidator;
import org.passay.PropertiesMessageResolver;

public final class PasswordValidatorUtil {
    public static PropertiesMessageResolver messageResolver(String messagesResourcePath) {
        Properties props = new Properties();
        InputStream in = null;
        try {
            in = PasswordValidatorUtil.class.getResourceAsStream(messagesResourcePath);
            props.load(in);
            PropertiesMessageResolver propertiesMessageResolver = new PropertiesMessageResolver(props);
            return propertiesMessageResolver;
        }
        catch (Exception e) {
            throw new IllegalStateException("Error loading default message properties.", e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static PasswordValidator validator(GenericPasswordPolicy policy, MessageResolver messageResolver) {
        ArrayList<Object> rules = new ArrayList<Object>();
        int minLength = Math.max(1, policy.getMinLength());
        int maxLength = policy.getMaxLength() > 0 ? policy.getMaxLength() : Integer.MAX_VALUE;
        rules.add(new LengthRule(minLength, maxLength));
        if (policy.getRequireUpperCaseCharacter() > 0) {
            rules.add(new CharacterRule((CharacterData)EnglishCharacterData.UpperCase, policy.getRequireUpperCaseCharacter()));
        }
        if (policy.getRequireLowerCaseCharacter() > 0) {
            rules.add(new CharacterRule((CharacterData)EnglishCharacterData.LowerCase, policy.getRequireLowerCaseCharacter()));
        }
        if (policy.getRequireDigit() > 0) {
            rules.add(new CharacterRule((CharacterData)EnglishCharacterData.Digit, policy.getRequireDigit()));
        }
        if (policy.getRequireSpecialCharacter() > 0) {
            rules.add(new CharacterRule((CharacterData)EnglishCharacterData.Special, policy.getRequireSpecialCharacter()));
        }
        return new PasswordValidator(messageResolver, rules);
    }
}

