/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.security.web;

import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.http.HttpStatus;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.util.RedirectUrlBuilder;
import org.springframework.util.Assert;

@ManagedResource(objectName="cloudfoundry.identity:name=FilterChainProcessor", description="Ability to dump requests through JMX")
public class SecurityFilterChainPostProcessor
implements BeanPostProcessor {
    private final Log logger = LogFactory.getLog(this.getClass());
    private boolean requireHttps = false;
    private List<String> redirectToHttps = Collections.emptyList();
    private List<String> ignore = Collections.emptyList();
    private boolean dumpRequests = false;
    private Map<Class<? extends Exception>, ReasonPhrase> errorMap = new HashMap<Class<? extends Exception>, ReasonPhrase>();
    private Map<FilterPosition, Filter> additionalFilters;

    public void setErrorMap(Map<Class<? extends Exception>, ReasonPhrase> errorMap) {
        this.errorMap = errorMap;
    }

    public Map<Class<? extends Exception>, ReasonPhrase> getErrorMap() {
        return this.errorMap;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof SecurityFilterChain && !this.ignore.contains(beanName)) {
            this.logger.info((Object)("Processing security filter chain " + beanName));
            SecurityFilterChain fc = (SecurityFilterChain)bean;
            HttpsEnforcementFilter uaaFilter = new HttpsEnforcementFilter(beanName, this.redirectToHttps.contains(beanName));
            fc.getFilters().add(0, uaaFilter);
            if (this.additionalFilters != null) {
                for (Map.Entry<FilterPosition, Filter> entry : this.additionalFilters.entrySet()) {
                    int position = entry.getKey().getPosition(fc);
                    if (position > fc.getFilters().size()) {
                        fc.getFilters().add(entry.getValue());
                        continue;
                    }
                    fc.getFilters().add(position, entry.getValue());
                }
            }
        }
        return bean;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public void setRequireHttps(boolean requireHttps) {
        this.requireHttps = requireHttps;
    }

    public boolean isRequireHttps() {
        return this.requireHttps;
    }

    @ManagedAttribute(description="Enable dumping of incoming requests to the debug log")
    public void setDumpRequests(boolean dumpRequests) {
        this.dumpRequests = dumpRequests;
    }

    public void setRedirectToHttps(List<String> redirectToHttps) {
        Assert.notNull(redirectToHttps);
        this.redirectToHttps = redirectToHttps;
    }

    public void setIgnore(List<String> ignore) {
        Assert.notNull(ignore);
        this.ignore = ignore;
    }

    public void setAdditionalFilters(Map<FilterPosition, Filter> additionalFilters) {
        this.additionalFilters = additionalFilters;
    }

    public static class FilterPosition {
        private int position = Integer.MAX_VALUE;
        private PLACEMENT placement = PLACEMENT.POSITION;
        private Class<?> clazz;

        public void setPosition(int position) {
            this.position = position;
            this.placement = PLACEMENT.POSITION;
        }

        public void setBefore(Class<?> clazz) {
            this.clazz = clazz;
            this.placement = PLACEMENT.BEFORE;
        }

        public void setAfter(Class<?> clazz) {
            this.clazz = clazz;
            this.placement = PLACEMENT.AFTER;
        }

        public int getPosition(SecurityFilterChain chain) {
            int index = chain.getFilters().size();
            if (this.clazz != null) {
                int pos = 0;
                for (Filter f : chain.getFilters()) {
                    if (this.clazz.equals(f.getClass())) {
                        index = pos;
                        break;
                    }
                    ++pos;
                }
            }
            switch (this.placement) {
                case POSITION: {
                    return this.position;
                }
                case BEFORE: {
                    return index;
                }
                case AFTER: {
                    return Math.min(chain.getFilters().size(), index + 1);
                }
            }
            return index;
        }

        public static FilterPosition position(int pos) {
            FilterPosition filterPosition = new FilterPosition();
            filterPosition.setPosition(pos);
            return filterPosition;
        }

        public static FilterPosition after(Class<?> clazz) {
            FilterPosition filterPosition = new FilterPosition();
            filterPosition.setAfter(clazz);
            return filterPosition;
        }

        public static FilterPosition before(Class<?> clazz) {
            FilterPosition filterPosition = new FilterPosition();
            filterPosition.setBefore(clazz);
            return filterPosition;
        }

        static enum PLACEMENT {
            POSITION,
            BEFORE,
            AFTER;

        }
    }

    class UaaLoggingFilter
    implements Filter {
        final Log logger = LogFactory.getLog(this.getClass());
        protected final String name;

        UaaLoggingFilter(String name) {
            this.name = name;
        }

        public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
            HttpServletRequest request = (HttpServletRequest)req;
            HttpServletResponse response = (HttpServletResponse)res;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Filter chain '" + this.name + "' processing request " + request.getMethod() + " " + request.getRequestURI()));
                if (SecurityFilterChainPostProcessor.this.dumpRequests) {
                    this.logger.debug((Object)this.dumpRequest(request));
                }
            }
            try {
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
            catch (Exception x) {
                ReasonPhrase reasonPhrase;
                this.logger.error((Object)"Uncaught Exception:", (Throwable)x);
                if (req.getAttribute("javax.servlet.error.exception") == null) {
                    req.setAttribute("javax.servlet.error.exception", (Object)x);
                }
                if (null == (reasonPhrase = SecurityFilterChainPostProcessor.this.getErrorMap().get(x.getClass()))) {
                    for (Class<? extends Exception> clazz : SecurityFilterChainPostProcessor.this.getErrorMap().keySet()) {
                        if (!clazz.isAssignableFrom(x.getClass())) continue;
                        reasonPhrase = SecurityFilterChainPostProcessor.this.getErrorMap().get(clazz);
                        break;
                    }
                    if (null == reasonPhrase) {
                        reasonPhrase = new ReasonPhrase(HttpStatus.INTERNAL_SERVER_ERROR.value(), HttpStatus.INTERNAL_SERVER_ERROR.getReasonPhrase());
                    }
                }
                response.sendError(reasonPhrase.getCode(), reasonPhrase.getPhrase());
            }
        }

        protected final String dumpRequest(HttpServletRequest r) {
            StringBuilder builder = new StringBuilder(256);
            builder.append("\n    ").append(r.getMethod()).append(" ").append(r.getRequestURI()).append("\n");
            Enumeration e = r.getHeaderNames();
            while (e.hasMoreElements()) {
                String hdrName = (String)e.nextElement();
                Enumeration values = r.getHeaders(hdrName);
                while (values.hasMoreElements()) {
                    builder.append("    ").append(hdrName).append(": ").append((String)values.nextElement()).append("\n");
                }
            }
            return builder.toString();
        }

        public void init(FilterConfig filterConfig) throws ServletException {
        }

        public void destroy() {
        }
    }

    final class HttpsEnforcementFilter
    extends UaaLoggingFilter {
        private final int httpsPort = 443;
        private final boolean redirect;

        HttpsEnforcementFilter(String name, boolean redirect) {
            super(name);
            this.httpsPort = 443;
            this.redirect = redirect;
        }

        @Override
        public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
            HttpServletRequest request = (HttpServletRequest)req;
            HttpServletResponse response = (HttpServletResponse)res;
            if (request.isSecure() || !SecurityFilterChainPostProcessor.this.requireHttps) {
                if (this.redirect) {
                    response.setHeader("Strict-Transport-Security", "max-age=31536000");
                }
                super.doFilter(req, (ServletResponse)response, chain);
                return;
            }
            this.logger.debug((Object)("Bad (non-https) request received from: " + request.getRemoteHost()));
            if (SecurityFilterChainPostProcessor.this.dumpRequests) {
                this.logger.debug((Object)this.dumpRequest(request));
            }
            if (this.redirect) {
                RedirectUrlBuilder rb = new RedirectUrlBuilder();
                rb.setScheme("https");
                rb.setPort(443);
                rb.setContextPath(request.getContextPath());
                rb.setServletPath(request.getServletPath());
                rb.setPathInfo(request.getPathInfo());
                rb.setQuery(request.getQueryString());
                rb.setServerName(request.getServerName());
                String url = rb.getUrl();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Redirecting to " + url));
                }
                response.setHeader("Location", url);
                response.setStatus(301);
            } else {
                response.setContentType("application/json");
                response.sendError(400, "{\"error\": \"request must be over https\"}");
            }
        }
    }

    public static class ReasonPhrase {
        private int code;
        private String phrase;

        public ReasonPhrase(int code, String phrase) {
            this.code = code;
            this.phrase = phrase;
        }

        public int getCode() {
            return this.code;
        }

        public String getPhrase() {
            return this.phrase;
        }
    }
}

