/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.security.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixHttpsSchemeRequest
extends HttpServletRequestWrapper {
    private static final Logger logger = LoggerFactory.getLogger(FixHttpsSchemeRequest.class);

    public String getScheme() {
        String scheme = super.getScheme();
        logger.debug("Request X-Forwarded-Proto " + super.getHeader("X-Forwarded-Proto"));
        if ("http".equals(scheme) && "https".equals(super.getHeader("X-Forwarded-Proto"))) {
            scheme = "https";
        }
        return scheme;
    }

    public int getServerPort() {
        int port = super.getServerPort();
        String scheme = super.getScheme();
        if ("http".equals(scheme) && "https".equals(super.getHeader("X-Forwarded-Proto"))) {
            port = 443;
        }
        return port;
    }

    public StringBuffer getRequestURL() {
        StringBuffer url = new StringBuffer();
        String scheme = this.getScheme();
        int port = this.getServerPort();
        if (port < 0) {
            port = 80;
        }
        url.append(scheme);
        url.append("://");
        url.append(this.getServerName());
        if (scheme.equals("http") && port != 80 || scheme.equals("https") && port != 443) {
            url.append(':');
            url.append(port);
        }
        url.append(this.getRequestURI());
        return url;
    }

    public FixHttpsSchemeRequest(HttpServletRequest request) {
        super(request);
    }
}

