/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.resources.jdbc;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.cloudfoundry.identity.uaa.resources.jdbc.LimitSqlAdapter;

public class SQLServerLimitSqlAdapter
implements LimitSqlAdapter {
    @Override
    public String getLimitSql(String sql, int index, int size) {
        Pattern p = Pattern.compile(".+order\\s+by\\s+\\w+(\\s+asc|\\s+desc)?([\\s,]*\\w+(\\s+asc|\\s+desc)?)*\\s*$", 34);
        Matcher m = p.matcher(sql);
        if (m.matches()) {
            return sql + " OFFSET " + index + " ROWS FETCH NEXT " + size + " ROWS ONLY;";
        }
        return sql + " ORDER BY 1 OFFSET " + index + " ROWS FETCH NEXT " + size + " ROWS ONLY;";
    }

    @Override
    public String getDeleteExpiredQuery(String tablename, String primaryKeyColumn, String expiresColumn, int maxRows) {
        return "DELETE FROM " + tablename + " WHERE " + primaryKeyColumn + " IN (SELECT TOP " + maxRows + " " + primaryKeyColumn + " FROM " + tablename + " WHERE " + expiresColumn + " < ? ORDER BY " + expiresColumn + ")";
    }
}

