/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.provider.saml.idp;

import java.util.List;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import org.cloudfoundry.identity.uaa.provider.saml.idp.IdpSamlAuthenticationSuccessHandler;
import org.cloudfoundry.identity.uaa.provider.saml.idp.IdpWebSSOProfileOptions;
import org.cloudfoundry.identity.uaa.provider.saml.idp.IdpWebSsoProfile;
import org.cloudfoundry.identity.uaa.provider.saml.idp.SamlServiceProviderConfigurator;
import org.cloudfoundry.identity.uaa.provider.saml.idp.SamlServiceProviderHolder;
import org.opensaml.common.SAMLException;
import org.opensaml.common.SAMLObject;
import org.opensaml.saml2.core.AuthnRequest;
import org.opensaml.saml2.metadata.AssertionConsumerService;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.ws.message.encoder.MessageEncodingException;
import org.opensaml.xml.io.MarshallingException;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.signature.SignatureException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.ProviderNotFoundException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.saml.context.SAMLContextProvider;
import org.springframework.security.saml.context.SAMLMessageContext;
import org.springframework.security.saml.metadata.MetadataManager;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class IdpInitiatedLoginController {
    private static final Logger log = LoggerFactory.getLogger(IdpInitiatedLoginController.class);
    private IdpWebSsoProfile idpWebSsoProfile;
    private MetadataManager metadataManager;
    private SamlServiceProviderConfigurator configurator;
    private SAMLContextProvider contextProvider;
    private IdpSamlAuthenticationSuccessHandler idpSamlAuthenticationSuccessHandler;

    @RequestMapping(value={"/saml/idp/initiate"})
    public void initiate(@RequestParam(value="sp", required=false) String sp, HttpServletRequest request, HttpServletResponse response) {
        if (!StringUtils.hasText((String)sp)) {
            throw new ProviderNotFoundException("Missing sp request parameter. sp parameter must be a valid and configured entity ID");
        }
        log.debug(String.format("IDP is initiating authentication request to SP[%s]", sp));
        Optional<SamlServiceProviderHolder> holder = this.configurator.getSamlServiceProviders().stream().filter(serviceProvider -> sp.equals(serviceProvider.getSamlServiceProvider().getEntityId())).findFirst();
        if (!holder.isPresent()) {
            log.debug(String.format("SP[%s] was not found, aborting saml response", sp));
            throw new ProviderNotFoundException("Invalid sp entity ID. sp parameter must be a valid and configured entity ID");
        }
        if (!holder.get().getSamlServiceProvider().isActive()) {
            log.debug(String.format("SP[%s] is disabled, aborting saml response", sp));
            throw new ProviderNotFoundException("Service provider is disabled.");
        }
        if (!holder.get().getSamlServiceProvider().getConfig().isEnableIdpInitiatedSso()) {
            log.debug(String.format("SP[%s] initiated login is disabled, aborting saml response", sp));
            throw new ProviderNotFoundException("IDP initiated login is disabled for this service provider.");
        }
        String nameId = "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified";
        try {
            String assertionLocation = this.getAssertionConsumerURL(sp);
            log.debug(String.format("IDP is sending assertion for SP[%s] to %s", sp, assertionLocation));
            AuthnRequest authnRequest = this.idpWebSsoProfile.buildIdpInitiatedAuthnRequest(nameId, sp, assertionLocation);
            SAMLMessageContext samlContext = this.getSamlContext(sp, authnRequest, request, response);
            this.idpWebSsoProfile.sendResponse(SecurityContextHolder.getContext().getAuthentication(), samlContext, this.getIdpIniatedOptions());
            log.debug(String.format("IDP initiated authentication and responded to SP[%s]", sp));
        }
        catch (SAMLException | MetadataProviderException | MessageEncodingException | MarshallingException | SecurityException | SignatureException e) {
            log.debug(String.format("IDP is unable to process assertion for SP[%s]", sp), e);
            throw new ProviderNotFoundException("Unable to process SAML assertion. Response not sent.");
        }
    }

    public String getAssertionConsumerURL(String sp) throws MetadataProviderException {
        EntityDescriptor entityDescriptor = this.metadataManager.getEntityDescriptor(sp);
        SPSSODescriptor spssoDescriptor = entityDescriptor.getSPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol");
        List assertionConsumerServices = spssoDescriptor.getAssertionConsumerServices();
        Optional<AssertionConsumerService> defaultService = assertionConsumerServices.stream().filter(acs -> acs.isDefault()).findFirst();
        if (defaultService.isPresent()) {
            return defaultService.get().getLocation();
        }
        return ((AssertionConsumerService)assertionConsumerServices.get(0)).getLocation();
    }

    protected SAMLMessageContext getSamlContext(String spEntityId, AuthnRequest authnRequest, HttpServletRequest request, HttpServletResponse response) throws MetadataProviderException {
        SAMLMessageContext samlContext = this.contextProvider.getLocalAndPeerEntity(request, response);
        samlContext.setPeerEntityId(spEntityId);
        samlContext.setPeerEntityRole(new QName("urn:oasis:names:tc:SAML:2.0:metadata", "SPSSODescriptor", "md"));
        this.idpSamlAuthenticationSuccessHandler.populatePeerContext(samlContext);
        samlContext.setInboundSAMLMessage((SAMLObject)authnRequest);
        return samlContext;
    }

    protected IdpWebSSOProfileOptions getIdpIniatedOptions() {
        IdpWebSSOProfileOptions options = new IdpWebSSOProfileOptions();
        options.setAssertionsSigned(false);
        return options;
    }

    public void setIdpWebSsoProfile(IdpWebSsoProfile idpWebSsoProfile) {
        this.idpWebSsoProfile = idpWebSsoProfile;
    }

    public void setMetadataManager(MetadataManager metadataManager) {
        this.metadataManager = metadataManager;
    }

    public void setConfigurator(SamlServiceProviderConfigurator configurator) {
        this.configurator = configurator;
    }

    public void setContextProvider(SAMLContextProvider contextProvider) {
        this.contextProvider = contextProvider;
    }

    public void setIdpSamlAuthenticationSuccessHandler(IdpSamlAuthenticationSuccessHandler idpSamlAuthenticationSuccessHandler) {
        this.idpSamlAuthenticationSuccessHandler = idpSamlAuthenticationSuccessHandler;
    }

    @ExceptionHandler
    public String handleException(AuthenticationException ae, HttpServletRequest request, HttpServletResponse response) {
        response.setStatus(400);
        request.setAttribute("saml_error", (Object)ae.getMessage());
        return "external_auth_error";
    }
}

