/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.provider.saml;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.provider.saml.SamlMessageStorage;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.springframework.security.saml.storage.SAMLMessageStorage;
import org.springframework.security.saml.storage.SAMLMessageStorageFactory;

public class SamlSessionStorageFactory
implements SAMLMessageStorageFactory {
    private static Log logger = LogFactory.getLog(SamlSessionStorageFactory.class);
    public static final String SAML_REQUEST_DATA = SamlMessageStorage.class.getName() + ".saml.requests";

    public synchronized SAMLMessageStorage getMessageStorage(HttpServletRequest request) {
        if (IdentityZoneHolder.get().getConfig().getSamlConfig().isDisableInResponseToCheck()) {
            return null;
        }
        HttpSession session = request.getSession(true);
        if (session.getAttribute(SAML_REQUEST_DATA) == null) {
            session.setAttribute(SAML_REQUEST_DATA, (Object)new SamlMessageStorage());
        }
        logger.debug((Object)("Returning SAML message factory for session ID:" + session.getId()));
        return (SAMLMessageStorage)session.getAttribute(SAML_REQUEST_DATA);
    }
}

