/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.provider.saml;

import org.cloudfoundry.identity.uaa.provider.saml.SamlBindingNotSupportedException;
import org.opensaml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml2.metadata.SingleSignOnService;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.springframework.security.saml.metadata.MetadataManager;
import org.springframework.security.saml.processor.SAMLProcessor;
import org.springframework.security.saml.websso.WebSSOProfileImpl;
import org.springframework.security.saml.websso.WebSSOProfileOptions;

public class SPWebSSOProfileImpl
extends WebSSOProfileImpl {
    public SPWebSSOProfileImpl() {
    }

    public SPWebSSOProfileImpl(SAMLProcessor processor, MetadataManager manager) {
        super(processor, manager);
    }

    protected boolean isEndpointSupported(SingleSignOnService endpoint) throws MetadataProviderException {
        return "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST".equals(endpoint.getBinding()) || "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect".equals(endpoint.getBinding());
    }

    protected SingleSignOnService getSingleSignOnService(WebSSOProfileOptions options, IDPSSODescriptor idpssoDescriptor, SPSSODescriptor spDescriptor) throws MetadataProviderException {
        try {
            return super.getSingleSignOnService(options, idpssoDescriptor, spDescriptor);
        }
        catch (MetadataProviderException e) {
            throw new SamlBindingNotSupportedException(e.getMessage(), (Exception)((Object)e));
        }
    }
}

