/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.provider.saml;

import java.net.URI;
import java.net.URISyntaxException;
import org.cloudfoundry.identity.uaa.cache.UrlContentCache;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.springframework.web.client.RestTemplate;

public class FixedHttpMetaDataProvider {
    private RestTemplate trustingRestTemplate;
    private RestTemplate nonTrustingRestTemplate;
    private UrlContentCache cache;

    public byte[] fetchMetadata(String metadataURL, boolean isSkipSSLValidation) throws MetadataProviderException, URISyntaxException {
        this.validateMetadataURL(metadataURL);
        if (isSkipSSLValidation) {
            return this.cache.getUrlContent(metadataURL, this.trustingRestTemplate);
        }
        return this.cache.getUrlContent(metadataURL, this.nonTrustingRestTemplate);
    }

    private void validateMetadataURL(String metadataURL) throws MetadataProviderException {
        try {
            new URI(metadataURL);
        }
        catch (URISyntaxException e) {
            throw new MetadataProviderException("Illegal URL syntax", (Exception)e);
        }
    }

    public void setTrustingRestTemplate(RestTemplate trustingRestTemplate) {
        this.trustingRestTemplate = trustingRestTemplate;
    }

    public void setNonTrustingRestTemplate(RestTemplate nonTrustingRestTemplate) {
        this.nonTrustingRestTemplate = nonTrustingRestTemplate;
    }

    public void setCache(UrlContentCache cache) {
        this.cache = cache;
    }
}

