/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.provider;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.audit.event.SystemDeletable;
import org.cloudfoundry.identity.uaa.provider.AbstractIdentityProviderDefinition;
import org.cloudfoundry.identity.uaa.provider.IdentityProvider;
import org.cloudfoundry.identity.uaa.provider.IdentityProviderProvisioning;
import org.cloudfoundry.identity.uaa.provider.IdpAlreadyExistsException;
import org.cloudfoundry.identity.uaa.provider.KeystoneIdentityProviderDefinition;
import org.cloudfoundry.identity.uaa.provider.LdapIdentityProviderDefinition;
import org.cloudfoundry.identity.uaa.provider.OIDCIdentityProviderDefinition;
import org.cloudfoundry.identity.uaa.provider.RawXOAuthIdentityProviderDefinition;
import org.cloudfoundry.identity.uaa.provider.SamlIdentityProviderDefinition;
import org.cloudfoundry.identity.uaa.provider.UaaIdentityProviderDefinition;
import org.cloudfoundry.identity.uaa.util.JsonUtils;
import org.cloudfoundry.identity.uaa.util.ObjectUtils;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class JdbcIdentityProviderProvisioning
implements IdentityProviderProvisioning,
SystemDeletable {
    private static Log logger = LogFactory.getLog(JdbcIdentityProviderProvisioning.class);
    public static final String ID_PROVIDER_FIELDS = "id,version,created,lastmodified,name,origin_key,type,config,identity_zone_id,active";
    public static final String CREATE_IDENTITY_PROVIDER_SQL = "insert into identity_provider(id,version,created,lastmodified,name,origin_key,type,config,identity_zone_id,active) values (?,?,?,?,?,?,?,?,?,?)";
    public static final String IDENTITY_PROVIDERS_QUERY = "select id,version,created,lastmodified,name,origin_key,type,config,identity_zone_id,active from identity_provider where identity_zone_id=?";
    public static final String IDENTITY_ACTIVE_PROVIDERS_QUERY = "select id,version,created,lastmodified,name,origin_key,type,config,identity_zone_id,active from identity_provider where identity_zone_id=? and active=?";
    public static final String ID_PROVIDER_UPDATE_FIELDS = "version,lastmodified,name,type,config,active".replace(",", "=?,") + "=?";
    public static final String UPDATE_IDENTITY_PROVIDER_SQL = "update identity_provider set " + ID_PROVIDER_UPDATE_FIELDS + " where id=? and identity_zone_id=?";
    public static final String DELETE_IDENTITY_PROVIDER_BY_ORIGIN_SQL = "delete from identity_provider where identity_zone_id=? and origin_key = ?";
    public static final String DELETE_IDENTITY_PROVIDER_BY_ZONE_SQL = "delete from identity_provider where identity_zone_id=?";
    public static final String IDENTITY_PROVIDER_BY_ID_QUERY = "select id,version,created,lastmodified,name,origin_key,type,config,identity_zone_id,active from identity_provider where id=? and identity_zone_id=?";
    public static final String IDENTITY_PROVIDER_BY_ORIGIN_QUERY = "select id,version,created,lastmodified,name,origin_key,type,config,identity_zone_id,active from identity_provider where origin_key=? and identity_zone_id=? ";
    public static final String IDENTITY_PROVIDER_BY_ORIGIN_QUERY_ACTIVE = "select id,version,created,lastmodified,name,origin_key,type,config,identity_zone_id,active from identity_provider where origin_key=? and identity_zone_id=?  and active = ? ";
    protected final JdbcTemplate jdbcTemplate;
    private final RowMapper<IdentityProvider> mapper = new IdentityProviderRowMapper();

    public JdbcIdentityProviderProvisioning(JdbcTemplate jdbcTemplate) {
        Assert.notNull((Object)jdbcTemplate);
        this.jdbcTemplate = jdbcTemplate;
    }

    @Override
    public IdentityProvider retrieve(String id, String zoneId) {
        IdentityProvider identityProvider = (IdentityProvider)this.jdbcTemplate.queryForObject(IDENTITY_PROVIDER_BY_ID_QUERY, this.mapper, new Object[]{id, zoneId});
        return identityProvider;
    }

    @Override
    public List<IdentityProvider> retrieveActive(String zoneId) {
        return this.jdbcTemplate.query(IDENTITY_ACTIVE_PROVIDERS_QUERY, this.mapper, new Object[]{zoneId, true});
    }

    @Override
    public List<IdentityProvider> retrieveAll(boolean activeOnly, String zoneId) {
        if (activeOnly) {
            return this.retrieveActive(zoneId);
        }
        return this.jdbcTemplate.query(IDENTITY_PROVIDERS_QUERY, this.mapper, new Object[]{zoneId});
    }

    @Override
    public IdentityProvider retrieveByOrigin(String origin, String zoneId) {
        IdentityProvider identityProvider = (IdentityProvider)this.jdbcTemplate.queryForObject(IDENTITY_PROVIDER_BY_ORIGIN_QUERY_ACTIVE, this.mapper, new Object[]{origin, zoneId, true});
        return identityProvider;
    }

    @Override
    public IdentityProvider retrieveByOriginIgnoreActiveFlag(String origin, String zoneId) {
        IdentityProvider identityProvider = (IdentityProvider)this.jdbcTemplate.queryForObject(IDENTITY_PROVIDER_BY_ORIGIN_QUERY, this.mapper, new Object[]{origin, zoneId});
        return identityProvider;
    }

    @Override
    public IdentityProvider create(final IdentityProvider identityProvider, final String zoneId) {
        this.validate(identityProvider);
        final String id = UUID.randomUUID().toString();
        try {
            this.jdbcTemplate.update(CREATE_IDENTITY_PROVIDER_SQL, new PreparedStatementSetter(){

                public void setValues(PreparedStatement ps) throws SQLException {
                    int pos = 1;
                    ps.setString(pos++, id);
                    ps.setInt(pos++, identityProvider.getVersion());
                    ps.setTimestamp(pos++, new Timestamp(System.currentTimeMillis()));
                    ps.setTimestamp(pos++, new Timestamp(System.currentTimeMillis()));
                    ps.setString(pos++, identityProvider.getName());
                    ps.setString(pos++, identityProvider.getOriginKey());
                    ps.setString(pos++, identityProvider.getType());
                    ps.setString(pos++, JsonUtils.writeValueAsString((Object)identityProvider.getConfig()));
                    ps.setString(pos++, zoneId);
                    ps.setBoolean(pos++, identityProvider.isActive());
                }
            });
        }
        catch (DuplicateKeyException e) {
            throw new IdpAlreadyExistsException(e.getMostSpecificCause().getMessage());
        }
        return this.retrieve(id, zoneId);
    }

    @Override
    public IdentityProvider update(final IdentityProvider identityProvider, final String zoneId) {
        this.validate(identityProvider);
        this.jdbcTemplate.update(UPDATE_IDENTITY_PROVIDER_SQL, new PreparedStatementSetter(){

            public void setValues(PreparedStatement ps) throws SQLException {
                int pos = 1;
                ps.setInt(pos++, identityProvider.getVersion() + 1);
                ps.setTimestamp(pos++, new Timestamp(new Date().getTime()));
                ps.setString(pos++, identityProvider.getName());
                ps.setString(pos++, identityProvider.getType());
                ps.setString(pos++, JsonUtils.writeValueAsString((Object)identityProvider.getConfig()));
                ps.setBoolean(pos++, identityProvider.isActive());
                ps.setString(pos++, identityProvider.getId().trim());
                ps.setString(pos++, zoneId);
            }
        });
        return this.retrieve(identityProvider.getId(), zoneId);
    }

    protected void validate(IdentityProvider provider) {
        if (provider == null) {
            throw new NullPointerException("Provider can not be null.");
        }
        if (!StringUtils.hasText((String)provider.getIdentityZoneId())) {
            throw new DataIntegrityViolationException("Identity zone ID must be set.");
        }
        if ("saml".equals(provider.getType()) && provider.getConfig() != null) {
            SamlIdentityProviderDefinition saml = (SamlIdentityProviderDefinition)ObjectUtils.castInstance((Object)provider.getConfig(), SamlIdentityProviderDefinition.class);
            saml.setIdpEntityAlias(provider.getOriginKey());
            saml.setZoneId(provider.getIdentityZoneId());
            provider.setConfig((AbstractIdentityProviderDefinition)saml);
        }
    }

    @Override
    public int deleteByIdentityZone(String zoneId) {
        return this.jdbcTemplate.update(DELETE_IDENTITY_PROVIDER_BY_ZONE_SQL, new Object[]{zoneId});
    }

    @Override
    public int deleteByOrigin(String origin, String zoneId) {
        return this.jdbcTemplate.update(DELETE_IDENTITY_PROVIDER_BY_ORIGIN_SQL, new Object[]{zoneId, origin});
    }

    @Override
    public Log getLogger() {
        return logger;
    }

    private static final class IdentityProviderRowMapper
    implements RowMapper<IdentityProvider> {
        private IdentityProviderRowMapper() {
        }

        public IdentityProvider mapRow(ResultSet rs, int rowNum) throws SQLException {
            IdentityProvider identityProvider = new IdentityProvider();
            int pos = 1;
            identityProvider.setId(rs.getString(pos++).trim());
            identityProvider.setVersion(rs.getInt(pos++));
            identityProvider.setCreated((Date)rs.getTimestamp(pos++));
            identityProvider.setLastModified((Date)rs.getTimestamp(pos++));
            identityProvider.setName(rs.getString(pos++));
            identityProvider.setOriginKey(rs.getString(pos++));
            identityProvider.setType(rs.getString(pos++));
            String config = rs.getString(pos++);
            if (StringUtils.hasText((String)config)) {
                AbstractIdentityProviderDefinition definition;
                switch (identityProvider.getType()) {
                    case "saml": {
                        definition = (AbstractIdentityProviderDefinition)JsonUtils.readValue((String)config, SamlIdentityProviderDefinition.class);
                        break;
                    }
                    case "oauth2.0": {
                        definition = (AbstractIdentityProviderDefinition)JsonUtils.readValue((String)config, RawXOAuthIdentityProviderDefinition.class);
                        break;
                    }
                    case "oidc1.0": {
                        definition = (AbstractIdentityProviderDefinition)JsonUtils.readValue((String)config, OIDCIdentityProviderDefinition.class);
                        break;
                    }
                    case "uaa": {
                        definition = (AbstractIdentityProviderDefinition)JsonUtils.readValue((String)config, UaaIdentityProviderDefinition.class);
                        break;
                    }
                    case "ldap": {
                        definition = (AbstractIdentityProviderDefinition)JsonUtils.readValue((String)config, LdapIdentityProviderDefinition.class);
                        break;
                    }
                    case "keystone": {
                        definition = (AbstractIdentityProviderDefinition)JsonUtils.readValue((String)config, KeystoneIdentityProviderDefinition.class);
                        break;
                    }
                    default: {
                        definition = (AbstractIdentityProviderDefinition)JsonUtils.readValue((String)config, AbstractIdentityProviderDefinition.class);
                    }
                }
                if (definition != null) {
                    identityProvider.setConfig(definition);
                }
            }
            identityProvider.setIdentityZoneId(rs.getString(pos++));
            identityProvider.setActive(rs.getBoolean(pos++));
            return identityProvider;
        }
    }
}

