/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.oauth.openid;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.cloudfoundry.identity.uaa.approval.ApprovalService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.oauth2.common.exceptions.InvalidTokenException;
import org.springframework.security.oauth2.provider.client.BaseClientDetails;

public class IdTokenGranter {
    private static final Logger logger = LoggerFactory.getLogger(IdTokenGranter.class);
    private final String REQUIRED_OPENID_SCOPE = "openid";
    private final List<String> GRANT_TYPES_THAT_MAY_GET_ID_TOKENS = Lists.newArrayList((Object[])new String[]{"authorization_code", "password", "implicit", "refresh_token"});
    private final ApprovalService approvalService;

    public IdTokenGranter(ApprovalService approvalService) {
        this.approvalService = approvalService;
    }

    public boolean shouldSendIdToken(String userId, BaseClientDetails clientDetails, Set<String> requestedScopes, String requestedGrantType) {
        if (!this.GRANT_TYPES_THAT_MAY_GET_ID_TOKENS.contains(requestedGrantType)) {
            return false;
        }
        try {
            this.approvalService.ensureRequiredApprovals(userId, Sets.newHashSet((Object[])new String[]{"openid"}), requestedGrantType, clientDetails);
        }
        catch (InvalidTokenException e) {
            return false;
        }
        Set clientScopes = clientDetails.getScope();
        if (null == clientScopes || clientScopes.isEmpty()) {
            return false;
        }
        if (clientScopes.stream().filter(Objects::nonNull).noneMatch("openid"::equals)) {
            return false;
        }
        if (requestedScopes != null && !requestedScopes.isEmpty() && !requestedScopes.contains("openid")) {
            logger.info("an ID token was requested but 'openid' is missing from the requested scopes");
            return false;
        }
        return true;
    }
}

