/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.oauth.jwt;

import java.nio.CharBuffer;
import org.cloudfoundry.identity.uaa.oauth.KeyInfo;
import org.cloudfoundry.identity.uaa.oauth.jwt.Jwt;
import org.cloudfoundry.identity.uaa.oauth.jwt.JwtHeader;
import org.cloudfoundry.identity.uaa.oauth.jwt.JwtHeaderHelper;
import org.cloudfoundry.identity.uaa.oauth.jwt.JwtImpl;
import org.springframework.security.jwt.codec.Codecs;

public class JwtHelper {
    static byte[] PERIOD = Codecs.utf8Encode((CharSequence)".");

    public static Jwt decode(String token) {
        byte[] crypto;
        boolean emptyCrypto;
        int firstPeriod = token.indexOf(46);
        int lastPeriod = token.lastIndexOf(46);
        if (firstPeriod <= 0 || lastPeriod <= firstPeriod) {
            throw new IllegalArgumentException("JWT must have 3 tokens");
        }
        CharBuffer buffer = CharBuffer.wrap(token, 0, firstPeriod);
        JwtHeader header = JwtHeaderHelper.create(buffer.toString());
        buffer.limit(lastPeriod).position(firstPeriod + 1);
        byte[] claims = Codecs.b64UrlDecode((CharSequence)buffer);
        boolean bl = emptyCrypto = lastPeriod == token.length() - 1;
        if (emptyCrypto) {
            if (!"none".equals(header.parameters.alg)) {
                throw new IllegalArgumentException("Signed or encrypted token must have non-empty crypto segment");
            }
            crypto = new byte[]{};
        } else {
            buffer.limit(token.length()).position(lastPeriod + 1);
            crypto = Codecs.b64UrlDecode((CharSequence)buffer);
        }
        return new JwtImpl(header, claims, crypto);
    }

    public static Jwt encode(CharSequence content, KeyInfo keyInfo) {
        JwtHeader header = JwtHeaderHelper.create(keyInfo.algorithm(), keyInfo.keyId(), keyInfo.keyURL());
        byte[] claims = Codecs.utf8Encode((CharSequence)content);
        byte[] crypto = keyInfo.getSigner().sign(Codecs.concat((byte[][])new byte[][]{Codecs.b64UrlEncode((byte[])header.bytes()), PERIOD, Codecs.b64UrlEncode((byte[])claims)}));
        return new JwtImpl(header, claims, crypto);
    }
}

