/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.oauth;

import java.util.ArrayList;
import java.util.Arrays;
import org.cloudfoundry.identity.uaa.oauth.KeyInfoService;
import org.cloudfoundry.identity.uaa.oauth.TokenEndpointBuilder;
import org.cloudfoundry.identity.uaa.oauth.TokenRevokedException;
import org.cloudfoundry.identity.uaa.oauth.token.RevocableToken;
import org.cloudfoundry.identity.uaa.oauth.token.RevocableTokenProvisioning;
import org.cloudfoundry.identity.uaa.user.UaaUser;
import org.cloudfoundry.identity.uaa.user.UaaUserDatabase;
import org.cloudfoundry.identity.uaa.util.TokenValidation;
import org.cloudfoundry.identity.uaa.util.UaaTokenUtils;
import org.cloudfoundry.identity.uaa.zone.ClientServicesExtension;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.security.oauth2.provider.ClientDetails;

public class TokenValidationService {
    private RevocableTokenProvisioning revocableTokenProvisioning;
    private TokenEndpointBuilder tokenEndpointBuilder;
    private UaaUserDatabase userDatabase;
    private ClientServicesExtension clientServicesExtension;
    private KeyInfoService keyInfoService;

    public TokenValidationService(RevocableTokenProvisioning revocableTokenProvisioning, TokenEndpointBuilder tokenEndpointBuilder, UaaUserDatabase userDatabase, ClientServicesExtension clientServicesExtension, KeyInfoService keyInfoService) {
        this.revocableTokenProvisioning = revocableTokenProvisioning;
        this.tokenEndpointBuilder = tokenEndpointBuilder;
        this.userDatabase = userDatabase;
        this.clientServicesExtension = clientServicesExtension;
        this.keyInfoService = keyInfoService;
    }

    public TokenValidation validateToken(String token, boolean isAccessToken) {
        if (!UaaTokenUtils.isJwtToken(token)) {
            RevocableToken revocableToken;
            try {
                revocableToken = (RevocableToken)this.revocableTokenProvisioning.retrieve(token, IdentityZoneHolder.get().getId());
            }
            catch (EmptyResultDataAccessException ex) {
                throw new TokenRevokedException("The token expired, was revoked, or the token ID is incorrect.");
            }
            token = revocableToken.getValue();
        }
        TokenValidation tokenValidation = isAccessToken ? TokenValidation.buildAccessTokenValidator(token, this.keyInfoService) : TokenValidation.buildRefreshTokenValidator(token, this.keyInfoService);
        tokenValidation.checkRevocableTokenStore(this.revocableTokenProvisioning).checkIssuer(this.tokenEndpointBuilder.getTokenEndpoint());
        ClientDetails client = tokenValidation.getClientDetails(this.clientServicesExtension);
        UaaUser user = tokenValidation.getUserDetails(this.userDatabase);
        tokenValidation.checkClientAndUser(client, user);
        ArrayList<String> clientSecrets = new ArrayList<String>();
        ArrayList<String> revocationSignatureList = new ArrayList<String>();
        if (client.getClientSecret() != null) {
            clientSecrets.addAll(Arrays.asList(client.getClientSecret().split(" ")));
        } else {
            revocationSignatureList.add(UaaTokenUtils.getRevocableTokenSignature(client, null, user));
        }
        for (String clientSecret : clientSecrets) {
            revocationSignatureList.add(UaaTokenUtils.getRevocableTokenSignature(client, clientSecret, user));
        }
        tokenValidation = tokenValidation.checkRevocationSignature(revocationSignatureList);
        return tokenValidation;
    }

    public void setUserDatabase(UaaUserDatabase userDatabase) {
        this.userDatabase = userDatabase;
    }
}

