/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.oauth;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.oauth.RemoteUserAuthentication;
import org.cloudfoundry.identity.uaa.util.JsonUtils;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.crypto.codec.Base64;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.exceptions.InvalidTokenException;
import org.springframework.security.oauth2.provider.AuthorizationRequest;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.client.BaseClientDetails;
import org.springframework.security.oauth2.provider.token.ResourceServerTokenServices;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.DefaultResponseErrorHandler;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;

public class RemoteTokenServices
implements ResourceServerTokenServices {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private RestOperations restTemplate = new RestTemplate();
    private String checkTokenEndpointUrl;
    private String clientId;
    private String clientSecret;
    private boolean storeClaims = false;

    public RemoteTokenServices() {
        ((RestTemplate)this.restTemplate).setErrorHandler((ResponseErrorHandler)new DefaultResponseErrorHandler(){

            public void handleError(ClientHttpResponse response) throws IOException {
                if (response.getRawStatusCode() != 400) {
                    super.handleError(response);
                }
            }
        });
    }

    public boolean isStoreClaims() {
        return this.storeClaims;
    }

    public void setStoreClaims(boolean storeClaims) {
        this.storeClaims = storeClaims;
    }

    public void setRestTemplate(RestOperations restTemplate) {
        this.restTemplate = restTemplate;
    }

    public void setCheckTokenEndpointUrl(String checkTokenEndpointUrl) {
        this.checkTokenEndpointUrl = checkTokenEndpointUrl;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public OAuth2Authentication loadAuthentication(String accessToken) throws AuthenticationException {
        LinkedMultiValueMap formData = new LinkedMultiValueMap();
        formData.add((Object)"token", (Object)accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.set("Authorization", this.getAuthorizationHeader(this.clientId, this.clientSecret));
        Map<String, Object> map = this.postForMap(this.checkTokenEndpointUrl, (MultiValueMap<String, String>)formData, headers);
        if (map.containsKey("error")) {
            this.logger.debug((Object)("check_token returned error: " + map.get("error")));
            throw new InvalidTokenException(accessToken);
        }
        Assert.state((boolean)map.containsKey("client_id"), (String)"Client id must be present in response from auth server");
        String remoteClientId = (String)map.get("client_id");
        HashSet<String> scope = new HashSet<String>();
        if (map.containsKey("scope")) {
            Collection values = (Collection)map.get("scope");
            scope.addAll(values);
        }
        AuthorizationRequest clientAuthentication = new AuthorizationRequest(remoteClientId, scope);
        if (map.containsKey("resource_ids") || map.containsKey("client_authorities")) {
            HashSet resourceIds = new HashSet();
            if (map.containsKey("resource_ids")) {
                Collection values = (Collection)map.get("resource_ids");
                resourceIds.addAll(values);
            }
            HashSet clientAuthorities = new HashSet();
            if (map.containsKey("client_authorities")) {
                Collection collection = (Collection)map.get("client_authorities");
                clientAuthorities.addAll(this.getAuthorities(collection));
            }
            BaseClientDetails baseClientDetails = new BaseClientDetails();
            baseClientDetails.setClientId(remoteClientId);
            baseClientDetails.setResourceIds(resourceIds);
            baseClientDetails.setAuthorities((Collection)clientAuthorities);
            clientAuthentication.setResourceIdsAndAuthoritiesFromClientDetails((ClientDetails)baseClientDetails);
        }
        HashMap requestParameters = new HashMap();
        if (this.isStoreClaims()) {
            for (Map.Entry entry : map.entrySet()) {
                if (entry.getValue() == null || !(entry.getValue() instanceof String)) continue;
                requestParameters.put(entry.getKey(), (String)entry.getValue());
            }
        }
        if (map.containsKey("az_attr")) {
            try {
                requestParameters.put("az_attr", JsonUtils.writeValueAsString((Object)map.get("az_attr")));
            }
            catch (JsonUtils.JsonUtilException e) {
                throw new IllegalStateException("Cannot convert access token to JSON", e);
            }
        }
        clientAuthentication.setRequestParameters(Collections.unmodifiableMap(requestParameters));
        Authentication userAuthentication = this.getUserAuthentication(map, scope);
        clientAuthentication.setApproved(true);
        return new OAuth2Authentication(clientAuthentication.createOAuth2Request(), userAuthentication);
    }

    private Authentication getUserAuthentication(Map<String, Object> map, Set<String> scope) {
        String username = (String)map.get("user_name");
        if (username == null) {
            return null;
        }
        HashSet<GrantedAuthority> userAuthorities = new HashSet<GrantedAuthority>();
        if (map.containsKey("user_authorities")) {
            Collection values = (Collection)map.get("user_authorities");
            userAuthorities.addAll(this.getAuthorities(values));
        } else {
            userAuthorities.addAll(this.getAuthorities(scope));
        }
        String email = (String)map.get("email");
        String id = (String)map.get("user_id");
        return new RemoteUserAuthentication(id, username, email, userAuthorities);
    }

    public OAuth2AccessToken readAccessToken(String accessToken) {
        throw new UnsupportedOperationException("Not supported: read access token");
    }

    private Set<GrantedAuthority> getAuthorities(Collection<String> authorities) {
        HashSet<GrantedAuthority> result = new HashSet<GrantedAuthority>();
        for (String authority : authorities) {
            result.add((GrantedAuthority)new SimpleGrantedAuthority(authority));
        }
        return result;
    }

    private String getAuthorizationHeader(String clientId, String clientSecret) {
        String creds = String.format("%s:%s", clientId, clientSecret);
        try {
            return "Basic " + new String(Base64.encode((byte[])creds.getBytes("UTF-8")));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Could not convert String");
        }
    }

    private Map<String, Object> postForMap(String path, MultiValueMap<String, String> formData, HttpHeaders headers) {
        Map map;
        if (headers.getContentType() == null) {
            headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        }
        Map result = map = (Map)this.restTemplate.exchange(path, HttpMethod.POST, new HttpEntity(formData, (MultiValueMap)headers), Map.class, new Object[0]).getBody();
        return result;
    }
}

