/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.oauth;

import java.util.Map;
import org.cloudfoundry.identity.uaa.util.UaaUrlUtils;
import org.springframework.security.jwt.crypto.sign.SignatureVerifier;
import org.springframework.security.jwt.crypto.sign.Signer;
import org.springframework.web.util.UriComponentsBuilder;

public abstract class KeyInfo {
    public abstract void verify();

    public abstract SignatureVerifier getVerifier();

    public abstract Signer getSigner();

    public abstract String keyId();

    public abstract String keyURL();

    public abstract String type();

    public abstract String verifierKey();

    public abstract Map<String, Object> getJwkMap();

    public abstract String algorithm();

    protected String validateAndConstructTokenKeyUrl(String keyUrl) {
        if (!UaaUrlUtils.isUrl(keyUrl)) {
            throw new IllegalArgumentException("Invalid Key URL");
        }
        return UriComponentsBuilder.fromHttpUrl((String)keyUrl).scheme("https").path("/token_keys").build().toUriString();
    }
}

