/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.oauth;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.oauth.jwt.Jwt;
import org.cloudfoundry.identity.uaa.oauth.jwt.JwtHelper;
import org.cloudfoundry.identity.uaa.oauth.token.IntrospectionClaims;
import org.cloudfoundry.identity.uaa.util.JsonUtils;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.exceptions.InvalidTokenException;
import org.springframework.security.oauth2.provider.token.ResourceServerTokenServices;
import org.springframework.stereotype.Controller;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class IntrospectEndpoint {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private ResourceServerTokenServices resourceServerTokenServices;

    @RequestMapping(value={"/introspect"}, method={RequestMethod.POST})
    @ResponseBody
    public IntrospectionClaims introspect(@RequestParam(value="token") String token) {
        IntrospectionClaims introspectionClaims = new IntrospectionClaims();
        try {
            OAuth2AccessToken oAuth2AccessToken = this.resourceServerTokenServices.readAccessToken(token);
            if (oAuth2AccessToken.isExpired()) {
                introspectionClaims.setActive(false);
                return introspectionClaims;
            }
            this.resourceServerTokenServices.loadAuthentication(token);
            introspectionClaims = this.getClaimsForToken(oAuth2AccessToken.getValue());
            introspectionClaims.setActive(true);
        }
        catch (InvalidTokenException e) {
            introspectionClaims.setActive(false);
            return introspectionClaims;
        }
        return introspectionClaims;
    }

    @RequestMapping(value={"/introspect"})
    @ResponseBody
    public IntrospectionClaims methodNotSupported(HttpServletRequest request) throws HttpRequestMethodNotSupportedException {
        throw new HttpRequestMethodNotSupportedException(request.getMethod());
    }

    private IntrospectionClaims getClaimsForToken(String token) {
        IntrospectionClaims claims;
        Jwt tokenJwt = JwtHelper.decode(token);
        try {
            claims = (IntrospectionClaims)JsonUtils.readValue((String)tokenJwt.getClaims(), IntrospectionClaims.class);
        }
        catch (JsonUtils.JsonUtilException e) {
            this.logger.error((Object)"Can't parse introspection claims in token. Is it a valid JSON?");
            throw new InvalidTokenException("Cannot read token claims", (Throwable)e);
        }
        return claims;
    }

    public void setTokenServices(ResourceServerTokenServices resourceServerTokenServices) {
        this.resourceServerTokenServices = resourceServerTokenServices;
    }
}

