/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.oauth;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.util.JsonUtils;
import org.springframework.util.StringUtils;

public class AuthorizationAttributesParser {
    private final Log logger = LogFactory.getLog(this.getClass());

    public Map<String, String> getAdditionalAuthorizationAttributes(String authoritiesJson) {
        if (StringUtils.hasLength((String)authoritiesJson)) {
            try {
                Map authorities = (Map)JsonUtils.readValue((String)authoritiesJson, (TypeReference)new TypeReference<Map<String, Object>>(){});
                Object az_attr = authorities.get("az_attr");
                if (az_attr == null) {
                    return null;
                }
                Map additionalAuthorizationAttributes = (Map)JsonUtils.readValue((byte[])JsonUtils.writeValueAsBytes(az_attr), (TypeReference)new TypeReference<Map<String, String>>(){});
                return additionalAuthorizationAttributes;
            }
            catch (Throwable t) {
                this.logger.error((Object)"Unable to read additionalAuthorizationAttributes", t);
            }
        }
        return null;
    }
}

