/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.metrics;

import java.util.Map;
import org.apache.tomcat.jdbc.pool.PoolProperties;
import org.apache.tomcat.jdbc.pool.interceptor.SlowQueryReport;
import org.cloudfoundry.identity.uaa.metrics.MetricsAccessor;
import org.cloudfoundry.identity.uaa.metrics.QueryMetric;
import org.cloudfoundry.identity.uaa.metrics.RequestMetric;
import org.cloudfoundry.identity.uaa.util.TimeService;
import org.cloudfoundry.identity.uaa.util.TimeServiceImpl;

public class QueryFilter
extends SlowQueryReport {
    private TimeService timeService = new TimeServiceImpl();

    protected void report(String query, long start, long delta) {
        RequestMetric metric = MetricsAccessor.getCurrent();
        if (metric != null) {
            metric.addQuery(new QueryMetric(query, start, delta, delta > this.getThreshold()));
        }
    }

    public void setProperties(Map<String, PoolProperties.InterceptorProperty> properties) {
        super.setProperties(properties);
        this.setLogFailed(false);
        this.setLogSlow(false);
    }

    protected String reportFailedQuery(String query, Object[] args, String name, long start, Throwable t) {
        String sql = super.reportFailedQuery(query, args, name, start, t);
        long delta = this.timeService.getCurrentTimeMillis() - start;
        this.report(sql, start, delta);
        return sql;
    }

    protected String reportQuery(String query, Object[] args, String name, long start, long delta) {
        String sql = super.reportQuery(query, args, name, start, delta);
        this.report(sql, start, delta);
        return sql;
    }

    protected String reportSlowQuery(String query, Object[] args, String name, long start, long delta) {
        return this.reportQuery(query, args, name, start, delta);
    }

    public void setTimeService(TimeService timeService) {
        this.timeService = timeService;
    }
}

