/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.message.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import org.springframework.mail.MailException;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessagePreparator;
import org.springframework.util.StreamUtils;

public class FakeJavaMailSender
implements JavaMailSender {
    private final Session session = Session.getInstance((Properties)new Properties());
    private final ArrayList<MimeMessageWrapper> sentMessages = new ArrayList();
    private volatile int maxMessages = 1000;

    public void clearMessage() {
        this.sentMessages.clear();
    }

    public int getMaxMessages() {
        return this.maxMessages;
    }

    public void setMaxMessages(int maxMessages) {
        this.maxMessages = maxMessages < 0 ? 0 : maxMessages;
    }

    public MimeMessage createMimeMessage() {
        return new MimeMessage(this.session);
    }

    public MimeMessage createMimeMessage(InputStream inputStream) {
        throw new UnsupportedOperationException();
    }

    public synchronized void send(MimeMessage mimeMessage) throws MailException {
        if (this.getMaxMessages() > 0) {
            this.sentMessages.add(new MimeMessageWrapper(mimeMessage));
        }
        while (this.sentMessages.size() > this.getMaxMessages()) {
            this.sentMessages.remove(0);
        }
    }

    public void send(MimeMessage[] mimeMessages) throws MailException {
        if (mimeMessages != null) {
            for (MimeMessage m : mimeMessages) {
                this.send(m);
            }
        }
    }

    public void send(MimeMessagePreparator mimeMessagePreparator) throws MailException {
        throw new UnsupportedOperationException();
    }

    public void send(MimeMessagePreparator[] mimeMessagePreparators) throws MailException {
        throw new UnsupportedOperationException();
    }

    public void send(SimpleMailMessage simpleMailMessage) throws MailException {
        throw new UnsupportedOperationException();
    }

    public void send(SimpleMailMessage[] simpleMailMessages) throws MailException {
        throw new UnsupportedOperationException();
    }

    public List<MimeMessageWrapper> getSentMessages() {
        return Collections.unmodifiableList(this.sentMessages);
    }

    public static class MimeMessageWrapper {
        private final MimeMessage mimeMessage;

        public MimeMessageWrapper(MimeMessage mimeMessage) {
            this.mimeMessage = mimeMessage;
        }

        public List<Address> getRecipients(Message.RecipientType recipientType) throws MessagingException {
            return Arrays.asList(this.mimeMessage.getRecipients(recipientType));
        }

        public List<Address> getFrom() throws MessagingException {
            return Arrays.asList(this.mimeMessage.getFrom());
        }

        public String getContentString() throws MessagingException, IOException {
            return StreamUtils.copyToString((InputStream)this.mimeMessage.getDataHandler().getInputStream(), (Charset)Charset.forName("UTF-8"));
        }

        public MimeMessage getMessage() {
            return this.mimeMessage;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("MimeMessageWrapper{");
            try {
                sb.append("From=").append(Arrays.toString(this.getFrom().toArray()));
                sb.append("; To=").append(Arrays.toString(this.getRecipients(Message.RecipientType.TO).toArray()));
                sb.append("; Content=").append(this.getContentString());
            }
            catch (MessagingException x) {
                sb.append("Message=").append(this.mimeMessage);
            }
            catch (IOException x) {
                sb.append("Message=").append(this.mimeMessage);
            }
            sb.append('}');
            return sb.toString();
        }
    }
}

