/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.message;

import com.google.common.collect.Sets;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.cloudfoundry.identity.uaa.zone.ClientServicesExtension;
import org.cloudfoundry.identity.uaa.zone.beans.IdentityZoneManager;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth2.client.OAuth2ClientContext;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.client.resource.UserRedirectRequiredException;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.OAuth2Request;
import org.springframework.security.oauth2.provider.token.AuthorizationServerTokenServices;

public class LocalUaaRestTemplate
extends OAuth2RestTemplate {
    private final AuthorizationServerTokenServices authorizationServerTokenServices;
    private final String clientId;
    private final ClientServicesExtension clientServicesExtension;
    private final IdentityZoneManager identityZoneManager;

    LocalUaaRestTemplate(@Qualifier(value="uaa") OAuth2ProtectedResourceDetails resource, AuthorizationServerTokenServices authorizationServerTokenServices, ClientServicesExtension clientServicesExtension, @Value(value="${notifications.verify_ssl:false}") boolean verifySsl, IdentityZoneManager identityZoneManager) throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
        super(resource);
        this.authorizationServerTokenServices = authorizationServerTokenServices;
        this.clientId = "login";
        this.clientServicesExtension = clientServicesExtension;
        this.identityZoneManager = identityZoneManager;
        if (!verifySsl) {
            this.skipSslValidation();
        }
    }

    public OAuth2AccessToken acquireAccessToken(OAuth2ClientContext oauth2Context) throws UserRedirectRequiredException {
        OAuth2Request request = new OAuth2Request(this.buildRequestParameters(), this.clientId, new HashSet(), true, this.buildScopes(), (Set)Sets.newHashSet((Object[])new String[]{"uaa"}), null, new HashSet(), new HashMap());
        OAuth2Authentication authentication = new OAuth2Authentication(request, null);
        OAuth2AccessToken result = this.authorizationServerTokenServices.createAccessToken(authentication);
        oauth2Context.setAccessToken(result);
        return result;
    }

    private Set<String> buildScopes() {
        ClientDetails client = this.clientServicesExtension.loadClientByClientId(this.clientId, this.identityZoneManager.getCurrentIdentityZoneId());
        return client.getAuthorities().stream().map(GrantedAuthority::getAuthority).collect(Collectors.toSet());
    }

    private Map<String, String> buildRequestParameters() {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put("client_id", this.clientId);
        requestParameters.put("grant_type", "client_credentials");
        return requestParameters;
    }

    private void skipSslValidation() throws KeyStoreException, NoSuchAlgorithmException, KeyManagementException {
        SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy()).build();
        CloseableHttpClient httpClient = HttpClients.custom().setSslcontext(sslContext).build();
        HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory((HttpClient)httpClient);
        this.setRequestFactory((ClientHttpRequestFactory)requestFactory);
    }
}

