/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.login;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.cloudfoundry.identity.uaa.provider.saml.SamlUserAuthority;

public class PasscodeInformation {
    private String userId;
    private String username;
    private String passcode;
    private Map<String, Object> authorizationParameters;
    private String origin;

    public PasscodeInformation(String userId, String username, String passcode, String origin, Map<String, Object> authorizationParameters) {
        this.setUserId(userId);
        this.setUsername(username);
        this.setPasscode(passcode);
        this.setAuthorizationParameters(authorizationParameters);
        this.setOrigin(origin);
    }

    @JsonCreator
    public PasscodeInformation(@JsonProperty(value="userId") String userId, @JsonProperty(value="username") String username, @JsonProperty(value="passcode") String passcode, @JsonProperty(value="origin") String origin, @JsonProperty(value="samlAuthorities") ArrayList<SamlUserAuthority> authorities) {
        this.setUserId(userId);
        this.setUsername(username);
        this.setPasscode(passcode);
        this.authorizationParameters = new LinkedHashMap<String, Object>();
        this.setSamlAuthorities(authorities);
        this.setOrigin(origin);
    }

    public PasscodeInformation(String username) {
        this.username = username;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @JsonProperty(value="samlAuthorities")
    public ArrayList<SamlUserAuthority> getSamlAuthorities() {
        ArrayList<SamlUserAuthority> list = new ArrayList<SamlUserAuthority>();
        if (this.authorizationParameters != null && this.authorizationParameters.containsKey("authorities")) {
            Set set = (Set)this.authorizationParameters.get("authorities");
            list.addAll(set);
        }
        return list;
    }

    public void setSamlAuthorities(ArrayList<SamlUserAuthority> authorities) {
        HashSet<SamlUserAuthority> set = new HashSet<SamlUserAuthority>();
        set.addAll(authorities);
        this.authorizationParameters.put("authorities", set);
    }

    @JsonIgnore
    public Map<String, Object> getAuthorizationParameters() {
        return this.authorizationParameters;
    }

    public void setAuthorizationParameters(Map<String, Object> authorizationParameters) {
        this.authorizationParameters = authorizationParameters;
    }

    public String getPasscode() {
        return this.passcode;
    }

    public void setPasscode(String passcode) {
        this.passcode = passcode;
    }

    public String getOrigin() {
        return this.origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }
}

