/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.login;

import java.net.URLEncoder;
import javax.servlet.http.Cookie;
import org.cloudfoundry.identity.uaa.authentication.UaaPrincipal;
import org.cloudfoundry.identity.uaa.login.CurrentUserInformation;
import org.cloudfoundry.identity.uaa.util.JsonUtils;

public class CurrentUserCookieFactory {
    private int sessionTimeout;
    public String CURRENT_USER_COOKIE_NAME = "Current-User";

    public CurrentUserCookieFactory(int sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    public Cookie getCookie(UaaPrincipal uaaPrincipal) throws CurrentUserCookieEncodingException {
        CurrentUserInformation currentUserInformation = new CurrentUserInformation();
        currentUserInformation.setUserId(uaaPrincipal.getId());
        Cookie cookie = new Cookie(this.CURRENT_USER_COOKIE_NAME, this.urlEncode(JsonUtils.writeValueAsString((Object)currentUserInformation)));
        cookie.setPath("/");
        cookie.setHttpOnly(false);
        cookie.setMaxAge(this.sessionTimeout);
        return cookie;
    }

    private String urlEncode(String value) throws CurrentUserCookieEncodingException {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (Exception e) {
            throw new CurrentUserCookieEncodingException(e);
        }
    }

    public Cookie getNullCookie() {
        Cookie currentUserCookie = new Cookie(this.CURRENT_USER_COOKIE_NAME, null);
        currentUserCookie.setHttpOnly(false);
        currentUserCookie.setMaxAge(0);
        currentUserCookie.setPath("/");
        return currentUserCookie;
    }

    public class CurrentUserCookieEncodingException
    extends Exception {
        public CurrentUserCookieEncodingException(Exception e) {
            super(e);
        }
    }
}

