/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.impl.config;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.ListUtils;

public class ScimExternalGroupsTypeResolvingFactoryBean {
    private Map<String, Map<String, List>> externalGroups;

    public ScimExternalGroupsTypeResolvingFactoryBean(Object o) {
        if (o instanceof List) {
            HashMap<String, Map<String, List>> resolvedMap = new HashMap<String, Map<String, List>>();
            for (String internalToExternalGroupsMapping : (List)o) {
                String[] internalExternalOrigin = internalToExternalGroupsMapping.trim().split("\\|");
                if (internalExternalOrigin.length <= 1) continue;
                String internalGroup = internalExternalOrigin[0];
                String externalGroupsSpaceDelimited = internalExternalOrigin[1];
                String origin = "ldap";
                if (internalExternalOrigin.length >= 3) {
                    origin = internalExternalOrigin[2];
                }
                String[] externalGroups = externalGroupsSpaceDelimited.trim().split("\\s+");
                HashMap<String, List<String>> externalToInternalMap = new HashMap<String, List<String>>();
                for (String externalGroup : externalGroups) {
                    externalToInternalMap.put(externalGroup, Arrays.asList(internalGroup));
                }
                Map existingOriginMap = resolvedMap.putIfAbsent(origin, externalToInternalMap);
                if (existingOriginMap == null) continue;
                Map originMap = (Map)resolvedMap.get(origin);
                HashMap combinedMap = new HashMap(originMap);
                for (Map.Entry e : externalToInternalMap.entrySet()) {
                    combinedMap.merge(e.getKey(), (List)e.getValue(), ListUtils::union);
                }
                resolvedMap.put(origin, combinedMap);
            }
            this.externalGroups = resolvedMap;
        } else {
            this.externalGroups = new HashMap<String, Map<String, List>>((Map)o);
        }
    }

    public Map<String, Map<String, List>> getExternalGroups() {
        return this.externalGroups;
    }

    public void setExternalGroups(Map<String, Map<String, List>> groups) {
        this.externalGroups = groups;
    }
}

