/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.db.postgresql;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.db.DatabaseInformation1_5_3;
import org.flywaydb.core.api.migration.spring.SpringJdbcMigration;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class V1_5_4__NormalizeTableAndColumnNames
extends DatabaseInformation1_5_3
implements SpringJdbcMigration {
    private final Log logger = LogFactory.getLog(this.getClass());
    private String colQuery = "SELECT 'noop', \n  c.relname as table_name,\n  a.attname as column_name \nFROM pg_catalog.pg_class c\n     LEFT JOIN pg_catalog.pg_namespace n ON n.oid = c.relnamespace\n     LEFT JOIN pg_catalog.pg_attribute a ON a.attrelid = c.relname::regclass    \nWHERE\n       n.nspname <> 'pg_catalog'\n      AND n.nspname <> 'information_schema'\n      AND n.nspname !~ '^pg_toast'\n  AND pg_catalog.pg_table_is_visible(c.oid)\n  AND c.relkind = 'r'\n  AND a.attnum > 0\nORDER BY 1,2";

    public void migrate(JdbcTemplate jdbcTemplate) throws Exception {
        this.logger.info((Object)("[V1_5_4] Running SQL: " + this.colQuery));
        List columns = jdbcTemplate.query(this.colQuery, (RowMapper)new DatabaseInformation1_5_3.ColumnMapper());
        for (DatabaseInformation1_5_3.ColumnInfo column : columns) {
            if (!this.processColumn(column)) continue;
            String sql = "ALTER TABLE " + column.tableName + " RENAME \"" + column.columnName + "\" TO \"" + column.columnName.toLowerCase() + "\"";
            this.logger.info((Object)("Renaming column: [" + sql + "]"));
            jdbcTemplate.execute(sql);
        }
    }
}

