/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.db.mysql;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.db.DatabaseInformation1_5_3;
import org.flywaydb.core.api.migration.spring.SpringJdbcMigration;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class V1_5_4__NormalizeTableAndColumnNames
extends DatabaseInformation1_5_3
implements SpringJdbcMigration {
    private final Log logger = LogFactory.getLog(this.getClass());
    private String colQuery = "SELECT CONCAT(\n'ALTER TABLE ', table_name, \n' CHANGE ', column_name, ' ', \nLOWER(column_name), ' ', column_type, ' ', extra,\nCASE WHEN IS_NULLABLE = 'YES' THEN  ' NULL' ELSE ' NOT NULL' END, IF(column_default IS NULL, '', CONCAT(' DEFAULT ',column_default)), ';') AS line, table_name, column_name \nFROM information_schema.columns\nWHERE table_schema = 'uaa' \nORDER BY line";

    public void migrate(JdbcTemplate jdbcTemplate) throws Exception {
        this.logger.info((Object)("[V1_5_4] Running SQL: " + this.colQuery));
        List columns = jdbcTemplate.query(this.colQuery, (RowMapper)new DatabaseInformation1_5_3.ColumnMapper());
        for (DatabaseInformation1_5_3.ColumnInfo column : columns) {
            if (!this.processColumn(column)) continue;
            String sql = column.sql.replaceAll("2001-01-01 .*", "'2001-01-01 01:01:01.000001'");
            this.logger.info((Object)("Renaming column: [" + sql + "]"));
            jdbcTemplate.execute(sql);
        }
    }
}

