/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.client.event;

import org.aspectj.lang.ProceedingJoinPoint;
import org.cloudfoundry.identity.uaa.audit.event.AbstractUaaEvent;
import org.cloudfoundry.identity.uaa.client.event.ClientApprovalsDeletedEvent;
import org.cloudfoundry.identity.uaa.client.event.ClientCreateEvent;
import org.cloudfoundry.identity.uaa.client.event.ClientDeleteEvent;
import org.cloudfoundry.identity.uaa.client.event.ClientUpdateEvent;
import org.cloudfoundry.identity.uaa.client.event.SecretChangeEvent;
import org.cloudfoundry.identity.uaa.client.event.SecretFailureEvent;
import org.cloudfoundry.identity.uaa.oauth.client.ClientDetailsModification;
import org.cloudfoundry.identity.uaa.zone.ClientServicesExtension;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.common.exceptions.InvalidClientException;
import org.springframework.security.oauth2.provider.ClientDetails;

public class ClientAdminEventPublisher
implements ApplicationEventPublisherAware {
    private ClientServicesExtension clientDetailsService;
    private ApplicationEventPublisher publisher;

    public ClientAdminEventPublisher(ClientServicesExtension clientDetailsService) {
        this.clientDetailsService = clientDetailsService;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }

    public ApplicationEventPublisher getPublisher() {
        return this.publisher;
    }

    public void create(ClientDetails client) {
        this.publish(new ClientCreateEvent(client, this.getPrincipal()));
    }

    public void createTx(ClientDetails[] clients) {
        for (ClientDetails client : clients) {
            this.publish(new ClientCreateEvent(client, this.getPrincipal()));
        }
    }

    public void update(ClientDetails client) {
        this.publish(new ClientUpdateEvent(client, this.getPrincipal()));
    }

    public void updateTx(ClientDetails[] clients) {
        for (ClientDetails client : clients) {
            this.publish(new ClientUpdateEvent(client, this.getPrincipal()));
        }
    }

    public ClientDetails delete(ProceedingJoinPoint jp, String clientId) throws Throwable {
        ClientDetails client = (ClientDetails)jp.proceed();
        this.publish(new ClientDeleteEvent(client, this.getPrincipal()));
        return client;
    }

    public void deleteTx(ClientDetails[] clients) {
        for (ClientDetails client : clients) {
            this.publish(new ClientDeleteEvent(client, this.getPrincipal()));
        }
    }

    public void modifyTx(ClientDetailsModification[] clients) {
        for (ClientDetailsModification client : clients) {
            if ("add".equals(client.getAction())) {
                this.publish(new ClientCreateEvent((ClientDetails)client, this.getPrincipal()));
                continue;
            }
            if ("update".equals(client.getAction())) {
                this.publish(new ClientUpdateEvent((ClientDetails)client, this.getPrincipal()));
                continue;
            }
            if ("delete".equals(client.getAction())) {
                this.publish(new ClientDeleteEvent((ClientDetails)client, this.getPrincipal()));
                continue;
            }
            if ("update,secret".equals(client.getAction())) {
                this.publish(new ClientUpdateEvent((ClientDetails)client, this.getPrincipal()));
                if (!client.isApprovalsDeleted()) continue;
                this.publish(new SecretChangeEvent((ClientDetails)client, this.getPrincipal()));
                this.publish(new ClientApprovalsDeletedEvent((ClientDetails)client, this.getPrincipal()));
                continue;
            }
            if (!"secret".equals(client.getAction()) || !client.isApprovalsDeleted()) continue;
            this.publish(new SecretChangeEvent((ClientDetails)client, this.getPrincipal()));
            this.publish(new ClientApprovalsDeletedEvent((ClientDetails)client, this.getPrincipal()));
        }
    }

    public void secretTx(ClientDetailsModification[] clients) {
        for (ClientDetailsModification client : clients) {
            this.publish(new ClientDeleteEvent((ClientDetails)client, this.getPrincipal()));
            if (!client.isApprovalsDeleted()) continue;
            this.publish(new ClientApprovalsDeletedEvent((ClientDetails)client, this.getPrincipal()));
        }
    }

    public void secretFailure(String clientId, Exception e) {
        this.publish(new SecretFailureEvent(e.getMessage(), this.getClient(clientId), this.getPrincipal()));
    }

    public void secretChange(String clientId) {
        this.publish(new SecretChangeEvent(this.getClient(clientId), this.getPrincipal()));
    }

    private ClientDetails getClient(String clientId) {
        try {
            return this.clientDetailsService.loadClientByClientId(clientId, IdentityZoneHolder.get().getId());
        }
        catch (InvalidClientException e) {
            return null;
        }
    }

    private Authentication getPrincipal() {
        return SecurityContextHolder.getContext().getAuthentication();
    }

    private void publish(AbstractUaaEvent event) {
        if (this.publisher != null) {
            this.publisher.publishEvent((ApplicationEvent)event);
        }
    }
}

